/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import tigase.conf.ConfigurationException;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.xmppclient.ClientTrustManagerFactory;
import tigase.server.xmppclient.IPMonitor;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.server.xmppclient.XMPPIOProcessorsFactory;
import tigase.util.DNSResolver;
import tigase.util.RoutingsContainer;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;

public class ClientConnectionManager
extends ConnectionManager<XMPPIOService<Object>> {
    private static final Logger log = Logger.getLogger(ClientConnectionManager.class.getName());
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final long SOCKET_CLOSE_WAIT_PROP_DEF = 1L;
    private static final String SOCKET_CLOSE_WAIT_PROP_KEY = "socket-close-wait";
    private static final String TLS_WANT_CLIENT_AUTH_ENABLED_KEY = "tls-want-client-auth-enabled";
    private static final String XMLNS = "jabber:client";
    private static final boolean TLS_WANT_CLIENT_AUTH_ENABLED_DEF = false;
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    protected RoutingsContainer routings = null;
    protected SeeOtherHostIfc see_other_host_strategy = null;
    private XMPPIOProcessor[] processors = new XMPPIOProcessor[0];
    private final ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    private final ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private long socket_close_wait_time = 1L;
    private IPMonitor ipMonitor = new IPMonitor();
    private final ClientTrustManagerFactory clientTrustManagerFactory = new ClientTrustManagerFactory();
    private boolean tlsWantClientAuthEnabled = false;

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getPacketFrom() != null && this.getComponentId().getBareJID().equals(packet.getPacketFrom().getBareJID())) {
            return packet.getPacketFrom().hashCode();
        }
        return packet.getTo().hashCode();
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toStringSecure());
        }
        if (packet.isCommand() && packet.getCommand() != Command.OTHER) {
            this.processCommand(packet);
        } else if (!this.writePacketToSocket(packet)) {
            block12: {
                if (packet.getType() != StanzaType.result && packet.getType() != StanzaType.available && packet.getType() != StanzaType.unavailable && packet.getType() != StanzaType.error && (packet.getElemName() != "presence" || packet.getType() != null)) {
                    try {
                        Packet error = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "The user connection is no longer active.", true);
                        this.addOutPacket(error);
                    }
                    catch (PacketErrorTypeException e) {
                        if (!log.isLoggable(Level.FINEST)) break block12;
                        log.finest("Ups, already error packet. Dropping it to prevent infinite loop.");
                    }
                }
            }
            if (packet.getType() != StanzaType.unavailable && packet.getPacketFrom() != null) {
                if (packet.getStanzaTo() != null) {
                    Packet command2 = Command.STREAM_CLOSED_UPDATE.getPacket(packet.getStanzaTo(), packet.getPacketFrom(), StanzaType.set, UUID.randomUUID().toString());
                    command2.setPacketFrom(packet.getPacketTo());
                    command2.setPacketTo(packet.getPacketFrom());
                    this.addOutPacket(command2);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Sending a command to close the remote session for non-existen {0} connection: {1}", new Object[]{this.getName(), command2.toStringSecure()});
                    }
                } else if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.FINE, "Stream close update without an user JID, skipping for packet: {0}", new Object[]{packet});
                }
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> serv) {
        JID id = serv.getConnectionId();
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing socket data: {0} from connection: {1}", new Object[]{p.toStringSecure(), id});
            }
            if (p.getAttributeStaticStr("xmlns") == null) {
                p.setXMLNS(XMLNS);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "XMLNS set for packet: {0} from connection: {1}", new Object[]{p.toStringSecure(), id});
                }
            }
            if (p.getStanzaFrom() != null) {
                p.initVars(null, p.getStanzaTo());
            }
            p.setPacketFrom(id);
            JID receiver = serv.getDataReceiver();
            if (receiver != null) {
                p.setPacketTo(serv.getDataReceiver());
                this.addOutPacket(p);
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Hm, receiver is not set yet stream open was not send by a client or server misconfiguration..., ignoring: {0}, connection: {1}", new Object[]{p.toStringSecure(), serv});
        }
        return null;
    }

    @Override
    public boolean processUndeliveredPacket(Packet packet, String errorMessage) {
        try {
            if (packet.getType() == StanzaType.error) {
                return false;
            }
            if (packet.getElemName() == "presence") {
                return false;
            }
            if (packet.getElemName() == "message") {
                Packet result = C2SDeliveryErrorProcessor.makeDeliveryError(packet);
                this.processOutPacket(result);
                return true;
            }
            this.processOutPacket(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, errorMessage, true));
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.FINER, "exception prepareing request for returning error, data = {0}", packet);
        }
        return true;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> service) {
        super.serviceStarted(service);
        String id = this.getUniqueId(service);
        JID connectionId = this.getFromAddress(id);
        service.setConnectionId(connectionId);
        service.setProcessors(this.processors);
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> service) {
        boolean result = super.serviceStopped(service);
        if (result) {
            Queue<Packet> undeliveredPackets = service.getWaitingPackets();
            Packet p = null;
            while ((p = undeliveredPackets.poll()) != null) {
                this.processUndeliveredPacket(p, null);
            }
        }
        this.xmppStreamClosed(service);
        return result;
    }

    @Override
    public void start() {
        super.start();
        this.ipMonitor = new IPMonitor();
        this.ipMonitor.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.ipMonitor.stopThread();
    }

    @Override
    public void tlsHandshakeCompleted(XMPPIOService<Object> serv) {
        if (serv.getPeersJIDsFromCert() != null && this.clientTrustManagerFactory.isActive()) {
            Packet clientAuthCommand = Command.CLIENT_AUTH.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, this.newPacketId("c2s-"), Command.DataType.submit);
            String id = (String)serv.getSessionData().get("sessionID");
            Command.addFieldValue(clientAuthCommand, "session-id", id);
            Command.addFieldValue(clientAuthCommand, "peer-certificate", "true");
            Command.addFieldMultiValue(clientAuthCommand, "jids", serv.getPeersJIDsFromCert());
            this.addOutPacket(clientAuthCommand);
        }
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream closed: {0}", serv.getConnectionId());
        }
        if (serv.getXMLNS() == XMLNS && serv.getSessionData().get("stream-closed") == null) {
            serv.getSessionData().put("stream-closed", "stream-closed");
            this.ipMonitor.addDisconnect(serv.getRemoteAddress());
            if (serv.getDataReceiver() != null) {
                Packet command2 = Command.STREAM_CLOSED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                String userJid = serv.getUserJid();
                if (userJid != null) {
                    Command.addFieldValue(command2, "user-jid", userJid);
                }
                this.addOutPacketWithTimeout(command2, this.stoppedHandler, 120L, TimeUnit.SECONDS);
                log.log(Level.FINE, "Service stopped, sending packet: {0}", command2);
            } else {
                log.fine("Service stopped, before stream:stream received");
            }
            serv.stop();
        }
    }

    @Override
    public String xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        BareJID see_other_host;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream opened: {0}", attribs);
        }
        String lang = attribs.get("xml:lang");
        String hostname = attribs.get("to");
        String from = attribs.get("from");
        BareJID fromJID = null;
        if (from != null) {
            try {
                fromJID = BareJID.bareJIDInstance(from);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.CONFIG, "From JID violates RFC6122 (XMPP:Address Format): ", ex);
                return this.prepareStreamError(serv, "improper-addressing", null);
            }
        }
        if (lang == null) {
            lang = "en";
        }
        if (hostname == null) {
            return this.prepareStreamError(serv, "improper-addressing", null);
        }
        if (!this.isLocalDomain(hostname)) {
            return this.prepareStreamError(serv, "host-unknown", null);
        }
        if (!this.isAllowed(serv, hostname)) {
            return this.prepareStreamError(serv, "policy-violation", null);
        }
        if (fromJID != null && this.see_other_host_strategy != null && this.see_other_host_strategy.isEnabled(SeeOtherHostIfc.Phase.OPEN) && (see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName())) != null && !see_other_host.equals(this.getDefHostName())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending redirect for {0} to host {1}, connection {2}.", new Object[]{fromJID, see_other_host, serv});
            }
            return this.prepareSeeOtherHost(serv, fromJID.getDomain(), see_other_host);
        }
        String id = (String)serv.getSessionData().get("sessionID");
        if (id == null) {
            id = UUID.randomUUID().toString();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "No Session ID, generating a new one: {0}", id);
            }
            serv.getSessionData().put("sessionID", id);
            serv.setXMLNS(XMLNS);
            serv.getSessionData().put("hostname-key", hostname);
            serv.setDataReceiver(JID.jidInstanceNS(this.routings.computeRouting(hostname)));
            String streamOpenData = this.prepareStreamOpen(serv, id, hostname);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Writing raw data to the socket: {0}", streamOpenData);
            }
            this.writeRawData(serv, streamOpenData);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "DONE");
            }
            Packet streamOpen = Command.STREAM_OPENED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, this.newPacketId("c2s-"), Command.DataType.submit);
            Command.addFieldValue(streamOpen, "session-id", id);
            Command.addFieldValue(streamOpen, "hostname", hostname);
            Command.addFieldValue(streamOpen, "xml:lang", lang);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Sending a system command to SM: {0}", streamOpen);
            }
            this.addOutPacketWithTimeout(streamOpen, this.startedHandler, 45L, TimeUnit.SECONDS);
            log.log(Level.FINER, "DOEN 2");
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Session ID is: {0}", id);
            }
            this.writeRawData(serv, this.prepareStreamOpen(serv, id, hostname));
            this.addOutPacket(Command.GETFEATURES.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.get, "ssl_" + UUID.randomUUID().toString(), null));
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        Boolean r_mode = (Boolean)params.get(this.getName() + "/" + ROUTINGS_PROP_KEY + "/" + ROUTING_MODE_PROP_KEY);
        String see_other_host_class = (String)params.get("--cm-see-other-host");
        this.see_other_host_strategy = this.getSeeOtherHostInstance(see_other_host_class);
        props.put("cm-see-other-host", see_other_host_class);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.getDefaults(props, params);
        }
        if (r_mode == null) {
            props.put("routings/multi-mode", true);
            if (params.get("config-type").equals("--gen-config-cs") && params.get("--ext-comp") != null) {
                String[] comp_params = ((String)params.get("--ext-comp")).split(",");
                props.put("routings/.+", "sess-man@" + comp_params[1]);
            } else {
                props.put("routings/.+", "sess-man@" + DNSResolver.getDefaultHostname());
            }
        }
        props.put(SOCKET_CLOSE_WAIT_PROP_KEY, 1L);
        props.put(TLS_WANT_CLIENT_AUTH_ENABLED_KEY, false);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Client connection manager";
    }

    public SeeOtherHostIfc getSeeOtherHostInstance(String see_other_host_class) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Configuring see_other_host strategy for: " + see_other_host_class);
        }
        if (see_other_host_class == null) {
            see_other_host_class = "tigase.server.xmppclient.SeeOtherHost";
        }
        if (see_other_host_class.equals("none")) {
            return null;
        }
        try {
            this.see_other_host_strategy = (SeeOtherHostIfc)Class.forName(see_other_host_class).newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate see_other_host strategy for class: " + see_other_host_class, e);
        }
        return this.see_other_host_strategy;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.clientTrustManagerFactory.setProperties(props);
        if (props.get(SOCKET_CLOSE_WAIT_PROP_KEY) != null) {
            this.socket_close_wait_time = (Long)props.get(SOCKET_CLOSE_WAIT_PROP_KEY);
        }
        this.processors = XMPPIOProcessorsFactory.updateIOProcessors(this, this.processors, props);
        if (props.size() == 1) {
            return;
        }
        String see_other_host_class = (String)props.get("cm-see-other-host");
        this.see_other_host_strategy = this.getSeeOtherHostInstance(see_other_host_class);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setProperties(props);
        }
        boolean routing_mode = (Boolean)props.get("routings/multi-mode");
        this.routings = new RoutingsContainer(routing_mode);
        int idx = "routings/".length();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("routings/") || entry.getKey().equals("routings/multi-mode")) continue;
            this.routings.addRouting(entry.getKey().substring(idx), (String)entry.getValue());
        }
        if (props.containsKey(TLS_WANT_CLIENT_AUTH_ENABLED_KEY)) {
            this.tlsWantClientAuthEnabled = (Boolean)props.get(TLS_WANT_CLIENT_AUTH_ENABLED_KEY);
        }
    }

    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        if (serv != null) {
            String serv_sessionId = (String)serv.getSessionData().get("sessionID");
            if (serv_sessionId.equals(command_sessionId)) {
                JID old_receiver = serv.getDataReceiver();
                serv.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.log(Level.WARNING, "Incorrect session ID, ignoring data redirect for: {0}, expected: {1}, received: {2}", new Object[]{newAddress, serv_sessionId, command_sessionId});
        }
        return null;
    }

    protected boolean isAllowed(XMPPIOService<Object> serv, String hostname) {
        int[] allowedPorts;
        VHostItem vhost = this.vHostManager.getVHostItem(hostname);
        return vhost == null || (allowedPorts = vhost.getC2SPortsAllowed()) == null || Arrays.binarySearch(allowedPorts, serv.getLocalPort()) >= 0;
    }

    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    protected ReceiverTimeoutHandler newStoppedHandler() {
        return new StoppedHandler();
    }

    protected void processCommand(Packet packet) {
        Object serv = this.getXMPPIOService(packet);
        Iq iqc = (Iq)packet;
        switch (iqc.getCommand()) {
            case GETFEATURES: {
                if (iqc.getType() != StanzaType.result) break;
                List<Element> features = this.getFeatures((XMPPIOService)serv);
                Element elem_features = new Element("stream:features");
                elem_features.addChildren(features);
                elem_features.addChildren(Command.getData(iqc));
                this.preprocessStreamFeatures((XMPPIOService<Object>)serv, elem_features);
                Packet result = Packet.packetInstance(elem_features, null, null);
                result.setPacketTo(iqc.getTo());
                this.writePacketToSocket(result);
                break;
            }
            case USER_LOGIN: {
                String jid = Command.getFieldValue(iqc, "user-jid");
                if (jid != null) {
                    if (serv != null) {
                        BareJID fromJID = null;
                        try {
                            fromJID = BareJID.bareJIDInstance(jid);
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                        if (fromJID != null && this.see_other_host_strategy != null && this.see_other_host_strategy.isEnabled(SeeOtherHostIfc.Phase.LOGIN)) {
                            BareJID see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName());
                            if (see_other_host == null || see_other_host.equals(this.getDefHostName())) break;
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Sending redirect for {0} to host {1}, connection {2}.", new Object[]{fromJID, see_other_host, serv});
                            }
                            String redirectMessage = this.prepareSeeOtherHost((XMPPIOService<Object>)serv, fromJID.getDomain(), see_other_host);
                            try {
                                SocketThread.removeSocketService(serv);
                                ((XMPPIOService)serv).writeRawData(redirectMessage);
                                ((XMPPIOService)serv).processWaitingPackets();
                                Thread.sleep(this.socket_close_wait_time);
                                ((XMPPIOService)serv).stop();
                            }
                            catch (Exception e) {}
                            break;
                        }
                        ((XMPPIOService)serv).setUserJid(jid);
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.log(Level.FINE, "Missing XMPPIOService for USER_LOGIN command: {0}", iqc);
                    break;
                }
                log.log(Level.WARNING, "Missing user-jid for USER_LOGIN command: {0}", iqc);
                break;
            }
            case STARTZLIB: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Starting zlib compression: {0}", serv);
                    }
                    try {
                        Element compressed = Command.getData(iqc, "compressed", null);
                        Packet p_compressed = Packet.packetInstance(compressed, null, null);
                        SocketThread.removeSocketService(serv);
                        ((XMPPIOService)serv).addPacketToSend(p_compressed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startZLib(9);
                        SocketThread.addSocketService(serv);
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Problem enabling zlib compression on the connection: ", ex);
                    }
                    break;
                }
                log.log(Level.WARNING, "Can't find sevice for STARTZLIB command: {0}", iqc);
                break;
            }
            case STARTTLS: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Starting TLS for connection: {0}", serv);
                    }
                    try {
                        Element proceed = Command.getData(iqc, "proceed", null);
                        Packet p_proceed = Packet.packetInstance(proceed, null, null);
                        SocketThread.removeSocketService(serv);
                        ((XMPPIOService)serv).addPacketToSend(p_proceed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        TrustManager[] x = this.clientTrustManagerFactory.getManager((XMPPIOService<Object>)serv);
                        ((IOService)serv).setX509TrustManagers(x);
                        ((IOService)serv).startTLS(false, this.isTlsWantClientAuthEnabled());
                        SocketThread.addSocketService(serv);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error starting TLS: {0}", e);
                        ((XMPPIOService)serv).forceStop();
                    }
                    break;
                }
                log.log(Level.WARNING, "Can't find sevice for STARTTLS command: {0}", iqc);
                break;
            }
            case REDIRECT: {
                String command_sessionId = Command.getFieldValue(iqc, "session-id");
                JID newAddress = iqc.getFrom();
                JID old_receiver = this.changeDataReceiver(iqc, newAddress, command_sessionId, (XMPPIOService<Object>)serv);
                if (old_receiver != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Redirecting data for sessionId: {0}, to: {1}", new Object[]{command_sessionId, newAddress});
                    }
                    Packet response = null;
                    response = iqc.commandResult(null);
                    Command.addFieldValue(response, "session-id", command_sessionId);
                    Command.addFieldValue(response, "action", "activate");
                    response.getElement().setAttribute("to", newAddress.toString());
                    this.addOutPacket(response);
                    break;
                }
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "Connection for REDIRECT command does not exist, ignoring packet: {0}", iqc.toStringSecure());
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                if (serv != null) {
                    String streamClose = this.prepareStreamClose((XMPPIOService<Object>)serv);
                    List<Element> err_el = packet.getElement().getChildrenStaticStr(Iq.IQ_COMMAND_PATH);
                    boolean moreToSend = false;
                    if (err_el != null && err_el.size() > 0) {
                        streamClose = this.prepareStreamError((XMPPIOService<Object>)serv, err_el) + streamClose;
                        moreToSend = true;
                    }
                    try {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Sending stream close to the client: {0}", streamClose);
                        }
                        ((XMPPIOService)serv).writeRawData(streamClose);
                        if (moreToSend) {
                            Thread.sleep(this.socket_close_wait_time);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ((XMPPIOService)serv).stop();
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Attempt to stop non-existen service for packet: {0}, Service already stopped?", iqc);
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (serv != null) {
                    this.addOutPacket(iqc.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.INFO, "Error packet is not really expected here: {0}", iqc.toStringSecure());
                }
                break;
            }
            case STREAM_MOVED: {
                if (this.processors == null) break;
                for (XMPPIOProcessor processor : this.processors) {
                    processor.processCommand((XMPPIOService)serv, packet);
                }
                break;
            }
            default: {
                this.writePacketToSocket(iqc);
            }
        }
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5222};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return new int[]{5223};
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000L;
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new XMPPIOService<Object>();
    }

    @Override
    protected boolean isTlsWantClientAuthEnabled() {
        return this.clientTrustManagerFactory.isSaslExternalAvailable();
    }

    protected String prepareStreamClose(XMPPIOService<Object> serv) {
        return "</stream:stream>";
    }

    protected String prepareStreamOpen(XMPPIOService<Object> serv, String id, String hostname) {
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'" + " id='" + id + "'" + " version='1.0' xml:lang='en'>";
    }

    protected String prepareStreamError(XMPPIOService<Object> serv, List<Element> err_el) {
        return "<stream:error>" + err_el.get(0).toString() + "</stream:error>";
    }

    protected String prepareStreamError(XMPPIOService<Object> serv, String errorName, String hostname) {
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + (hostname != null ? hostname : this.getDefVHostItem()) + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<" + errorName + " xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
    }

    protected String prepareSeeOtherHost(XMPPIOService<Object> serv, String hostname, BareJID see_other_host) {
        return "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + (hostname != null ? hostname : this.getDefVHostItem()) + "'" + " version='1.0' xml:lang='en'>" + this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", see_other_host).toString() + "</stream:stream>";
    }

    protected void preprocessStreamFeatures(XMPPIOService<Object> serv, Element elem_features) {
    }

    private List<Element> getFeatures(XMPPIOService service) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPIOProcessor proc : this.processors) {
            Element[] features = proc.supStreamFeatures(service);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS(this.getName(), this.getDefHostName().getDomain(), id);
    }

    private XMPPResourceConnection getXMPPSession(Packet p) {
        Object serv = this.getXMPPIOService(p);
        return serv == null ? null : (XMPPResourceConnection)((IOService)serv).getSessionData().get("xmpp-session");
    }

    private class StoppedHandler
    implements ReceiverTimeoutHandler {
        private StoppedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response for stop received...");
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.log(Level.INFO, "No response within time limit received for a packet: {0}", packet.toStringSecure());
            ClientConnectionManager.this.addOutPacketWithTimeout(packet, ClientConnectionManager.this.stoppedHandler, 60L, TimeUnit.SECONDS);
        }
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            ClientConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, "ssl_" + UUID.randomUUID().toString(), null));
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.log(Level.INFO, "No response within time limit received for a packet: {0}", packet.toStringSecure());
            Object serv = ClientConnectionManager.this.getXMPPIOService(packet.getFrom().toString());
            if (serv != null) {
                ((XMPPIOService)serv).stop();
            } else {
                log.log(Level.FINE, "Attempt to stop non-existen service for packet: {0}, Service already stopped?", packet);
            }
        }
    }
}

