/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import tigase.db.MsgRepositoryIfc;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.amp.JidResourceMap;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class MsgRepository<T>
implements MsgRepositoryIfc {
    public static final long MSGS_STORE_LIMIT_VAL = 100L;
    public static final String MSGS_STORE_LIMIT_KEY = "store-limit";
    protected static final int MAX_QUEUE_SIZE = 1000;
    private static final Map<String, MsgRepositoryIfc> repos = new ConcurrentSkipListMap<String, MsgRepositoryIfc>();
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    protected long earliestOffline = Long.MAX_VALUE;
    protected DelayQueue<MsgDBItem> expiredQueue = new DelayQueue();
    protected long broadcastMessagesLastCleanup = 0L;
    protected Map<String, BroadcastMsg> broadcastMessages = new ConcurrentHashMap<String, BroadcastMsg>();

    public static MsgRepositoryIfc getInstance(String cls, String id_string) throws TigaseDBException {
        try {
            String key;
            MsgRepositoryIfc result;
            if (cls == null) {
                cls = RepositoryFactory.getRepoClassName(MsgRepositoryIfc.class, id_string);
            }
            if ((result = repos.get(key = cls + "#" + id_string)) == null) {
                result = (MsgRepositoryIfc)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                repos.put(key, result);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TigaseDBException("Could not create instance of " + cls + " for uri " + id_string, ex);
        }
    }

    protected abstract void loadExpiredQueue(int var1);

    protected abstract void loadExpiredQueue(Date var1);

    protected abstract void deleteMessage(T var1);

    public abstract void loadMessagesToBroadcast();

    protected abstract void ensureBroadcastMessageRecipient(String var1, BareJID var2);

    protected abstract void insertBroadcastMessage(String var1, Element var2, Date var3, BareJID var4);

    public abstract Map<MSG_TYPES, Long> getMessagesCount(JID var1) throws UserNotFoundException;

    public abstract List<Element> getMessagesList(JID var1) throws UserNotFoundException;

    public abstract Queue<Element> loadMessagesToJID(List<String> var1, JID var2, boolean var3, OfflineMessagesProcessor var4) throws UserNotFoundException;

    public abstract int deleteMessagesToJID(List<String> var1, JID var2) throws UserNotFoundException;

    public BroadcastMsg getBroadcastMsg(String id) {
        return this.broadcastMessages.get(id);
    }

    public String dumpBroadcastMessageKeys() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.broadcastMessages.keySet()) {
            if (sb.length() == 0) {
                sb.append("[");
            } else {
                sb.append(",");
            }
            sb.append(key);
        }
        return sb.append("]").toString();
    }

    public Collection<BroadcastMsg> getBroadcastMessages() {
        long now = System.currentTimeMillis();
        if (now - this.broadcastMessagesLastCleanup > 60000L) {
            this.broadcastMessagesLastCleanup = now;
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, BroadcastMsg> e : this.broadcastMessages.entrySet()) {
                if (e.getValue().getDelay(TimeUnit.MILLISECONDS) >= 0L) continue;
                toRemove.add(e.getKey());
            }
            for (String key : toRemove) {
                this.broadcastMessages.remove(key);
            }
        }
        return Collections.unmodifiableCollection(this.broadcastMessages.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
        boolean isNew = false;
        Map<String, BroadcastMsg> map = this.broadcastMessages;
        synchronized (map) {
            BroadcastMsg bmsg = this.broadcastMessages.get(id);
            if (bmsg == null) {
                bmsg = new BroadcastMsg(null, msg, expire);
                this.broadcastMessages.put(id, bmsg);
                isNew = true;
                this.insertBroadcastMessage(id, msg, expire, recipient);
            }
            if (bmsg.addRecipient(recipient)) {
                this.ensureBroadcastMessageRecipient(id, recipient);
            }
            return isNew;
        }
    }

    @Override
    public Element getMessageExpired(long time, boolean delete) {
        MsgDBItem item;
        if (this.expiredQueue.size() == 0) {
            this.loadExpiredQueue(1000);
        } else {
            item = (MsgDBItem)this.expiredQueue.peek();
            if (item != null && this.earliestOffline < item.expired.getTime()) {
                this.loadExpiredQueue(item.expired);
            }
        }
        item = null;
        while (item == null) {
            try {
                item = (MsgDBItem)this.expiredQueue.take();
            }
            catch (InterruptedException ex) {}
        }
        if (delete) {
            this.deleteMessage(item.db_id);
        }
        return item.msg;
    }

    public String getStanzaTo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static interface OfflineMessagesProcessor {
        public void stamp(Element var1, String var2);
    }

    public class BroadcastMsg
    extends MsgDBItem {
        private JidResourceMap<Boolean> recipients;

        public BroadcastMsg(T db_id, Element msg, Date expired) {
            super(db_id, msg, expired);
            this.recipients = new JidResourceMap();
        }

        protected boolean addRecipient(BareJID jid) {
            if (this.recipients.containsKey(jid)) {
                return false;
            }
            this.recipients.put(JID.jidInstance(jid), Boolean.TRUE);
            return true;
        }

        public boolean needToSend(JID jid) {
            return this.recipients.containsKey(jid.getBareJID()) && (jid.getResource() == null || !this.recipients.containsKey(jid));
        }

        public void markAsSent(JID jid) {
            this.recipients.put(jid, Boolean.TRUE);
        }
    }

    protected class MsgDBItem
    implements Delayed {
        public final T db_id;
        public final Date expired;
        public final Element msg;

        public MsgDBItem(T db_id, Element msg, Date expired) {
            this.db_id = db_id;
            this.msg = msg;
            this.expired = expired;
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expired.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public static enum MSG_TYPES {
        none(0),
        message(1),
        presence(2);

        private final int numVal;

        private MSG_TYPES(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static MSG_TYPES getFromInt(int type) {
            switch (type) {
                case 1: {
                    return message;
                }
                case 2: {
                    return presence;
                }
            }
            return none;
        }
    }
}

