/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.NonAuthUserRepositoryAware;
import tigase.auth.SessionAware;
import tigase.auth.impl.AuthRepoPlainCallbackHandler;
import tigase.db.NonAuthUserRepository;
import tigase.xmpp.XMPPResourceConnection;

public class CallbackHandlerFactory {
    private static final String CALLBACK_HANDLER_KEY = "callbackhandler";

    public CallbackHandler create(String mechanismName, XMPPResourceConnection session, NonAuthUserRepository repo, Map<String, Object> settings) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> handlerClass;
        CallbackHandler handler;
        String handlerClassName = this.getHandlerClassname(mechanismName, session, repo, settings);
        if (handlerClassName == null) {
            handlerClassName = AuthRepoPlainCallbackHandler.class.getName();
        }
        if ((handler = (CallbackHandler)(handlerClass = Class.forName(handlerClassName)).newInstance()) instanceof SessionAware) {
            ((SessionAware)((Object)handler)).setSession(session);
        }
        if (handler instanceof DomainAware) {
            ((DomainAware)((Object)handler)).setDomain(session.getDomain().getVhost().getDomain());
        }
        if (handler instanceof NonAuthUserRepositoryAware) {
            ((NonAuthUserRepositoryAware)((Object)handler)).setNonAuthUserRepository(repo);
        }
        if (handler instanceof AuthRepositoryAware) {
            ((AuthRepositoryAware)((Object)handler)).setAuthRepository(session.getAuthRepository());
        }
        return handler;
    }

    private String getHandlerClassname(String mechanismName, XMPPResourceConnection session, NonAuthUserRepository repo, Map<String, Object> settings) {
        if (settings == null) {
            return null;
        }
        if (settings.containsKey("callbackhandler-" + mechanismName)) {
            return (String)settings.get("callbackhandler-" + mechanismName);
        }
        if (settings.containsKey(CALLBACK_HANDLER_KEY)) {
            return (String)settings.get(CALLBACK_HANDLER_KEY);
        }
        return null;
    }
}

