/*
 * Decompiled with CFR 0.152.
 */
package tigase.sys;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.XMPPServer;
import tigase.server.monitor.MonitorRuntime;
import tigase.sys.CPULoadListener;
import tigase.sys.MemoryChangeListener;
import tigase.sys.OnlineJidsReporter;
import tigase.sys.ResourceState;
import tigase.sys.ShutdownHook;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public abstract class TigaseRuntime {
    protected static final long SECOND = 1000L;
    private static final Logger log = Logger.getLogger(TigaseRuntime.class.getName());
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private int cpus = Runtime.getRuntime().availableProcessors();
    private float cpuUsage = 0.0f;
    private MemoryPoolMXBean oldMemPool = null;
    private long prevCputime = 0L;
    private long prevUptime = 0L;

    protected TigaseRuntime() {
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memPools) {
            if (!memoryPoolMXBean.getName().toLowerCase().contains("old")) continue;
            this.oldMemPool = memoryPoolMXBean;
            log.info("Using OldGen memory pool for reporting memory usage.");
            break;
        }
    }

    public abstract void addCPULoadListener(CPULoadListener var1);

    public abstract void addMemoryChangeListener(MemoryChangeListener var1);

    public abstract void addOnlineJidsReporter(OnlineJidsReporter var1);

    public abstract void addShutdownHook(ShutdownHook var1);

    public abstract JID[] getConnectionIdsForJid(JID var1);

    public int getCPUsNumber() {
        return this.cpus;
    }

    public ResourceState getCPUState() {
        return ResourceState.GREEN;
    }

    public float getCPUUsage() {
        long currCputime = -1L;
        long elapsedCpu = -1L;
        long currUptime = this.getUptime();
        long elapsedTime = currUptime - this.prevUptime;
        if (this.prevUptime > 0L && elapsedTime > 500L) {
            currCputime = this.getProcessCPUTime();
            elapsedCpu = currCputime - this.prevCputime;
            this.cpuUsage = Math.min(99.99f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)this.cpus));
        }
        if (elapsedTime > 500L) {
            this.prevUptime = currUptime;
            this.prevCputime = currCputime;
        }
        return this.cpuUsage;
    }

    public long getDirectMemUsed() {
        long result = -1L;
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memPools) {
            if (!memoryPoolMXBean.getName().toLowerCase().contains("direct")) continue;
            result = memoryPoolMXBean.getUsage().getUsed();
            break;
        }
        return result;
    }

    public long getHeapMemMax() {
        if (this.oldMemPool != null) {
            MemoryUsage memUsage = this.oldMemPool.getUsage();
            return memUsage.getMax();
        }
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
    }

    public float getHeapMemUsage() {
        return this.getHeapMemMax() == -1L ? 100.0f : (float)this.getHeapMemUsed() * 100.0f / (float)this.getHeapMemMax();
    }

    public long getHeapMemUsed() {
        if (this.oldMemPool != null) {
            MemoryUsage memUsage = this.oldMemPool.getUsage();
            return memUsage.getUsed();
        }
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    public double getLoadAverage() {
        return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
    }

    public ResourceState getMemoryState() {
        return ResourceState.GREEN;
    }

    public long getNonHeapMemMax() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getMax();
    }

    public float getNonHeapMemUsage() {
        return this.getNonHeapMemMax() == -1L ? 100.0f : (float)this.getNonHeapMemUsed() * 100.0f / (float)this.getNonHeapMemMax();
    }

    public long getNonHeapMemUsed() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
    }

    public long getProcessCPUTime() {
        long result = 0L;
        java.lang.management.OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOSMXBean = (OperatingSystemMXBean)osMXBean;
            result = sunOSMXBean.getProcessCpuTime();
        } else {
            ThreadMXBean thBean = ManagementFactory.getThreadMXBean();
            for (long thid : thBean.getAllThreadIds()) {
                result += thBean.getThreadCpuTime(thid);
            }
        }
        return result;
    }

    public int getThreadsNumber() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public static TigaseRuntime getTigaseRuntime() {
        return MonitorRuntime.getMonitorRuntime();
    }

    public long getUptime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public String getUptimeString() {
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        long days = uptime / 86400000L;
        long hours = (uptime - days * 24L * 3600000L) / 3600000L;
        long minutes = (uptime - (days * 24L * 3600000L + hours * 3600000L)) / 60000L;
        long seconds = (uptime - (days * 24L * 3600000L + hours * 3600000L + minutes * 60000L)) / 1000L;
        StringBuilder sb = new StringBuilder();
        sb.append(days > 0L ? days + (days == 1L ? " day" : " days") : "");
        if (hours > 0L) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(hours + (hours == 1L ? " hour" : " hours"));
        }
        if (days == 0L && minutes > 0L) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(minutes + (minutes == 1L ? " min" : " mins"));
        }
        if (days == 0L && hours == 0L && seconds > 0L) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(seconds + " sec");
        }
        return sb.toString();
    }

    public abstract boolean hasCompleteJidsInfo();

    public abstract boolean isJidOnline(JID var1);

    public abstract boolean isJidOnlineLocally(BareJID var1);

    public abstract boolean isJidOnlineLocally(JID var1);

    public void shutdownTigase(String[] msg) {
        if (XMPPServer.isOSGi()) {
            for (String line : msg) {
                log.log(Level.SEVERE, line);
            }
        } else {
            for (String line : msg) {
                System.out.println(line);
            }
        }
        System.exit(1);
    }
}

