/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.MechanismSelector;
import tigase.auth.mechanisms.TigaseSaslServerFactory;
import tigase.vhosts.VHostItem;
import tigase.xmpp.XMPPResourceConnection;

public class DefaultMechanismSelector
implements MechanismSelector {
    private final Set<String> allowedMechanisms = new HashSet<String>();
    protected Map<String, Object> settings;

    @Override
    public Collection<String> filterMechanisms(Enumeration<SaslServerFactory> serverFactories, XMPPResourceConnection session) {
        HashMap props = new HashMap();
        ArrayList<String> result = new ArrayList<String>();
        while (serverFactories.hasMoreElements()) {
            String[] x;
            SaslServerFactory ss = serverFactories.nextElement();
            for (String name : x = ss.getMechanismNames(props)) {
                if (!this.match(ss, name, session) || !this.isAllowedForDomain(name, session.getDomain())) continue;
                result.add(name);
            }
        }
        return result;
    }

    @Override
    public void init(Map<String, Object> settings) {
        String[] a;
        this.settings = settings;
        String tmp = (String)settings.get("enabled-mechanisms");
        if (tmp != null && (a = tmp.split(",")) != null) {
            this.allowedMechanisms.addAll(Arrays.asList(a));
        }
    }

    protected boolean isAllowedForDomain(String mechanismName, VHostItem vhost) {
        String[] saslAllowedMechanisms = vhost.getSaslAllowedMechanisms();
        if (saslAllowedMechanisms != null && saslAllowedMechanisms.length > 0) {
            for (String allowed : saslAllowedMechanisms) {
                if (!allowed.equals(mechanismName)) continue;
                return true;
            }
            return false;
        }
        if (!this.allowedMechanisms.isEmpty()) {
            return this.allowedMechanisms.contains(mechanismName);
        }
        return true;
    }

    protected boolean match(SaslServerFactory factory, String mechanismName, XMPPResourceConnection session) {
        if (session.isTlsRequired() && !session.isEncrypted()) {
            return false;
        }
        if (factory instanceof TigaseSaslServerFactory) {
            if (!session.getDomain().isAnonymousEnabled() && "ANONYMOUS".equals(mechanismName)) {
                return false;
            }
            return !"EXTERNAL".equals(mechanismName) || session.getSessionData("SASL_EXTERNAL_ALLOWED") == Boolean.TRUE;
        }
        return false;
    }
}

