/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class C2SDeliveryErrorProcessor {
    private static final Logger log = Logger.getLogger(C2SDeliveryErrorProcessor.class.getCanonicalName());
    public static final String ELEM_NAME = "delivery-error";
    public static final String XMLNS = "http://tigase.org/delivery-error";

    public static void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, JID toIgnore) {
        for (Packet p : results) {
            Element elem;
            Element error;
            if (p.getElemName() != "message" || (error = (elem = p.getElement()).getChildStaticStr(ELEM_NAME)) == null || error.getXMLNS() != XMLNS || toIgnore != null && toIgnore.equals(packet.getPacketTo())) continue;
            elem.removeChild(error);
        }
    }

    public static boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (packet.getElemName() != "message") {
            return false;
        }
        if (!C2SDeliveryErrorProcessor.isDeliveryError(packet)) {
            return false;
        }
        try {
            return packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null && session != null && !session.getActiveSessions().isEmpty();
        }
        catch (NotAuthorizedException ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("NotAuthorizedException while processing undelivered message from C2S, packet = " + packet);
            }
            return false;
        }
    }

    public static boolean isDeliveryError(Packet packet) {
        Element elem = packet.getElement();
        Element error = elem.getChildStaticStr(ELEM_NAME);
        return error != null && error.getXMLNS() == XMLNS;
    }

    public static Packet makeDeliveryError(Packet packet) {
        Packet result = packet.copyElementOnly();
        result.setPacketFrom(packet.getPacketTo());
        result.getElement().addChild(new Element(ELEM_NAME, new String[]{"xmlns"}, new String[]{XMLNS}));
        return result;
    }
}

