/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.security.NoSuchAlgorithmException;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.MsgRepository;
import tigase.util.Algorithms;
import tigase.util.SimpleCache;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

@Repository.Meta(isDefault=true, supportedUris={"jdbc:[^:]+:.*"})
public class JDBCMsgRepository
extends MsgRepository<Long> {
    private static final Logger log = Logger.getLogger(JDBCMsgRepository.class.getName());
    private static final String MSG_TABLE = "msg_history";
    private static final String MSG_ID_COLUMN = "msg_id";
    private static final String MSG_TIMESTAMP_COLUMN = "ts";
    private static final String MSG_EXPIRED_COLUMN = "expired";
    private static final String MSG_FROM_UID_COLUMN = "sender_uid";
    private static final String MSG_TO_UID_COLUMN = "receiver_uid";
    private static final String MSG_TYPE_COLUMN = "msg_type";
    private static final String MSG_BODY_COLUMN = "message";
    private static final String HISTORY_FLAG_COLUMN = "history_enabled";
    private static final String JID_TABLE = "user_jid";
    private static final String JID_ID_COLUMN = "jid_id";
    private static final String JID_SHA_COLUMN = "jid_sha";
    private static final String JID_COLUMN = "jid";
    private static final int StatementsCount = 2;
    private static final String MYSQL_CREATE_MSG_TABLE = "create table msg_history (   msg_id serial,  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  expired DATETIME,  sender_uid bigint unsigned,  receiver_uid bigint unsigned NOT NULL,  msg_type int NOT NULL,  message varchar(4096) NOT NULL,   key (expired),  key (sender_uid, receiver_uid), key (receiver_uid, sender_uid)) ENGINE=InnoDB default character set utf8 ROW_FORMAT=DYNAMIC;";
    private static final String PGSQL_CREATE_MSG_TABLE = "create table msg_history (   msg_id serial,  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  expired TIMESTAMP,  sender_uid bigint,  receiver_uid bigint NOT NULL,  msg_type int NOT NULL,  message varchar(4096) NOT NULL);create index index_expired on msg_history (expired);create index index_sender_uid_receiver_uid on msg_history(sender_uid,receiver_uid);create index index_receiver_uid_sender_uid on msg_history(receiver_uid,sender_uid);";
    private static final String SQLSERVER_CREATE_MSG_TABLE = "create table msg_history (   msg_id [bigint] IDENTITY(1,1),  ts [datetime] DEFAULT getdate() ,  expired [datetime] ,  sender_uid bigint,  receiver_uid bigint NOT NULL,  msg_type int NOT NULL,  message nvarchar(4000) NOT NULL);create index index_expired on msg_history (expired);create index index_sender_uid_receiver_uid on msg_history(sender_uid,receiver_uid);create index index_receiver_uid_sender_uid on msg_history(receiver_uid,sender_uid);";
    private static final String DERBY_CREATE_MSG_TABLE = "create table msg_history (   msg_id bigint generated by default as identity not null,  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  expired TIMESTAMP,  sender_uid bigint,  receiver_uid bigint NOT NULL,  msg_type int NOT NULL,  message varchar(4096) NOT NULL);create index index_expired on msg_history (expired);create index index_sender_uid_receiver_uid on msg_history(sender_uid,receiver_uid);create index index_receiver_uid_sender_uid on msg_history(receiver_uid,sender_uid);";
    private static final String MYSQL_CREATE_JID_TABLE = "create table user_jid (   jid_id serial,  jid_sha char(128) NOT NULL,  jid varchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id), unique key jid_sha (jid_sha), key jid (jid(255)))";
    private static final String PGSQL_CREATE_JID_TABLE = "create table user_jid (   jid_id serial,  jid_sha char(128) NOT NULL,  jid varchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id)); create unique index index_jid_sha on user_jid (jid_sha); create unique index index_jid on user_jid (jid); ";
    private static final String SQLSERVER_CREATE_JID_TABLE = "create table user_jid (   jid_id [bigint] IDENTITY(1,1),  jid_sha char(128) NOT NULL,  jid nvarchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id)); create unique index index_jid_sha on user_jid (jid_sha); create unique index index_jid on user_jid (jid); ";
    private static final String DERBY_CREATE_JID_TABLE = "create table user_jid (   jid_id bigint generated by default as identity not null,  jid_sha char(128) NOT NULL,  jid varchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id)); create unique index index_jid_sha on user_jid (jid_sha); create unique index index_jid on user_jid (jid); ";
    private static final String MSG_INSERT_QUERY = "insert into msg_history ( expired, sender_uid, receiver_uid, msg_type, message) values (?, ?, ?, ?, ?)";
    private static final String MSG_SELECT_TO_JID_QUERY = "select * from msg_history where receiver_uid = ?";
    private static final String MSG_SELECT_IDS_TO_JID_QUERY = "select * from msg_history where receiver_uid = ? AND msg_id IN ( ";
    private static final String MSG_SELECT_COUNT_TO_JID_QUERY = "select msg_type , count(msg_type) from msg_history where receiver_uid = ?  group by msg_type";
    private static final String MSG_SELECT_LIST_TO_JID_QUERY = "select msg_id,msg_type,jid from msg_history  left join user_jid ON msg_history.sender_uid=user_jid.jid_id where receiver_uid = ? ";
    private static final String MSG_DELETE_TO_JID_QUERY = "delete from msg_history where receiver_uid = ?";
    private static final String MSG_DELETE_IDS_TO_JID_QUERY = "delete from msg_history where receiver_uid = ? AND msg_id IN ( ";
    private static final String MSG_DELETE_ID_QUERY = "delete from msg_history where msg_id = ?";
    private static final String MSG_SELECT_EXPIRED_QUERY = "select * from msg_history where expired is not null order by expired";
    private static final String MSG_SELECT_EXPIRED_BEFORE_QUERY = "select * from msg_history where expired is not null and expired <= ? order by expired";
    private static final String MYSQL_CREATE_BROADCAST_MSGS_TABLE = "create table broadcast_msgs (   id varchar(128) NOT NULL,  expired datetime NOT NULL,  msg varchar(4096) NOT NULL,  primary key (id))";
    private static final String PGSQL_CREATE_BROADCAST_MSGS_TABLE = "create table broadcast_msgs (   id varchar(128) NOT NULL,  expired timestamp NOT NULL,  msg varchar(4096) NOT NULL,  primary key (id))";
    private static final String SQLSERVER_CREATE_BROADCAST_MSGS_TABLE = "create table broadcast_msgs (   id varchar(128) NOT NULL,  expired datetime NOT NULL,  msg nvarchar(4000) NOT NULL,  primary key (id))";
    private static final String DERBY_CREATE_BROADCAST_MSGS_TABLE = "create table broadcast_msgs (   id varchar(128) NOT NULL,  expired timestamp NOT NULL,  msg varchar(4096) NOT NULL,  primary key (id))";
    private static final String MYSQL_CREATE_BROADCAST_MSGS_RECIPIENTS_TABLE = "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint unsigned NOT NULL,   primary key (msg_id, jid_id))";
    private static final String PGSQL_CREATE_BROADCAST_MSGS_RECIPIENTS_TABLE = "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint NOT NULL,   primary key (msg_id, jid_id))";
    private static final String SQLSERVER_CREATE_BROADCAST_MSGS_RECIPIENTS_TABLE = "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint NOT NULL,   primary key (msg_id, jid_id))";
    private static final String DERBY_CREATE_BROADCAST_MSGS_RECIPIENTS_TABLE = "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint NOT NULL,   primary key (msg_id, jid_id))";
    private static final String MSG_SELECT_MESSAGES_TO_BROADCAST = "select id, expired, msg from broadcast_msgs where expired >= ?";
    private static final String SQLSERVER_MSG_INSERT_MESSAGE_TO_BROADCAST = "insert into broadcast_msgs (id, expired, msg) values (?, ?, ?) where not exists (select 1 from broadcast_msgs where id = ?)";
    private static final String SQL_MSG_INSERT_MESSAGE_TO_BROADCAST = "insert into broadcast_msgs (id, expired, msg) select ?, ?, ? from (select 1) x where not exists (select 1 from broadcast_msgs where id = ?)";
    private static final String DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST1 = "select id from broadcast_msgs where id = ?";
    private static final String DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST2 = "insert into broadcast_msgs (id, expired, msg) values (?,?,?)";
    private static final String MSG_SELECT_BROADCAST_RECIPIENTS = "select j.jid from broadcast_msgs_recipients r join user_jid j on j.jid_id = r.jid_id where r.msg_id = ?";
    private static final String SQLSERVER_MSG_ENSURE_BROADCAT_RECIPIETN = "insert into broadcast_msgs_recipients (msg_id, jid_id) values (?, ?) where not exists (select 1 from broadcast_msgs_recipients where msg_id = ? and jid_id = ?)";
    private static final String SQL_MSG_ENSURE_BROADCAT_RECIPIETN = "insert into broadcast_msgs_recipients (msg_id, jid_id) select ?, ? from (select 1) x where not exists (select 1 from broadcast_msgs_recipients where msg_id = ? and jid_id = ?)";
    private static final String DERBY_MSG_ENSURE_BROADCAT_RECIPIETN1 = "select 1 from broadcast_msgs_recipients where msg_id = ? and jid_id = ?";
    private static final String DERBY_MSG_ENSURE_BROADCAT_RECIPIETN2 = "insert into broadcast_msgs_recipients (msg_id, jid_id) values (?, ?)";
    private static final String GET_USER_UID_DEF_QUERY = "select jid_id, jid from user_jid where jid_sha = ?";
    private static final String MSG_COUNT_FOR_TO_AND_FROM_QUERY_DEF = "select count(*) from msg_history where receiver_uid = ? and sender_uid = ?";
    private static final String ADD_USER_JID_ID_QUERY = "insert into user_jid ( jid_sha, jid) values (?, ?)";
    private static final String GET_USER_UID_PROP_KEY = "user-uid-query";
    private static final String MSGS_COUNT_LIMIT_PROP_KEY = "count-limit-query";
    private static final int MAX_UID_CACHE_SIZE = 100000;
    private static final long MAX_UID_CACHE_TIME = 3600000L;
    private DataRepository data_repo = null;
    private String uid_query = "select jid_id, jid from user_jid where jid_sha = ?";
    private String msg_count_for_limit_query = "select count(*) from msg_history where receiver_uid = ? and sender_uid = ?";
    private String msg_insert_message_to_broadcast = "insert into broadcast_msgs (id, expired, msg) select ?, ?, ? from (select 1) x where not exists (select 1 from broadcast_msgs where id = ?)";
    private String msg_ensure_broadcast_recipient = "insert into broadcast_msgs_recipients (msg_id, jid_id) select ?, ? from (select 1) x where not exists (select 1 from broadcast_msgs_recipients where msg_id = ? and jid_id = ?)";
    private long msgs_store_limit = 100L;
    private boolean initialized = false;
    private Map<BareJID, Long> uids_cache = Collections.synchronizedMap(new SimpleCache(100000, 3600000L));

    @Override
    public void initRepository(String conn_str, Map<String, String> map) throws DBInitException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.log(Level.INFO, "Initializing dbAccess for db connection url: {0}", conn_str);
        if (map != null) {
            String msgs_store_limit_str;
            String query = map.get(GET_USER_UID_PROP_KEY);
            if (query != null) {
                this.uid_query = query;
            }
            if ((query = map.get(MSGS_COUNT_LIMIT_PROP_KEY)) != null) {
                this.msg_count_for_limit_query = query;
            }
            if ((msgs_store_limit_str = map.get("store-limit")) != null) {
                this.msgs_store_limit = Long.parseLong(msgs_store_limit_str);
            }
        }
        try {
            int j;
            StringBuilder select;
            int i;
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, map);
            switch (this.data_repo.getDatabaseType()) {
                case sqlserver: {
                    this.msg_ensure_broadcast_recipient = SQLSERVER_MSG_ENSURE_BROADCAT_RECIPIETN;
                    this.msg_insert_message_to_broadcast = SQLSERVER_MSG_INSERT_MESSAGE_TO_BROADCAST;
                    break;
                }
                default: {
                    this.msg_ensure_broadcast_recipient = SQL_MSG_ENSURE_BROADCAT_RECIPIETN;
                    this.msg_insert_message_to_broadcast = SQL_MSG_INSERT_MESSAGE_TO_BROADCAST;
                }
            }
            this.checkDB();
            this.data_repo.initPreparedStatement(this.uid_query, this.uid_query);
            this.data_repo.initPreparedStatement(MSG_INSERT_QUERY, MSG_INSERT_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_TO_JID_QUERY, MSG_SELECT_TO_JID_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_COUNT_TO_JID_QUERY, MSG_SELECT_COUNT_TO_JID_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_LIST_TO_JID_QUERY, MSG_SELECT_LIST_TO_JID_QUERY);
            this.data_repo.initPreparedStatement(MSG_DELETE_TO_JID_QUERY, MSG_DELETE_TO_JID_QUERY);
            this.data_repo.initPreparedStatement(MSG_DELETE_ID_QUERY, MSG_DELETE_ID_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_EXPIRED_QUERY, MSG_SELECT_EXPIRED_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_EXPIRED_BEFORE_QUERY, MSG_SELECT_EXPIRED_BEFORE_QUERY);
            this.data_repo.initPreparedStatement(this.msg_count_for_limit_query, this.msg_count_for_limit_query);
            this.data_repo.initPreparedStatement(ADD_USER_JID_ID_QUERY, ADD_USER_JID_ID_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_BROADCAST_RECIPIENTS, MSG_SELECT_BROADCAST_RECIPIENTS);
            this.data_repo.initPreparedStatement(MSG_SELECT_MESSAGES_TO_BROADCAST, MSG_SELECT_MESSAGES_TO_BROADCAST);
            if (this.data_repo.getDatabaseType() == DataRepository.dbTypes.derby) {
                this.data_repo.initPreparedStatement(DERBY_MSG_ENSURE_BROADCAT_RECIPIETN1, DERBY_MSG_ENSURE_BROADCAT_RECIPIETN1);
                this.data_repo.initPreparedStatement(DERBY_MSG_ENSURE_BROADCAT_RECIPIETN2, DERBY_MSG_ENSURE_BROADCAT_RECIPIETN2);
                this.data_repo.initPreparedStatement(DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST1, DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST1);
                this.data_repo.initPreparedStatement(DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST2, DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST2);
            } else {
                this.data_repo.initPreparedStatement(this.msg_ensure_broadcast_recipient, this.msg_ensure_broadcast_recipient);
                this.data_repo.initPreparedStatement(this.msg_insert_message_to_broadcast, this.msg_insert_message_to_broadcast);
            }
            for (i = 1; i <= 2; ++i) {
                select = new StringBuilder().append(MSG_DELETE_IDS_TO_JID_QUERY);
                for (j = 1; j <= i; ++j) {
                    if (j > 1) {
                        select.append(" , ");
                    }
                    select.append(" ? ");
                }
                select.append(")");
                this.data_repo.initPreparedStatement("delete from msg_history where receiver_uid = ? AND msg_id IN ( _" + i, select.toString());
            }
            for (i = 1; i <= 2; ++i) {
                select = new StringBuilder().append(MSG_SELECT_IDS_TO_JID_QUERY);
                for (j = 1; j <= i; ++j) {
                    if (j > 1) {
                        select.append(" , ");
                    }
                    select.append(" ? ");
                }
                select.append(")");
                this.data_repo.initPreparedStatement("select * from msg_history where receiver_uid = ? AND msg_id IN ( _" + i, select.toString());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "MsgRepository not initialized due to exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MsgRepository.MSG_TYPES, Long> getMessagesCount(JID to) throws UserNotFoundException {
        HashMap<MsgRepository.MSG_TYPES, Long> result = new HashMap<MsgRepository.MSG_TYPES, Long>(MsgRepository.MSG_TYPES.values().length);
        try {
            PreparedStatement number_of_messages;
            ResultSet rs = null;
            long to_uid = this.getUserUID(to.getBareJID());
            if (to_uid < 0L) {
                throw new UserNotFoundException("User: " + to + " was not found in database.");
            }
            PreparedStatement preparedStatement = number_of_messages = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_SELECT_COUNT_TO_JID_QUERY);
            synchronized (preparedStatement) {
                number_of_messages.setLong(1, to_uid);
                rs = number_of_messages.executeQuery();
                while (rs.next()) {
                    int msgType = rs.getInt(1);
                    long msgCount = rs.getLong(2);
                    result.put(MsgRepository.MSG_TYPES.getFromInt(msgType), msgCount);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + to, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Element> getMessagesList(JID to) throws UserNotFoundException {
        LinkedList<Element> result = new LinkedList<Element>();
        ResultSet rs = null;
        try {
            PreparedStatement select_messages_list;
            long to_uid = this.getUserUID(to.getBareJID());
            if (to_uid < 0L) {
                throw new UserNotFoundException("User: " + to + " was not found in database.");
            }
            PreparedStatement preparedStatement = select_messages_list = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_SELECT_LIST_TO_JID_QUERY);
            synchronized (preparedStatement) {
                select_messages_list.setLong(1, to_uid);
                rs = select_messages_list.executeQuery();
                while (rs.next()) {
                    long msgId = rs.getLong(MSG_ID_COLUMN);
                    int mType = rs.getInt(MSG_TYPE_COLUMN);
                    MsgRepository.MSG_TYPES messageType = MsgRepository.MSG_TYPES.getFromInt(mType);
                    String sender = rs.getString(JID_COLUMN);
                    if (msgId == 0L || messageType == MsgRepository.MSG_TYPES.none || sender == null) continue;
                    Element item = new Element("item", new String[]{JID_COLUMN, "node", "type", "name"}, new String[]{to.getBareJID().toString(), String.valueOf(msgId), messageType.name(), sender});
                    result.add(item);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + to, e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Element> loadMessagesToJID(List<String> db_ids, JID to, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        LinkedList<Element> result = null;
        ResultSet rs = null;
        try {
            long to_uid = this.getUserUID(to.getBareJID());
            if (to_uid < 0L) {
                throw new UserNotFoundException("User: " + to + " was not found in database.");
            }
            if (db_ids == null || db_ids.size() == 0) {
                Queue<Element> queue = this.loadMessagesToJID(to, delete, proc);
                return queue;
            }
            result = new LinkedList<Element>();
            Iterator<String> ids = db_ids.iterator();
            int iters = db_ids.size() / 2 + 1;
            for (int i = 0; i < iters; ++i) {
                PreparedStatement select_ids_to_jid_st;
                int params;
                int n = params = i == iters - 1 ? db_ids.size() % 2 : 2;
                if (params == 0) continue;
                PreparedStatement preparedStatement = select_ids_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), "select * from msg_history where receiver_uid = ? AND msg_id IN ( _" + params);
                synchronized (preparedStatement) {
                    select_ids_to_jid_st.setLong(1, to_uid);
                    for (int j = 0; j < params; ++j) {
                        String id = ids.next();
                        select_ids_to_jid_st.setString(j + 2, id);
                    }
                    rs = select_ids_to_jid_st.executeQuery();
                    result.addAll(this.parseLoadedMessages(proc, rs));
                    this.data_repo.release(null, rs);
                    rs = null;
                    continue;
                }
            }
            if (delete) {
                this.deleteMessagesToJID(null, to);
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + to, e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteMessagesToJID(List<String> db_ids, JID to) throws UserNotFoundException {
        int affectedRows;
        block12: {
            affectedRows = 0;
            try {
                long to_uid = this.getUserUID(to.getBareJID());
                if (to_uid < 0L) {
                    throw new UserNotFoundException("User: " + to + " was not found in database.");
                }
                if (db_ids == null || db_ids.size() == 0) {
                    PreparedStatement delete_to_jid_st;
                    PreparedStatement preparedStatement = delete_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_DELETE_TO_JID_QUERY);
                    synchronized (preparedStatement) {
                        delete_to_jid_st.setLong(1, to_uid);
                        affectedRows += delete_to_jid_st.executeUpdate();
                        break block12;
                    }
                }
                Iterator<String> ids = db_ids.iterator();
                int iters = db_ids.size() / 2 + 1;
                for (int i = 0; i < iters; ++i) {
                    PreparedStatement delete_to_jid_st;
                    int params;
                    int n = params = i == iters - 1 ? db_ids.size() % 2 : 2;
                    if (params == 0) continue;
                    PreparedStatement preparedStatement = delete_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), "delete from msg_history where receiver_uid = ? AND msg_id IN ( _" + params);
                    synchronized (preparedStatement) {
                        delete_to_jid_st.setLong(1, to_uid);
                        for (int j = 0; j < params; ++j) {
                            String id = ids.next();
                            delete_to_jid_st.setString(j + 2, id);
                        }
                        affectedRows += delete_to_jid_st.executeUpdate();
                        continue;
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting offline messages for user: " + to, e);
            }
        }
        return affectedRows;
    }

    @Override
    public Queue<Element> loadMessagesToJID(JID to, boolean delete) throws UserNotFoundException {
        return this.loadMessagesToJID(to, delete, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Element> loadMessagesToJID(JID to, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        Queue<Element> result = null;
        ResultSet rs = null;
        try {
            PreparedStatement select_to_jid_st;
            long to_uid = this.getUserUID(to.getBareJID());
            if (to_uid < 0L) {
                throw new UserNotFoundException("User: " + to + " was not found in database.");
            }
            PreparedStatement preparedStatement = select_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_SELECT_TO_JID_QUERY);
            synchronized (preparedStatement) {
                select_to_jid_st.setLong(1, to_uid);
                rs = select_to_jid_st.executeQuery();
                StringBuilder sb = new StringBuilder(1000);
                result = this.parseLoadedMessages(proc, rs);
            }
            if (delete) {
                PreparedStatement delete_to_jid_st;
                PreparedStatement preparedStatement2 = delete_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_DELETE_TO_JID_QUERY);
                synchronized (preparedStatement2) {
                    delete_to_jid_st.setLong(1, to_uid);
                    delete_to_jid_st.executeUpdate();
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + to, e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        return result;
    }

    private Queue<Element> parseLoadedMessages(MsgRepository.OfflineMessagesProcessor proc, ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder(1000);
        Queue<Element> result = new LinkedList<Element>();
        if (proc == null) {
            while (rs.next()) {
                sb.append(rs.getString(MSG_BODY_COLUMN));
            }
            if (sb.length() > 0) {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse(domHandler, sb.toString().toCharArray(), 0, sb.length());
                result = domHandler.getParsedElements();
            }
        } else {
            result = new LinkedList();
            while (rs.next()) {
                String msg = rs.getString(MSG_BODY_COLUMN);
                long msgId = rs.getLong(MSG_ID_COLUMN);
                if (msg == null) continue;
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse(domHandler, msg.toCharArray(), 0, msg.length());
                Queue<Element> parsedElements = domHandler.getParsedElements();
                Element msgEl = parsedElements.poll();
                if (msgEl == null || msgId <= 0L) continue;
                proc.stamp(msgEl, String.valueOf(msgId));
                result.add(msgEl);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(JID from, JID to, Date expired, Element msg) throws UserNotFoundException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Storring expired: {0} message: {1}", new Object[]{expired, Packet.elemToString(msg)});
        }
        ResultSet rs = null;
        try {
            PreparedStatement insert_msg_st;
            PreparedStatement preparedStatement;
            long to_uid;
            long from_uid = this.getUserUID(from.getBareJID());
            if (from_uid < 0L) {
                from_uid = this.addUserJID(from.getBareJID());
            }
            if ((to_uid = this.getUserUID(to.getBareJID())) < 0L) {
                to_uid = this.addUserJID(to.getBareJID());
            }
            long count = 0L;
            if (this.msgs_store_limit > 0L) {
                PreparedStatement count_msgs_st;
                preparedStatement = count_msgs_st = this.data_repo.getPreparedStatement(to.getBareJID(), this.msg_count_for_limit_query);
                synchronized (preparedStatement) {
                    count_msgs_st.setLong(1, to_uid);
                    count_msgs_st.setLong(2, from_uid);
                    rs = count_msgs_st.executeQuery();
                    if (rs.next()) {
                        count = rs.getLong(1);
                    }
                }
            }
            if (this.msgs_store_limit > 0L && this.msgs_store_limit <= count) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Message store limit ({0}) exceeded for message: {1}", new Object[]{this.msgs_store_limit, Packet.elemToString(msg)});
                }
                return;
            }
            preparedStatement = insert_msg_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_INSERT_QUERY);
            synchronized (preparedStatement) {
                int msg_type;
                if (expired == null) {
                    insert_msg_st.setNull(1, 93);
                } else {
                    Timestamp time = new Timestamp(expired.getTime());
                    insert_msg_st.setTimestamp(1, time);
                }
                if (from_uid <= 0L) {
                    insert_msg_st.setNull(2, -5);
                } else {
                    insert_msg_st.setLong(2, from_uid);
                }
                insert_msg_st.setLong(3, to_uid);
                try {
                    String name = msg.getName();
                    MsgRepository.MSG_TYPES valueOf = MsgRepository.MSG_TYPES.valueOf(name);
                    msg_type = valueOf.ordinal();
                }
                catch (IllegalArgumentException e) {
                    msg_type = Integer.MAX_VALUE;
                }
                insert_msg_st.setLong(4, msg_type);
                insert_msg_st.setString(5, msg.toString());
                insert_msg_st.executeUpdate();
            }
            if (expired != null) {
                if (expired.getTime() < this.earliestOffline) {
                    this.earliestOffline = expired.getTime();
                }
                if (this.expiredQueue.size() == 0) {
                    this.loadExpiredQueue(1);
                }
            }
        }
        catch (DataTruncation dte) {
            log.log(Level.FINE, "Data truncated for message from {0} to {1}", new Object[]{from, to});
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadMessagesToBroadcast() {
        ResultSet rs = null;
        try {
            PreparedStatement stmt;
            HashSet oldMessages = new HashSet(this.broadcastMessages.keySet());
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(null, MSG_SELECT_MESSAGES_TO_BROADCAST);
            synchronized (preparedStatement) {
                stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                rs = stmt.executeQuery();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                while (rs.next()) {
                    String msgId = rs.getString(1);
                    oldMessages.remove(msgId);
                    if (this.broadcastMessages.containsKey(msgId)) continue;
                    Timestamp expire = rs.getTimestamp(2);
                    char[] msgChars = rs.getString(3).toCharArray();
                    this.parser.parse(domHandler, msgChars, 0, msgChars.length);
                    Queue<Element> elems = domHandler.getParsedElements();
                    Element msg = elems.poll();
                    if (msg == null) continue;
                    this.broadcastMessages.put(msgId, new MsgRepository.BroadcastMsg(this, null, msg, expire));
                }
            }
            for (String id : oldMessages) {
                this.broadcastMessages.remove(id);
            }
            this.data_repo.release(null, rs);
            rs = null;
            for (String id : this.broadcastMessages.keySet()) {
                MsgRepository.BroadcastMsg bmsg = (MsgRepository.BroadcastMsg)this.broadcastMessages.get(id);
                PreparedStatement preparedStatement2 = stmt = this.data_repo.getPreparedStatement(null, MSG_SELECT_BROADCAST_RECIPIENTS);
                synchronized (preparedStatement2) {
                    stmt.setString(1, id);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        BareJID jid = BareJID.bareJIDInstanceNS(rs.getString(1));
                        bmsg.addRecipient(jid);
                    }
                }
                this.data_repo.release(null, rs);
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "Problem with retrieving broadcast messages", ex);
        }
        finally {
            this.data_repo.release(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
        block12: {
            try {
                PreparedStatement stmt;
                if (this.data_repo.getDatabaseType() == DataRepository.dbTypes.derby) {
                    PreparedStatement stmt2;
                    boolean exists = false;
                    PreparedStatement preparedStatement = stmt2 = this.data_repo.getPreparedStatement(recipient, DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST1);
                    synchronized (preparedStatement) {
                        stmt2.setString(1, id);
                        ResultSet rs = stmt2.executeQuery();
                        exists = rs.next();
                        this.data_repo.release(null, rs);
                    }
                    if (exists) break block12;
                    preparedStatement = stmt2 = this.data_repo.getPreparedStatement(recipient, DERBY_MSG_INSERT_MESSAGE_TO_BROADCAST2);
                    synchronized (preparedStatement) {
                        stmt2.setString(1, id);
                        stmt2.setTimestamp(2, new Timestamp(expire.getTime()));
                        stmt2.setString(3, msg.toString());
                        stmt2.executeUpdate();
                        break block12;
                    }
                }
                PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(recipient, this.msg_insert_message_to_broadcast);
                synchronized (preparedStatement) {
                    stmt.setString(1, id);
                    stmt.setTimestamp(2, new Timestamp(expire.getTime()));
                    stmt.setString(3, msg.toString());
                    stmt.setString(4, id);
                    stmt.executeUpdate();
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem with updating broadcast message", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureBroadcastMessageRecipient(String id, BareJID recipient) {
        block13: {
            try {
                PreparedStatement stmt;
                long uid = this.getUserUID(recipient);
                if (uid == -1L) {
                    uid = this.addUserJID(recipient);
                }
                if (this.data_repo.getDatabaseType() == DataRepository.dbTypes.derby) {
                    PreparedStatement stmt2;
                    boolean exists = false;
                    PreparedStatement preparedStatement = stmt2 = this.data_repo.getPreparedStatement(recipient, DERBY_MSG_ENSURE_BROADCAT_RECIPIETN1);
                    synchronized (preparedStatement) {
                        stmt2.setString(1, id);
                        stmt2.setLong(2, uid);
                        ResultSet rs = stmt2.executeQuery();
                        exists = rs.next();
                        this.data_repo.release(null, rs);
                    }
                    if (exists) break block13;
                    preparedStatement = stmt2 = this.data_repo.getPreparedStatement(recipient, DERBY_MSG_ENSURE_BROADCAT_RECIPIETN2);
                    synchronized (preparedStatement) {
                        stmt2.setString(1, id);
                        stmt2.setLong(2, uid);
                        stmt2.executeUpdate();
                        break block13;
                    }
                }
                PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(recipient, this.msg_ensure_broadcast_recipient);
                synchronized (preparedStatement) {
                    stmt.setString(1, id);
                    stmt.setLong(2, uid);
                    stmt.setString(3, id);
                    stmt.setLong(4, uid);
                    stmt.executeUpdate();
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem with updating broadcast message", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addUserJID(BareJID bareJID) throws SQLException, UserNotFoundException {
        try {
            PreparedStatement add_jid_id_st;
            String jid_sha = Algorithms.hexDigest(bareJID.toString(), "", "SHA");
            PreparedStatement preparedStatement = add_jid_id_st = this.data_repo.getPreparedStatement(bareJID, ADD_USER_JID_ID_QUERY);
            synchronized (preparedStatement) {
                add_jid_id_st.setString(1, jid_sha);
                add_jid_id_st.setString(2, bareJID.toString());
                add_jid_id_st.executeUpdate();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.WARNING, "Configuration error or code bug: ", ex);
            return -1L;
        }
        return this.getUserUID(bareJID);
    }

    private void checkDB() throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.data_repo.createStatement(null);
            stmt.executeQuery("select msg_type from msg_history where msg_id = 0");
        }
        catch (SQLException ex) {
            log.log(Level.INFO, "msg_history table was in old version, performing update to add missing column");
            String alterTable = null;
            try {
                alterTable = "alter table msg_history add msg_type int NOT NULL;";
                if (stmt == null) {
                    stmt = this.data_repo.createStatement(null);
                }
                stmt.execute(alterTable);
            }
            catch (SQLException ex1) {
                log.log(Level.SEVERE, "could not alter table msg_history to add missing column by SQL:\n" + alterTable, ex1);
            }
        }
        DataRepository.dbTypes databaseType = this.data_repo.getDatabaseType();
        switch (databaseType) {
            case mysql: {
                this.data_repo.checkTable(JID_TABLE, MYSQL_CREATE_JID_TABLE);
                this.data_repo.checkTable(MSG_TABLE, MYSQL_CREATE_MSG_TABLE);
                this.data_repo.checkTable("broadcast_msgs", MYSQL_CREATE_BROADCAST_MSGS_TABLE);
                this.data_repo.checkTable("broadcast_msgs_recipients", MYSQL_CREATE_BROADCAST_MSGS_RECIPIENTS_TABLE);
                break;
            }
            case postgresql: {
                this.data_repo.checkTable(JID_TABLE, PGSQL_CREATE_JID_TABLE);
                this.data_repo.checkTable(MSG_TABLE, PGSQL_CREATE_MSG_TABLE);
                this.data_repo.checkTable("broadcast_msgs", "create table broadcast_msgs (   id varchar(128) NOT NULL,  expired timestamp NOT NULL,  msg varchar(4096) NOT NULL,  primary key (id))");
                this.data_repo.checkTable("broadcast_msgs_recipients", "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint NOT NULL,   primary key (msg_id, jid_id))");
                break;
            }
            case derby: {
                this.data_repo.checkTable(JID_TABLE, DERBY_CREATE_JID_TABLE);
                this.data_repo.checkTable(MSG_TABLE, DERBY_CREATE_MSG_TABLE);
                this.data_repo.checkTable("broadcast_msgs", "create table broadcast_msgs (   id varchar(128) NOT NULL,  expired timestamp NOT NULL,  msg varchar(4096) NOT NULL,  primary key (id))");
                this.data_repo.checkTable("broadcast_msgs_recipients", "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint NOT NULL,   primary key (msg_id, jid_id))");
                break;
            }
            case sqlserver: 
            case jtds: {
                this.data_repo.checkTable(JID_TABLE, SQLSERVER_CREATE_JID_TABLE);
                this.data_repo.checkTable(MSG_TABLE, SQLSERVER_CREATE_MSG_TABLE);
                this.data_repo.checkTable("broadcast_msgs", SQLSERVER_CREATE_BROADCAST_MSGS_TABLE);
                this.data_repo.checkTable("broadcast_msgs_recipients", "create table broadcast_msgs_recipients (   msg_id varchar(128) NOT NULL,  jid_id bigint NOT NULL,   primary key (msg_id, jid_id))");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteMessage(Long msg_id) {
        try {
            PreparedStatement delete_id_st;
            PreparedStatement preparedStatement = delete_id_st = this.data_repo.getPreparedStatement(null, MSG_DELETE_ID_QUERY);
            synchronized (preparedStatement) {
                delete_id_st.setLong(1, msg_id);
                delete_id_st.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem removing entry from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUserUID(BareJID user_id) throws SQLException, UserNotFoundException {
        String jid_sha;
        Long cache_res = this.uids_cache.get(user_id);
        if (cache_res != null) {
            return cache_res;
        }
        ResultSet rs = null;
        long result = -1L;
        try {
            jid_sha = Algorithms.hexDigest(user_id.toString(), "", "SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.WARNING, "Configuration error or code bug: ", ex);
            return -1L;
        }
        try {
            PreparedStatement uid_st;
            PreparedStatement preparedStatement = uid_st = this.data_repo.getPreparedStatement(user_id, this.uid_query);
            synchronized (preparedStatement) {
                uid_st.setString(1, jid_sha);
                rs = uid_st.executeQuery();
                if (rs.next()) {
                    BareJID res_jid = BareJID.bareJIDInstanceNS(rs.getString(JID_COLUMN));
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Found entry for JID: {0}, DB JID: {1}", new Object[]{user_id, res_jid});
                    }
                    if (user_id.equals(res_jid)) {
                        result = rs.getLong(JID_ID_COLUMN);
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "JIDs don't match, SHA conflict? JID: {0}, DB JID: {1}", new Object[]{user_id, res_jid});
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No entry for JID: {0}", user_id);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        if (result > 0L) {
            this.uids_cache.put(user_id, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExpiredQueue(int min_elements) {
        ResultSet rs = null;
        try {
            PreparedStatement select_expired_st;
            PreparedStatement preparedStatement = select_expired_st = this.data_repo.getPreparedStatement(null, MSG_SELECT_EXPIRED_QUERY);
            synchronized (preparedStatement) {
                rs = select_expired_st.executeQuery();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                int counter = 0;
                while (rs.next() && (this.expiredQueue.size() < 1000 || counter++ < min_elements)) {
                    String msg_str = rs.getString(MSG_BODY_COLUMN);
                    this.parser.parse(domHandler, msg_str.toCharArray(), 0, msg_str.length());
                    Queue<Element> elems = domHandler.getParsedElements();
                    Element msg = elems.poll();
                    if (msg == null) {
                        log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                        continue;
                    }
                    Timestamp ts = rs.getTimestamp(MSG_EXPIRED_COLUMN);
                    MsgRepository.MsgDBItem item = new MsgRepository.MsgDBItem(this, rs.getLong(MSG_ID_COLUMN), msg, ts);
                    this.expiredQueue.offer(item);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExpiredQueue(Date expired) {
        ResultSet rs = null;
        try {
            PreparedStatement select_expired_before_st;
            if (this.expiredQueue.size() > 100000) {
                this.expiredQueue.clear();
            }
            PreparedStatement preparedStatement = select_expired_before_st = this.data_repo.getPreparedStatement(null, MSG_SELECT_EXPIRED_BEFORE_QUERY);
            synchronized (preparedStatement) {
                select_expired_before_st.setTimestamp(1, new Timestamp(expired.getTime()));
                rs = select_expired_before_st.executeQuery();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                int counter = 0;
                while (rs.next() && counter++ < 1000) {
                    String msg_str = rs.getString(MSG_BODY_COLUMN);
                    this.parser.parse(domHandler, msg_str.toCharArray(), 0, msg_str.length());
                    Queue<Element> elems = domHandler.getParsedElements();
                    Element msg = elems.poll();
                    if (msg == null) {
                        log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                        continue;
                    }
                    Timestamp ts = rs.getTimestamp(MSG_EXPIRED_COLUMN);
                    MsgRepository.MsgDBItem item = new MsgRepository.MsgDBItem(this, rs.getLong(MSG_ID_COLUMN), msg, ts);
                    this.expiredQueue.offer(item);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }
}

