/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.PBKDIterationsCallback;
import tigase.auth.callbacks.SaltCallback;
import tigase.auth.callbacks.SaltedPasswordCallback;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.util.Base64;

public abstract class AbstractSaslSCRAM
extends AbstractSasl {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final Pattern CLIENT_FIRST_MESSAGE = Pattern.compile("^(?<gs2Header>(?:y|n|p=(?<cbName>[a-zA-z0-9.-]+)),(?:a=(?<authzid>(?:[\\x21-\\x2B\\x2D-\\x7E]|=2C|=3D)+))?,)(?<clientFirstBare>(?<mext>m=[^\\000=]+,)?n=(?<username>(?:[\\x21-\\x2B\\x2D-\\x7E]|=2C|=3D)+),r=(?<nonce>[\\x21-\\x2B\\x2D-\\x7E]+)(?:,.*)?)$");
    private static final Pattern CLIENT_LAST_MESSAGE = Pattern.compile("^(?<withoutPoof>c=(?<cb>[a-zA-Z0-9/+=]+),(?:r=(?<nonce>[\\x21-\\x2B\\x2D-\\x7E]+))(?:,.*)?),p=(?<proof>[a-zA-Z0-9/+=]+)$");
    private final String algorithm;
    private String cfmAuthzid;
    private String cfmBareMessage;
    private String cfmCbname;
    private String cfmGs2header;
    private String cfmUsername;
    private byte[] clientKey;
    private final byte[] clientKeyData;
    private final String mechanismName;
    private Random random = new SecureRandom();
    private byte[] saltedPassword;
    private final byte[] serverKeyData;
    private final String serverNonce;
    private String sfmMessage;
    private String sfmNonce;
    private Step step = Step.clientFirstMessage;
    private byte[] storedKey;

    public static byte[] hi(String algorithm, byte[] password, byte[] salt, int iterations) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec k = new SecretKeySpec(password, "Hmac" + algorithm);
        byte[] z = new byte[salt.length + 4];
        System.arraycopy(salt, 0, z, 0, salt.length);
        System.arraycopy(new byte[]{0, 0, 0, 1}, 0, z, salt.length, 4);
        byte[] u = AbstractSaslSCRAM.hmac(k, z);
        byte[] result = new byte[u.length];
        System.arraycopy(u, 0, result, 0, result.length);
        for (int i = 1; i < iterations; ++i) {
            u = AbstractSaslSCRAM.hmac(k, u);
            for (int j = 0; j < u.length; ++j) {
                int n = j;
                result[n] = (byte)(result[n] ^ u[j]);
            }
        }
        return result;
    }

    protected static byte[] hmac(SecretKey key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        return mac.doFinal(data);
    }

    public static byte[] normalize(String str) {
        return str.getBytes(CHARSET);
    }

    protected AbstractSaslSCRAM(String mechanismName, String algorithm, byte[] clientKey, byte[] serverKey, Map<? super String, ?> props, CallbackHandler callbackHandler) {
        super(props, callbackHandler);
        this.mechanismName = mechanismName;
        this.algorithm = algorithm;
        this.clientKeyData = clientKey;
        this.serverKeyData = serverKey;
        this.serverNonce = this.randomString();
    }

    protected AbstractSaslSCRAM(String mechanismName, String algorithm, byte[] clientKey, byte[] serverKey, Map<? super String, ?> props, CallbackHandler callbackHandler, String serverOnce) {
        super(props, callbackHandler);
        this.mechanismName = mechanismName;
        this.algorithm = algorithm;
        this.clientKeyData = clientKey;
        this.serverKeyData = serverKey;
        this.serverNonce = serverOnce;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            switch (this.step) {
                case clientFirstMessage: {
                    return this.processClientFirstMessage(response);
                }
                case clientFinalMessage: {
                    return this.processClientLastMessage(response);
                }
            }
            throw new SaslException(this.getMechanismName() + ": Server at illegal state");
        }
        catch (SaslException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaslException("SASL Failed", e);
        }
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return this.mechanismName;
    }

    protected byte[] h(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        return digest.digest(data);
    }

    protected SecretKey key(byte[] key) {
        return new SecretKeySpec(key, "Hmac" + this.algorithm);
    }

    protected byte[] processClientFirstMessage(byte[] data) throws SaslException, InvalidKeyException, NoSuchAlgorithmException {
        Matcher r = CLIENT_FIRST_MESSAGE.matcher(new String(data));
        if (!r.matches()) {
            throw new SaslException("Bad challenge syntax");
        }
        this.cfmGs2header = r.group("gs2Header");
        this.cfmCbname = r.group("cbName");
        this.cfmAuthzid = r.group("authzid");
        this.cfmBareMessage = r.group("clientFirstBare");
        String cfmMext = r.group("mext");
        this.cfmUsername = r.group("username");
        String cfmNonce = r.group("nonce");
        if (this.cfmAuthzid == null) {
            this.cfmAuthzid = this.cfmUsername;
        }
        NameCallback nc = new NameCallback("Authentication identity", this.cfmUsername);
        PBKDIterationsCallback ic = new PBKDIterationsCallback("PBKD2 iterations");
        SaltCallback sc = new SaltCallback("Salt");
        SaltedPasswordCallback pc = new SaltedPasswordCallback("Salted password");
        this.handleCallbacks(nc, ic, sc, pc);
        if (pc.getSaltedPassword() == null) {
            throw new SaslException("Unknown user");
        }
        this.sfmNonce = cfmNonce + this.serverNonce;
        this.saltedPassword = pc.getSaltedPassword();
        this.clientKey = AbstractSaslSCRAM.hmac(this.key(this.saltedPassword), this.clientKeyData);
        this.storedKey = this.h(this.clientKey);
        StringBuilder serverStringMessage = new StringBuilder();
        serverStringMessage.append("r=").append(this.sfmNonce).append(",");
        serverStringMessage.append("s=").append(Base64.encode(sc.getSalt())).append(",");
        serverStringMessage.append("i=").append(ic.getInterations());
        this.sfmMessage = serverStringMessage.toString();
        this.step = Step.clientFinalMessage;
        return this.sfmMessage.getBytes();
    }

    protected byte[] processClientLastMessage(byte[] data) throws SaslException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] dcp;
        Matcher r = CLIENT_LAST_MESSAGE.matcher(new String(data));
        if (!r.matches()) {
            throw new SaslException("Bad challenge syntax");
        }
        String clmWithoutPoof = r.group("withoutPoof");
        String clmCb = new String(Base64.decode(r.group("cb")));
        String clmNonce = r.group("nonce");
        String clmProof = r.group("proof");
        if (!clmCb.startsWith(this.cfmGs2header)) {
            throw new XmppSaslException(XmppSaslException.SaslError.not_authorized, "Invalid GS2 header");
        }
        if (!clmNonce.equals(this.sfmNonce)) {
            throw new XmppSaslException(XmppSaslException.SaslError.not_authorized, "Wrong nonce");
        }
        String authMessage = this.cfmBareMessage + "," + this.sfmMessage + "," + clmWithoutPoof;
        byte[] clientSignature = AbstractSaslSCRAM.hmac(this.key(this.storedKey), authMessage.getBytes());
        byte[] clientProof = this.xor(this.clientKey, clientSignature);
        boolean proofMatch = Arrays.equals(clientProof, dcp = Base64.decode(clmProof));
        if (!proofMatch) {
            throw new XmppSaslException(XmppSaslException.SaslError.not_authorized, "Password not verified");
        }
        AuthorizeCallback ac = new AuthorizeCallback(this.cfmUsername, this.cfmAuthzid);
        this.handleCallbacks(ac);
        if (!ac.isAuthorized()) {
            throw new XmppSaslException(XmppSaslException.SaslError.invalid_authzid, "SCRAM: " + this.cfmAuthzid + " is not authorized to act as " + this.cfmAuthzid);
        }
        this.authorizedId = ac.getAuthorizedID();
        byte[] serverKey = AbstractSaslSCRAM.hmac(this.key(this.saltedPassword), this.serverKeyData);
        byte[] serverSignature = AbstractSaslSCRAM.hmac(this.key(serverKey), authMessage.getBytes());
        StringBuilder serverStringMessage = new StringBuilder();
        serverStringMessage.append("v=").append(Base64.encode(serverSignature));
        this.step = Step.finished;
        this.complete = true;
        return serverStringMessage.toString().getBytes();
    }

    private String randomString() {
        int length = 20;
        int x = ALPHABET.length();
        char[] buffer = new char[20];
        for (int i = 0; i < 20; ++i) {
            int r = this.random.nextInt(x);
            buffer[i] = ALPHABET.charAt(r);
        }
        return new String(buffer);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return null;
    }

    protected byte[] xor(byte[] a, byte[] b) {
        int l = a.length;
        byte[] r = new byte[l];
        for (int i = 0; i < l; ++i) {
            r[i] = (byte)(a[i] ^ b[i]);
        }
        return r;
    }

    private static enum Step {
        clientFinalMessage,
        clientFirstMessage,
        finished;

    }
}

