/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class MobileV3
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc {
    private static final int DEF_MAX_QUEUE_SIZE_VAL = 50;
    private static final String ID = "mobile_v3";
    private static final Logger log = Logger.getLogger(MobileV3.class.getCanonicalName());
    private static final String MAX_QUEUE_SIZE_KEY = "max-queue-size";
    private static final String MOBILE_EL_NAME = "mobile";
    private static final String XMLNS = "http://tigase.org/protocol/mobile#v3";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"iq", "mobile"}};
    private static final String[] XMLNSS = new String[]{"http://tigase.org/protocol/mobile#v3"};
    private static final Element[] SUP_FEATURES = new Element[]{new Element("mobile", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/mobile#v3"})};
    private static final String PRESENCE_QUEUE_KEY = "mobile_v3-presence-queue";
    private static final String PACKET_QUEUE_KEY = "mobile_v3-packet-queue";
    private static final String DELAY_ELEM_NAME = "delay";
    private static final String DELAY_XMLNS = "urn:xmpp:delay";
    private static final String MESSAGE_ELEM_NAME = "message";
    private static final ThreadLocal<Queue> prependResultsThreadQueue = new ThreadLocal();
    private int maxQueueSize = 50;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public MobileV3() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        Integer maxQueueSizeVal = (Integer)settings.get(MAX_QUEUE_SIZE_KEY);
        if (maxQueueSizeVal != null) {
            this.maxQueueSize = maxQueueSizeVal;
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        try {
            StanzaType type = packet.getType();
            switch (type) {
                case set: {
                    boolean value;
                    Element el = packet.getElement().getChild(MOBILE_EL_NAME);
                    String valueStr = el.getAttributeStaticStr("enable");
                    boolean bl = value = valueStr != null && ("true".equals(valueStr) || "1".equals(valueStr));
                    if (session.getSessionData(PRESENCE_QUEUE_KEY) == null) {
                        session.putSessionData(PRESENCE_QUEUE_KEY, new ConcurrentHashMap());
                    }
                    if (session.getSessionData(PACKET_QUEUE_KEY) == null) {
                        session.putSessionData(PACKET_QUEUE_KEY, new ArrayDeque());
                    }
                    session.putSessionData(XMLNS, value);
                    results.offer(packet.okResult((Element)null, 0));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Mobile processing type is incorrect", false));
                    break;
                }
            }
        }
        catch (PacketErrorTypeException ex) {
            Logger.getLogger(MobileV3.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null) {
            return null;
        }
        if (!session.isAuthorized()) {
            return null;
        }
        return SUP_FEATURES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void filter(Packet _packet, XMPPResourceConnection sessionFromSM, NonAuthUserRepository repo, Queue<Packet> results) {
        if (sessionFromSM == null || !sessionFromSM.isAuthorized() || results == null || results.size() == 0) {
            return;
        }
        ArrayDeque<Packet> prependResults = null;
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Packet res = (Packet)it.next();
            if (res == null || res.getPacketTo() == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("packet without destination");
                continue;
            }
            XMPPResourceConnection session = sessionFromSM.getParentSession().getResourceForConnectionId(res.getPacketTo());
            if (session == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "no session for destination {0} for packet {1}", new Object[]{res.getPacketTo().toString(), res.toString()});
                continue;
            }
            Map presenceQueue = (Map)session.getSessionData(PRESENCE_QUEUE_KEY);
            Queue packetQueue = (Queue)session.getSessionData(PACKET_QUEUE_KEY);
            QueueState state = QueueState.need_flush;
            if (!MobileV3.isQueueEnabled(session)) {
                if (presenceQueue == null && packetQueue == null || presenceQueue.isEmpty() && packetQueue.isEmpty()) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "mobile queues needs flushing - presences: {0}, packets: {1}", new Object[]{presenceQueue.size(), packetQueue.size()});
                }
            } else {
                state = this.filter(session, res, presenceQueue, (Queue<Packet>)packetQueue);
                if (state == QueueState.queued) {
                    it.remove();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "queue packet = {0}", res.toString());
                    }
                    if (presenceQueue.size() > this.maxQueueSize) {
                        state = QueueState.need_flush;
                    } else if (packetQueue.size() > this.maxQueueSize) {
                        state = QueueState.need_packet_flush;
                    }
                }
            }
            switch (state) {
                case need_flush: {
                    JID connId;
                    prependResults = prependResultsThreadQueue.get();
                    if (prependResults == null) {
                        prependResults = new ArrayDeque<Packet>();
                        prependResultsThreadQueue.set(prependResults);
                    }
                    try {
                        Map map = presenceQueue;
                        synchronized (map) {
                            connId = session.getConnectionId();
                            for (Packet p : presenceQueue.values()) {
                                p.setPacketTo(connId);
                                prependResults.offer(p);
                            }
                            presenceQueue.clear();
                        }
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.SEVERE, "this should not happen", ex);
                    }
                }
                case need_packet_flush: {
                    JID connId;
                    if (prependResults == null && (prependResults = prependResultsThreadQueue.get()) == null) {
                        prependResults = new ArrayDeque();
                        prependResultsThreadQueue.set(prependResults);
                    }
                    try {
                        Queue ex = packetQueue;
                        synchronized (ex) {
                            connId = session.getConnectionId();
                            Packet p = null;
                            while ((p = (Packet)packetQueue.poll()) != null) {
                                p.setPacketTo(connId);
                                prependResults.offer(p);
                            }
                            packetQueue.clear();
                            break;
                        }
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.SEVERE, "this should not happen", ex);
                    }
                }
                case queued: {
                    break;
                }
            }
        }
        if (prependResults != null && !prependResults.isEmpty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "sending queued packets = {0}", prependResults.size());
            }
            prependResults.addAll(results);
            results.clear();
            results.addAll((Collection<Packet>)prependResults);
            prependResults.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueState filter(XMPPResourceConnection session, Packet res, Map<JID, Packet> presenceQueue, Queue<Packet> packetQueue) {
        Element delay;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "checking if packet should be queued {0}", res.toString());
        }
        if (res.getElemName() == MESSAGE_ELEM_NAME) {
            List<Element> children = res.getElement().getChildren();
            for (Element child : children) {
                Element msg;
                Element forward;
                if (!"urn:xmpp:carbons:2".equals(child.getXMLNS())) continue;
                Element delay2 = res.getElement().getChild(DELAY_ELEM_NAME, DELAY_XMLNS);
                if (delay2 == null && (delay2 = this.createDelayElem(session)) != null && (forward = child.getChild("forward", "urn:xmpp:forward:0")) != null && (msg = forward.getChild(MESSAGE_ELEM_NAME)) != null) {
                    msg.addChild(delay2);
                }
                Queue<Packet> queue = packetQueue;
                synchronized (queue) {
                    packetQueue.offer(res);
                }
                return QueueState.queued;
            }
            return QueueState.need_packet_flush;
        }
        if (res.getElemName() != "presence") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "ignoring packet, packet is not presence:  {0}", res.toString());
            }
            return QueueState.need_packet_flush;
        }
        StanzaType type = res.getType();
        if (type != null && type != StanzaType.unavailable && type != StanzaType.available) {
            return QueueState.need_flush;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "queuing packet {0}", res.toString());
        }
        if ((delay = res.getElement().getChild(DELAY_ELEM_NAME, DELAY_XMLNS)) == null && (delay = this.createDelayElem(session)) != null) {
            res.getElement().addChild(delay);
        }
        Map<JID, Packet> map = presenceQueue;
        synchronized (map) {
            presenceQueue.put(res.getStanzaFrom(), res);
        }
        return QueueState.queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element createDelayElem(XMPPResourceConnection session) {
        String timestamp = null;
        SimpleDateFormat simpleDateFormat = this.formatter;
        synchronized (simpleDateFormat) {
            timestamp = this.formatter.format(new Date());
        }
        try {
            return new Element(DELAY_ELEM_NAME, new String[]{"xmlns", "from", "stamp"}, new String[]{DELAY_XMLNS, session.getBareJID().getDomain(), timestamp});
        }
        catch (NotAuthorizedException ex) {
            return null;
        }
    }

    protected static boolean isQueueEnabled(XMPPResourceConnection session) {
        Boolean enabled = (Boolean)session.getSessionData(XMLNS);
        return enabled != null && enabled != false;
    }

    private static enum QueueState {
        queued,
        need_flush,
        need_packet_flush;

    }
}

