/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import tigase.util.DNSEntry;
import tigase.util.SimpleCache;

public class DNSResolver {
    private static String defaultHostname = null;
    private static final long DNS_CACHE_TIME = 60000L;
    private static final String LOCALHOST = "localhost";
    private static String[] localnames = null;
    private static final Logger log = Logger.getLogger(DNSResolver.class.getName());
    private static final String OPEN_DNS_HIT_NXDOMAIN = "hit-nxdomain.opendns.com";
    public static Map<String, DNSEntry[]> srv_cache = Collections.synchronizedMap(new SimpleCache(100, 60000L));
    public static Map<String, DNSEntry> ip_cache = Collections.synchronizedMap(new SimpleCache(100, 60000L));
    private static String opendns_hit_nxdomain_ip = null;
    private static long resolveDefaultTime = 0L;
    private static Random rand = new Random();

    public static void main(String[] args) throws Exception {
        InetAddress[] all;
        String host = "tigase.im";
        if (args.length > 0) {
            host = args[0];
        }
        Object[] hostIPs = DNSResolver.getHostIPs(host);
        Object[] dns_entries = DNSResolver.getHostSRV_Entries(host);
        System.out.println(host + ":getHostIP: " + DNSResolver.getHostIP(host));
        System.out.println(host + ":getHostIPs (" + hostIPs.length + "): " + Arrays.toString(hostIPs));
        System.out.println(host + ":getHostSRV_IP: " + DNSResolver.getHostSRV_IP(host));
        System.out.println(host + ":getHostSRV_Entries: " + Arrays.toString(dns_entries));
        System.out.println("-------------------");
        for (InetAddress ia : all = InetAddress.getAllByName(host)) {
            System.out.println("Host:getAllByName: " + ia.toString());
        }
        System.out.println("-------------------");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attrs = ctx.getAttributes("_xmpp-server._tcp." + host, new String[]{"SRV", "A"});
        String id = "SRV";
        Attribute att = attrs.get(id);
        if (att == null) {
            id = "A";
            att = attrs.get(id);
        }
        System.out.println(id + ": " + att.get(0));
        System.out.println("Class: " + att.get(0).getClass().getSimpleName());
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMoreElements()) {
            Attribute attr = ae.next();
            String attrId = attr.getID();
            NamingEnumeration<?> vals = attr.getAll();
            while (vals.hasMoreElements()) {
                System.out.println(attrId + ": " + vals.nextElement());
            }
        }
        ctx.close();
        System.out.println("-------------------");
        for (Object entry : dns_entries) {
            System.out.println(((DNSEntry)entry).toString());
        }
        System.out.println("-------------------");
        System.out.println("defaultHostname: " + defaultHostname);
        System.out.println("-------------------");
        System.out.println("Localhost name: " + InetAddress.getLocalHost().getHostName());
        System.out.println("Localhost canonnical name: " + InetAddress.getLocalHost().getCanonicalHostName());
        System.out.println("Is local loopback: " + InetAddress.getLocalHost().isLoopbackAddress());
        for (String hostname : localnames) {
            for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                System.out.println("  ------   ");
                System.out.println("Host name: " + addr.getHostName());
                System.out.println("Host getCanonicalHostName(): " + addr.getCanonicalHostName());
                System.out.println("Host getHostAddress(): " + addr.getHostAddress());
                System.out.println("Is isLoopbackAddress()  : " + addr.isLoopbackAddress());
                System.out.println("Is isAnyLocalAddress()  : " + addr.isAnyLocalAddress());
                System.out.println("Is isLinkLocalAddress() : " + addr.isLinkLocalAddress());
                System.out.println("Is isSiteLocalAddress() : " + addr.isSiteLocalAddress());
            }
        }
    }

    public static String getDefaultHostname() {
        return defaultHostname;
    }

    public static String[] getDefHostNames() {
        return localnames != null ? Arrays.copyOf(localnames, localnames.length) : null;
    }

    public static String getHostIP(String hostname) throws UnknownHostException {
        return DNSResolver.getHostIPs(hostname)[0];
    }

    public static String[] getHostIPs(String hostname) throws UnknownHostException {
        DNSEntry cache_res = ip_cache.get(hostname);
        if (cache_res != null) {
            return cache_res.getIps();
        }
        InetAddress[] all = InetAddress.getAllByName(hostname);
        String[] ip_addresses = new String[all.length];
        for (int j = 0; j < all.length; ++j) {
            ip_addresses[j] = all[j].getHostAddress();
            if (!ip_addresses[j].equals(opendns_hit_nxdomain_ip)) continue;
            throw new UnknownHostException("OpenDNS NXDOMAIN");
        }
        ip_cache.put(hostname, new DNSEntry(hostname, ip_addresses));
        return ip_addresses;
    }

    public static DNSEntry[] getHostSRV_Entries(String hostname) throws UnknownHostException {
        String service = "_xmpp-server._tcp";
        int defPort = 5269;
        return DNSResolver.getHostSRV_Entries(hostname, service, defPort);
    }

    public static DNSEntry[] getHostSRV_Entries(String hostname, String service, int defPort) throws UnknownHostException {
        DNSEntry[] result;
        ArrayList<DNSEntry> entries;
        int port;
        String result_host;
        block16: {
            DNSEntry[] cache_res = srv_cache.get(hostname);
            if (cache_res != null) {
                return cache_res;
            }
            result_host = hostname;
            port = defPort;
            int priority = 0;
            int weight = 0;
            long ttl = 3600000L;
            entries = new ArrayList<DNSEntry>();
            try {
                Hashtable<String, String> env = new Hashtable<String, String>(5);
                env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                InitialDirContext ctx = new InitialDirContext(env);
                Attributes attrs = ctx.getAttributes(service + "." + hostname, new String[]{"SRV"});
                Attribute att = attrs.get("SRV");
                if (att != null && att.size() > 0) {
                    for (int i = 0; i < att.size(); ++i) {
                        String[] dns_resp = att.get(i).toString().split(" ");
                        try {
                            priority = Integer.parseInt(dns_resp[0]);
                        }
                        catch (Exception e) {
                            priority = 0;
                        }
                        try {
                            weight = Integer.parseInt(dns_resp[1]);
                        }
                        catch (Exception e) {
                            weight = 0;
                        }
                        try {
                            port = Integer.parseInt(dns_resp[2]);
                        }
                        catch (Exception e) {
                            port = defPort;
                        }
                        result_host = dns_resp[3];
                        try {
                            String[] ip_addresses = DNSResolver.getHostIPs(result_host);
                            entries.add(new DNSEntry(hostname, result_host, ip_addresses, port, ttl, priority, weight));
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                } else {
                    log.log(Level.FINER, "Empty SRV DNS records set for domain: {0}", hostname);
                }
                ctx.close();
            }
            catch (NamingException e) {
                result_host = hostname;
                if (!log.isLoggable(Level.FINER)) break block16;
                log.log(Level.FINER, "Problem getting SRV DNS records for domain: " + hostname, e);
            }
        }
        if (entries.isEmpty()) {
            String ip_address = DNSResolver.getHostIP(result_host);
            entries.add(new DNSEntry(hostname, ip_address, port));
        }
        if ((result = entries.toArray(new DNSEntry[0])) != null) {
            srv_cache.put(hostname, result);
        }
        return result;
    }

    public static DNSEntry getHostSRV_Entry(String hostname) throws UnknownHostException {
        String service = "_xmpp-server._tcp";
        int defPort = 5269;
        return DNSResolver.getHostSRV_Entry(hostname, service, defPort);
    }

    public static DNSEntry getHostSRV_Entry(String hostname, String service, int defPort) throws UnknownHostException {
        Object[] entries = DNSResolver.getHostSRV_Entries(hostname, service, defPort);
        if (entries == null || entries.length == 0) {
            return null;
        }
        int priority = Integer.MAX_VALUE;
        Object result = null;
        int start = rand.nextInt(entries.length);
        int idx = 0;
        for (int i = 0; i < entries.length; ++i) {
            idx = (i + start) % entries.length;
            if (entries[idx].getPriority() >= priority) continue;
            priority = ((DNSEntry)entries[idx]).getPriority();
            result = entries[idx];
        }
        if (result == null) {
            result = entries[0];
            log.log(Level.WARNING, "No result?? should not happen, an error in the code: {0}", Arrays.toString(entries));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Start idx: {0}, last idx: {1}, selected DNSEntry: {2}", new Object[]{start, idx, result});
        }
        return result;
    }

    public static String getHostSRV_IP(String hostname) throws UnknownHostException {
        DNSEntry entry = DNSResolver.getHostSRV_Entry(hostname);
        return entry != null ? entry.getIp() : null;
    }

    static {
        long start = System.currentTimeMillis();
        Security.setProperty("networkaddress.cache.ttl", "0");
        ip_cache.put(LOCALHOST, new DNSEntry(LOCALHOST, "127.0.0.1"));
        try {
            String newHostName = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
            if (newHostName.equalsIgnoreCase(InetAddress.getLocalHost().getHostAddress())) {
                newHostName = InetAddress.getLocalHost().getHostName();
            }
            if (!LOCALHOST.equals(newHostName)) {
                localnames = new String[2];
                DNSResolver.localnames[0] = newHostName;
                DNSResolver.localnames[1] = LOCALHOST;
                InetAddress[] all = InetAddress.getAllByName(localnames[0]);
                ip_cache.put(localnames[0], new DNSEntry(localnames[0], all[0].getHostAddress().toLowerCase()));
            } else {
                localnames = new String[]{LOCALHOST};
            }
            for (String hostname : localnames) {
                InetAddress[] all;
                for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress() || !(defaultHostname = addr.getCanonicalHostName().toLowerCase()).equalsIgnoreCase(addr.getHostAddress())) continue;
                    defaultHostname = addr.getHostName();
                }
            }
            if (defaultHostname == null) {
                defaultHostname = localnames[0];
            }
        }
        catch (UnknownHostException e) {
            localnames = new String[]{LOCALHOST};
            defaultHostname = LOCALHOST;
            log.severe("Most likely network misconfiguration problem, make sure the local hostname to whichever it is set does resolve to IP address, now using: " + defaultHostname);
        }
        new Thread("OpenDNS checker"){

            @Override
            public void run() {
                try {
                    opendns_hit_nxdomain_ip = InetAddress.getByName(DNSResolver.OPEN_DNS_HIT_NXDOMAIN).getHostAddress();
                }
                catch (UnknownHostException e) {
                    opendns_hit_nxdomain_ip = null;
                }
            }
        }.start();
        resolveDefaultTime = System.currentTimeMillis() - start;
        if (resolveDefaultTime > 0L) {
            log.warning("Resolving default host name took: " + resolveDefaultTime);
        }
    }
}

