/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;
import tigase.util.Base64;

public class WebSocketHybi
implements WebSocketProtocolIfc {
    private static final Logger log = Logger.getLogger(WebSocketHybi.class.getCanonicalName());
    public static final String ID = "hybi";
    private static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String RESPONSE_HEADER = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nAccess-Control-Allow-Origin: *\r\nAccess-Control-Allow-Methods: GET, POST, OPTIONS\r\nAccess-Control-Allow-Headers: Content-Type\r\nAccess-Control-Max-Age: 86400\r\n";
    private static final String WS_ACCEPT_KEY = "Sec-WebSocket-Accept";
    private static final String WS_KEY_KEY = "Sec-WebSocket-Key";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean handshake(WebSocketXMPPIOService service, Map<String, String> headers, byte[] buf) throws NoSuchAlgorithmException, IOException {
        if (!headers.containsKey("Sec-WebSocket-Version")) {
            return false;
        }
        StringBuilder response = new StringBuilder(RESPONSE_HEADER.length() * 2);
        response.append(RESPONSE_HEADER);
        int version = Integer.parseInt(headers.get("Sec-WebSocket-Version"));
        String key = headers.get(WS_KEY_KEY) + GUID;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] resp = md.digest(key.getBytes());
        response.append("Sec-WebSocket-Protocol");
        response.append(": xmpp\r\n");
        response.append("Sec-WebSocket-Accept: ");
        response.append(Base64.encode(resp));
        response.append("\r\n");
        response.append("\r\n");
        service.maskingKey = new byte[4];
        service.writeRawData(response.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer decodeFrame(WebSocketXMPPIOService service, ByteBuffer buf) {
        ByteBuffer unmasked;
        block19: {
            if (!buf.hasRemaining()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("no content remainging to process");
                }
                return null;
            }
            boolean masked = false;
            byte type = 0;
            int position = buf.position();
            unmasked = null;
            try {
                byte[] data;
                if (service.frameLength == -1L) {
                    type = buf.get();
                    if ((type & 8) == 8) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("closing connection due to client request");
                        }
                        service.forceStop();
                        return null;
                    }
                    byte b2 = buf.get();
                    masked = (b2 & 0x80) == 128;
                    service.frameLength = b2 & 0x7F;
                    if (service.frameLength > 125L) {
                        long l = service.frameLength = service.frameLength == 126L ? (long)buf.getShort() : buf.getLong();
                    }
                    if (masked) {
                        buf.get(service.maskingKey);
                    }
                }
                if ((long)buf.remaining() >= service.frameLength) {
                    data = new byte[(int)service.frameLength];
                    buf.get(data);
                    if (masked) {
                        byte[] maskingKey = service.maskingKey;
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = (byte)(data[i] ^ maskingKey[i % 4]);
                        }
                    }
                } else {
                    buf.position(position);
                    service.frameLength = -1L;
                    return null;
                }
                unmasked = ByteBuffer.wrap(data);
                service.frameLength = -1L;
                if (service.frameLength != -1L) break block19;
                if ((type & 0xA) == 10) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("ignoring pong frame");
                    }
                    unmasked = null;
                    break block19;
                }
                if ((type & 9) != 9) break block19;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("sending response on ping frame");
                }
                type = (byte)((byte)(type ^ 9) | 0xA);
                try {
                    ByteBuffer header = this.createFrameHeader(type, unmasked.remaining());
                    service.writeInProgress.lock();
                    service.writeBytes(header);
                    service.writeBytes(unmasked);
                }
                finally {
                    service.writeInProgress.unlock();
                }
                unmasked = null;
            }
            catch (BufferUnderflowException ex) {
                buf.position(position);
                service.frameLength = -1L;
                unmasked = null;
            }
        }
        return unmasked;
    }

    @Override
    public void encodeFrameAndWrite(WebSocketXMPPIOService service, ByteBuffer buf) throws IOException {
        int size = buf.remaining();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "sending encoded data size = {0}", size);
        }
        ByteBuffer bbuf = this.createFrameHeader((byte)-127, size);
        service.writeBytes(bbuf);
        service.writeBytes(buf);
    }

    private ByteBuffer createFrameHeader(byte type, int size) {
        ByteBuffer bbuf = ByteBuffer.allocate(12);
        bbuf.put(type);
        if (size <= 125) {
            bbuf.put((byte)size);
        } else if (size <= 65535) {
            bbuf.put((byte)126);
            bbuf.putShort((short)size);
        } else {
            bbuf.put((byte)127);
            bbuf.putLong(size);
        }
        bbuf.flip();
        return bbuf;
    }
}

