/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.UserRepository;
import tigase.server.Packet;
import tigase.server.amp.ActionIfc;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;

public abstract class ActionAbstract
implements ActionIfc {
    public static final String AMP_SECURITY_LEVEL = "--amp-security-level";
    public static final String AMP_SECURITY_LEVEL_DEFAULT = "STRICT";
    public static final String SECURITY_PROP_KEY = "security-level";
    private static Logger log = Logger.getLogger(ActionAbstract.class.getName());
    protected ActionResultsHandlerIfc resultsHandler = null;
    private SECURITY security = SECURITY.STRICT;
    private UserRepository user_repository = null;
    RosterFlat rosterUtil = new RosterFlat();

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        String sec_str = (String)params.get(AMP_SECURITY_LEVEL);
        if (null == sec_str) {
            sec_str = AMP_SECURITY_LEVEL_DEFAULT;
        }
        try {
            SECURITY sec;
            this.security = sec = SECURITY.valueOf(sec_str.toUpperCase());
        }
        catch (Exception e) {
            // empty catch block
        }
        defs.put(SECURITY_PROP_KEY, this.security.name());
        return defs;
    }

    @Override
    public void setProperties(Map<String, Object> props, ActionResultsHandlerIfc resultsHandler) {
        this.resultsHandler = resultsHandler;
        String sec_str = (String)props.get(AMP_SECURITY_LEVEL);
        try {
            SECURITY sec;
            this.security = sec = SECURITY.valueOf(sec_str.toUpperCase());
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Incorrect amp security settings, using defaults: " + (Object)((Object)this.security), e);
        }
        this.user_repository = (UserRepository)props.get("shared-user-repo");
    }

    protected Packet prepareAmpPacket(Packet packet, Element rule) throws PacketErrorTypeException {
        boolean error_result = false;
        switch (this.security) {
            case NONE: {
                break;
            }
            case PERFORMANCE: {
                error_result = true;
                break;
            }
            case STRICT: {
                error_result = !this.checkUserRoster(packet.getStanzaTo(), packet.getStanzaFrom());
            }
        }
        Packet result = null;
        if (error_result) {
            result = Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, null, false);
        } else {
            JID old_from = packet.getStanzaFrom();
            JID old_to = packet.getStanzaTo();
            String from_conn_id = packet.getAttributeStaticStr("from-conn-id");
            JID new_from = null;
            new_from = from_conn_id != null ? JID.jidInstanceNS(old_from.getDomain()) : JID.jidInstanceNS(old_to.getDomain());
            result = packet.copyElementOnly();
            result.initVars(new_from, old_from);
            Element amp = result.getElement().getChild("amp", "http://jabber.org/protocol/amp");
            result.getElement().removeChild(amp);
            amp = new Element("amp", new Element[]{rule}, new String[]{"from", "to", "xmlns", "status"}, new String[]{old_from.toString(), old_to.toString(), "http://jabber.org/protocol/amp", this.getName()});
            result.getElement().addChild(amp);
            this.removeTigasePayload(result);
            if (from_conn_id != null) {
                result.setPacketTo(JID.jidInstanceNS(from_conn_id));
            }
        }
        return result;
    }

    protected void removeTigasePayload(Packet packet) {
        packet.getElement().removeAttribute("to-conn-id");
        packet.getElement().removeAttribute("to-res");
        packet.getElement().removeAttribute("offline");
        packet.getElement().removeAttribute("from-conn-id");
        packet.getElement().removeAttribute("expired");
    }

    private boolean checkUserRoster(JID user, JID contact) {
        try {
            String roster_str = this.user_repository.getData(user.getBareJID(), "roster");
            if (roster_str != null) {
                LinkedHashMap<BareJID, RosterElement> roster = new LinkedHashMap<BareJID, RosterElement>();
                RosterFlat.parseRosterUtil(roster_str, roster, null);
                RosterElement re = (RosterElement)roster.get(contact.getBareJID());
                if (re != null) {
                    return this.rosterUtil.isSubscribedFrom(re.getSubscription());
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Problem retrieving user roster: " + user, ex);
        }
        return false;
    }

    private static enum SECURITY {
        NONE,
        PERFORMANCE,
        STRICT;

    }
}

