/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.xmpp.BareJID;

public class AuthRepositoryMDImpl
implements AuthRepository {
    private static final Logger log = Logger.getLogger(AuthRepositoryMDImpl.class.getName());
    private AuthRepository def = null;
    private ConcurrentSkipListMap<String, AuthRepository> repos = new ConcurrentSkipListMap();

    public void addRepo(String domain, AuthRepository repo) {
        this.repos.put(domain, repo);
    }

    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        AuthRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.addUser(user, password);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    @Deprecated
    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        AuthRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.digestAuth(user, digest, id, alg);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return false;
    }

    public AuthRepository getRepo(String domain) {
        AuthRepository result = this.repos.get(domain);
        if (result == null) {
            result = this.def;
        }
        return result;
    }

    @Override
    public String getResourceUri() {
        return this.def.getResourceUri();
    }

    @Override
    public long getUsersCount() {
        long result = 0L;
        for (AuthRepository repo : this.repos.values()) {
            result += repo.getUsersCount();
        }
        return result;
    }

    @Override
    public long getUsersCount(String domain) {
        AuthRepository repo = this.getRepo(domain);
        if (repo != null) {
            return repo.getUsersCount(domain);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + domain + ", not even default one!");
        return -1L;
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        log.info("Multi-domain repository pool initialized: " + resource_uri + ", params: " + params);
    }

    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.logout(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> authProps) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        AuthRepository repo = this.getRepo((String)authProps.get("server-name"));
        if (repo != null) {
            return repo.otherAuth(authProps);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + (String)authProps.get("server-name") + ", not even default one!");
        return false;
    }

    @Override
    @Deprecated
    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        AuthRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.plainAuth(user, password);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return false;
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        AuthRepository repo = this.getRepo((String)authProps.get("server-name"));
        if (repo != null) {
            repo.queryAuth(authProps);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + (String)authProps.get("server-name") + ", not even default one!");
        }
    }

    public AuthRepository removeRepo(String domain) {
        return this.repos.remove(domain);
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeUser(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    public void setDefault(AuthRepository repo) {
        this.def = repo;
    }

    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.updatePassword(user, password);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }
}

