/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateEntry;
import tigase.cert.RSAPrivateKeyDecoder;
import tigase.util.Algorithms;
import tigase.util.Base64;

public abstract class CertificateUtil {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String BEGIN_RSA_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String ENCRIPT_TEST = "--encript-test";
    private static final String ENCRIPT_TEST_SHORT = "-et";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static final String END_KEY = "-----END PRIVATE KEY-----";
    private static final String END_RSA_KEY = "-----END RSA PRIVATE KEY-----";
    protected static final byte[] ID_ON_XMPPADDR = new byte[]{6, 8, 43, 6, 1, 5, 5, 7, 8, 5};
    private static final String KEY_PAIR = "--key-pair";
    private static final String KEY_PAIR_SHORT = "-kp";
    private static final String LOAD_CERT = "--load-cert";
    private static final String LOAD_CERT_SHORT = "-lc";
    private static final String LOAD_DER_PRIVATE_KEY = "--load-der-priv-key";
    private static final String LOAD_DER_PRIVATE_KEY_SHORT = "-ldpk";
    private static final Logger log = Logger.getLogger(CertificateUtil.class.getName());
    private static final String PRINT_PROVIDERS = "--print-providers";
    private static final String PRINT_PROVIDERS_SHORT = "-pp";
    private static final String PRINT_SERVICES = "--print-services";
    private static final String PRINT_SERVICES_SHORT = "-ps";
    private static final String SELF_SIGNED_CERT = "--self-signed-cert";
    private static final String SELF_SIGNED_CERT_SHORT = "-ssc";
    private static final String STORE_CERT = "--store-cert";
    private static final String STORE_CERT_SHORT = "-sc";

    private static void appendName(StringBuilder sb, String prefix, String value) {
        if (value != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(prefix).append('=').append(value);
        }
    }

    private static int calculateLength(byte[] buffer, int start) throws ArrayIndexOutOfBoundsException {
        int offset = start + 1;
        int b = buffer[offset] & 0xFF;
        if (b < 128) {
            return b;
        }
        int result = 0;
        ++offset;
        int len = b - 128;
        for (int i = 0; i < len; ++i) {
            b = buffer[i + offset] & 0xFF;
            result = (result << 8) + b;
        }
        return result;
    }

    private static final int calculateOffset(byte[] buffer, int offset) throws ArrayIndexOutOfBoundsException {
        int b = buffer[offset + 1] & 0xFF;
        if (b < 128) {
            return offset + 2;
        }
        int len = b - 128;
        return offset + len + 2;
    }

    public static KeyPair createKeyPair(int size, String password) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(size);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        return keyPair;
    }

    public static X509Certificate createSelfSignedCertificate(String email, String domain, String organizationUnit, String organization, String city, String state, String country, KeyPair keyPair) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        X509CertInfo certInfo = new X509CertInfo();
        CertificateVersion certVersion = new CertificateVersion();
        certInfo.set("version", certVersion);
        Date firstDate = new Date();
        Date lastDate = new Date(firstDate.getTime() + 31536000000L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        certInfo.set("validity", interval);
        certInfo.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
        StringBuilder subject = new StringBuilder(1024);
        CertificateUtil.appendName(subject, "CN", domain);
        CertificateUtil.appendName(subject, "CN", "*." + domain);
        CertificateUtil.appendName(subject, "EMAILADDRESS", email);
        CertificateUtil.appendName(subject, "OU", organizationUnit);
        CertificateUtil.appendName(subject, "O", organization);
        CertificateUtil.appendName(subject, "L", city);
        CertificateUtil.appendName(subject, "ST", state);
        CertificateUtil.appendName(subject, "C", country);
        X500Name issuerName = new X500Name(subject.toString());
        CertificateIssuerName certIssuer = new CertificateIssuerName(issuerName);
        CertificateSubjectName certSubject = new CertificateSubjectName(issuerName);
        certInfo.set("issuer", certIssuer);
        certInfo.set("subject", certSubject);
        AlgorithmId algorithm = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
        CertificateAlgorithmId certAlgorithm = new CertificateAlgorithmId(algorithm);
        certInfo.set("algorithmID", certAlgorithm);
        CertificateX509Key certPublicKey = new CertificateX509Key(keyPair.getPublic());
        certInfo.set("key", certPublicKey);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), "SHA1WithRSA");
        return newCert;
    }

    private static void encriptTest() throws Exception {
        System.out.print("Generating key pair...");
        System.out.flush();
        KeyPair keyPair = CertificateUtil.createKeyPair(1024, "secret");
        System.out.println(" done.");
        byte[] inputText = "Encription test...".getBytes();
        Cipher cipher = Cipher.getInstance("RSA");
        System.out.println("Encripting text: " + new String(inputText));
        cipher.init(1, keyPair.getPublic());
        byte[] cipherText = cipher.doFinal(inputText);
        System.out.println("Encripted text: " + Algorithms.bytesToHex(cipherText));
        cipher.init(2, keyPair.getPrivate());
        byte[] plainText = cipher.doFinal(cipherText);
        System.out.println("Decripted text: " + new String(plainText));
    }

    public static String exportToPemFormat(CertificateEntry entry) throws CertificateEncodingException {
        String b64;
        byte[] bytes;
        StringBuilder sb = new StringBuilder(4096);
        if (entry.getCertChain() != null && entry.getCertChain().length > 0) {
            bytes = entry.getCertChain()[0].getEncoded();
            b64 = Base64.encode(bytes);
            sb.append(BEGIN_CERT).append('\n').append(b64).append('\n').append(END_CERT).append('\n');
        }
        if (entry.getPrivateKey() != null) {
            bytes = entry.getPrivateKey().getEncoded();
            b64 = Base64.encode(bytes);
            sb.append(BEGIN_KEY).append('\n').append(b64).append('\n').append(END_KEY).append('\n');
        }
        if (entry.getCertChain() != null && entry.getCertChain().length > 1) {
            for (int i = 1; i < entry.getCertChain().length; ++i) {
                byte[] bytes2 = entry.getCertChain()[i].getEncoded();
                String b642 = Base64.encode(bytes2);
                sb.append(BEGIN_CERT).append('\n').append(b642).append('\n').append(END_CERT).append('\n');
            }
        }
        return sb.toString();
    }

    private static String extractValue(byte[] buffer, byte[] id) {
        try {
            if (buffer[0] != 48) {
                return null;
            }
            int len = CertificateUtil.calculateLength(buffer, 0);
            int offset = CertificateUtil.calculateOffset(buffer, 0);
            for (int i = 0; i < id.length; ++i) {
                int j = offset + i;
                if (j >= len) {
                    return null;
                }
                if (id[i] == buffer[j]) continue;
                return null;
            }
            int valStart = offset + id.length;
            int pos = CertificateUtil.calculateOffset(buffer, valStart);
            while (pos < buffer.length) {
                byte d = buffer[pos];
                int cmp = CertificateUtil.calculateOffset(buffer, pos);
                int l = CertificateUtil.calculateLength(buffer, pos);
                if (d == 12 || d == 22) {
                    return new String(buffer, cmp, l);
                }
                pos = cmp;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static List<String> extractXmppAddrs(X509Certificate x509Certificate) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = x509Certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return result;
            }
            for (List<?> item : altNames) {
                byte[] buffer;
                String jid;
                Integer type = (Integer)item.get(0);
                if (type != 0 || (jid = CertificateUtil.extractValue(buffer = (byte[])item.get(1), ID_ON_XMPPADDR)) == null) continue;
                result.add(jid);
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static ArrayList<String> getCertAltCName(X509Certificate cert) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            Collection<List<?>> subjectAlternativeNames = cert.getSubjectAlternativeNames();
            for (List<?> list : subjectAlternativeNames) {
                if (!list.get(0).equals(2)) continue;
                result.add(list.get(1).toString());
            }
            return result;
        }
        catch (CertificateParsingException e) {
            return null;
        }
    }

    public static String getCertCName(X509Certificate cert) {
        String[] all;
        X500Principal princ = cert.getSubjectX500Principal();
        String name = princ.getName();
        for (String n : all = name.split(",")) {
            String[] ns = n.trim().split("=");
            if (!ns[0].equals("CN")) continue;
            return ns[1];
        }
        return null;
    }

    public static boolean isExpired(X509Certificate cert) {
        try {
            cert.checkValidity();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        return cert.getIssuerDN().equals(cert.getSubjectDN());
    }

    private static void keyPairTest() throws Exception {
        System.out.print("Generating key pair...");
        System.out.flush();
        KeyPair keyPair = CertificateUtil.createKeyPair(1024, "secret");
        System.out.println(" done, private key: " + keyPair.getPrivate() + ", public key: " + keyPair.getPublic());
    }

    public static CertificateEntry loadCertificate(File file) throws FileNotFoundException, IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException {
        return CertificateUtil.parseCertificate(new FileReader(file));
    }

    public static CertificateEntry loadCertificate(String file) throws FileNotFoundException, IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException {
        return CertificateUtil.loadCertificate(new File(file));
    }

    public static PrivateKey loadPrivateKeyFromDER(File file) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        byte[] privKeyBytes = new byte[(int)file.length()];
        dis.read(privKeyBytes);
        dis.close();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privKeyBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        return privKey;
    }

    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            String file;
            if (args[0].equals(PRINT_PROVIDERS) || args[0].equals(PRINT_PROVIDERS_SHORT)) {
                CertificateUtil.printProviders(false);
            }
            if (args[0].equals(PRINT_SERVICES) || args[0].equals(PRINT_SERVICES_SHORT)) {
                CertificateUtil.printProviders(true);
            }
            if (args[0].equals(KEY_PAIR) || args[0].equals(KEY_PAIR_SHORT)) {
                CertificateUtil.keyPairTest();
            }
            if (args[0].equals(ENCRIPT_TEST) || args[0].equals(ENCRIPT_TEST_SHORT)) {
                CertificateUtil.encriptTest();
            }
            if (args[0].equals(SELF_SIGNED_CERT) || args[0].equals(SELF_SIGNED_CERT_SHORT)) {
                CertificateUtil.selfSignedCertTest();
            }
            if (args[0].equals(LOAD_CERT) || args[0].equals(LOAD_CERT_SHORT)) {
                file = args[1];
                CertificateEntry ce = CertificateUtil.loadCertificate(file);
                System.out.println(ce.toString());
            }
            if (args[0].equals(STORE_CERT) || args[0].equals(STORE_CERT_SHORT)) {
                file = args[1];
                String email = "artur.hefczyc@tigase.org";
                String domain = "tigase.org";
                String ou = "XMPP Service";
                String o = "Tigase.org";
                String l = "Cambourne";
                String st = "Cambridgeshire";
                String c = "UK";
                KeyPair keyPair = CertificateUtil.createKeyPair(1024, "secret");
                X509Certificate cert = CertificateUtil.createSelfSignedCertificate(email, domain, ou, o, l, st, c, keyPair);
                CertificateEntry entry = new CertificateEntry();
                entry.setPrivateKey(keyPair.getPrivate());
                entry.setCertChain(new Certificate[]{cert});
                CertificateUtil.storeCertificate(file, entry);
            }
            if (args[0].equals(LOAD_DER_PRIVATE_KEY) || args[0].equals(LOAD_DER_PRIVATE_KEY_SHORT)) {
                file = args[1];
                PrivateKey key = CertificateUtil.loadPrivateKeyFromDER(new File(file));
                System.out.println(key.toString());
            }
        } else {
            CertificateUtil.printHelp();
        }
    }

    public static CertificateEntry parseCertificate(Reader data) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException {
        String line;
        BufferedReader br = new BufferedReader(data);
        StringBuilder sb = new StringBuilder(4096);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        PrivateKey privateKey = null;
        boolean addToBuffer = false;
        while ((line = br.readLine()) != null) {
            byte[] bytes;
            if (line.contains(BEGIN_CERT) || line.contains(BEGIN_KEY) || line.contains(BEGIN_RSA_KEY)) {
                addToBuffer = true;
                continue;
            }
            if (line.contains(END_CERT)) {
                addToBuffer = false;
                bytes = Base64.decode(sb.toString());
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (bais.available() > 0) {
                    Certificate cert = cf.generateCertificate(bais);
                    certs.add((X509Certificate)cert);
                }
                sb = new StringBuilder(4096);
                continue;
            }
            if (line.contains(END_KEY)) {
                addToBuffer = false;
                bytes = Base64.decode(sb.toString());
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                privateKey = keyFactory.generatePrivate(keySpec);
                sb = new StringBuilder(4096);
                continue;
            }
            if (line.contains(END_RSA_KEY)) {
                addToBuffer = false;
                bytes = Base64.decode(sb.toString());
                RSAPrivateKeyDecoder decoder = new RSAPrivateKeyDecoder(bytes);
                privateKey = decoder.getPrivateKey();
                sb = new StringBuilder(4096);
                continue;
            }
            if (!addToBuffer) continue;
            sb.append(line);
        }
        CertificateEntry entry = new CertificateEntry();
        entry.setCertChain(certs.toArray(new Certificate[certs.size()]));
        entry.setPrivateKey(privateKey);
        return entry;
    }

    public static Certificate[] sort(Certificate[] chain) {
        List<Certificate> res = CertificateUtil.sort(new ArrayList<Certificate>(Arrays.asList(chain)));
        return res.toArray(new Certificate[res.size()]);
    }

    public static List<Certificate> sort(List<Certificate> certs) {
        Certificate rt = null;
        for (Certificate x509Certificate : certs) {
            Principal s;
            Principal i = ((X509Certificate)x509Certificate).getIssuerDN();
            if (!i.equals(s = ((X509Certificate)x509Certificate).getSubjectDN())) continue;
            rt = x509Certificate;
        }
        if (rt == null) {
            throw new RuntimeException("Can't find root certificate in chain!");
        }
        ArrayList<Certificate> res = new ArrayList<Certificate>();
        certs.remove(rt);
        res.add(rt);
        while (!certs.isEmpty()) {
            boolean found = false;
            for (Certificate x509Certificate : certs) {
                Principal i = ((X509Certificate)x509Certificate).getIssuerDN();
                if (!i.equals(((X509Certificate)rt).getSubjectDN())) continue;
                rt = x509Certificate;
                found = true;
                break;
            }
            if (found) {
                certs.remove(rt);
                res.add(0, rt);
                continue;
            }
            throw new RuntimeException("Can't find certificate " + ((X509Certificate)rt).getSubjectDN() + " in chain. Verify that all entries are correct and match against each other!");
        }
        return res;
    }

    private static void printHelp() {
        System.out.println(CertificateUtil.class.getName() + " test code.");
        System.out.println("You can run following tests:");
        System.out.println(" --print-providers | -pp - prints all supported providers");
        System.out.println(" --print-services | -ps - print all supported services");
        System.out.println(" --key-pair | -kp - generate a key pair and print the result");
        System.out.println(" --encript-test | -et - encript simple text with public key, decript with private");
        System.out.println(" --self-signed-cert | -ssc - generate self signed certificate");
        System.out.println(" --load-cert file.pem | -lc file.pem - load certificate from file");
        System.out.println(" --store-cert file.pem | -sc file.pem - generate self-signed certificate and save it to the given pem file");
        System.out.println(" --load-der-priv-key | -ldpk file.der - load private key from DER file.");
    }

    private static void printProviders(boolean includeServices) {
        Provider[] providers = Security.getProviders();
        if (providers != null && providers.length > 0) {
            for (Provider provider : providers) {
                System.out.println(provider.getName() + "\t" + provider.getInfo());
                if (!includeServices) continue;
                for (Provider.Service service : provider.getServices()) {
                    System.out.println("\t" + service.getAlgorithm());
                }
            }
        } else {
            System.out.println("No security providers found!");
        }
    }

    private static void selfSignedCertTest() throws Exception {
        KeyPair keyPair = CertificateUtil.createKeyPair(1024, "secret");
        String email = "artur.hefczyc@tigase.org";
        String domain = "tigase.org";
        String ou = "XMPP Service";
        String o = "Tigase.org";
        String l = "Cambourne";
        String st = "Cambridgeshire";
        String c = "UK";
        System.out.println("Creating self-signed certificate for issuer: " + domain);
        X509Certificate cert = CertificateUtil.createSelfSignedCertificate(email, domain, ou, o, l, st, c, keyPair);
        System.out.print("Checking certificate validity today...");
        System.out.flush();
        cert.checkValidity();
        System.out.println(" done.");
        System.out.print("Checking certificate validity yesterday...");
        System.out.flush();
        try {
            cert.checkValidity(new Date(System.currentTimeMillis() - 86400000L));
            System.out.println(" error.");
        }
        catch (CertificateNotYetValidException e) {
            System.out.println(" not valid!");
        }
        System.out.print("Verifying certificate with public key...");
        System.out.flush();
        cert.verify(keyPair.getPublic());
        System.out.println(" done.");
        System.out.println(cert.toString());
    }

    public static void storeCertificate(String file, CertificateEntry entry) throws CertificateEncodingException, IOException {
        String pemFormat = CertificateUtil.exportToPemFormat(entry);
        File f = new File(file);
        if (f.exists()) {
            f.renameTo(new File(file + ".bak"));
        }
        FileWriter fw = new FileWriter(f, false);
        fw.write(pemFormat);
        fw.close();
    }

    public static CertCheckResult validateCertificate(Certificate[] chain, KeyStore trustKeystore, boolean revocationEnabled) throws NoSuchAlgorithmException, KeyStoreException, InvalidAlgorithmParameterException, CertificateException {
        CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        X509CertSelector selector = new X509CertSelector();
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustKeystore, (CertSelector)selector);
        params.setRevocationEnabled(false);
        List<Certificate> certList = Arrays.asList(chain);
        CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(certList);
        try {
            certPathValidator.validate(certPath, params);
            return CertCheckResult.trusted;
        }
        catch (CertPathValidatorException ex) {
            if (CertificateUtil.isExpired((X509Certificate)chain[0])) {
                return CertCheckResult.expired;
            }
            if (chain.length == 1 && CertificateUtil.isSelfSigned((X509Certificate)chain[0])) {
                return CertCheckResult.self_signed;
            }
            return CertCheckResult.untrusted;
        }
    }
}

