/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.security.Security;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.auth.CallbackHandlerFactory;
import tigase.auth.MechanismSelector;
import tigase.auth.MechanismSelectorFactory;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.XmppSaslException;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class SaslAuth
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String ID = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String _XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String ALLOWED_SASL_MECHANISMS_KEY = "allowed-sasl-mechanisms";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    private static final String[][] ELEMENTS = new String[][]{{"auth"}, {"response"}, {"challenge"}, {"failure"}, {"success"}, {"abort"}};
    private static final Logger log = Logger.getLogger(SaslAuth.class.getName());
    private static final String SASL_SERVER_KEY = "SASL_SERVER_KEY";
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl"};
    private CallbackHandlerFactory callbackHandlerFactory = new CallbackHandlerFactory();
    private final Map<String, Object> props = new HashMap<String, Object>();
    private MechanismSelector mechanismSelector;

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.toString());
        reply.setXMLNS("urn:ietf:params:xml:ns:xmpp-sasl");
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        if (settings != null) {
            this.props.putAll(settings);
        }
        super.init(settings);
        if (!(Security.getProvider("tigase.sasl") instanceof TigaseSaslProvider)) {
            Security.removeProvider("tigase.sasl");
        }
        Security.insertProviderAt(new TigaseSaslProvider(settings), 1);
        MechanismSelectorFactory mechanismSelectorFactory = new MechanismSelectorFactory();
        try {
            this.mechanismSelector = mechanismSelectorFactory.create(settings);
        }
        catch (Exception e) {
            log.severe("Can't create SASL Mechanism Selector");
            throw new RuntimeException("Can't create SASL Mechanism Selector", e);
        }
    }

    protected void onAuthFail(XMPPResourceConnection session) {
        session.removeSessionData(SASL_SERVER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block32: {
                if (session.getSessionData("authentication-timeout") != null) {
                    return;
                }
                if (session.isAuthorized()) {
                    Packet res = packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null);
                    res.setPriority(Priority.SYSTEM);
                    results.offer(res);
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Discovered second authentication attempt: {0}, packet: {1}", new Object[]{session.toString(), packet.toString()});
                    }
                    try {
                        session.logout();
                    }
                    catch (NotAuthorizedException ex) {
                        log.log(Level.FINER, "Unsuccessful session logout: {0}", session.toString());
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Session after logout: {0}", session.toString());
                    }
                }
                Element request = packet.getElement();
                try {
                    SaslServer ss;
                    if ("auth" == request.getName()) {
                        String mechanismName = request.getAttributeStaticStr("mechanism");
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Start SASL auth. mechanism=" + mechanismName);
                        }
                        Collection<String> allowedMechanisms = (Collection<String>)session.getSessionData(ALLOWED_SASL_MECHANISMS_KEY);
                        session.removeSessionData(ALLOWED_SASL_MECHANISMS_KEY);
                        if (allowedMechanisms == null) {
                            allowedMechanisms = this.mechanismSelector.filterMechanisms(Sasl.getSaslServerFactories(), session);
                        }
                        if (mechanismName == null || allowedMechanisms == null || !allowedMechanisms.contains(mechanismName)) {
                            throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                        }
                        CallbackHandler cbh = this.callbackHandlerFactory.create(mechanismName, session, repo, settings);
                        ss = Sasl.createSaslServer(mechanismName, "xmpp", session.getDomain().getVhost().getDomain(), this.props, cbh);
                        if (ss == null) {
                            throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                        }
                        session.putSessionData(SASL_SERVER_KEY, ss);
                    } else if ("response" == request.getName()) {
                        ss = (SaslServer)session.getSessionData(SASL_SERVER_KEY);
                        if (ss == null) {
                            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                        }
                    } else {
                        throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Unrecognized element " + request.getName());
                    }
                    String cdata = request.getCData();
                    byte[] data = cdata != null && cdata.length() == 1 && cdata.equals("=") ? new byte[]{} : (cdata != null && cdata.length() > 0 ? Base64.decode(cdata) : new byte[]{});
                    byte[] challenge = ss.evaluateResponse(data);
                    String challengeData = challenge != null ? Base64.encode(challenge) : null;
                    if (ss.isComplete() && ss.getAuthorizationID() != null) {
                        boolean anonymous;
                        BareJID jid = ss.getAuthorizationID().contains("@") ? BareJID.bareJIDInstance(ss.getAuthorizationID()) : BareJID.bareJIDInstance(ss.getAuthorizationID(), session.getDomain().getVhost().getDomain());
                        if (log.isLoggable(Level.FINE)) {
                            log.finest("Authorized as " + jid);
                        }
                        try {
                            Boolean x = (Boolean)ss.getNegotiatedProperty("IS_ANONYMOUS");
                            anonymous = x == null ? false : x;
                        }
                        catch (Exception e) {
                            anonymous = false;
                        }
                        session.removeSessionData(SASL_SERVER_KEY);
                        session.authorizeJID(jid, anonymous);
                        results.offer(packet.swapFromTo(this.createReply(ElementType.success, challengeData), null, null));
                        break block32;
                    }
                    if (!ss.isComplete()) {
                        results.offer(packet.swapFromTo(this.createReply(ElementType.challenge, challengeData), null, null));
                        break block32;
                    }
                    throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                }
                catch (XmppSaslException e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    String el = e.getSaslErrorElementName() != null ? "<" + e.getSaslErrorElementName() + "/>" : "<not-authorized/>";
                    if (e.getMessage() != null) {
                        el = el + "<text xml:lang='en'>" + e.getMessage() + "</text>";
                    }
                    Packet response = packet.swapFromTo(this.createReply(ElementType.failure, el), null, null);
                    response.setPriority(Priority.SYSTEM);
                    results.offer(response);
                }
                catch (SaslException e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    Packet response = packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null);
                    response.setPriority(Priority.SYSTEM);
                    results.offer(response);
                }
                catch (Exception e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "Problem with SASL", e);
                    }
                    Packet response = packet.swapFromTo(this.createReply(ElementType.failure, "<temporary-auth-failure/>"), null, null);
                    response.setPriority(Priority.SYSTEM);
                    results.offer(response);
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        Collection<String> auth_mechs = this.mechanismSelector.filterMechanisms(Sasl.getSaslServerFactories(), session);
        Element[] mechs = new Element[auth_mechs.size()];
        int idx = 0;
        session.putSessionData(ALLOWED_SASL_MECHANISMS_KEY, auth_mechs);
        for (String mech : auth_mechs) {
            mechs[idx++] = new Element("mechanism", mech);
        }
        return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    }

    public static enum ElementType {
        abort,
        auth,
        challenge,
        failure,
        response,
        success;

    }
}

