/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.util.ArrayList;
import java.util.Map;
import tigase.server.websocket.WebSocketHixie76;
import tigase.server.websocket.WebSocketHybi;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.xmpp.XMPPIOService;

public class WebSocketClientConnectionManager
extends ClientConnectionManager {
    private static final String PROTOCOL_VERSIONS_KEY = "protocol-versions";
    private static final String[] PROTOCOL_VERSIONS_DEF = new String[]{"hybi"};
    private static final WebSocketProtocolIfc[] SUPPORTED_PROTOCOL_VERSIONS = new WebSocketProtocolIfc[]{new WebSocketHybi(), new WebSocketHixie76()};
    private WebSocketProtocolIfc[] enabledProtocolVersions = null;

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        defs.put(PROTOCOL_VERSIONS_KEY, PROTOCOL_VERSIONS_DEF);
        return defs;
    }

    @Override
    public String getDiscoDescription() {
        return "Websocket connection manager";
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(PROTOCOL_VERSIONS_KEY)) {
            String[] versions = (String[])props.get(PROTOCOL_VERSIONS_KEY);
            ArrayList<WebSocketProtocolIfc> value = new ArrayList<WebSocketProtocolIfc>();
            for (String version : versions) {
                for (WebSocketProtocolIfc v : SUPPORTED_PROTOCOL_VERSIONS) {
                    if (!version.equals(v.getId())) continue;
                    value.add(v);
                }
            }
            this.enabledProtocolVersions = value.toArray(new WebSocketProtocolIfc[value.size()]);
        }
        super.setProperties(props);
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5290};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new WebSocketXMPPIOService<Object>(this.enabledProtocolVersions);
    }
}

