/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy.cmd;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.DefaultClusteringStrategyAbstract;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPResourceConnection;

public class PacketForwardCmd
extends CommandListenerAbstract {
    private static final Logger log = Logger.getLogger(PacketForwardCmd.class.getName());
    private SessionManagerClusteredIfc sm;
    private DefaultClusteringStrategyAbstract strategy;

    public PacketForwardCmd(String name, SessionManagerClusteredIfc sm, DefaultClusteringStrategyAbstract strategy) {
        super(name);
        this.sm = sm;
        this.strategy = strategy;
    }

    @Override
    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
        }
        if (packets != null && packets.size() > 0) {
            for (Element elem : packets) {
                try {
                    Packet el_packet = Packet.packetInstance(elem);
                    XMPPResourceConnection conn = this.sm.getXMPPResourceConnection(el_packet);
                    LinkedHashMap<String, String> locdata = null;
                    if (conn != null) {
                        locdata = new LinkedHashMap<String, String>();
                        if (data != null) {
                            locdata.putAll(data);
                        }
                        data.put("user-session-found-key", this.sm.getComponentId().toString());
                    }
                    boolean isSent = this.strategy.sendToNextNode(fromNode, visitedNodes, data, Packet.packetInstance(elem));
                    if (conn != null) {
                        if (this.sm.getComponentId().equals(fromNode)) continue;
                        this.sm.processPacket(el_packet, conn);
                        continue;
                    }
                    if (!this.sm.getComponentId().equals(fromNode) || data != null && data.get("user-session-found-key") != null) continue;
                    this.sm.processPacket(el_packet, conn);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Addressing problem, stringprep failed for packet: " + elem);
                }
            }
        } else {
            log.finest("Empty packets list in the forward command");
        }
    }
}

