/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.PresenceCapabilitiesManager;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public class CAPS
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String[][] ELEMENTS = new String[][]{{"presence"}, Iq.IQ_QUERY_PATH};
    private static final String ID = "caps";
    private static final Logger log = Logger.getLogger(CAPS.class.getCanonicalName());
    private static final String XMLNS_DISCO = "http://jabber.org/protocol/disco#info";
    private static final String[] XMLNSS = new String[]{"jabber:client", "http://jabber.org/protocol/disco#info"};
    private static final RosterAbstract roster_impl = RosterFactory.getRosterImplementation(true);

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session != null && session.isAuthorized()) {
            try {
                if (packet.getElemName() == "presence") {
                    JID to = packet.getStanzaTo();
                    ConcurrentHashMap<JID, Object[]> resources = (ConcurrentHashMap<JID, Object[]>)session.getCommonSessionData(ID);
                    if (resources == null) {
                        resources = new ConcurrentHashMap<JID, Object[]>();
                        session.putCommonSessionData(ID, resources);
                    }
                    if (packet.getType() == null || packet.getType() == StanzaType.available) {
                        Element c = packet.getElement().getChild("c");
                        if (c == null) {
                            return;
                        }
                        Object[] capsNodes = PresenceCapabilitiesManager.processPresence(c);
                        Object[] capsNodesOld = resources.put(packet.getStanzaFrom(), capsNodes);
                        if (capsNodesOld == null || !Arrays.equals(capsNodes, capsNodesOld)) {
                            if (to != null && !roster_impl.isSubscribedFrom(session, packet.getStanzaFrom())) {
                                return;
                            }
                            if (to == null) {
                                to = session.getJID();
                            }
                            PresenceCapabilitiesManager.prepareCapsQueries(JID.jidInstanceNS(to.getDomain()), packet.getStanzaFrom(), (String[])capsNodes, results);
                            if (!session.isUserId(to.getBareJID())) {
                                return;
                            }
                            PresenceCapabilitiesManager.handlePresence(to, packet.getStanzaFrom(), (String[])capsNodes, results);
                        }
                    } else if (packet.getType() == StanzaType.unavailable || packet.getType() == StanzaType.error) {
                        resources.remove(packet.getStanzaFrom());
                    }
                } else if (packet.getElemName() == "iq" && (packet.getType() == StanzaType.error || packet.getType() == StanzaType.result)) {
                    PresenceCapabilitiesManager.processCapsQueryResponse(packet);
                }
            }
            catch (NotAuthorizedException ex) {
                Logger.getLogger(CAPS.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (TigaseDBException ex) {
                Logger.getLogger(CAPS.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (!(session != null && !session.isServerSession() || packet.getElemName() != "iq" || packet.getType() != StanzaType.error && packet.getType() != StanzaType.result)) {
            PresenceCapabilitiesManager.processCapsQueryResponse(packet);
        }
    }

    public static Set<JID> getJidsWithFeature(XMPPResourceConnection session, String feature) {
        HashSet<JID> jids = new HashSet<JID>();
        Map resources = (Map)session.getCommonSessionData(ID);
        if (resources != null) {
            ArrayList available = new ArrayList(resources.keySet());
            block0: for (JID jid : available) {
                String[] capsNodes = (String[])resources.get(jid);
                if (capsNodes == null) continue;
                for (String capsNode : capsNodes) {
                    Object[] features = PresenceCapabilitiesManager.getNodeFeatures(capsNode);
                    if (features == null || Arrays.binarySearch(features, feature) < 0) continue;
                    jids.add(jid);
                    continue block0;
                }
            }
        }
        return jids;
    }
}

