/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.xmpp.BareJID;

public class DataRepositoryImpl
implements DataRepository {
    private static final Logger log = Logger.getLogger(DataRepositoryImpl.class.getName());
    public static final String DERBY_CONNVALID_QUERY = "values 1";
    public static final String JDBC_CONNVALID_QUERY = "select 1";
    public static final String MYSQL_CHECK_TABLE_QUERY = "select * from information_schema.tables where table_name = ? and table_schema = ?";
    public static final String PGSQL_CHECK_TABLE_QUERY = "select * from pg_tables where tablename = ? and schemaname = ?";
    public static final String DERBY_CHECK_TABLE_QUERY = "select * from SYS.SYSTABLES where tablename = UPPER(?) and ? is not null";
    public static final String SQLSERVER_CHECK_TABLE_QUERY = "SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_TYPE = 'BASE TABLE' AND  TABLE_NAME = ? and TABLE_SCHEMA = ?";
    public static final String OTHER_CHECK_TABLE_QUERY = "";
    public static final String SP_STARTS_WITH = "{ call";
    public static final String QUERY_TIMEOUT_PROP_KEY = "sql-query-timeout";
    public static final int QUERY_TIMEOUT = 10;
    public static final String DB_CONN_TIMEOUT_PROP_KEY = "db-conn-timeout";
    public static final int DB_CONN_TIMEOUT = 15;
    private DataRepository.dbTypes database = null;
    private Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long connectionValidateInterval = 60000L;
    private String db_conn = null;
    private long lastConnectionValidated = 0L;
    private boolean derby_mode = false;
    private Map<String, PreparedStatement> db_statements = new ConcurrentSkipListMap<String, PreparedStatement>();
    private Map<String, String> db_queries = new ConcurrentSkipListMap<String, String>();
    private String check_table_query = "";
    private String table_schema = null;
    private int query_timeout = 10;
    private int db_conn_timeout = 15;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTable(String tableName) throws SQLException {
        PreparedStatement checkTableSt = this.getPreparedStatement(null, this.check_table_query);
        if (checkTableSt == null) {
            return true;
        }
        boolean result = false;
        ResultSet rs = null;
        PreparedStatement preparedStatement = checkTableSt;
        synchronized (preparedStatement) {
            try {
                checkTableSt.setString(1, tableName);
                checkTableSt.setString(2, this.table_schema);
                rs = checkTableSt.executeQuery();
                if (rs.next()) {
                    result = true;
                }
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTable(String tableName, String createTableQuery) throws SQLException {
        Object rs = null;
        Statement st = null;
        boolean result = false;
        try {
            log.log(Level.INFO, "Checking if table {0} exists in DB {1}.", new Object[]{tableName, this.table_schema});
            if (!this.checkTable(tableName)) {
                log.log(Level.INFO, "Table {0} not found in database, creating: {1}", new Object[]{tableName, createTableQuery});
                st = this.createStatement(null);
                if (!this.db_conn.contains("derby")) {
                    st.executeUpdate(createTableQuery);
                } else {
                    String[] queries;
                    for (String query : queries = createTableQuery.split(";")) {
                        if ((query = query.trim()).isEmpty()) continue;
                        st.executeUpdate(query);
                    }
                }
                result = true;
            } else {
                log.log(Level.INFO, "OK table {0} found in database.", tableName);
            }
        }
        finally {
            this.release(st, rs);
            rs = null;
            st = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(BareJID user_id) throws SQLException {
        this.checkConnection();
        Map<String, PreparedStatement> map = this.db_statements;
        synchronized (map) {
            return this.conn.createStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement getPreparedStatement(BareJID user_id, String stIdKey) throws SQLException {
        this.checkConnection();
        Map<String, PreparedStatement> map = this.db_statements;
        synchronized (map) {
            return this.db_statements.get(stIdKey);
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public DataRepository.dbTypes getDatabaseType() {
        return this.database;
    }

    @Override
    public void initPreparedStatement(String key, String query) throws SQLException {
        this.db_queries.put(key, query);
        this.initStatement(key);
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws SQLException {
        String driverClass = null;
        if (resource_uri.startsWith("jdbc:postgresql")) {
            this.database = DataRepository.dbTypes.postgresql;
        } else if (resource_uri.startsWith("jdbc:mysql")) {
            this.database = DataRepository.dbTypes.mysql;
        } else if (resource_uri.startsWith("jdbc:derby")) {
            this.database = DataRepository.dbTypes.derby;
        } else if (resource_uri.startsWith("jdbc:jtds:sqlserver")) {
            this.database = DataRepository.dbTypes.jtds;
        } else if (resource_uri.startsWith("jdbc:sqlserver")) {
            this.database = DataRepository.dbTypes.sqlserver;
        }
        switch (this.database) {
            case postgresql: {
                driverClass = "org.postgresql.Driver";
                this.check_table_query = PGSQL_CHECK_TABLE_QUERY;
                break;
            }
            case mysql: {
                driverClass = "com.mysql.jdbc.Driver";
                this.check_table_query = MYSQL_CHECK_TABLE_QUERY;
                break;
            }
            case derby: {
                driverClass = "org.apache.derby.jdbc.EmbeddedDriver";
                this.check_table_query = DERBY_CHECK_TABLE_QUERY;
                break;
            }
            case jtds: {
                driverClass = "net.sourceforge.jtds.jdbc.Driver";
                this.check_table_query = SQLSERVER_CHECK_TABLE_QUERY;
                break;
            }
            case sqlserver: {
                driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                this.check_table_query = SQLSERVER_CHECK_TABLE_QUERY;
                break;
            }
            default: {
                driverClass = "net.sf.log4jdbc.sql.jdbcapi.DriverSpy";
                this.check_table_query = OTHER_CHECK_TABLE_QUERY;
            }
        }
        try {
            Class.forName(driverClass, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DataRepositoryImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.db_conn = resource_uri;
        this.db_conn_timeout = this.getParam(DB_CONN_TIMEOUT_PROP_KEY, params, 15);
        this.query_timeout = this.getParam(QUERY_TIMEOUT_PROP_KEY, params, 10);
        if (this.db_conn != null) {
            switch (this.database) {
                case jtds: 
                case sqlserver: {
                    this.table_schema = "dbo";
                    break;
                }
                case postgresql: {
                    this.table_schema = "public";
                    break;
                }
                default: {
                    String[] slashes = this.db_conn.split("/");
                    this.table_schema = slashes[slashes.length - 1].split("\\?")[0];
                }
            }
            log.log(Level.INFO, "Table schema found: {0}, database type: {1}, database driver: {2}", new Object[]{this.table_schema, this.database.toString(), driverClass});
        }
        this.initRepo();
        if (!this.check_table_query.isEmpty()) {
            this.initPreparedStatement(this.check_table_query, this.check_table_query);
        }
        log.log(Level.INFO, "Initialized database connection: {0}", resource_uri);
    }

    protected int getParam(String key, Map<String, String> params, int def) {
        int result = def;
        String temp = System.getProperty(key);
        if (temp != null) {
            try {
                result = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                result = def;
            }
        }
        if (params != null && (temp = params.get(key)) != null) {
            try {
                result = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                result = def;
            }
        }
        return result;
    }

    @Override
    public void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean checkConnection() throws SQLException {
        ResultSet rs = null;
        try {
            long tmp = System.currentTimeMillis();
            if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                this.lastConnectionValidated = tmp;
                rs = this.conn_valid_st.executeQuery();
            }
            if ((this.conn_valid_st == null || this.conn_valid_st.isClosed()) && tmp - this.lastConnectionValidated >= 1000L) {
                this.initRepo();
            }
            this.release(null, rs);
        }
        catch (Exception e) {
            this.initRepo();
        }
        finally {
            this.release(null, rs);
        }
        return true;
    }

    private void initPreparedStatements() throws SQLException {
        String query = this.derby_mode ? DERBY_CONNVALID_QUERY : JDBC_CONNVALID_QUERY;
        this.conn_valid_st = this.prepareQuery(query);
        try {
            this.conn_valid_st.setQueryTimeout(this.query_timeout);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        for (String key : this.db_queries.keySet()) {
            this.initStatement(key);
        }
    }

    private void initStatement(String key) throws SQLException {
        String query = this.db_queries.get(key);
        PreparedStatement st = this.prepareQuery(query);
        try {
            st.setQueryTimeout(this.query_timeout);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.db_statements.put(key, st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        Object rs = null;
        try {
            Map<String, PreparedStatement> map = this.db_statements;
            synchronized (map) {
                this.db_statements.clear();
                DriverManager.setLoginTimeout(this.db_conn_timeout);
                this.conn = DriverManager.getConnection(this.db_conn);
                this.conn.setAutoCommit(true);
                this.derby_mode = this.db_conn.startsWith("jdbc:derby");
                this.initPreparedStatements();
            }
        }
        finally {
            this.release(null, rs);
            rs = null;
        }
    }

    private PreparedStatement prepareQuery(String query) throws SQLException {
        if (query.startsWith(SP_STARTS_WITH)) {
            return this.conn.prepareCall(query);
        }
        return this.conn.prepareStatement(query);
    }

    @Override
    public DataRepository takeRepoHandle(BareJID user_id) {
        return this;
    }

    @Override
    public void startTransaction() throws SQLException {
        this.conn.setAutoCommit(false);
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void endTransaction() throws SQLException {
        this.conn.setAutoCommit(true);
    }

    @Override
    public void releaseRepoHandle(DataRepository repo) {
    }
}

