/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class Privacy {
    protected static final String ACTION = "action";
    protected static final String ACTIVE = "active-list";
    protected static final String DEFAULT = "default-list";
    protected static final String ITEM = "item";
    protected static final String LIST = "list";
    protected static final String NAME = "name";
    protected static final String ORDER = "order";
    protected static final String PRIVACY = "privacy";
    protected static final String PRIVACY_LIST = "privacy-list";
    protected static final String STANZAS = "stanzas";
    protected static final String TYPE = "type";
    protected static final String VALUE = "value";
    private static Logger log = Logger.getLogger(Privacy.class.getName());

    public static void addList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Saving privacy list: {0}", list);
        }
        String lNode = Privacy.listNode(list.getAttributeStaticStr(NAME));
        session.setData(lNode, PRIVACY_LIST, list.toString());
    }

    public static void removeList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing privacy list: {0}", list);
        }
        String lNode = Privacy.listNode(list.getAttributeStaticStr(NAME));
        session.removeData(lNode, PRIVACY_LIST);
        session.removeDataGroup(lNode);
    }

    public static Element getActiveList(XMPPResourceConnection session) throws NotAuthorizedException {
        return (Element)session.getSessionData(ACTIVE);
    }

    public static String getActiveListName(XMPPResourceConnection session) throws NotAuthorizedException {
        Element list = Privacy.getActiveList(session);
        if (list != null) {
            return list.getAttributeStaticStr(NAME);
        }
        return null;
    }

    public static String getDefaultList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getData(PRIVACY, DEFAULT, null);
    }

    public static Element getList(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode;
        String list_str;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loading privacy list: {0}", list);
        }
        if ((list_str = session.getData(lNode = Privacy.listNode(list), PRIVACY_LIST, null)) != null && !list_str.isEmpty()) {
            SimpleParser parser = SingletonFactory.getParserInstance();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse(domHandler, list_str.toCharArray(), 0, list_str.length());
            Queue<Element> elems = domHandler.getParsedElements();
            Element result = elems.poll();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Loaded privacy list: {0}", result);
            }
            return result;
        }
        return Privacy.getListOld(session, list);
    }

    public static Element getListOld(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode = Privacy.listNode(list);
        String[] items = session.getDataGroups(lNode);
        if (items != null) {
            Element eList = new Element(LIST, new String[]{NAME}, new String[]{list});
            for (String item : items) {
                String iNode = lNode + "/" + item;
                String type = session.getData(iNode, TYPE, null);
                String value = session.getData(iNode, VALUE, null);
                String action = session.getData(iNode, ACTION, null);
                String[] stanzas = session.getDataList(iNode, STANZAS);
                if (item == null || action == null) continue;
                Element eItem = new Element(ITEM, new String[]{ORDER, ACTION}, new String[]{item, action});
                if (type != null) {
                    eItem.addAttribute(TYPE, type);
                }
                if (value != null) {
                    eItem.addAttribute(VALUE, value);
                }
                if (stanzas != null) {
                    for (String stanza : stanzas) {
                        eItem.addChild(new Element(stanza));
                    }
                }
                eList.addChild(eItem);
            }
            return eList;
        }
        return null;
    }

    public static String[] getLists(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getDataGroups(PRIVACY);
    }

    public static String listNode(String list) {
        return "privacy/" + list;
    }

    public static void setActiveList(XMPPResourceConnection session, String lName) throws NotAuthorizedException, TigaseDBException {
        if (lName == null) {
            session.removeSessionData(ACTIVE);
        } else {
            Element list = Privacy.getList(session, lName);
            if (list != null) {
                session.putSessionData(ACTIVE, list);
            } else {
                log.log(Level.INFO, "Setting active list to null, do something better than that, perhaps notify user.");
            }
        }
    }

    public static void setDefaultList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (list != null && list.getAttributeStaticStr(NAME) != null) {
            session.setData(PRIVACY, DEFAULT, list.getAttributeStaticStr(NAME));
        } else {
            session.removeData(PRIVACY, DEFAULT);
        }
    }
}

