/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZLibWrapper {
    private static Logger log = Logger.getLogger(ZLibWrapper.class.getName());
    public static final int COMPRESSED_BUFF_SIZE = 512;
    public static final int DECOMPRESSED_BUFF_SIZE = 5120;
    private static final byte[] EMPTYBYTEARRAY = new byte[0];
    private float average_compression_rate = 0.0f;
    private float average_decompression_rate = 0.0f;
    private byte[] compress_input = null;
    private byte[] compress_output = null;
    private Deflater compresser = null;
    private byte[] decompress_input = null;
    private byte[] decompress_output = null;
    private Inflater decompresser = null;
    private CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
    private int decompressed_buff_size = 5120;
    private CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    private int compression_level = 9;
    private int compressed_buff_size = 512;
    private float last_compression_rate = 0.0f;
    private float last_decompression_rate = 0.0f;

    public ZLibWrapper() {
        this(9, 512);
    }

    public ZLibWrapper(int level) {
        this(level, 512);
    }

    public ZLibWrapper(int level, int comp_buff_size) {
        this.compression_level = level;
        this.compressed_buff_size = comp_buff_size;
        this.decompressed_buff_size = 10 * comp_buff_size;
        this.compresser = new Deflater(this.compression_level, false);
        this.decompresser = new Inflater(false);
        this.compress_output = new byte[this.compressed_buff_size];
        this.compress_input = new byte[this.decompressed_buff_size];
        this.decompress_output = new byte[this.decompressed_buff_size];
        this.decompress_input = new byte[this.compressed_buff_size];
    }

    public static void main(String[] args) throws Exception {
        String[] inputs;
        ZLibWrapper zlib = new ZLibWrapper(9);
        for (String input : inputs = new String[]{"Stream compression implementation for The Tigase XMPP Server.", "Stream compression implementation for The Tigase XMPP Server.", "<message to='kobit@some.domain' from='artur@another.domain'><thread>abcd</thread><subject>some subject</subject><body>This is a message body</body></message>", "<presence to='kobit@some.domain' from='artur@another.domain'><status>away</status><show>I am away</show></presence>", "<message to='ala@some.domain' from='as@another.domain'><thread>abcd</thread><subject>Another subject</subject><body>This is a message body sent to as</body></message>", "<presence to='ala@some.domain' from='as@another.domain'><status>dnd</status><show>I am working really hard</show></presence>", "<message to='santa@some.domain' from='elf@another.domain'><thread>abcd</thread><subject>Christmass presents</subject><body>We need to have a chat about Christmas presents.</body></message>", "<presence to='kobit@some.domain' from='artur@another.domain'><status>away</status><show>I am away</show></presence>"}) {
            System.out.println("\nINPUT[" + input.length() + "]: \n" + input);
            ByteBuffer compressedBuffer = zlib.compress(input);
            System.out.println("  CREATED, compressedBuffer capacity: " + compressedBuffer.capacity() + ", remaining: " + compressedBuffer.remaining() + ", position: " + compressedBuffer.position() + ", limit: " + compressedBuffer.limit());
            String output = zlib.decompressToString(compressedBuffer);
            System.out.println("OUTPUT[" + output.length() + "]: \n" + output);
            System.out.println("input.equals(output)=" + input.equals(output));
        }
        System.out.println("Compression rate: " + zlib.lastCompressionRate());
        String inputstr = "";
        for (String input : inputs) {
            inputstr = inputstr + input;
        }
        System.out.println("INPUT[" + inputstr.length() + "]: \n" + inputstr);
        ByteBuffer compressedBuffer = zlib.compress(inputstr);
        System.out.println("  CREATED, compressedBuffer capacity: " + compressedBuffer.capacity() + ", remaining: " + compressedBuffer.remaining() + ", position: " + compressedBuffer.position() + ", limit: " + compressedBuffer.limit());
        String output = zlib.decompressToString(compressedBuffer);
        System.out.println("OUTPUT[" + output.length() + "]: \n" + output);
        System.out.println("Compression rate: " + zlib.lastCompressionRate());
        System.out.println("inputstr.equals(output)=" + inputstr.equals(output) + "\n");
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'W', 'X', 'Y', 'Z'};
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 100; ++j) {
                    sb.append(c);
                }
                sb.append('\n');
            }
        }
        String input = sb.toString();
        System.out.println("INPUT[" + input.length() + "]:");
        compressedBuffer = zlib.compress(input);
        System.out.println("  CREATED, compressedBuffer capacity: " + compressedBuffer.capacity() + ", remaining: " + compressedBuffer.remaining() + ", position: " + compressedBuffer.position() + ", limit: " + compressedBuffer.limit());
        output = zlib.decompressToString(compressedBuffer);
        System.out.println("OUTPUT[" + output.length() + "]:");
        System.out.println("Compression rate: " + zlib.lastCompressionRate());
        System.out.println("input.equals(output)=" + input.equals(output) + "\n");
        System.out.println("INPUT[" + input.length() + "]:");
        compressedBuffer = zlib.compress(input);
        System.out.println("  CREATED, compressedBuffer capacity: " + compressedBuffer.capacity() + ", remaining: " + compressedBuffer.remaining() + ", position: " + compressedBuffer.position() + ", limit: " + compressedBuffer.limit());
        output = zlib.decompressToString(compressedBuffer);
        System.out.println("OUTPUT[" + output.length() + "]:");
        System.out.println("Compression rate: " + zlib.lastCompressionRate());
        System.out.println("input.equals(output)=" + input.equals(output) + "\n");
    }

    public float averageCompressionRate() {
        return this.average_compression_rate;
    }

    public float averageDecompressionRate() {
        return this.average_decompression_rate;
    }

    public ByteBuffer compress(ByteBuffer input) {
        byte[] result_arr = null;
        float before = input.remaining();
        while (input.hasRemaining()) {
            int size = Math.min(this.compress_input.length, input.remaining());
            input.get(this.compress_input, 0, size);
            this.compresser.setInput(this.compress_input, 0, size);
            while (!this.compresser.needsInput()) {
                result_arr = this.deflate(result_arr);
            }
            result_arr = this.deflate(result_arr);
        }
        if (result_arr.length > this.compress_output.length) {
            this.compress_output = result_arr;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Increasing compress_output size to: {0}", this.compress_output.length);
            }
        }
        this.last_compression_rate = (before - (float)result_arr.length) / before;
        this.average_compression_rate = (this.average_compression_rate + this.last_compression_rate) / 2.0f;
        ByteBuffer result = ByteBuffer.wrap(result_arr);
        return result;
    }

    public ByteBuffer compress(String input) throws CharacterCodingException {
        this.encoder.reset();
        ByteBuffer dataBuffer = this.encoder.encode(CharBuffer.wrap(input));
        this.encoder.flush(dataBuffer);
        ByteBuffer compressedBuffer = this.compress(dataBuffer);
        return compressedBuffer;
    }

    public ByteBuffer decompress(ByteBuffer input) {
        byte[] result_arr = null;
        float before = input.remaining();
        while (input.hasRemaining()) {
            int size = Math.min(this.decompress_input.length, input.remaining());
            input.get(this.decompress_input, 0, size);
            this.decompresser.setInput(this.decompress_input, 0, size);
            int decompressed_size = 1;
            while (!this.decompresser.needsInput() || decompressed_size > 0) {
                try {
                    decompressed_size = this.decompresser.inflate(this.decompress_output, 0, this.decompress_output.length);
                    if (decompressed_size <= 0) continue;
                    if (result_arr == null) {
                        result_arr = Arrays.copyOf(this.decompress_output, decompressed_size);
                        continue;
                    }
                    int old_size = result_arr.length;
                    result_arr = Arrays.copyOf(result_arr, old_size + decompressed_size);
                    System.arraycopy(this.decompress_output, 0, result_arr, old_size, decompressed_size);
                }
                catch (DataFormatException ex) {
                    log.log(Level.INFO, "Stream decompression error: ", ex);
                    this.decompresser.reset();
                }
            }
        }
        ByteBuffer result = null;
        if (result_arr != null) {
            if (result_arr.length > this.decompress_output.length) {
                this.decompress_output = result_arr;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Increasing compress_output size to: " + this.compress_output.length);
                }
            }
            this.last_decompression_rate = ((float)result_arr.length - before) / (float)result_arr.length;
            this.average_decompression_rate = (this.average_decompression_rate + this.last_decompression_rate) / 2.0f;
            result = ByteBuffer.wrap(result_arr);
        }
        return result;
    }

    public String decompressToString(ByteBuffer input) throws CharacterCodingException {
        ByteBuffer decompressed_buff = this.decompress(input);
        CharBuffer cb = this.decoder.decode(decompressed_buff);
        String output = new String(cb.array());
        return output;
    }

    public void end() {
        this.compresser.end();
        this.decompresser.end();
        this.compress_output = null;
        this.compress_input = null;
        this.decompress_output = null;
        this.decompress_input = null;
    }

    public float lastCompressionRate() {
        return this.last_compression_rate;
    }

    public float lastDecompressionRate() {
        return this.last_decompression_rate;
    }

    private byte[] deflate(byte[] input_arr) {
        byte[] result_arr = input_arr;
        int compressed_size = this.compresser.deflate(this.compress_output, 0, this.compress_output.length, 2);
        if (compressed_size > 0) {
            if (result_arr == null) {
                result_arr = Arrays.copyOf(this.compress_output, compressed_size);
            } else {
                int old_size = result_arr.length;
                result_arr = Arrays.copyOf(result_arr, old_size + compressed_size);
                System.arraycopy(this.compress_output, 0, result_arr, old_size, compressed_size);
            }
        }
        return result_arr;
    }
}

