/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.net.IOServiceListener;
import tigase.net.SocketThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.util.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;

public class StreamManagementIOProcessor
implements XMPPIOProcessor {
    private static final Logger log = Logger.getLogger(StreamManagementIOProcessor.class.getCanonicalName());
    public static final String XMLNS = "urn:xmpp:sm:3";
    private static final String ACK_NAME = "a";
    private static final String ENABLE_NAME = "enable";
    private static final String ENABLED_NAME = "enabled";
    private static final String REQ_NAME = "r";
    private static final String RESUME_NAME = "resume";
    private static final String RESUMED_NAME = "resumed";
    private static final String H_ATTR = "h";
    private static final String LOCATION_ATTR = "location";
    private static final String RESUME_ATTR = "resume";
    private static final String MAX_ATTR = "max";
    private static final String PREVID_ATTR = "previd";
    private static final String INGORE_UNDELIVERED_PRESENCE_KEY = "ignore-undelivered-presence";
    private static final String IN_COUNTER_KEY = "urn:xmpp:sm:3_in";
    private static final String MAX_RESUMPTION_TIMEOUT_KEY = "urn:xmpp:sm:3_resumption-timeout";
    private static final String OUT_COUNTER_KEY = "urn:xmpp:sm:3_out";
    private static final String RESUMPTION_TASK_KEY = "urn:xmpp:sm:3_resumption-task";
    private static final String RESUMPTION_TIMEOUT_PROP_KEY = "resumption-timeout";
    private static final String STREAM_ID_KEY = "urn:xmpp:sm:3_stream_id";
    private static final Element[] FEATURES = new Element[]{new Element("sm", new String[]{"xmlns"}, new String[]{"urn:xmpp:sm:3"})};
    private final ConcurrentHashMap<String, XMPPIOService> services = new ConcurrentHashMap();
    private boolean ignoreUndeliveredPresence = true;
    private int resumption_timeout = 60;
    private int default_ack_request_count = 10;
    private ConnectionManager connectionManager;

    public static boolean isEnabled(XMPPIOService service) {
        return service.getSessionData().containsKey(IN_COUNTER_KEY);
    }

    private static boolean isResumptionEnabled(XMPPIOService service) {
        return service.getSessionData().containsKey(STREAM_ID_KEY);
    }

    @Override
    public String getId() {
        return XMLNS;
    }

    @Override
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public Element[] supStreamFeatures(XMPPIOService service) {
        return FEATURES;
    }

    @Override
    public boolean processIncoming(XMPPIOService service, Packet packet) {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            if (packet.getXMLNS() != XMLNS) {
                return false;
            }
            if (packet.getElemName() == ENABLE_NAME) {
                service.getSessionData().putIfAbsent(IN_COUNTER_KEY, new Counter());
                service.getSessionData().putIfAbsent(OUT_COUNTER_KEY, new OutQueue());
                String id = null;
                String location = null;
                int max = this.resumption_timeout;
                if (this.resumption_timeout > 0 && packet.getElement().getAttributeStaticStr("resume") != null) {
                    String maxStr = packet.getElement().getAttributeStaticStr(MAX_ATTR);
                    if (maxStr != null) {
                        max = Math.min(max, Integer.parseInt(maxStr));
                    }
                    id = UUID.randomUUID().toString();
                    location = this.connectionManager.getDefHostName().toString();
                    service.getSessionData().putIfAbsent(STREAM_ID_KEY, id);
                    service.getSessionData().put(MAX_RESUMPTION_TIMEOUT_KEY, max);
                    this.services.put(id, service);
                }
                try {
                    service.writeRawData("<enabled xmlns='urn:xmpp:sm:3'" + (id != null ? " id='" + id + "' " + "resume" + "='true' " + MAX_ATTR + "='" + max + "'" : "") + (location != null ? " location='" + location + "'" : "") + " />");
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "exception during sending <enabled/>, stopping...", ex);
                    }
                    service.forceStop();
                }
                return true;
            }
            if (packet.getElemName() == "resume") {
                String h = packet.getElement().getAttributeStaticStr(H_ATTR);
                String id = packet.getElement().getAttributeStaticStr(PREVID_ATTR);
                try {
                    this.resumeStream(service, id, Integer.parseInt(h));
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "exception while resuming stream for user " + service.getUserJid() + " with id " + id, ex);
                    }
                    service.forceStop();
                }
                return true;
            }
            return false;
        }
        if (packet.getXMLNS() == XMLNS) {
            if (packet.getElemName() == ACK_NAME) {
                String valStr = packet.getAttributeStaticStr(H_ATTR);
                int val = Integer.parseInt(valStr);
                OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
                outQueue.ack(val);
            } else if (packet.getElemName() == REQ_NAME) {
                int value = ((Counter)service.getSessionData().get(IN_COUNTER_KEY)).get();
                try {
                    service.writeRawData("<a xmlns='urn:xmpp:sm:3' h='" + String.valueOf(value) + "'/>");
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "exception during sending <a/> as response for <r/>, stopping...", ex);
                    }
                    service.forceStop();
                }
            }
            return true;
        }
        ((Counter)service.getSessionData().get(IN_COUNTER_KEY)).inc();
        return false;
    }

    @Override
    public boolean processOutgoing(XMPPIOService service, Packet packet) {
        if (!StreamManagementIOProcessor.isEnabled(service) || packet.getXMLNS() == XMLNS) {
            return false;
        }
        OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
        outQueue.append(packet);
        return service.getSessionData().containsKey(RESUMPTION_TASK_KEY);
    }

    @Override
    public void packetsSent(XMPPIOService service) throws IOException {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            return;
        }
        OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
        if (outQueue.waitingForAck() >= this.default_ack_request_count) {
            service.writeRawData("<r xmlns='urn:xmpp:sm:3' />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCommand(XMPPIOService service, Packet pc) {
        String cmdId = Command.getFieldValue(pc, "cmd");
        if ("stream-moved".equals(cmdId)) {
            block17: {
                String newConn = Command.getFieldValue(pc, "new-conn-jid");
                String id = (String)service.getSessionData().get(STREAM_ID_KEY);
                JID newConnJid = JID.jidInstanceNS(newConn);
                Object newService = this.connectionManager.getXMPPIOService(newConnJid.getResource());
                if (newService != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "stream for user {2} moved from {0} to {1}", new Object[]{service.getConnectionId(), ((IOService)newService).getConnectionId(), ((XMPPIOService)newService).getUserJid()});
                    }
                    try {
                        ((XMPPIOService)newService).setUserJid(service.getUserJid());
                        Counter inCounter = (Counter)((IOService)newService).getSessionData().get(IN_COUNTER_KEY);
                        ((XMPPIOService)newService).writeRawData("<resumed xmlns='urn:xmpp:sm:3' previd='" + id + "' " + H_ATTR + "='" + inCounter.get() + "' />");
                        service.getSessionData().put("stream-closed", "stream-closed");
                        this.services.put(id, (XMPPIOService)newService);
                        OutQueue outQueue = (OutQueue)((IOService)newService).getSessionData().get(OUT_COUNTER_KEY);
                        ArrayList<Packet> packetsToResend = new ArrayList<Packet>(outQueue.getQueue());
                        for (Packet packet : packetsToResend) {
                            ((XMPPIOService)newService).addPacketToSend(packet);
                        }
                        if (packetsToResend.isEmpty() || !((XMPPIOService)newService).writeInProgress.tryLock()) break block17;
                        try {
                            ((XMPPIOService)newService).processWaitingPackets();
                            SocketThread.addSocketService(newService);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, newService + "Exception during writing packets: ", e);
                            try {
                                ((XMPPIOService)newService).stop();
                            }
                            catch (Exception e1) {
                                log.log(Level.WARNING, newService + "Exception stopping XMPPIOService: ", e1);
                            }
                        }
                        finally {
                            ((XMPPIOService)newService).writeInProgress.unlock();
                        }
                    }
                    catch (IOException ex) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "could not confirm session resumption for user = " + ((XMPPIOService)newService).getUserJid(), ex);
                        }
                        this.services.remove(id, service);
                        this.services.remove(id, newService);
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "no new service available for user {0} to resume from {1}, already closed?", new Object[]{service.getUserJid(), service});
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "closing old service {0} for user {1}", new Object[]{service, service.getUserJid()});
            }
            this.connectionManager.serviceStopped(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean serviceStopped(XMPPIOService service, boolean streamClosed) {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            return false;
        }
        String id = (String)service.getSessionData().get(STREAM_ID_KEY);
        if (streamClosed) {
            service.getSessionData().remove(STREAM_ID_KEY);
        }
        if (StreamManagementIOProcessor.isResumptionEnabled(service)) {
            if (!this.services.containsKey(id)) {
                return false;
            }
            service.setIOServiceListener((IOServiceListener)null);
            int resumptionTimeout = (Integer)service.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY);
            XMPPIOService xMPPIOService = service;
            synchronized (xMPPIOService) {
                if (!service.getSessionData().containsKey(RESUMPTION_TASK_KEY)) {
                    ResumptionTimeoutTask timerTask = new ResumptionTimeoutTask(service);
                    service.getSessionData().put(RESUMPTION_TASK_KEY, timerTask);
                    this.connectionManager.addTimerTask(timerTask, (long)(resumptionTimeout * 1000));
                }
            }
            return false;
        }
        if (id != null) {
            this.services.remove(id, service);
        }
        this.sendErrorsForQueuedPackets(service);
        return false;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(RESUMPTION_TIMEOUT_PROP_KEY)) {
            this.resumption_timeout = (Integer)props.get(RESUMPTION_TIMEOUT_PROP_KEY);
        }
        if (props.containsKey(INGORE_UNDELIVERED_PRESENCE_KEY)) {
            this.ignoreUndeliveredPresence = (Boolean)props.get(INGORE_UNDELIVERED_PRESENCE_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeStream(XMPPIOService service, String id, int h) throws IOException {
        XMPPIOService oldService = this.services.get(id);
        if (oldService == null || !this.isSameUser(oldService, service)) {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><item-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
            return;
        }
        if (service.getUserJid() != null) {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><unexpected-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
            return;
        }
        if (this.services.remove(id, oldService)) {
            XMPPIOService xMPPIOService = oldService;
            synchronized (xMPPIOService) {
                TimerTask timerTask = (TimerTask)oldService.getSessionData().remove(RESUMPTION_TASK_KEY);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                oldService.getSessionData().put(RESUMPTION_TASK_KEY, true);
            }
            OutQueue outQueue = (OutQueue)oldService.getSessionData().get(OUT_COUNTER_KEY);
            outQueue.ack(h);
            service.getSessionData().put(OUT_COUNTER_KEY, outQueue);
            service.getSessionData().put(MAX_RESUMPTION_TIMEOUT_KEY, oldService.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY));
            service.getSessionData().put(IN_COUNTER_KEY, oldService.getSessionData().get(IN_COUNTER_KEY));
            service.getSessionData().put(STREAM_ID_KEY, oldService.getSessionData().get(STREAM_ID_KEY));
            Packet cmd = Command.STREAM_MOVED.getPacket(service.getConnectionId(), service.getDataReceiver(), StanzaType.set, "moved");
            cmd.setPacketFrom(service.getConnectionId());
            cmd.setPacketTo(service.getDataReceiver());
            Command.addFieldValue(cmd, "old-conn-jid", oldService.getConnectionId().toString());
            this.connectionManager.processOutPacket(cmd);
        } else {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><item-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
        }
    }

    private boolean isSameUser(XMPPIOService oldService, XMPPIOService newService) {
        if (oldService.getUserJid() == null || newService.getUserJid() == null) {
            return false;
        }
        JID oldUserJid = JID.jidInstanceNS(oldService.getUserJid());
        JID newUserJid = JID.jidInstanceNS(newService.getUserJid());
        return oldUserJid.getBareJID().equals(newUserJid.getBareJID());
    }

    private void sendErrorsForQueuedPackets(XMPPIOService service) {
        OutQueue outQueue = (OutQueue)service.getSessionData().remove(OUT_COUNTER_KEY);
        if (outQueue != null) {
            Packet packet = null;
            while ((packet = (Packet)outQueue.queue.poll()) != null) {
                try {
                    if (packet.getElemName() == "presence" && this.ignoreUndeliveredPresence) continue;
                    this.connectionManager.processOutPacket(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, null, true));
                }
                catch (PacketErrorTypeException ex) {
                    log.log(Level.FINER, "exception prepareing request for returning error, data = {0}", packet);
                }
            }
        }
    }

    public static class OutQueue
    extends Counter {
        private final ArrayDeque<Packet> queue = new ArrayDeque();

        public void append(Packet packet) {
            if (!packet.wasProcessedBy(StreamManagementIOProcessor.XMLNS)) {
                packet.processedBy(StreamManagementIOProcessor.XMLNS);
                this.queue.offer(packet);
                this.inc();
            }
        }

        public void ack(int value) {
            int count = this.get() - value;
            if (count < 0) {
                count = Integer.MAX_VALUE - value + this.get() + 1;
            }
            while (count < this.queue.size()) {
                this.queue.poll();
            }
        }

        public int waitingForAck() {
            return this.queue.size();
        }

        protected ArrayDeque<Packet> getQueue() {
            return this.queue;
        }
    }

    private static class Counter {
        private int counter = 0;

        private Counter() {
        }

        public void inc() {
            ++this.counter;
            if (this.counter < 0) {
                this.counter = 0;
            }
        }

        public int get() {
            return this.counter;
        }

        protected void setCounter(int value) {
            this.counter = value;
        }
    }

    private class ResumptionTimeoutTask
    extends TimerTask {
        private final XMPPIOService service;

        public ResumptionTimeoutTask(XMPPIOService service) {
            this.service = service;
        }

        @Override
        public void run() {
            String id = (String)this.service.getSessionData().get(StreamManagementIOProcessor.STREAM_ID_KEY);
            if (StreamManagementIOProcessor.this.services.remove(id, this.service)) {
                StreamManagementIOProcessor.this.sendErrorsForQueuedPackets(this.service);
                StreamManagementIOProcessor.this.connectionManager.serviceStopped(this.service);
            }
        }
    }
}

