/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.IOInterface;
import tigase.net.IOUtil;
import tigase.stats.StatisticsList;

public class SocketIO
implements IOInterface {
    private static final Logger log = Logger.getLogger(SocketIO.class.getName());
    private static final int MAX_USER_IO_QUEUE_SIZE_PROP_DEF = 1000;
    private static final String MAX_USER_IO_QUEUE_SIZE_PROP_KEY = "max-user-io-queue-size";
    private long buffOverflow = 0L;
    private int bytesRead = 0;
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private SocketChannel channel = null;
    private Queue<ByteBuffer> dataToSend = null;
    private String logId = null;
    private String remoteAddress = null;
    private long totalBuffOverflow = 0L;
    private long totalBytesReceived = 0L;
    private long totalBytesSent = 0L;

    public SocketIO(SocketChannel sock) throws IOException {
        this.channel = sock;
        this.channel.configureBlocking(false);
        this.channel.socket().setSoLinger(false, 0);
        this.channel.socket().setReuseAddress(true);
        this.channel.socket().setKeepAlive(true);
        this.remoteAddress = this.channel.socket().getInetAddress().getHostAddress();
        if (this.channel.socket().getTrafficClass() == 8) {
            this.dataToSend = new LinkedBlockingQueue<ByteBuffer>(100000);
        } else {
            int queue_size = Integer.getInteger(MAX_USER_IO_QUEUE_SIZE_PROP_KEY, 1000);
            this.dataToSend = new LinkedBlockingQueue<ByteBuffer>(queue_size);
        }
    }

    @Override
    public int bytesRead() {
        return this.bytesRead;
    }

    @Override
    public boolean checkCapabilities(String caps) {
        return false;
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.channel.socket().getReceiveBufferSize();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public void getStatistics(StatisticsList list, boolean reset) {
        list.add("socketio", "Bytes sent", this.bytesSent, Level.FINE);
        list.add("socketio", "Bytes received", this.bytesReceived, Level.FINE);
        list.add("socketio", "Buffers overflow", this.buffOverflow, Level.FINE);
        list.add("socketio", "Total bytes sent", this.totalBytesSent, Level.FINE);
        list.add("socketio", "Total bytes received", this.totalBytesReceived, Level.FINE);
        list.add("socketio", "Ttoal buffers overflow", this.totalBuffOverflow, Level.FINE);
        if (reset) {
            this.bytesSent = 0L;
            this.bytesReceived = 0L;
            this.buffOverflow = 0L;
        }
    }

    @Override
    public long getBytesSent(boolean reset) {
        long tmp = this.bytesSent;
        if (reset) {
            this.bytesSent = 0L;
        }
        return tmp;
    }

    @Override
    public long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    @Override
    public long getBytesReceived(boolean reset) {
        long tmp = this.bytesReceived;
        if (reset) {
            this.bytesReceived = 0L;
        }
        return tmp;
    }

    @Override
    public long getTotalBytesReceived() {
        return this.totalBytesReceived;
    }

    @Override
    public long getBuffOverflow(boolean reset) {
        long tmp = this.buffOverflow;
        if (reset) {
            this.buffOverflow = 0L;
        }
        return tmp;
    }

    @Override
    public long getTotalBuffOverflow() {
        return this.totalBuffOverflow;
    }

    @Override
    public boolean isConnected() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isRemoteAddress(String addr) {
        return this.remoteAddress.equals(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        ByteBuffer tmp = IOUtil.getDirectBuffer(buff.remaining());
        try {
            this.bytesRead = this.channel.read(tmp);
            tmp.flip();
            if (this.bytesRead > 0) {
                buff.put(tmp);
            }
        }
        finally {
            IOUtil.returnDirectBuffer(tmp);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Read from channel {0} bytes, {1}", new Object[]{this.bytesRead, this.toString()});
        }
        if (this.bytesRead == -1) {
            this.channel.close();
        }
        if (this.bytesRead > 0) {
            buff.flip();
            this.bytesReceived += (long)this.bytesRead;
            this.totalBytesReceived += (long)this.bytesRead;
        }
        return buff;
    }

    @Override
    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called " + this.toString());
        }
        this.channel.close();
    }

    public String toString() {
        return this.logId + (this.channel == null ? null : this.channel.socket());
    }

    @Override
    public boolean waitingToSend() {
        return this.isConnected() && this.dataToSend.size() > 0;
    }

    @Override
    public int waitingToSendSize() {
        return this.dataToSend.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buff) throws IOException {
        if (buff != null && buff.hasRemaining()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "SOCKET - Writing data, remaining: {0}, {1}", new Object[]{buff.remaining(), this.toString()});
            }
            if (!this.dataToSend.offer(buff)) {
                ++this.buffOverflow;
                ++this.totalBuffOverflow;
            }
        }
        int result = 0;
        ByteBuffer dataBuffer = null;
        while ((dataBuffer = this.dataToSend.peek()) != null) {
            int lim;
            int pos = dataBuffer.position();
            int rem = pos <= (lim = dataBuffer.limit()) ? lim - pos : 0;
            int res = 0;
            ByteBuffer tmp = IOUtil.getDirectBuffer(rem);
            try {
                tmp.put(dataBuffer);
                tmp.flip();
                dataBuffer.position(pos);
                res = this.channel.write(tmp);
                if (res > 0) {
                    dataBuffer.position(pos + res);
                }
            }
            finally {
                IOUtil.returnDirectBuffer(tmp);
            }
            if (res == -1) {
                throw new EOFException("Channel has been closed.");
            }
            result += res;
            if (dataBuffer.hasRemaining()) break;
            this.dataToSend.poll();
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Wrote to channel {0} bytes, {1}", new Object[]{result, this.toString()});
        }
        this.bytesSent += (long)result;
        this.totalBytesSent += (long)result;
        return result;
    }

    @Override
    public void setLogId(String logId) {
        this.logId = logId + " ";
    }
}

