/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.vhosts.VHostManager;
import tigase.xmpp.JID;

public class VHostManagerClustered
extends VHostManager
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(VHostManagerClustered.class.getName());
    private List<JID> connectedNodes = new CopyOnWriteArrayList<JID>();
    private String CONNECTED_NODES_VAR = "connectedNodes";

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(String node) {
        JID nodeJID = JID.jidInstanceNS("vhost-man", node, null);
        log.log(Level.FINEST, "Node connected: " + nodeJID);
        List<JID> list = this.connectedNodes;
        synchronized (list) {
            if (!this.connectedNodes.contains(nodeJID)) {
                this.connectedNodes.add(nodeJID);
            }
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        JID nodeJID = JID.jidInstanceNS("vhost-man", node, null);
        log.log(Level.FINEST, "Node disconnected: " + nodeJID);
        this.connectedNodes.remove(nodeJID);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(this.CONNECTED_NODES_VAR, (Object)this.connectedNodes);
        log.log(Level.ALL, " == initBindings: " + Arrays.asList(this.connectedNodes));
    }
}

