/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import tigase.auth.SessionAware;
import tigase.auth.callbacks.ValidateCertificateData;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;
import tigase.xmpp.XMPPResourceConnection;

public class CertBasedCallbackHandler
implements CallbackHandler,
SessionAware {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private XMPPResourceConnection session;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof ValidateCertificateData) {
                    String[] authJIDs;
                    ValidateCertificateData authCallback = (ValidateCertificateData)callbacks[i];
                    String domain = this.session.getDomain().getVhost().getDomain();
                    BareJID defaultAuthzid = authCallback.getDefaultAuthzid();
                    if (defaultAuthzid != null && !defaultAuthzid.getDomain().equals(domain)) {
                        return;
                    }
                    for (String string : authJIDs = (String[])this.session.getSessionData("SESSION_AUTH_JIDS_KEY")) {
                        if (defaultAuthzid != null) {
                            if (!string.equals(defaultAuthzid.toString())) continue;
                            authCallback.setAuthorized(true);
                            authCallback.setAuthorizedID(string);
                            continue;
                        }
                        if (!BareJID.bareJIDInstance(string).getDomain().equals(domain)) continue;
                        authCallback.setAuthorized(true);
                        authCallback.setAuthorizedID(string);
                    }
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
        catch (TigaseStringprepException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSession(XMPPResourceConnection session) {
        this.session = session;
    }
}

