/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.DynamicRosterIfc;

public abstract class DynamicRoster {
    private static final String DYNAMIC_ROSTERS = "dynamic-rosters";
    private static final String DYNAMIC_ROSTERS_CLASSES = "dynamic-roster-classes";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.DynamicRoster");

    public static JID[] addBuddies(XMPPResourceConnection session, Map<String, Object> settings, JID[] buddies) throws NotAuthorizedException {
        List<JID> result = DynamicRoster.getBuddiesList(session, settings);
        if (buddies != null) {
            if (result == null) {
                result = new ArrayList<JID>();
            }
            DynamicRoster.addBuddiesToList(result, buddies);
        }
        if (result != null && result.size() > 0) {
            return result.toArray(new JID[result.size()]);
        }
        return null;
    }

    public static JID[] getBuddies(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException {
        List<JID> result = DynamicRoster.getBuddiesList(session, settings);
        if (result != null && result.size() > 0) {
            return result.toArray(new JID[result.size()]);
        }
        return null;
    }

    public static List<JID> getBuddiesList(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException {
        DynamicRosterIfc[] dynr = DynamicRoster.getDynamicRosters(settings);
        if (dynr != null) {
            ArrayList<JID> result = new ArrayList<JID>();
            for (DynamicRosterIfc dri : dynr) {
                JID[] buddies = dri.getBuddies(session);
                if (buddies == null) continue;
                DynamicRoster.addBuddiesToList(result, buddies);
            }
            if (result.size() > 0) {
                return result;
            }
        }
        return null;
    }

    public static void addBuddiesToList(List<JID> list, JID[] buddies) {
        for (JID buddy : buddies) {
            if (list.contains(buddy)) continue;
            list.add(buddy);
        }
    }

    public static Element getBuddyItem(XMPPResourceConnection session, Map<String, Object> settings, JID buddy) throws NotAuthorizedException {
        DynamicRosterIfc[] dynr = DynamicRoster.getDynamicRosters(settings);
        if (dynr != null) {
            for (DynamicRosterIfc dri : dynr) {
                Element item = dri.getBuddyItem(session, buddy);
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicRosterIfc[] getDynamicRosters(Map<String, Object> settings) {
        DynamicRosterIfc[] dynr = null;
        if (settings != null) {
            Map<String, Object> map = settings;
            synchronized (map) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Initializing settings.");
                }
                DynamicRoster.init_settings(settings);
            }
            dynr = (DynamicRosterIfc[])settings.get(DYNAMIC_ROSTERS);
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Settings parameter is NULL");
        }
        return dynr;
    }

    public static List<Element> getRosterItems(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException {
        DynamicRosterIfc[] dynr = DynamicRoster.getDynamicRosters(settings);
        if (dynr != null) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (DynamicRosterIfc dri : dynr) {
                List<Element> items = dri.getRosterItems(session);
                if (items == null) continue;
                result.addAll(items);
            }
            if (result.size() > 0) {
                return result;
            }
        }
        return null;
    }

    public static void init_settings(Map<String, Object> settings) {
        DynamicRosterIfc[] dynr = (DynamicRosterIfc[])settings.get(DYNAMIC_ROSTERS);
        if (dynr == null) {
            log.finer("Initializing dynamic rosters...");
            String dynclss = (String)settings.get(DYNAMIC_ROSTERS_CLASSES);
            if (dynclss != null) {
                String[] dyncls = dynclss.split(",");
                ArrayList<DynamicRosterIfc> al = new ArrayList<DynamicRosterIfc>(50);
                for (String cls : dyncls) {
                    try {
                        DynamicRosterIfc dri = (DynamicRosterIfc)Class.forName(cls).newInstance();
                        if (settings.get(cls + ".init") != null) {
                            dri.init((String)settings.get(cls + ".init"));
                        } else {
                            dri.init(settings);
                        }
                        al.add(dri);
                        log.log(Level.INFO, "Initialized dynamic roster: {0}", cls);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Problem initializing dynmic roster class: {0}, {1}", new Object[]{cls, e});
                    }
                }
                if (al.size() > 0) {
                    settings.put(DYNAMIC_ROSTERS, al.toArray(new DynamicRosterIfc[al.size()]));
                }
            }
        }
    }

    public static Element getItemExtraData(XMPPResourceConnection session, Map<String, Object> settings, Element item) {
        DynamicRosterIfc[] dynr = DynamicRoster.getDynamicRosters(settings);
        if (dynr != null) {
            DynamicRosterIfc dri;
            Element result = null;
            DynamicRosterIfc[] arr$ = dynr;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = (dri = arr$[i$]).getItemExtraData(item)) == null; ++i$) {
            }
            return result;
        }
        return null;
    }

    public static void setItemExtraData(XMPPResourceConnection session, Map<String, Object> settings, Element item) {
        DynamicRosterIfc[] dynr = DynamicRoster.getDynamicRosters(settings);
        if (dynr != null) {
            for (DynamicRosterIfc dri : dynr) {
                dri.setItemExtraData(item);
            }
        }
    }
}

