/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import tigase.db.NonAuthUserRepository;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;

public class MessageCarbons
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc,
XMPPPacketFilterIfc {
    private static final String ID = "message-carbons";
    private static final String XMLNS = "urn:xmpp:carbons:2";
    private static final String[][] ELEMENTS = new String[][]{{"message"}, {"iq", "enable"}, {"iq", "disable"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "urn:xmpp:carbons:2", "urn:xmpp:carbons:2"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:carbons:2"})};
    private static final String ENABLED_KEY = "urn:xmpp:carbons:2-enabled";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (packet.getElemName() == "iq") {
            boolean disable;
            boolean enable = packet.getElement().getChild("enable", XMLNS) != null;
            boolean bl = disable = packet.getElement().getChild("disable", XMLNS) != null;
            if (enable && disable || !enable && !disable) {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, false));
            } else {
                this.setEnabled(session, enable);
                results.offer(packet.okResult((Element)null, 0));
            }
        } else if (packet.getElemName() == "message" && packet.getType() == StanzaType.chat && packet.getStanzaTo() != null) {
            Set enabledJids = (Set)session.getCommonSessionData(ENABLED_KEY);
            if (enabledJids == null || enabledJids.isEmpty()) {
                return;
            }
            if (!(session.isUserId(packet.getStanzaTo().getBareJID()) && packet.getStanzaTo().getResource() == null || packet.getType() != StanzaType.chat)) {
                Element privateEl = packet.getElement().getChild("private", XMLNS);
                if (privateEl != null) {
                    packet.getElement().removeChild(privateEl);
                    return;
                }
                String type = session.isUserId(packet.getStanzaTo().getBareJID()) ? "received" : "sent";
                JID srcJid = JID.jidInstance(session.getBareJID());
                for (JID jid : enabledJids) {
                    if (session.getJID().equals(jid)) continue;
                    try {
                        Packet msgClone = this.prepareCarbonCopy(packet, session, srcJid, jid, type);
                        results.offer(msgClone);
                    }
                    catch (NoConnectionIdException ex) {
                        enabledJids.remove(jid);
                    }
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private Packet prepareCarbonCopy(Packet packet, XMPPResourceConnection session, JID srcJid, JID jid, String type) throws NoConnectionIdException {
        Packet msgClone = Message.getMessage(srcJid, jid, packet.getType(), null, null, null, packet.getStanzaId());
        msgClone.setPacketTo(session.getConnectionId(jid));
        Element received = new Element(type);
        received.setXMLNS(XMLNS);
        msgClone.getElement().addChild(received);
        Element forwarded = new Element("forwarded");
        forwarded.setXMLNS("urn:xmpp:forward:0");
        received.addChild(forwarded);
        forwarded.addChild(packet.getElement().clone());
        return msgClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(XMPPResourceConnection session, boolean value) throws NotAuthorizedException {
        XMPPSession xMPPSession = session.getParentSession();
        synchronized (xMPPSession) {
            CopyOnWriteArraySet<JID> enabledJids = (CopyOnWriteArraySet<JID>)session.getCommonSessionData(ENABLED_KEY);
            if (enabledJids == null && value) {
                enabledJids = new CopyOnWriteArraySet<JID>();
                session.putCommonSessionData(ENABLED_KEY, enabledJids);
            }
            if (value) {
                enabledJids.add(session.getJID());
            } else if (enabledJids != null) {
                enabledJids.remove(session.getJID());
            }
        }
    }

    private boolean isEnabled(XMPPResourceConnection session) throws NotAuthorizedException {
        Set enabledJids = (Set)session.getCommonSessionData(ENABLED_KEY);
        return enabledJids != null && enabledJids.contains(session.getJID());
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (session.isAuthorized()) {
            try {
                this.setEnabled(session, false);
            }
            catch (NotAuthorizedException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || !session.isAuthorized() || results == null || results.size() == 0 || packet == null) {
            return;
        }
        if (packet.getElemName() != "message") {
            return;
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Element messageEl;
            Element privateEl;
            Packet res = (Packet)it.next();
            if (res.getElemName() != "message") continue;
            if (this.isErrorDeliveringForkedMessage(packet, session)) {
                it.remove();
            }
            if ((privateEl = (messageEl = res.getElement()).getChild("private", XMLNS)) == null) continue;
            messageEl.removeChild(privateEl);
        }
    }

    private boolean isErrorDeliveringForkedMessage(Packet packet, XMPPResourceConnection session) {
        if (!session.isAuthorized() || packet.getStanzaTo() == null) {
            return false;
        }
        try {
            if (packet.getType() == StanzaType.error && packet.getStanzaTo().getResource() == null && session.isUserId(packet.getStanzaTo().getBareJID())) {
                Element messageEl = packet.getElement();
                Element sentEl = messageEl.getChild("sent", XMLNS);
                if (sentEl != null) {
                    return true;
                }
                Element receivedEl = messageEl.getChild("received", XMLNS);
                if (receivedEl != null) {
                    return true;
                }
            }
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        return false;
    }
}

