/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.X509TrustManager;

public class CertFilesTrustManager
implements X509TrustManager {
    private static CertificateFactory certificateFactory;
    private PKIXParameters parameters;
    private CertPathValidator validator;

    public static CertFilesTrustManager getInstance(String pathToCertsFiles) throws Exception {
        File[] files;
        certificateFactory = CertificateFactory.getInstance("X.509");
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (File file : files = new File(pathToCertsFiles).listFiles()) {
            if (!file.isFile()) continue;
            try {
                X509Certificate cert = CertFilesTrustManager.loadCertificate(file);
                TrustAnchor ta = new TrustAnchor(cert, null);
                trustAnchors.add(ta);
            }
            catch (CertificateParsingException e) {
                // empty catch block
            }
        }
        CertPathValidator val = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        PKIXParameters cpp = new PKIXParameters(trustAnchors);
        cpp.setRevocationEnabled(false);
        CertFilesTrustManager tm = new CertFilesTrustManager(val, cpp);
        return tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate loadCertificate(File certFile) throws Exception {
        FileInputStream inStream = null;
        try {
            X509Certificate cert;
            inStream = new FileInputStream(certFile);
            X509Certificate x509Certificate = cert = (X509Certificate)certificateFactory.generateCertificate(inStream);
            return x509Certificate;
        }
        finally {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
    }

    private CertFilesTrustManager(CertPathValidator val, PKIXParameters cpp) {
        this.validator = val;
        this.parameters = cpp;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509Certificate certificate : chain) {
            certificate.checkValidity();
            certs.add(certificate);
        }
        CertPath cp = CertificateFactory.getInstance("X.509").generateCertPath(certs);
        try {
            CertPathValidatorResult result = this.validator.validate(cp, this.parameters);
            System.out.println(result);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.parameters.getTrustAnchors().toArray(new X509Certificate[0]);
    }
}

