/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;

public class VCardTemp
extends XMPPProcessorAbstract {
    public static final String VCARD_KEY = "vCard";
    private static Logger log = Logger.getLogger(VCardTemp.class.getName());
    private static final String vCard = "vCard";
    private static final String VCARD = "VCARD";
    private static final String XMLNS = "vcard-temp";
    private static final String ID = "vcard-temp";
    private static final String[][] ELEMENTS = new String[][]{{"iq", "vCard"}, {"iq", "VCARD"}};
    private static final String[] XMLNSS = new String[]{"vcard-temp", "vcard-temp"};
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"vcard-temp"})};

    @Override
    public String id() {
        return "vcard-temp";
    }

    @Override
    public void processFromUserOutPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (session.isLocalDomain(packet.getStanzaTo().getDomain(), false)) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID(), "vcard-temp", "vCard", null);
                Packet result = null;
                result = strvCard != null ? this.parseXMLData(strvCard, packet) : packet.okResult((String)null, 1);
                result.setPacketTo(connectionId);
                results.offer(result);
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        } else {
            results.offer(packet.copyElementOnly());
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() != null) {
            try {
                Packet result = null;
                switch (packet.getType()) {
                    case get: {
                        String strvCard = session.getPublicData("vcard-temp", "vCard", null);
                        if (strvCard != null) {
                            result = this.parseXMLData(strvCard, packet);
                            break;
                        }
                        result = packet.okResult((String)null, 1);
                        break;
                    }
                    case set: {
                        Element elvCard = packet.getElement().getChild("vCard");
                        if (elvCard == null) {
                            elvCard = packet.getElement().getChild(VCARD);
                        }
                        if (elvCard != null) {
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("Adding vCard: " + elvCard);
                            }
                            session.setPublicData("vcard-temp", "vCard", elvCard.toString());
                        } else {
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("Removing vCard");
                            }
                            session.removePublicData("vcard-temp", "vCard");
                        }
                        result = packet.okResult((String)null, 0);
                        break;
                    }
                }
                if (result != null) {
                    result.setPacketTo(session.getConnectionId());
                    results.offer(result);
                }
            }
            catch (NoConnectionIdException ex) {
                log.warning("This should not happen, unless this is a vcard result packet sent to the server, which should not happen: " + packet);
            }
            catch (NotAuthorizedException ex) {
                log.warning("Received vCard request but user session is not authorized yet: " + packet);
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
            catch (TigaseDBException ex) {
                log.warning("Database problem, please contact admin: " + ex);
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
            }
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() == StanzaType.get) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID(), "vcard-temp", "vCard", null);
                if (strvCard != null) {
                    results.offer(this.parseXMLData(strvCard, packet));
                } else {
                    results.offer(packet.okResult((String)null, 1));
                }
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        this.processNullSessionPacket(packet, repo, results, settings);
        if (session != null && session.isAuthorized() && packet.getType() != StanzaType.get) {
            try {
                JID conId = session.getConnectionId(packet.getStanzaTo());
                if (conId == null) {
                    return;
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                results.offer(result);
            }
            catch (NoConnectionIdException ex) {
                log.warning("This should not happen, unless this is a vcard result packet sent to the server, which should not happen: " + packet);
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private Packet parseXMLData(String data, Packet packet) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse(domHandler, data.toCharArray(), 0, data.length());
        Queue<Element> elems = domHandler.getParsedElements();
        Packet result = packet.okResult((Element)null, 0);
        result.setPacketFrom(null);
        result.setPacketTo(null);
        for (Element el : elems) {
            result.getElement().addChild(el);
        }
        return result;
    }
}

