/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class StartTLS
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc {
    public static final String EL_NAME = "starttls";
    protected static final String ID = "starttls";
    private static final String[][] ELEMENTS = new String[][]{{"starttls"}, {"proceed"}, {"failure"}};
    private static final Logger log = Logger.getLogger(StartTLS.class.getName());
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-tls";
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-tls", "urn:ietf:params:xml:ns:xmpp-tls", "urn:ietf:params:xml:ns:xmpp-tls"};
    private static final Element[] F_REQUIRED = new Element[]{new Element("starttls", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"})};
    private static final Element[] F_NOT_REQUIRED = new Element[]{new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"})};
    private Element proceed = new Element("proceed", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});
    private Element failure = new Element("failure", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});

    @Override
    public String id() {
        return "starttls";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (packet.isElement("starttls", XMLNS)) {
            if (session.getSessionData("starttls") != null) {
                log.log(Level.WARNING, "Multiple TLS requests, possible DOS attack, closing connection: {0}", packet);
                results.offer(packet.swapFromTo(this.failure, null, null));
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                return;
            }
            session.putSessionData("starttls", "true");
            Packet result = Command.STARTTLS.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId(), Command.DataType.submit);
            Command.setData(result, this.proceed);
            results.offer(result);
        } else {
            log.log(Level.WARNING, "Unknown TLS element: {0}", packet);
            results.offer(packet.swapFromTo(this.failure, null, null));
            results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && session.getSessionData("starttls") == null) {
            VHostItem vhost = session.getDomain();
            if (vhost != null && vhost.isTlsRequired()) {
                return F_REQUIRED;
            }
            return F_NOT_REQUIRED;
        }
        return null;
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        boolean stop = false;
        if (session == null || session.isServerSession()) {
            return stop;
        }
        VHostItem vhost = session.getDomain();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "VHost: {0}", new Object[]{vhost});
        }
        if (vhost != null && vhost.isTlsRequired() && session.getSessionData("starttls") == null && !packet.isElement("starttls", XMLNS)) {
            stop = true;
        }
        return stop;
    }
}

