/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class BindResource
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String DEF_RESOURCE_PREFIX_PROP_KEY = "def-resource-prefix";
    private static final String EL_NAME = "bind";
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_BIND_RESOURCE_PATH};
    private static final Logger log = Logger.getLogger(BindResource.class.getName());
    private static int resGenerator = 0;
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-bind";
    private static final String ID = "urn:ietf:params:xml:ns:xmpp-bind";
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-bind"};
    private static final Element[] FEATURES = new Element[]{new Element("bind", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})};
    private String resourceDefPrefix = "tigase-";

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-bind";
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        if (settings.get(DEF_RESOURCE_PREFIX_PROP_KEY) != null) {
            this.resourceDefPrefix = settings.get(DEF_RESOURCE_PREFIX_PROP_KEY).toString();
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            return;
        }
        Element request = packet.getElement();
        StanzaType type = packet.getType();
        try {
            switch (type) {
                case set: {
                    String resource = request.getChildCDataStaticStr(Iq.IQ_BIND_RESOURCE_PATH);
                    try {
                        if (resource == null || resource.trim().isEmpty()) {
                            resource = this.resourceDefPrefix + ++resGenerator;
                            session.setResource(resource);
                        } else {
                            try {
                                session.setResource(resource);
                            }
                            catch (TigaseStringprepException ex) {
                                log.log(Level.INFO, "Incrrect resource provided by the user: {0}, generating a different one by the server.", resource);
                                resource = this.resourceDefPrefix + ++resGenerator;
                                session.setResource(resource);
                            }
                        }
                    }
                    catch (TigaseStringprepException ex) {
                        log.log(Level.WARNING, "stringprep problem with the server generated resource: {0}", resource);
                    }
                    packet.initVars(session.getJID(), packet.getStanzaTo());
                    results.offer(packet.okResult(new Element("jid", session.getJID().toString()), 1));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bind type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && !session.isResourceSet() && session.isAuthorized()) {
            return FEATURES;
        }
        return null;
    }
}

