/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;

public abstract class RepositoryAccess {
    protected static final String NO_ACCESS_TO_REP_MSG = "Can not access user repository.";
    protected static final String NOT_AUTHORIZED_MSG = "Session has not been yet authorised.";
    private static final String ANONYMOUS_MECH = "ANONYMOUS";
    private static final Logger log = Logger.getLogger("tigase.xmpp.RepositoryAccess");
    protected AuthRepository authRepo = null;
    protected VHostItem domain = null;
    private UserRepository repo = null;
    protected boolean is_anonymous = false;
    protected Authorization authState = Authorization.NOT_AUTHORIZED;

    public RepositoryAccess(UserRepository rep, AuthRepository auth) {
        this.repo = rep;
        this.authRepo = auth;
    }

    public abstract BareJID getBareJID() throws NotAuthorizedException;

    public abstract String getUserName() throws NotAuthorizedException;

    protected abstract void login();

    public void addDataList(String subnode, String key, String[] list) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            this.repo.addDataList(this.getBareJID(), subnode, key, list);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public void addOfflineDataList(String subnode, String key, String[] list) throws NotAuthorizedException, TigaseDBException {
        this.addDataList(this.calcNode("offline", subnode), key, list);
    }

    public void addPublicDataList(String subnode, String key, String[] list) throws NotAuthorizedException, TigaseDBException {
        this.addDataList(this.calcNode("public", subnode), key, list);
    }

    public final Authorization getAuthState() {
        return this.authState;
    }

    public String getAuthenticationToken(String xmpp_sessionId) throws NotAuthorizedException, TigaseDBException {
        UUID token = UUID.randomUUID();
        this.setData("tokens", xmpp_sessionId, token.toString());
        return token.toString();
    }

    public String getData(String subnode, String key, String def) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getData(this.getBareJID(), subnode, key, def);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public String[] getDataGroups(String subnode) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getSubnodes(this.getBareJID(), subnode);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public String[] getDataKeys(String subnode) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getKeys(this.getBareJID(), subnode);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public String[] getDataList(String subnode, String key) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getDataList(this.getBareJID(), subnode, key);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public VHostItem getDomain() {
        return this.domain;
    }

    public JID getDomainAsJID() {
        return this.domain.getVhost();
    }

    public String getOfflineData(String subnode, String key, String def) throws NotAuthorizedException, TigaseDBException {
        return this.getData(this.calcNode("offline", subnode), key, def);
    }

    public String[] getOfflineDataList(String subnode, String key) throws NotAuthorizedException, TigaseDBException {
        return this.getDataList(this.calcNode("offline", subnode), key);
    }

    public String getPublicData(String subnode, String key, String def) throws NotAuthorizedException, TigaseDBException {
        return this.getData(this.calcNode("public", subnode), key, def);
    }

    public String[] getPublicDataList(String subnode, String key) throws NotAuthorizedException, TigaseDBException {
        return this.getDataList(this.calcNode("public", subnode), key);
    }

    public boolean isAnonymous() {
        return this.is_anonymous;
    }

    public boolean isAuthorized() {
        return this.authState == Authorization.AUTHORIZED;
    }

    @Deprecated
    public Authorization loginDigest(BareJID userId, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        this.isLoginAllowed();
        try {
            if (this.authRepo.digestAuth(userId, digest, id, alg)) {
                this.authState = Authorization.AUTHORIZED;
                this.login();
            }
            return this.authState;
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
    }

    @Deprecated
    public Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        this.isLoginAllowed();
        try {
            String mech = (String)props.get("mechanism");
            if (this.domain.isAnonymousEnabled() && mech != null && mech.equals(ANONYMOUS_MECH)) {
                this.is_anonymous = true;
                props.put("user-id", BareJID.bareJIDInstanceNS(UUID.randomUUID().toString(), this.getDomain().getVhost().getDomain()));
                this.authState = Authorization.AUTHORIZED;
                this.login();
            } else if (this.authRepo.otherAuth(props)) {
                this.authState = Authorization.AUTHORIZED;
                this.login();
            }
            return this.authState;
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "User not found: ", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
    }

    @Deprecated
    public Authorization loginPlain(BareJID userId, String password) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        this.isLoginAllowed();
        try {
            if (this.authRepo.plainAuth(userId, password)) {
                this.authState = Authorization.AUTHORIZED;
                this.login();
            }
            return this.authState;
        }
        catch (UserNotFoundException e) {
            log.info("User not found, authorization failed: " + userId);
            throw new NotAuthorizedException("Authorization failed", e);
        }
    }

    @Deprecated
    public Authorization loginToken(BareJID userId, String xmpp_sessionId, String token) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        this.isLoginAllowed();
        try {
            String db_token = this.repo.getData(userId, "tokens", xmpp_sessionId);
            if (token.equals(db_token)) {
                this.authState = Authorization.AUTHORIZED;
                this.login();
                this.repo.removeData(userId, "tokens", xmpp_sessionId);
            }
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        return this.authState;
    }

    public void logout() throws NotAuthorizedException {
        this.authState = Authorization.NOT_AUTHORIZED;
    }

    public void queryAuth(Map<String, Object> authProps) throws TigaseDBException {
        if (this.authRepo == null) {
            log.severe("Authentication repository is not available! Misconfiguration error or authentication database is not available. Please check your logs from the server startup time.");
            return;
        }
        authProps.put("server-name", this.getDomain().getVhost().getDomain());
        this.authRepo.queryAuth(authProps);
        if (this.domain.isAnonymousEnabled() && authProps.get("protocol") == "sasl") {
            String[] auth_mechs = (String[])authProps.get("result");
            if (auth_mechs == null) {
                throw new TigaseDBException("No euthentication mechanisms found, probably DB misconfiguration problem.");
            }
            auth_mechs = Arrays.copyOf(auth_mechs, auth_mechs.length + 1);
            auth_mechs[auth_mechs.length - 1] = ANONYMOUS_MECH;
            authProps.put("result", auth_mechs);
        }
    }

    @Deprecated
    public Authorization register(String name_param, String pass_param, String email_param) throws NotAuthorizedException, TigaseDBException, TigaseStringprepException {
        LinkedHashMap<String, String> reg_params = null;
        if (email_param != null && !email_param.trim().isEmpty()) {
            reg_params = new LinkedHashMap<String, String>();
            reg_params.put("email", email_param);
        }
        return this.register(name_param, pass_param, reg_params);
    }

    public Authorization register(String name_param, String pass_param, Map<String, String> reg_params) throws NotAuthorizedException, TigaseDBException, TigaseStringprepException {
        String user_name = BareJID.parseJID(name_param)[0];
        if (user_name == null || user_name.trim().isEmpty()) {
            user_name = name_param;
        }
        if (this.isAuthorized()) {
            return this.changeRegistration(user_name, pass_param, reg_params);
        }
        if (!this.domain.isRegisterEnabled()) {
            throw new NotAuthorizedException("Registration is now allowed for this domain");
        }
        if (this.domain.getMaxUsersNumber() > 0L) {
            long domainUsers = this.authRepo.getUsersCount(this.domain.getVhost().getDomain());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Current number of users for domain: " + this.domain.getVhost().getDomain() + " is: " + domainUsers);
            }
            if (domainUsers >= this.domain.getMaxUsersNumber()) {
                throw new NotAuthorizedException("Maximum users number for the domain exceeded.");
            }
        }
        if (user_name == null || user_name.equals("") || pass_param == null || pass_param.equals("")) {
            return Authorization.NOT_ACCEPTABLE;
        }
        try {
            this.authRepo.addUser(BareJID.bareJIDInstance(user_name, this.getDomain().getVhost().getDomain()), pass_param);
            if (log.isLoggable(Level.INFO)) {
                log.info("User added: " + BareJID.toString(user_name, this.getDomain().getVhost().getDomain()) + ", pass: " + pass_param);
            }
            this.setRegistration(user_name, pass_param, reg_params);
            if (log.isLoggable(Level.INFO)) {
                log.info("Registration data set for: " + BareJID.toString(user_name, this.getDomain().getVhost().getDomain()) + ", pass: " + pass_param + ", reg_params: " + reg_params);
            }
            return Authorization.AUTHORIZED;
        }
        catch (UserExistsException e) {
            return Authorization.CONFLICT;
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            return Authorization.INTERNAL_SERVER_ERROR;
        }
    }

    public void removeData(String subnode, String key) throws NotAuthorizedException, TigaseDBException {
        try {
            this.repo.removeData(this.getBareJID(), subnode, key);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public void removeDataGroup(String subnode) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            this.repo.removeSubnode(this.getBareJID(), subnode);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public void removeOfflineData(String subnode, String key) throws NotAuthorizedException, TigaseDBException {
        this.removeData(this.calcNode("offline", subnode), key);
    }

    public void removeOfflineDataGroup(String subnode) throws NotAuthorizedException, TigaseDBException {
        this.removeDataGroup(this.calcNode("offline", subnode));
    }

    public void removePublicData(String subnode, String key) throws NotAuthorizedException, TigaseDBException {
        this.removeData(this.calcNode("public", subnode), key);
    }

    public void removePublicDataGroup(String subnode) throws NotAuthorizedException, TigaseDBException {
        this.removeDataGroup(this.calcNode("public", subnode));
    }

    public void setData(String subnode, String key, String value) throws NotAuthorizedException, TigaseDBException {
        try {
            this.repo.setData(this.getBareJID(), subnode, key, value);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public void setDataList(String subnode, String key, String[] list) throws NotAuthorizedException, TigaseDBException {
        if (this.is_anonymous) {
            return;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            this.repo.setDataList(this.getBareJID(), subnode, key, list);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
    }

    public void setDomain(VHostItem domain) throws TigaseStringprepException {
        this.domain = domain;
    }

    public void setOfflineData(String subnode, String key, String value) throws NotAuthorizedException, TigaseDBException {
        this.setData(this.calcNode("offline", subnode), key, value);
    }

    public void setOfflineDataList(String subnode, String key, String[] list) throws NotAuthorizedException, TigaseDBException {
        this.setDataList(this.calcNode("offline", subnode), key, list);
    }

    public void setPublicData(String subnode, String key, String value) throws NotAuthorizedException, TigaseDBException {
        this.setData(this.calcNode("public", subnode), key, value);
    }

    public void setPublicDataList(String subnode, String key, String[] list) throws NotAuthorizedException, TigaseDBException {
        this.setDataList(this.calcNode("public", subnode), key, list);
    }

    public Authorization unregister(String name_param) throws NotAuthorizedException, TigaseDBException, TigaseStringprepException {
        if (!this.isAuthorized()) {
            return Authorization.FORBIDDEN;
        }
        String user_name = BareJID.parseJID(name_param)[0];
        if (user_name == null || user_name.trim().isEmpty()) {
            user_name = name_param;
        }
        if (this.getUserName().equals(user_name)) {
            try {
                this.authRepo.removeUser(BareJID.bareJIDInstance(user_name, this.getDomain().getVhost().getDomain()));
                try {
                    this.repo.removeUser(BareJID.bareJIDInstance(user_name, this.getDomain().getVhost().getDomain()));
                }
                catch (UserNotFoundException ex) {
                    // empty catch block
                }
                this.logout();
                return Authorization.AUTHORIZED;
            }
            catch (UserNotFoundException e) {
                return Authorization.REGISTRATION_REQUIRED;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Repository access exception.", e);
                return Authorization.INTERNAL_SERVER_ERROR;
            }
        }
        return Authorization.FORBIDDEN;
    }

    private String calcNode(String base, String subnode) {
        if (subnode == null) {
            return base;
        }
        return base + "/" + subnode;
    }

    private Authorization changeRegistration(String name_param, String pass_param, Map<String, String> registr_params) throws NotAuthorizedException, TigaseDBException, TigaseStringprepException {
        if (name_param == null || name_param.equals("") || pass_param == null || pass_param.equals("")) {
            return Authorization.BAD_REQUEST;
        }
        if (this.getUserName().equals(name_param)) {
            this.setRegistration(name_param, pass_param, registr_params);
            return Authorization.AUTHORIZED;
        }
        return Authorization.NOT_AUTHORIZED;
    }

    private boolean isLoginAllowed() throws AuthorizationException {
        if (this.isAuthorized()) {
            throw new AuthorizationException("User session already authenticated. Subsequent login is forbidden. You must loggin on a different connection.");
        }
        return true;
    }

    private void setRegistration(String name_param, String pass_param, Map<String, String> registr_params) throws TigaseDBException, TigaseStringprepException {
        try {
            this.authRepo.updatePassword(BareJID.bareJIDInstance(name_param, this.getDomain().getVhost().getDomain()), pass_param);
            if (registr_params != null) {
                for (Map.Entry<String, String> entry : registr_params.entrySet()) {
                    this.repo.setData(BareJID.bareJIDInstance(name_param, this.getDomain().getVhost().getDomain()), entry.getKey(), entry.getValue());
                }
            }
        }
        catch (UserNotFoundException e) {
            log.log(Level.WARNING, "Problem accessing reposiotry: ", e);
        }
    }
}

