/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.conf.Configurable;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.NonAuthUserRepositoryImpl;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.PacketDefaultHandler;
import tigase.server.xmppsession.SMResourceConnection;
import tigase.server.xmppsession.SessionManagerConfig;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.stats.StatisticsList;
import tigase.sys.OnlineJidsReporter;
import tigase.sys.TigaseRuntime;
import tigase.util.ProcessingThreads;
import tigase.util.QueueItem;
import tigase.util.TigaseStringprepException;
import tigase.util.TimerTask;
import tigase.util.WorkerThread;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.PresenceCapabilitiesManager;

public class SessionManager
extends AbstractMessageReceiver
implements Configurable,
SessionManagerHandler,
OnlineJidsReporter {
    protected static final String ADMIN_COMMAND_NODE = "http://jabber.org/protocol/admin";
    private static final Logger log = Logger.getLogger(SessionManager.class.getName());
    private AuthRepository auth_repository = null;
    private long authTimeouts = 0L;
    private long closedConnections = 0L;
    private DefaultHandlerProc defHandlerProc = null;
    private PacketDefaultHandler defPacketHandler = null;
    private String defPluginsThreadsPool = "default-threads-pool";
    private boolean forceDetailStaleConnectionCheck = true;
    private int maxIdx = 100;
    private int maxUserConnections = 0;
    private int maxUserSessions = 0;
    private NonAuthUserRepository naUserRepository = null;
    private SessionCloseProc sessionCloseProc = null;
    private SessionOpenProc sessionOpenProc = null;
    private SMResourceConnection smResourceConnection = null;
    private int tIdx = 0;
    private long totalUserConnections = 0L;
    private long totalUserSessions = 0L;
    private UserRepository user_repository = null;
    private Set<String> trusted = new ConcurrentSkipListSet<String>();
    private Map<String, XMPPStopListenerIfc> stopListeners = new ConcurrentHashMap<String, XMPPStopListenerIfc>(10);
    private boolean skipPrivacy = false;
    private ConcurrentHashMap<BareJID, XMPPSession> sessionsByNodeId = new ConcurrentHashMap(100000);
    private Set<XMPPImplIfc> allPlugins = new ConcurrentSkipListSet<XMPPImplIfc>();
    private Map<String, ProcessingThreads<ProcessorWorkerThread>> workerThreads = new ConcurrentHashMap<String, ProcessingThreads<ProcessorWorkerThread>>(32);
    private StaleConnectionCloser staleConnectionCloser = new StaleConnectionCloser();
    private Map<String, XMPPProcessorIfc> processors = new ConcurrentHashMap<String, XMPPProcessorIfc>(32);
    private Map<String, XMPPPreprocessorIfc> preProcessors = new ConcurrentHashMap<String, XMPPPreprocessorIfc>(10);
    private Map<String, long[]> postTimes = new ConcurrentSkipListMap<String, long[]>();
    private Map<String, XMPPPostprocessorIfc> postProcessors = new ConcurrentHashMap<String, XMPPPostprocessorIfc>(10);
    private Map<String, Map<String, Object>> plugin_config = new ConcurrentHashMap<String, Map<String, Object>>(20);
    private Map<String, XMPPPacketFilterIfc> outFilters = new ConcurrentHashMap<String, XMPPPacketFilterIfc>(10);
    private ConnectionCheckCommandHandler connectionCheckCommandHandler = new ConnectionCheckCommandHandler();
    protected ConcurrentHashMap<JID, XMPPResourceConnection> connectionsByFrom = new ConcurrentHashMap(100000);

    @Override
    public boolean addOutPacket(Packet packet) {
        if (packet.getPacketFrom() == null) {
            packet.setPacketFrom(this.getComponentId());
        }
        return super.addOutPacket(packet);
    }

    public XMPPImplIfc addPlugin(String plug_id, Integer conc) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        XMPPPacketFilterIfc filterproc;
        XMPPStopListenerIfc stoplist;
        XMPPPostprocessorIfc postproc;
        XMPPPreprocessorIfc preproc;
        XMPPImplIfc result = null;
        XMPPProcessorIfc proc = null;
        if (plug_id.equals("session-open")) {
            this.sessionOpenProc = new SessionOpenProc();
            proc = this.sessionOpenProc;
        }
        if (plug_id.equals("session-close")) {
            this.sessionCloseProc = new SessionCloseProc();
            proc = this.sessionCloseProc;
        }
        if (plug_id.equals("default-handler")) {
            this.defHandlerProc = new DefaultHandlerProc();
            proc = this.defHandlerProc;
        }
        if (proc == null) {
            proc = SessionManagerConfig.getProcessor(plug_id);
        }
        boolean loaded = false;
        if (proc != null) {
            int concurrency = conc != null ? conc : (proc != null ? proc.concurrentQueuesNo() : 0);
            System.out.println("Loading plugin: " + plug_id + "=" + concurrency + " ...");
            if (this.workerThreads.get(this.defPluginsThreadsPool) == null || conc != null) {
                ProcessorWorkerThread worker = new ProcessorWorkerThread();
                ProcessingThreads<ProcessorWorkerThread> pt = new ProcessingThreads<ProcessorWorkerThread>(worker, concurrency, this.maxInQueueSize, proc.id());
                this.workerThreads.put(proc.id(), pt);
                log.log(Level.CONFIG, "Created thread pool: {0}, queue: {1} for plugin id: {2}", new Object[]{concurrency, this.maxInQueueSize, proc.id()});
            }
            this.processors.put(proc.id(), proc);
            log.log(Level.CONFIG, "Added processor: {0} for plugin id: {1}", new Object[]{proc.getClass().getSimpleName(), proc.id()});
            loaded = true;
            result = proc;
        }
        if ((preproc = SessionManagerConfig.getPreprocessor(plug_id)) != null) {
            this.preProcessors.put(plug_id, preproc);
            log.log(Level.CONFIG, "Added preprocessor: {0} for plugin id: {1}", new Object[]{preproc.getClass().getSimpleName(), plug_id});
            loaded = true;
            result = preproc;
        }
        if ((postproc = SessionManagerConfig.getPostprocessor(plug_id)) != null) {
            this.postProcessors.put(plug_id, postproc);
            log.log(Level.CONFIG, "Added postprocessor: {0} for plugin id: {1}", new Object[]{postproc.getClass().getSimpleName(), plug_id});
            loaded = true;
            result = postproc;
        }
        if ((stoplist = SessionManagerConfig.getStopListener(plug_id)) != null) {
            this.stopListeners.put(plug_id, stoplist);
            log.log(Level.CONFIG, "Added stopped processor: {0} for plugin id: {1}", new Object[]{stoplist.getClass().getSimpleName(), plug_id});
            loaded = true;
            result = stoplist;
        }
        if ((filterproc = SessionManagerConfig.getPacketFilter(plug_id)) != null) {
            this.outFilters.put(plug_id, filterproc);
            log.log(Level.CONFIG, "Added packet filter: {0} for plugin id: {1}", new Object[]{filterproc.getClass().getSimpleName(), plug_id});
            loaded = true;
            result = filterproc;
        }
        if (!loaded) {
            log.log(Level.WARNING, "No implementation found for plugin id: {0}", plug_id);
        }
        if (result != null) {
            this.allPlugins.add(result);
            if (result instanceof PresenceCapabilitiesManager.PresenceCapabilitiesListener) {
                PresenceCapabilitiesManager.registerPresenceHandler((PresenceCapabilitiesManager.PresenceCapabilitiesListener)((Object)result));
            }
        }
        return result;
    }

    @Override
    public boolean containsJid(BareJID jid) {
        return this.sessionsByNodeId.containsKey(jid);
    }

    @Override
    public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "handleLogin called for: {0}, conn_id: {1}", new Object[]{userId, conn});
        }
        this.registerNewSession(userId, conn);
    }

    @Override
    public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session != null && session.getActiveResourcesSize() <= 1) {
            this.sessionsByNodeId.remove(userId);
        }
        try {
            this.connectionsByFrom.remove(conn.getConnectionId());
            Packet cmd = Command.CLOSE.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId());
            String error = (String)conn.getSessionData("error-key");
            if (error != null) {
                Element err_el = new Element(error);
                err_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                cmd.getElement().getChild("command").addChild(err_el);
            }
            this.fastAddOutPacket(cmd);
        }
        catch (NoConnectionIdException ex) {
            log.log(Level.WARNING, "Connection ID not set for session: {0}", conn);
        }
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        if (!conn.isServerSession() && !"USER_STATUS".equals(conn.getSessionId())) {
            try {
                Packet user_login_cmd = Command.USER_LOGIN.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId(), Command.DataType.submit);
                Command.addFieldValue(user_login_cmd, "user-jid", conn.getjid().toString());
                this.addOutPacket(user_login_cmd);
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
            }
        }
    }

    @Override
    public boolean handlesLocalDomains() {
        return true;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("authRepository", (Object)this.auth_repository);
        binds.put("userConnections", (Object)this.connectionsByFrom);
        binds.put("userRepository", (Object)this.user_repository);
        binds.put("userSessions", (Object)this.sessionsByNodeId);
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 8;
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 8;
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Received packet: {0}", packet.toStringSecure());
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (conn == null && this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet)) {
            return;
        }
        this.processPacket(packet, conn);
    }

    public void removePlugin(String plug_id) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing plugin {0}", plug_id);
        }
        XMPPImplIfc p = null;
        ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.remove(plug_id);
        if (pt != null) {
            p = this.processors.remove(plug_id);
            pt.shutdown();
            if (p != null) {
                this.allPlugins.remove(p);
            }
        }
        if (this.preProcessors.get(plug_id) != null) {
            p = this.preProcessors.remove(plug_id);
            this.allPlugins.remove(p);
        }
        if (this.postProcessors.get(plug_id) != null) {
            p = this.postProcessors.remove(plug_id);
            this.allPlugins.remove(p);
        }
        if (this.stopListeners.get(plug_id) != null) {
            p = this.stopListeners.remove(plug_id);
            this.allPlugins.remove(p);
        }
        if (p != null && p instanceof PresenceCapabilitiesManager.PresenceCapabilitiesListener) {
            PresenceCapabilitiesManager.unregisterPresenceHandler((PresenceCapabilitiesManager.PresenceCapabilitiesListener)((Object)p));
        }
    }

    public boolean skipPrivacy() {
        return this.skipPrivacy;
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        XMPPSession session;
        if (this.skipPrivacy() && (session = this.sessionsByNodeId.get(jid)) != null) {
            return session.getConnectionIds();
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        SessionManagerConfig.getDefaults(props, params);
        props.put("force-detail-stale-connection-check", true);
        props.put("stale-connection-closer-queue-size", 1000);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "sm";
    }

    @Override
    public String getDiscoDescription() {
        return "Session manager";
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        LinkedList<Element> features = new LinkedList<Element>();
        List<Element> tmp = super.getDiscoFeatures(from);
        if (tmp != null) {
            features.addAll(tmp);
        }
        for (XMPPProcessorIfc proc_t : this.processors.values()) {
            Element[] discoFeatures = proc_t.supDiscoFeatures(null);
            if (discoFeatures == null) continue;
            features.addAll(Arrays.asList(discoFeatures));
        }
        return features;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && (this.getName().equals(jid.getLocalpart()) || this.isLocalDomain(jid.toString()))) {
            Element query = super.getDiscoInfo(node, jid, from);
            if (query == null) {
                query = new Element("query");
                query.setXMLNS("http://jabber.org/protocol/disco#info");
            }
            if (node == null) {
                for (XMPPProcessorIfc proc_t : this.processors.values()) {
                    Element[] discoFeatures = proc_t.supDiscoFeatures(null);
                    if (discoFeatures == null) continue;
                    query.addChildren(Arrays.asList(discoFeatures));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Found disco info: {0}", query != null ? query.toString() : null);
            }
            return query;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Not found disco info for node: {0}, jid: {1}", new Object[]{node, jid});
        }
        return null;
    }

    public XMPPResourceConnection getResourceConnection(JID jid) {
        XMPPSession session = this.getSession(jid.getBareJID());
        if (session != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Session not null, searching session for jid: {0}", jid);
            }
            XMPPResourceConnection res = session.getResourceConnection(jid);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Found session: {0}, for jid: {1}", new Object[]{res, jid});
            }
            return res;
        }
        if (this.isLocalDomain(jid.toString(), false)) {
            return this.smResourceConnection;
        }
        return null;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Registered accounts", this.user_repository.getUsersCount(), Level.FINEST);
        }
        list.add(this.getName(), "Open user connections", this.connectionsByFrom.size(), Level.INFO);
        list.add(this.getName(), "Maximum user connections", this.maxUserConnections, Level.INFO);
        list.add(this.getName(), "Total user connections", this.totalUserConnections, Level.FINER);
        list.add(this.getName(), "Closed user connections", this.closedConnections, Level.FINER);
        list.add(this.getName(), "Open user sessions", this.sessionsByNodeId.size(), Level.INFO);
        list.add(this.getName(), "Maximum user sessions", this.maxUserSessions, Level.FINE);
        list.add(this.getName(), "Total user sessions", this.totalUserSessions, Level.FINER);
        list.add(this.getName(), "Authentication timouts", this.authTimeouts, Level.INFO);
        if (list.checkLevel(Level.INFO)) {
            int totalQueuesWait = list.getValue(this.getName(), "Total queues wait", 0);
            long totalQueuesOverflow = list.getValue(this.getName(), "Total queues overflow", 0L);
            for (Map.Entry<String, ProcessingThreads<ProcessorWorkerThread>> procent : this.workerThreads.entrySet()) {
                ProcessingThreads<ProcessorWorkerThread> proc = procent.getValue();
                totalQueuesWait += proc.getTotalQueueSize();
                totalQueuesOverflow += proc.getDroppedPackets();
                if (!list.checkLevel(Level.INFO, (long)proc.getTotalQueueSize() + proc.getDroppedPackets())) continue;
                list.add(this.getName(), "Processor: " + procent.getKey(), ", Queue: " + proc.getTotalQueueSize() + ", AvTime: " + proc.getAverageProcessingTime() + ", Runs: " + proc.getTotalRuns() + ", Lost: " + proc.getDroppedPackets(), Level.INFO);
            }
            list.add(this.getName(), "Total queues wait", totalQueuesWait, Level.INFO);
            list.add(this.getName(), "Total queues overflow", totalQueuesOverflow, Level.INFO);
        }
        if (list.checkLevel(Level.FINE)) {
            Iterator<Map.Entry<String, long[]>> i$ = this.postTimes.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, long[]> tmEntry;
                Map.Entry<String, long[]> entry = tmEntry = i$.next();
                list.add(this.getName(), "Average " + tmEntry.getKey() + " on last " + entry.getValue().length + " runs [ms]", this.calcAverage(entry.getValue()), Level.FINE);
            }
        }
        for (XMPPImplIfc plugin : this.allPlugins) {
            plugin.getStatistics(list);
        }
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return true;
    }

    @Override
    public boolean isLocalDomain(String domain, boolean includeComponents) {
        if (includeComponents) {
            return this.isLocalDomainOrComponent(domain);
        }
        return this.isLocalDomain(domain);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        TigaseRuntime.getTigaseRuntime().addOnlineJidsReporter(this);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String res_uri;
        String[] trusted_tmp;
        super.setProperties(props);
        if (props.get("skip-privacy") != null) {
            this.skipPrivacy = (Boolean)props.get("skip-privacy");
        }
        if (props.get("trusted") != null && (trusted_tmp = (String[])props.get("trusted")) != null) {
            for (String trust : trusted_tmp) {
                this.trusted.add(trust);
            }
        }
        if (props.get("force-detail-stale-connection-check") != null) {
            this.forceDetailStaleConnectionCheck = (Boolean)props.get("force-detail-stale-connection-check");
            log.log(Level.CONFIG, "forced detailed stale connection checking is set to = {0}", this.forceDetailStaleConnectionCheck);
        }
        if (props.get("stale-connection-closer-queue-size") != null) {
            this.staleConnectionCloser.setMaxQueueSize((Integer)props.get("stale-connection-closer-queue-size"));
            log.log(Level.CONFIG, "stale connection closer queue is set to = {0}", this.staleConnectionCloser.getMaxQueueSize());
        }
        if (!this.staleConnectionCloser.isScheduled()) {
            this.addTimerTask(this.staleConnectionCloser, this.staleConnectionCloser.getTimeout());
        }
        if (props.size() == 1) {
            return;
        }
        this.defPacketHandler = new PacketDefaultHandler();
        this.user_repository = (UserRepository)props.get("shared-user-repo");
        if (this.user_repository != null) {
            log.log(Level.CONFIG, "Using shared repository instance: {0}", this.user_repository.getClass().getName());
        } else {
            LinkedHashMap<String, String> user_repo_params = new LinkedHashMap<String, String>(10);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String[] nodes;
                if (!entry.getKey().startsWith("user-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
                user_repo_params.put(nodes[1], entry.getValue().toString());
            }
            try {
                res_uri = (String)props.get("user-repo-url");
                this.user_repository = RepositoryFactory.getUserRepository(null, res_uri, user_repo_params);
                log.log(Level.CONFIG, "Initialized {0} as user repository: {1}", new Object[]{null, res_uri});
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize user repository: ", e);
            }
        }
        this.auth_repository = (AuthRepository)props.get("shared-auth-repo");
        if (this.auth_repository != null) {
            log.log(Level.CONFIG, "Using shared auth repository instance: {0}", this.auth_repository.getClass().getName());
        } else {
            LinkedHashMap<String, String> auth_repo_params = new LinkedHashMap<String, String>(10);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String[] nodes;
                if (!entry.getKey().startsWith("auth-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
                auth_repo_params.put(nodes[1], entry.getValue().toString());
            }
            try {
                res_uri = (String)props.get("auth-repo-url");
                this.auth_repository = RepositoryFactory.getAuthRepository(null, res_uri, auth_repo_params);
                log.log(Level.CONFIG, "Initialized {0} as auth repository: {1}", new Object[]{null, res_uri});
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize auth repository: ", e);
            }
        }
        this.naUserRepository = new NonAuthUserRepositoryImpl(this.user_repository, this.getDefHostName(), Boolean.parseBoolean((String)props.get("offline-user-autocreate")));
        if (this.isInitializationComplete()) {
            return;
        }
        LinkedHashMap<String, Integer> plugins_concurrency = new LinkedHashMap<String, Integer>(20);
        Object[] plugins_conc = ((String)props.get("plugins-concurrency")).split(",");
        log.log(Level.CONFIG, "Loading concurrency plugins list: {0}", Arrays.toString(plugins_conc));
        if (plugins_conc != null && plugins_conc.length > 0) {
            for (Object plugc : plugins_conc) {
                log.log(Level.CONFIG, "Loading: {0}", plugc);
                if (((String)plugc).trim().isEmpty()) continue;
                String[] pc = ((String)plugc).split("=");
                try {
                    int conc = Integer.parseInt(pc[1]);
                    plugins_concurrency.put(pc[0], conc);
                    log.log(Level.CONFIG, "Concurrency for plugin: {0} set to: {1}", new Object[]{pc[0], conc});
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Plugin concurrency parsing error for: " + (String)plugc + ", ", e);
                }
            }
        }
        HashSet<String> keys = new HashSet<String>(this.processors.keySet());
        try {
            String sm_threads_pool = (String)props.get("sm-threads-pool");
            if (!sm_threads_pool.equals("default")) {
                String[] threads_pool_params = sm_threads_pool.split(":");
                int def_pool_size = 100;
                if (threads_pool_params.length > 1) {
                    try {
                        def_pool_size = Integer.parseInt(threads_pool_params[1]);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Incorrect threads pool size: {0}, setting default to 100", threads_pool_params[1]);
                        def_pool_size = 100;
                    }
                }
                ProcessorWorkerThread worker = new ProcessorWorkerThread();
                ProcessingThreads<ProcessorWorkerThread> pt = new ProcessingThreads<ProcessorWorkerThread>(worker, def_pool_size, this.maxInQueueSize, this.defPluginsThreadsPool);
                this.workerThreads.put(this.defPluginsThreadsPool, pt);
                log.log(Level.CONFIG, "Created a default thread pool: {0}", def_pool_size);
            }
            Object[] plugins = SessionManagerConfig.getActivePlugins(props);
            log.log(Level.CONFIG, "Loaded plugins list: {0}", Arrays.toString(plugins));
            for (Object plug_id : plugins) {
                keys.remove(plug_id);
                log.log(Level.CONFIG, "Loading and configuring plugin: {0}", plug_id);
                XMPPImplIfc plugin = this.addPlugin((String)plug_id, (Integer)plugins_concurrency.get(plug_id));
                if (plugin == null) continue;
                Map<String, Object> plugin_settings = this.getPluginSettings((String)plug_id, props);
                if (plugin_settings.size() > 0) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.log(Level.CONFIG, "Plugin configuration: {0}", plugin_settings);
                    }
                    this.plugin_config.put((String)plug_id, plugin_settings);
                }
                try {
                    plugin.init(plugin_settings);
                }
                catch (TigaseDBException ex) {
                    log.log(Level.SEVERE, "Problem initializing plugin: " + plugin.id(), ex);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem with component initialization: " + this.getName(), e);
        }
        for (String key : keys) {
            this.removePlugin(key);
        }
        this.smResourceConnection = new SMResourceConnection(null, this.user_repository, this.auth_repository, this);
        this.registerNewSession(this.getComponentId().getBareJID(), this.smResourceConnection);
    }

    protected void addOutPackets(Packet packet, XMPPResourceConnection conn, Queue<Packet> results) {
        for (XMPPPacketFilterIfc outfilter : this.outFilters.values()) {
            outfilter.filter(packet, conn, this.naUserRepository, results);
        }
        this.addOutPackets(results);
    }

    protected boolean addTrusted(JID jid) {
        return this.trusted.add(jid.getBareJID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(JID connectionId, String userId, boolean closeOnly) {
        XMPPResourceConnection connection;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream closed from: {0}", connectionId);
        }
        if ((connection = this.connectionsByFrom.remove(connectionId)) != null) {
            XMPPResourceConnection xMPPResourceConnection = connection;
            synchronized (xMPPResourceConnection) {
                connection.putSessionData("closing-conn", "closing-conn");
                this.closeSession(connection, closeOnly);
            }
        } else {
            log.log(Level.FINE, "Can not find resource connection for connectionId: {0}", connectionId);
            if (userId != null) {
                log.log(Level.WARNING, "Found trying to find stale XMPPResourceConnection by userId {0}...", userId);
                JID userJid = JID.jidInstanceNS(userId);
                XMPPSession sessionByUserId = this.sessionsByNodeId.get(userJid.getBareJID());
                if (sessionByUserId != null && (connection = sessionByUserId.getResourceForConnectionId(connectionId)) != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.WARNING, "Found stale XMPPResourceConnection {0} by userId {1}, removing...", new Object[]{connection, userId});
                    }
                    sessionByUserId.removeResourceConnection(connection);
                }
                return;
            }
            if (!this.forceDetailStaleConnectionCheck) {
                return;
            }
            this.staleConnectionCloser.queueForClose(connectionId);
        }
    }

    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (!closeOnly) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>(50);
            for (XMPPStopListenerIfc stopProc : this.stopListeners.values()) {
                stopProc.stopped(conn, results, this.plugin_config.get(stopProc.id()));
            }
            this.addOutPackets(null, conn, results);
        }
        try {
            if (conn.isAuthorized()) {
                XMPPSession session;
                JID userJid = conn.getJID();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Closing connection for: {0}", userJid);
                }
                if ((session = conn.getParentSession()) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Found parent session for: {0}", userJid);
                    }
                    if (session.getActiveResourcesSize() <= 1) {
                        session = this.sessionsByNodeId.remove(userJid.getBareJID());
                        if (session == null) {
                            log.log(Level.INFO, "UPS can't remove, session not found in map: {0}", userJid);
                        } else if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "Number of user sessions: {0}", this.sessionsByNodeId.size());
                        }
                        this.auth_repository.logout(userJid.getBareJID());
                    } else if (log.isLoggable(Level.FINER)) {
                        StringBuilder sb = new StringBuilder(100);
                        for (XMPPResourceConnection res_con : session.getActiveResources()) {
                            sb.append(", res=").append(res_con.getResource());
                        }
                        log.log(Level.FINER, "Number of connections is {0} for the user: {1}{2}", new Object[]{session.getActiveResourcesSize(), userJid, sb.toString()});
                    }
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.log(Level.INFO, "Closed not authorized session: {0}", e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception closing session... ", e);
        }
        ++this.closedConnections;
        conn.streamClosed();
    }

    protected XMPPResourceConnection createUserSession(JID conn_id, String domain) throws TigaseStringprepException {
        XMPPResourceConnection connection = new XMPPResourceConnection(conn_id, this.user_repository, this.auth_repository, this);
        VHostItem vitem = null;
        if (domain != null) {
            vitem = this.getVHostItem(domain);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting hostname {0} for connection: {1}, VHostItem: {2}", new Object[]{domain, conn_id, vitem});
            }
        }
        if (vitem == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Can't get VHostItem for domain: {0}, using default one instead: {1}", new Object[]{domain, this.getDefHostName()});
            }
            vitem = new VHostItem(this.getDefHostName().getDomain());
        }
        connection.setDomain(vitem.getUnmodifiableVHostItem());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Domain set for connectionId {0}", conn_id);
        }
        this.connectionsByFrom.put(conn_id, connection);
        int currSize = this.connectionsByFrom.size();
        if (currSize > this.maxUserConnections) {
            this.maxUserConnections = currSize;
        }
        ++this.totalUserConnections;
        return connection;
    }

    protected boolean delTrusted(JID jid) {
        return this.trusted.remove(jid.getBareJID().toString());
    }

    protected boolean fastAddOutPacket(Packet packet) {
        return this.addOutPacket(packet);
    }

    protected XMPPResourceConnection loginUserSession(JID conn_id, String domain, BareJID user_id, String resource, String xmpp_sessionId) {
        try {
            XMPPResourceConnection conn = this.createUserSession(conn_id, domain);
            conn.setSessionId(xmpp_sessionId);
            this.user_repository.setData(user_id, "tokens", xmpp_sessionId, conn_id.toString());
            Authorization auth = conn.loginToken(user_id, xmpp_sessionId, conn_id.toString());
            if (auth == Authorization.AUTHORIZED) {
                this.handleLogin(user_id, conn);
                if (resource != null) {
                    conn.setResource(resource);
                }
            } else {
                this.connectionsByFrom.remove(conn_id);
                return null;
            }
            return conn;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem logging user: " + user_id + "/" + resource, ex);
            return null;
        }
    }

    protected boolean processAdminsOrDomains(Packet packet) {
        if (packet.getStanzaFrom() == null && packet.getPacketFrom() != null) {
            return false;
        }
        JID to = packet.getStanzaTo();
        if (to != null && this.isLocalDomain(to.toString())) {
            if (packet.getElemName() == "message") {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Packet for admin: {0}", packet);
                }
                this.sendToAdmins(packet);
                packet.processedBy("admins-or-domains");
                return true;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Packet for hostname, should be handled elsewhere: {0}", packet);
            }
        }
        return false;
    }

    protected boolean processCommand(Packet pc) {
        if (pc.getStanzaTo() == null || !this.getComponentId().equals(pc.getStanzaTo()) && !this.isLocalDomain(pc.getStanzaTo().toString())) {
            return false;
        }
        Iq iqc = (Iq)pc;
        boolean processing_result = false;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0} command from: {1}", new Object[]{iqc.getCommand().toString(), iqc.getFrom()});
        }
        XMPPResourceConnection connection = this.connectionsByFrom.get(iqc.getFrom());
        switch (iqc.getCommand()) {
            case CLOSE: {
                log.log(Level.WARNING, "Unexpected packet: {0}", pc);
                processing_result = true;
                break;
            }
            case STREAM_OPENED: {
                ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.get(this.sessionOpenProc.id());
                if (pt == null) {
                    pt = this.workerThreads.get(this.defPluginsThreadsPool);
                }
                pt.addItem(this.sessionOpenProc, iqc, connection);
                processing_result = true;
                break;
            }
            case GETFEATURES: {
                if (iqc.getType() == StanzaType.get) {
                    List<Element> features = this.getFeatures(this.connectionsByFrom.get(iqc.getFrom()));
                    Packet result = iqc.commandResult(null);
                    Command.setData(result, features);
                    this.addOutPacket(result);
                }
                processing_result = true;
                break;
            }
            case STREAM_CLOSED: {
                this.fastAddOutPacket(iqc.okResult((String)null, 0));
                ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.get(this.sessionCloseProc.id());
                if (pt == null) {
                    pt = this.workerThreads.get(this.defPluginsThreadsPool);
                }
                pt.addItem(this.sessionCloseProc, iqc, connection);
                processing_result = true;
                break;
            }
            case STREAM_CLOSED_UPDATE: {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} processing comment, connection: {1}", new Object[]{iqc.getCommand(), connection != null ? connection : " is null"});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} adding to the processor: {1}", new Object[]{iqc.getCommand(), connection != null ? connection : " is null"});
                }
                if (connection == null) {
                    JID stanzaFrom = iqc.getStanzaFrom();
                    if (stanzaFrom == null) {
                        log.log(Level.WARNING, "Stream close update without an user JID: {0}", iqc);
                    } else {
                        XMPPSession xs = this.sessionsByNodeId.get(stanzaFrom.getBareJID());
                        if (xs == null) {
                            log.log(Level.INFO, "Stream close for the user session which does not exist: {0}", iqc);
                        } else {
                            XMPPResourceConnection xcr = xs.getResourceForConnectionId(iqc.getPacketFrom());
                            if (xcr == null) {
                                log.log(Level.INFO, "Stream close for the resource connection which does not exist", iqc);
                            } else {
                                xs.removeResourceConnection(xcr);
                                if (log.isLoggable(Level.FINEST)) {
                                    log.log(Level.FINEST, "{0} removed resource connection: {1}", new Object[]{iqc.getCommand(), xcr});
                                }
                            }
                        }
                    }
                } else {
                    ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.get(this.sessionCloseProc.id());
                    if (pt == null) {
                        pt = this.workerThreads.get(this.defPluginsThreadsPool);
                    }
                    pt.addItem(this.sessionCloseProc, iqc, connection);
                }
                processing_result = true;
                break;
            }
            case USER_STATUS: {
                try {
                    if (this.isTrusted(iqc.getStanzaFrom()) || this.isTrusted(iqc.getStanzaFrom().getDomain())) {
                        boolean available;
                        String av = Command.getFieldValue(pc, "available");
                        boolean bl = available = av == null || !av.equalsIgnoreCase("false");
                        if (available) {
                            Packet presence = null;
                            Element p = iqc.getElement().getChild("command").getChild("presence");
                            if (p != null) {
                                Element elem = p.clone();
                                elem.setXMLNS("jabber:client");
                                presence = Packet.packetInstance(elem);
                            }
                            if ((connection = this.connectionsByFrom.get(iqc.getStanzaFrom())) == null) {
                                JID user_jid = JID.jidInstance(Command.getFieldValue(iqc, "jid"));
                                connection = this.loginUserSession(iqc.getStanzaFrom(), user_jid.getDomain(), user_jid.getBareJID(), user_jid.getResource(), "USER_STATUS");
                                connection.putSessionData("jingle", "active");
                                this.fastAddOutPacket(iqc.okResult((String)null, 0));
                                if (presence == null) {
                                    presence = Packet.packetInstance(new Element("presence", new Element[]{new Element("priority", "-1"), new Element("c", new String[]{"node", "ver", "ext", "xmlns"}, new String[]{"http://www.google.com/xmpp/client/caps", XMPPServer.getImplementationVersion(), "voice-v1", "http://jabber.org/protocol/caps"})}, null, null));
                                }
                            } else if (log.isLoggable(Level.FINEST)) {
                                log.finest("USER_STATUS set to true for user who is already available: " + iqc.toStringSecure());
                            }
                            if (presence != null) {
                                presence.setPacketFrom(iqc.getStanzaFrom());
                                presence.setPacketTo(this.getComponentId());
                                this.addOutPacket(presence);
                            }
                        } else {
                            connection = this.connectionsByFrom.remove(iqc.getStanzaFrom());
                            if (connection != null) {
                                this.closeSession(connection, false);
                                this.addOutPacket(iqc.okResult((String)null, 0));
                            } else {
                                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "The user resource you want to remove does not exist.", true));
                                log.info("Can not find resource connection for packet: " + iqc.toStringSecure());
                            }
                        }
                    } else {
                        try {
                            this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(iqc, "Only trusted entity can do it.", true));
                        }
                        catch (PacketErrorTypeException e) {
                            log.warning("Packet error type when not expected: " + iqc.toStringSecure());
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        this.addOutPacket(Authorization.UNDEFINED_CONDITION.getResponseMessage(iqc, "Unexpected error occured during the request: " + e, true));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    log.log(Level.WARNING, "USER_STATUS session creation error: ", e);
                }
                processing_result = true;
                break;
            }
            case OTHER: {
                if (!this.getComponentId().equals(iqc.getStanzaTo()) || !this.getComponentId().equals(iqc.getPacketFrom())) break;
                try {
                    this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(iqc, "There is no implementation for such command on the server.", true));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                log.log(Level.WARNING, "There is no implementation for such command on the server: " + iqc);
                processing_result = true;
                break;
            }
            case CLIENT_AUTH: {
                if (connection == null) break;
                String[] jids = Command.getFieldValues(pc, "jids");
                connection.putSessionData("SASL_EXTERNAL_ALLOWED", Boolean.TRUE);
                connection.putSessionData("SESSION_AUTH_JIDS_KEY", jids);
                processing_result = true;
                break;
            }
            default: {
                if (!this.getComponentId().equals(iqc.getStanzaTo()) || !this.getComponentId().equals(iqc.getPacketFrom())) break;
                try {
                    this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(iqc, "There is no implementation for such command on the server.", true));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                log.log(Level.WARNING, "There is no implementation for such command on the server: " + iqc);
                processing_result = true;
            }
        }
        return processing_result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPacket(Packet packet, XMPPResourceConnection conn) {
        long startTime = System.currentTimeMillis();
        int idx = this.tIdx;
        this.tIdx = (this.tIdx + 1) % this.maxIdx;
        packet.setPacketTo(this.getComponentId());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "processing packet: {0}, connection: {1}", new Object[]{packet.toStringSecure(), conn});
        }
        ArrayDeque<Packet> results = new ArrayDeque<Packet>(2);
        boolean stop = false;
        if (!stop && this.defPacketHandler.preprocess(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet preprocessed: {0}", packet.toStringSecure());
                if (results.size() > 0) {
                    for (Packet p : results) {
                        log.log(Level.FINEST, "Preprocess result: {0}", p.toStringSecure());
                    }
                }
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            for (XMPPPreprocessorIfc preproc : this.preProcessors.values()) {
                if (!(stop |= preproc.preProcess(packet, conn, this.naUserRepository, results, this.plugin_config.get(preproc.id()))) || !log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Packet blocked by: {0}, packet{1}", new Object[]{preproc.id(), packet});
                break;
            }
        }
        if (!stop && this.defPacketHandler.forward(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet forwarded: {0}", packet);
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            this.walk(packet, conn);
        }
        if (!stop) {
            for (XMPPPostprocessorIfc postproc : this.postProcessors.values()) {
                String plug_id = postproc.id();
                long[] postProcTime = null;
                Map<String, long[]> map = this.postTimes;
                synchronized (map) {
                    postProcTime = this.postTimes.get(plug_id);
                    if (postProcTime == null) {
                        postProcTime = new long[this.maxIdx];
                        this.postTimes.put(plug_id, postProcTime);
                    }
                }
                long stTime = System.currentTimeMillis();
                postproc.postProcess(packet, conn, this.naUserRepository, results, this.plugin_config.get(postproc.id()));
                postProcTime[idx] = System.currentTimeMillis() - stTime;
            }
        }
        if (!(stop || packet.wasProcessed() || packet.getStanzaTo() != null && this.isLocalDomain(packet.getStanzaTo().toString()) || !this.defPacketHandler.canHandle(packet, conn))) {
            ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.get(this.defHandlerProc.id());
            if (pt == null) {
                pt = this.workerThreads.get(this.defPluginsThreadsPool);
            }
            pt.addItem(this.defHandlerProc, packet, conn);
            packet.processedBy(this.defHandlerProc.id());
        }
        this.setPermissions(conn, results);
        this.addOutPackets(packet, conn, results);
        if (packet.wasProcessed() || this.processAdminsOrDomains(packet)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet processed by: {0}", packet.getProcessorsIds().toString());
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet not processed: {0}", packet.toStringSecure());
            }
            Packet error = null;
            if (stop || conn == null && packet.getStanzaFrom() != null && packet.getStanzaTo() != null && !packet.getStanzaTo().equals(this.getComponentId()) && (packet.getElemName() == "iq" || packet.getElemName() == "message")) {
                try {
                    error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Service not available. Packet is error type already: {0}", packet.toStringSecure());
                }
            } else if (packet.getStanzaFrom() != null || conn != null) {
                try {
                    error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Feature not supported yet. Packet is error type already: {0}", packet.toStringSecure());
                }
            }
            if (error != null) {
                if (error.getStanzaTo() != null) {
                    conn = this.getResourceConnection(error.getStanzaTo());
                }
                try {
                    if (conn != null) {
                        error.setPacketTo(conn.getConnectionId());
                    }
                    this.addOutPacket(error);
                }
                catch (NoConnectionIdException e) {
                    log.log(Level.WARNING, "Error packet to the SM''s own session: {0}", error);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNewSession(BareJID userId, XMPPResourceConnection conn) {
        XMPPResourceConnection xMPPResourceConnection = conn;
        synchronized (xMPPResourceConnection) {
            if (conn.getSessionData("closing-conn") != null) {
                return;
            }
            XMPPSession session = this.sessionsByNodeId.get(userId);
            if (session == null) {
                session = new XMPPSession(userId.getLocalpart());
                this.sessionsByNodeId.put(userId, session);
                int currSize = this.sessionsByNodeId.size();
                if (currSize > this.maxUserSessions) {
                    this.maxUserSessions = currSize;
                }
                ++this.totalUserSessions;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Created new XMPPSession for: {0}", userId);
                }
            } else {
                List<XMPPResourceConnection> connections = session.getActiveResources();
                if (connections != null) {
                    for (XMPPResourceConnection connection : connections) {
                        if (connection == conn) continue;
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Checking connection: {0}", connection);
                        }
                        try {
                            Packet command2 = Command.CHECK_USER_CONNECTION.getPacket(this.getComponentId(), connection.getConnectionId(), StanzaType.get, UUID.randomUUID().toString());
                            Command.addFieldValue(command2, "user-jid", userId.toString());
                            this.addOutPacketWithTimeout(command2, this.connectionCheckCommandHandler, 30L, TimeUnit.SECONDS);
                        }
                        catch (NoConnectionIdException ex) {
                            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                        }
                    }
                }
            }
            try {
                session.addResourceConnection(conn);
                if (!conn.isServerSession() && !"USER_STATUS".equals(conn.getSessionId())) {
                    try {
                        Packet user_login_cmd = Command.USER_LOGIN.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId(), Command.DataType.submit);
                        Command.addFieldValue(user_login_cmd, "user-jid", userId.toString());
                        this.addOutPacket(user_login_cmd);
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                    }
                }
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.INFO, "Stringprep problem for resource connection: {0}", conn);
                this.handleLogout(userId, conn);
            }
        }
    }

    protected void sendToAdmins(Packet packet) {
        for (BareJID admin : this.admins) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Sending packet to admin: {0}", admin);
            }
            Packet admin_pac = packet.copyElementOnly();
            admin_pac.initVars(packet.getStanzaFrom(), JID.jidInstance(admin));
            this.processPacket(admin_pac);
        }
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    protected XMPPSession getSession(BareJID jid) {
        return this.sessionsByNodeId.get(jid);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(JID connId) {
        return this.connectionsByFrom.get(connId);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        XMPPResourceConnection conn = null;
        JID from = p.getPacketFrom();
        if (from != null && (conn = this.connectionsByFrom.get(from)) != null) {
            return conn;
        }
        JID to = p.getStanzaTo();
        if (to != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Searching for resource connection for: " + to);
            }
            conn = this.getResourceConnection(to);
        } else {
            log.log(Level.INFO, "Message without TO attribute set, don''t know what to do wih this: {0}", p);
        }
        return conn;
    }

    protected boolean isBrokenPacket(Packet p) {
        if (this.getComponentId().equals(p.getPacketFrom()) && p.getPacketTo() == null) {
            return false;
        }
        if (p.getFrom() == null) {
            log.log(Level.FINE, "Broken packet: {0}", p.toStringSecure());
            return true;
        }
        if (!p.getFrom().equals(p.getStanzaFrom()) && (!p.isCommand() || p.isCommand() && p.getCommand() == Command.OTHER)) {
            if (p.getStanzaFrom() != null && !this.isLocalDomain(p.getStanzaFrom().getDomain())) {
                p.setPacketFrom(null);
                p.setPacketTo(null);
                this.fastAddOutPacket(p);
                return true;
            }
            log.log(Level.FINE, "Broken packet: {0}", p.toStringSecure());
            if (p.getElemName() == "iq" || p.getElemName() == "message") {
                try {
                    Packet error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(p, "Service not available.", true);
                    error.setPacketTo(p.getFrom());
                    this.fastAddOutPacket(error);
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Packet is error type already: {0}", p.toStringSecure());
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isTrusted(JID jid) {
        if (this.trusted.contains(jid.getBareJID().toString())) {
            return true;
        }
        return this.isAdmin(jid);
    }

    protected boolean isTrusted(String jid) {
        return this.trusted.contains(jid);
    }

    private long calcAverage(long[] timings) {
        long res = 0L;
        for (long ppt : timings) {
            res += ppt;
        }
        long processingTime = res / (long)timings.length;
        return processingTime;
    }

    private void walk(Packet packet, XMPPResourceConnection connection) {
        for (XMPPProcessorIfc proc_t : this.processors.values()) {
            XMPPProcessorIfc processor = proc_t;
            Authorization result = processor.canHandle(packet, connection);
            if (result == Authorization.AUTHORIZED) {
                ProcessingThreads<ProcessorWorkerThread> pt;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "XMPPProcessorIfc: {0} ({1})\n Request: {2}, conn: {3}", new Object[]{processor.getClass().getSimpleName(), processor.id(), packet, connection});
                }
                if ((pt = this.workerThreads.get(processor.id())) == null) {
                    pt = this.workerThreads.get(this.defPluginsThreadsPool);
                }
                if (pt.addItem(processor, packet, connection)) {
                    packet.processedBy(processor.id());
                    continue;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Can not add packet: {0} to processor: {1} internal queue full.", new Object[]{packet.toStringSecure(), pt.getName()});
                continue;
            }
            if (result == null) continue;
        }
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPProcessorIfc proc_t : this.processors.values()) {
            Element[] features = proc_t.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    private Map<String, Object> getPluginSettings(String plug_id, Map<String, Object> props) {
        String[] nodes;
        ConcurrentHashMap<String, Object> plugin_settings = new ConcurrentHashMap<String, Object>(10);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("plugins-conf") || (nodes = entry.getKey().split("/")).length != 2) continue;
            plugin_settings.put(nodes[1], entry.getValue());
            log.log(Level.CONFIG, "Adding a common plugins option: {0} = {1}", new Object[]{nodes[1], entry.getValue()});
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("plugins-conf") || (nodes = entry.getKey().split("/")).length <= 2) continue;
            Object[] ids = nodes[1].split(",");
            Arrays.sort(ids);
            if (Arrays.binarySearch(ids, plug_id) < 0) continue;
            plugin_settings.put(nodes[2], entry.getValue());
            log.log(Level.CONFIG, "Adding a specific plugins option [{0}]: {1} = {2}", new Object[]{plug_id, nodes[1], entry.getValue()});
        }
        plugin_settings.put("sm-jid", this.getComponentId());
        return plugin_settings;
    }

    private void setPermissions(XMPPResourceConnection conn, Queue<Packet> results) {
        Permissions perms = Permissions.NONE;
        if (conn != null) {
            perms = Permissions.LOCAL;
            if (conn.isAuthorized()) {
                perms = Permissions.AUTH;
                if (conn.isAnonymous()) {
                    perms = Permissions.ANONYM;
                } else {
                    try {
                        JID id = conn.getJID();
                        if (this.isTrusted(id)) {
                            perms = Permissions.TRUSTED;
                        }
                        if (this.isAdmin(id)) {
                            perms = Permissions.ADMIN;
                        }
                    }
                    catch (NotAuthorizedException e) {
                        perms = Permissions.NONE;
                    }
                }
            }
        }
        for (Packet res : results) {
            res.setPermissions(perms);
        }
    }

    private class StaleConnectionCloser
    extends TimerTask {
        public static final int DEF_QUEUE_SIZE = 1000;
        public static final long DEF_TIMEOUT = 30000L;
        private int maxQueueSize;
        private Set<JID> queueSet;
        private Thread thread;
        private long timeout;
        private Set<JID> workingSet;

        public StaleConnectionCloser() {
            this(1000, 30000L);
        }

        public StaleConnectionCloser(int queueSize, long timeout) {
            this.timeout = timeout;
            this.maxQueueSize = queueSize;
            this.workingSet = new HashSet<JID>(queueSize);
            this.queueSet = new HashSet<JID>(queueSize);
        }

        public void closeConnections() {
            if (this.workingSet.isEmpty()) {
                return;
            }
            log.log(Level.INFO, "Trying to find and remove stale XMPPResourceConnections");
            LinkedList<XMPPResourceConnection> staleConnections = new LinkedList<XMPPResourceConnection>();
            for (XMPPSession session : SessionManager.this.sessionsByNodeId.values()) {
                XMPPResourceConnection connection;
                List<XMPPResourceConnection> connections = session.getActiveResources();
                for (XMPPResourceConnection connection2 : connections) {
                    try {
                        JID connectionId = connection2.getConnectionId();
                        if (!this.workingSet.contains(connectionId)) continue;
                        staleConnections.offer(connection2);
                        this.workingSet.remove(connectionId);
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.FINEST, "found connection without proper connection id = {0}", connection2.toString());
                    }
                }
                while ((connection = (XMPPResourceConnection)staleConnections.poll()) != null) {
                    log.log(Level.WARNING, "Found stale XMPPResourceConnection: {0}, removing...", connection);
                    session.removeResourceConnection(connection);
                }
                if (!this.workingSet.isEmpty()) continue;
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueForClose(JID connectionId) {
            boolean result;
            StaleConnectionCloser staleConnectionCloser = this;
            synchronized (staleConnectionCloser) {
                if (this.queueSet.size() > this.maxQueueSize) {
                    return false;
                }
                result = this.queueSet.add(connectionId);
            }
            if (!result && log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "connection with id {0} already queued for removing as stale XMPPResourceConnection", connectionId);
            }
            return result;
        }

        @Override
        public void run() {
            if (this.thread != null && this.thread.isAlive()) {
                return;
            }
            this.thread = new Thread(){

                @Override
                public void run() {
                    StaleConnectionCloser.this.process();
                    StaleConnectionCloser.this.thread = null;
                }
            };
            this.thread.start();
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setMaxQueueSize(int queueSize) {
            this.maxQueueSize = queueSize;
        }

        private void process() {
            try {
                while (this.swapSets()) {
                    this.closeConnections();
                }
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "exception closing stale connections", th);
            }
            SessionManager.this.addTimerTask(this, this.timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean swapSets() {
            StaleConnectionCloser staleConnectionCloser = this;
            synchronized (staleConnectionCloser) {
                Set<JID> tmp = this.workingSet;
                this.workingSet = this.queueSet;
                this.queueSet = tmp;
                this.queueSet.clear();
                return !this.workingSet.isEmpty();
            }
        }
    }

    private class SessionOpenProc
    extends XMPPProcessor
    implements XMPPProcessorIfc {
        private SessionOpenProc() {
        }

        @Override
        public int concurrentQueuesNo() {
            return 4;
        }

        @Override
        public String id() {
            return "session-open";
        }

        @Override
        public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
            XMPPResourceConnection conn = session;
            if (conn == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Adding resource connection for: {0}", packet.getFrom());
                }
                String hostname = Command.getFieldValue(packet, "hostname");
                try {
                    conn = SessionManager.this.createUserSession(packet.getFrom(), hostname);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.WARNING, "Incrrect hostname, did not pass stringprep processing: {0}", hostname);
                    return;
                }
                SessionManager.this.addTimerTask(new AuthenticationTimer(packet.getFrom()), 2L, TimeUnit.MINUTES);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Stream opened for existing session, authorized: {0}", conn.isAuthorized());
            }
            conn.setSessionId(Command.getFieldValue(packet, "session-id"));
            conn.setDefLang(Command.getFieldValue(packet, "xml:lang"));
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting session-id {0} for connection: {1}", new Object[]{conn.getSessionId(), conn});
            }
            SessionManager.this.fastAddOutPacket(packet.okResult((String)null, 0));
        }
    }

    private class SessionCloseProc
    extends XMPPProcessor
    implements XMPPProcessorIfc {
        private SessionCloseProc() {
        }

        @Override
        public int concurrentQueuesNo() {
            return 4;
        }

        @Override
        public String id() {
            return "session-close";
        }

        @Override
        public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Executing connection close for: {0}", packet);
            }
            String userJid = Command.getFieldValue(packet, "user-jid");
            SessionManager.this.closeConnection(packet.getFrom(), userJid, false);
        }
    }

    private class ProcessorWorkerThread
    extends WorkerThread {
        private ArrayDeque<Packet> local_results = new ArrayDeque(100);

        private ProcessorWorkerThread() {
        }

        @Override
        public void process(QueueItem item) {
            XMPPProcessorIfc processor = item.getProcessor();
            try {
                processor.process(item.getPacket(), item.getConn(), SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(processor.id()));
                if (item.getConn() != null) {
                    SessionManager.this.setPermissions(item.getConn(), this.local_results);
                }
                SessionManager.this.addOutPackets(item.getPacket(), item.getConn(), this.local_results);
            }
            catch (PacketErrorTypeException e) {
                log.log(Level.INFO, "Already error packet, ignoring: {0}", item.getPacket().toStringSecure());
            }
            catch (XMPPException e) {
                log.log(Level.WARNING, "Exception during packet processing: " + item.getPacket().toStringSecure(), e);
            }
        }

        @Override
        public WorkerThread getNewInstance() {
            ProcessorWorkerThread worker = new ProcessorWorkerThread();
            return worker;
        }
    }

    private class DefaultHandlerProc
    extends XMPPProcessor
    implements XMPPProcessorIfc {
        private DefaultHandlerProc() {
        }

        @Override
        public int concurrentQueuesNo() {
            return 4;
        }

        @Override
        public String id() {
            return "default-handler";
        }

        @Override
        public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Executing default packet handler for: {0}", packet);
            }
            SessionManager.this.defPacketHandler.process(packet, session, repo, results);
        }
    }

    private class ConnectionCheckCommandHandler
    implements ReceiverTimeoutHandler {
        private ConnectionCheckCommandHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (response.getType() == StanzaType.error) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Connection checker error received, closing connection: {0}", packet.getTo());
                }
                String userJid = Command.getFieldValue(packet, "user-jid");
                SessionManager.this.closeConnection(packet.getTo(), userJid, false);
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Connection checker timeout expired, closing connection: {0}", packet.getTo());
            }
            String userJid = Command.getFieldValue(packet, "user-jid");
            SessionManager.this.closeConnection(packet.getTo(), userJid, false);
        }
    }

    private class AuthenticationTimer
    extends TimerTask {
        private JID connId = null;

        private AuthenticationTimer(JID connId) {
            this.connId = connId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XMPPResourceConnection conn = SessionManager.this.connectionsByFrom.get(this.connId);
            if (conn != null) {
                XMPPResourceConnection xMPPResourceConnection = conn;
                synchronized (xMPPResourceConnection) {
                    if (!conn.isAuthorized()) {
                        conn.putSessionData("authentication-timeout", "authentication-timeout");
                        SessionManager.this.connectionsByFrom.remove(this.connId);
                        ++SessionManager.this.authTimeouts;
                        log.log(Level.INFO, "Authentication timeout expired, closing connection: {0}", this.connId);
                        SessionManager.this.fastAddOutPacket(Command.CLOSE.getPacket(SessionManager.this.getComponentId(), this.connId, StanzaType.set, conn.nextStanzaId()));
                    }
                }
            }
        }
    }
}

