/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.S2SConnection;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SConnectionSelector;
import tigase.server.xmppserver.S2SIOService;
import tigase.util.DNSEntry;
import tigase.util.DNSResolver;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

public class CIDConnections {
    private static final Logger log = Logger.getLogger(CIDConnections.class.getName());
    private static int outgoingOpenTasksSize = Runtime.getRuntime().availableProcessors();
    private static ScheduledExecutorService outgoingOpenTasks = Executors.newScheduledThreadPool(outgoingOpenTasksSize);
    private CID cid = null;
    private S2SConnectionSelector connectionSelector = null;
    private long firstWaitingTime = 0L;
    private S2SConnectionHandlerIfc<S2SIOService> handler = null;
    private int max_in_conns = 4;
    private int max_out_conns = 4;
    private int max_out_conns_per_ip = 2;
    private long max_waiting_time = 900000L;
    private boolean testMode = Boolean.getBoolean("test");
    private ReentrantLock sendInProgress = new ReentrantLock();
    private AtomicBoolean outgoingOpenInProgress = new AtomicBoolean(false);
    private Set<S2SConnection> outgoing_handshaking = new ConcurrentSkipListSet<S2SConnection>();
    private Set<S2SConnection> outgoing = new ConcurrentSkipListSet<S2SConnection>();
    private Set<S2SConnection> incoming = new ConcurrentSkipListSet<S2SConnection>();
    private Map<String, String> dbKeys = new ConcurrentSkipListMap<String, String>();
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();

    public static void setOutgoingOpenThreadsSize(int size) {
        if (outgoingOpenTasksSize != size) {
            outgoingOpenTasksSize = size;
            ScheduledExecutorService scheduler = outgoingOpenTasks;
            outgoingOpenTasks = Executors.newScheduledThreadPool(outgoingOpenTasksSize);
            scheduler.shutdown();
        }
    }

    public CIDConnections(CID cid, S2SConnectionHandlerIfc<S2SIOService> handler, S2SConnectionSelector selector, int maxInConns, int maxOutConns, int maxOutConnsPerIP, long max_waiting_time) {
        this.cid = cid;
        this.handler = handler;
        this.connectionSelector = selector;
        this.max_in_conns = maxInConns;
        this.max_out_conns = maxOutConns;
        this.max_out_conns_per_ip = maxOutConnsPerIP;
        this.max_waiting_time = max_waiting_time;
    }

    public void resetOutgoingInProgress() {
        this.outgoingOpenInProgress.set(false);
    }

    public boolean getOutgoingInProgress() {
        return this.outgoingOpenInProgress.get();
    }

    public void addDBKey(String sessId, String key) {
        this.dbKeys.put(sessId, key);
    }

    public void addIncoming(S2SIOService serv) {
        S2SConnection s2s_conn = serv.getS2SConnection();
        if (s2s_conn == null) {
            s2s_conn = new S2SConnection(this.handler, serv.getRemoteAddress());
            s2s_conn.setS2SIOService(serv);
            serv.setS2SConnection(s2s_conn);
        }
        this.incoming.add(s2s_conn);
    }

    public void connectionAuthenticated(S2SIOService serv) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, connection is authenticated.", serv);
        }
        serv.addCID(this.cid);
        if (serv.connectionType() == ConnectionType.connect) {
            this.outgoingOpenInProgress.set(false);
            S2SConnection s2s_conn = serv.getS2SConnection();
            this.outgoing_handshaking.remove(s2s_conn);
            this.outgoing.add(s2s_conn);
            this.sendPacket(null);
        }
    }

    public void connectionAuthenticated(String sessionId) {
        S2SConnection s2s_conn = this.getS2SConnectionForSessionId(sessionId);
        if (s2s_conn != null) {
            this.connectionAuthenticated(s2s_conn.getS2SIOService());
        }
    }

    public void connectionStopped(S2SIOService serv) {
        S2SConnection s2s_conn = serv.getS2SConnection();
        if (s2s_conn == null) {
            log.log(Level.INFO, "s2s_conn not set for serv: {0}", serv);
            return;
        }
        if (serv.getSessionId() != null) {
            this.dbKeys.remove(serv.getSessionId());
        }
        switch (serv.connectionType()) {
            case connect: {
                this.outgoingOpenInProgress.set(false);
                this.outgoing.remove(s2s_conn);
                this.outgoing_handshaking.remove(s2s_conn);
                if (this.waitingPackets.isEmpty()) break;
                this.checkOpenConnections();
                break;
            }
            case accept: {
                this.incoming.remove(s2s_conn);
                break;
            }
        }
    }

    public String getDBKey(String key_sessionId) {
        return this.dbKeys.get(key_sessionId);
    }

    public int getDBKeysCount() {
        return this.dbKeys.size();
    }

    public int getIncomingCount() {
        int result = 0;
        for (S2SConnection s2SConnection : this.incoming) {
            if (!s2SConnection.isConnected()) continue;
            ++result;
        }
        return result;
    }

    public int getIncomingTLSCount() {
        int result = 0;
        for (S2SConnection s2SConnection : this.incoming) {
            S2SIOService serv = s2SConnection.getS2SIOService();
            if (!serv.isConnected() || serv.getSessionData().get("cert-check-result") == null) continue;
            ++result;
        }
        return result;
    }

    public int getMaxOutConns() {
        return this.max_out_conns;
    }

    public int getMaxOutConnsPerIP() {
        return this.max_out_conns_per_ip;
    }

    public int getOutgoingCount() {
        int result = 0;
        for (S2SConnection s2SConnection : this.outgoing) {
            if (!s2SConnection.isConnected()) continue;
            ++result;
        }
        return result;
    }

    public int getOutgoingHandshakingCount() {
        int result = 0;
        for (S2SConnection s2SConnection : this.outgoing_handshaking) {
            if (!s2SConnection.isConnected()) continue;
            ++result;
        }
        return result;
    }

    public int getOutgoingTLSCount() {
        int result = 0;
        for (S2SConnection s2SConnection : this.outgoing) {
            S2SIOService serv = s2SConnection.getS2SIOService();
            if (!serv.isConnected() || serv.getSessionData().get("cert-check-result") == null) continue;
            ++result;
        }
        return result;
    }

    public S2SConnection getS2SConnectionForSessionId(String sessionId) {
        S2SConnection s2s_conn = null;
        for (S2SConnection s2sc : this.incoming) {
            if (s2sc.getS2SIOService() == null || !sessionId.equals(s2sc.getS2SIOService().getSessionId())) continue;
            s2s_conn = s2sc;
            break;
        }
        if (s2s_conn == null) {
            for (S2SConnection s2sc : this.outgoing) {
                if (s2sc.getS2SIOService() == null || !sessionId.equals(s2sc.getS2SIOService().getSessionId())) continue;
                s2s_conn = s2sc;
                break;
            }
        }
        if (s2s_conn == null) {
            for (S2SConnection s2sc : this.outgoing_handshaking) {
                if (s2sc.getS2SIOService() == null || !sessionId.equals(s2sc.getS2SIOService().getSessionId())) continue;
                s2s_conn = s2sc;
                break;
            }
        }
        return s2s_conn;
    }

    public int getWaitingControlCount() {
        int result = 0;
        for (S2SConnection s2sc : this.incoming) {
            result += s2sc.getWaitingControlCount();
        }
        for (S2SConnection s2sc : this.outgoing) {
            result += s2sc.getWaitingControlCount();
        }
        for (S2SConnection s2sc : this.outgoing_handshaking) {
            result += s2sc.getWaitingControlCount();
        }
        return result;
    }

    public int getWaitingCount() {
        return this.waitingPackets.size();
    }

    public void reconnectionFailed(Map<String, Object> port_props) {
        block7: {
            block6: {
                S2SConnection s2s_conn = (S2SConnection)port_props.get("s2s-connection-key");
                if (s2s_conn == null) {
                    log.log(Level.INFO, "s2s_conn not set for serv: {0}", port_props);
                    return;
                }
                ConnectionType type = (ConnectionType)((Object)port_props.get("type"));
                if (type == null) break block6;
                switch (type) {
                    case connect: {
                        this.outgoingOpenInProgress.set(false);
                        this.outgoing.remove(s2s_conn);
                        this.outgoing_handshaking.remove(s2s_conn);
                        if (!this.waitingPackets.isEmpty()) {
                            this.checkOpenConnections();
                            break;
                        }
                        break block7;
                    }
                    case accept: {
                        this.incoming.remove(s2s_conn);
                        break;
                    }
                }
                break block7;
            }
            log.log(Level.INFO, "ConnectionType not set for serv: {0}", port_props);
        }
    }

    public boolean sendControlPacket(String sessionId, Packet packet) {
        S2SConnection s2s_conn = this.getS2SConnectionForSessionId(sessionId);
        if (s2s_conn != null) {
            s2s_conn.addControlPacket(packet);
            s2s_conn.sendAllControlPackets();
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Control packet: {0} could not be sent as there is no connection for the session id: {1}", new Object[]{packet, sessionId});
        }
        return false;
    }

    public void sendHandshakingOnly(final Packet verify_req) {
        outgoingOpenTasks.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    DNSEntry dns_entry = DNSResolver.getHostSRV_Entry(CIDConnections.this.cid.getRemoteHost());
                    S2SConnection s2s_conn = new S2SConnection(CIDConnections.this.handler, dns_entry.getIp());
                    s2s_conn.addControlPacket(verify_req);
                    TreeMap<String, String> port_props = new TreeMap<String, String>();
                    port_props.put("handshaking-only-key", "handshaking-only-key");
                    port_props.put("handshaking-domain-key", verify_req.getStanzaTo().toString());
                    CIDConnections.this.initNewConnection(dns_entry.getIp(), dns_entry.getPort(), s2s_conn, port_props);
                }
                catch (UnknownHostException ex) {
                    log.log(Level.INFO, "Remote host not found: " + CIDConnections.this.cid.getRemoteHost(), ex);
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending packets.");
        }
        if (packet != null) {
            if (this.firstWaitingTime == 0L || this.waitingPackets.isEmpty()) {
                this.firstWaitingTime = System.currentTimeMillis();
            }
            this.waitingPackets.offer(packet);
        }
        if (this.sendInProgress.tryLock()) {
            try {
                boolean packetSent = false;
                Packet waiting = null;
                while ((waiting = this.waitingPackets.peek()) != null) {
                    S2SConnection s2s_conn = this.getOutgoingConnection(waiting);
                    if (s2s_conn != null) {
                        try {
                            packetSent = s2s_conn.sendPacket(waiting);
                            this.waitingPackets.poll();
                            if (!log.isLoggable(Level.FINEST)) continue;
                            log.log(Level.FINEST, "Packet: {0} sent over connection: {1}", new Object[]{waiting, s2s_conn.getS2SIOService()});
                        }
                        catch (Exception ex) {
                            log.log(Level.FINE, "A problem sending packet, connection broken? Retrying later. {0}", waiting);
                        }
                        continue;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "There is no connection available to send the packet: {0}", waiting);
                    break;
                }
                if (!packetSent) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "No packet could be sent, trying to open more connections: {0}", this.cid);
                    }
                    this.checkOpenConnections();
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Some packets were sent, not trying to open more connections: {0}", this.cid);
                }
            }
            finally {
                this.sendInProgress.unlock();
            }
        }
    }

    private void checkOpenConnections() {
        if (this.outgoingOpenInProgress.compareAndSet(false, true)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Scheduling task for openning a new connection for: {0}", this.cid);
            }
            outgoingOpenTasks.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean result = false;
                    try {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Running scheduled task for openning a new connection for: {0}", CIDConnections.this.cid);
                        }
                        result = CIDConnections.this.openOutgoingConnections();
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "uncaughtException in the connection opening thread: ", e);
                    }
                    if (!result) {
                        CIDConnections.this.outgoingOpenInProgress.set(false);
                    }
                }
            }, 0L, TimeUnit.MILLISECONDS);
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Outgoing open in progress, skipping for: {0}", this.cid);
        }
    }

    private int getOpenForIP(String ip) {
        int result = 0;
        for (S2SConnection s2SConnection : this.outgoing) {
            if (!ip.equals(s2SConnection.getIPAddress())) continue;
            ++result;
        }
        for (S2SConnection s2SConnection : this.outgoing_handshaking) {
            if (!ip.equals(s2SConnection.getIPAddress())) continue;
            ++result;
        }
        return result;
    }

    private S2SConnection getOutgoingConnection(Packet packet) {
        return this.connectionSelector.selectConnection(packet, this.outgoing);
    }

    private void initNewConnection(String ip, int port, S2SConnection s2s_conn, Map<String, Object> port_props) {
        this.outgoing_handshaking.add(s2s_conn);
        port_props.put("s2s-connection-key", s2s_conn);
        port_props.put("remote-ip", ip);
        port_props.put("local-hostname", this.cid.getLocalHost());
        port_props.put("remote-hostname", this.cid.getRemoteHost());
        port_props.put("ifc", new String[]{ip});
        port_props.put("socket", (Object)SocketType.plain);
        port_props.put("type", (Object)ConnectionType.connect);
        port_props.put("srv-type", "_xmpp-server._tcp");
        port_props.put("port-no", port);
        port_props.put("cid", this.cid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "STARTING new connection: {0}", this.cid);
            log.log(Level.FINEST, "{0} connection params: {1}", new Object[]{this.cid, port_props});
        }
        this.handler.initNewConnection(port_props);
    }

    private boolean openOutgoingConnections() {
        boolean result = false;
        try {
            DNSEntry[] dns_entries;
            for (S2SConnection out_conn : this.outgoing) {
                if (out_conn.isConnected()) continue;
                this.outgoing.remove(out_conn);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Removing inactive connection: {0}", out_conn);
            }
            if (this.firstWaitingTime + this.max_waiting_time <= System.currentTimeMillis()) {
                this.sendPacketsBack();
                this.firstWaitingTime = 0L;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "S2S Timeout expired, sending back: {0}", this.waitingPackets);
                }
                return result;
            }
            int all_outgoing = this.outgoing.size() + this.outgoing_handshaking.size();
            if (all_outgoing >= this.max_out_conns) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Exceeded max number of outgoing connections, not doing anything: {0}", all_outgoing);
                }
                return result;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Checking DNS for host: {0} for: {1}", new Object[]{this.cid.getRemoteHost(), this.cid});
            }
            if (this.testMode && this.cid.getRemoteHost().startsWith("vhost-") && !this.cid.getRemoteHost().contains(".")) {
                throw new UnknownHostException(this.cid.getRemoteHost());
            }
            for (DNSEntry dNSEntry : dns_entries = DNSResolver.getHostSRV_Entries(this.cid.getRemoteHost())) {
                int openForIP;
                for (int i = openForIP = this.getOpenForIP(dNSEntry.getIp()); i < this.max_out_conns_per_ip; ++i) {
                    if (dNSEntry.getIp().equals("127.0.0.1")) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "DNS misconfiguration for domain: {0}, for: {1}", new Object[]{this.cid.getRemoteHost(), this.cid});
                        }
                        throw new UnknownHostException("DNS misconfiguration for domain: " + this.cid.getRemoteHost());
                    }
                    S2SConnection s2s_conn = new S2SConnection(this.handler, dNSEntry.getIp());
                    TreeMap<String, Object> port_props = new TreeMap<String, Object>();
                    this.initNewConnection(dNSEntry.getIp(), dNSEntry.getPort(), s2s_conn, port_props);
                    result = true;
                    if (++all_outgoing < this.max_out_conns) continue;
                    return result;
                }
            }
        }
        catch (UnknownHostException ex) {
            log.log(Level.INFO, "Remote host not found: " + this.cid.getRemoteHost() + ", for: " + this.cid, ex);
            this.sendPacketsBack();
        }
        return result;
    }

    private void sendPacketsBack() {
        Packet p = null;
        while ((p = this.waitingPackets.poll()) != null) {
            try {
                this.handler.addOutPacket(Authorization.REMOTE_SERVER_NOT_FOUND.getResponseMessage(p, "S2S - destination host not found", true));
            }
            catch (PacketErrorTypeException e) {
                log.log(Level.WARNING, "Packet: {0} processing exception: {1}", new Object[]{p.toString(), e});
            }
        }
    }
}

