/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.ServiceChecker;
import tigase.stats.StatisticsList;
import tigase.util.DataTypes;
import tigase.util.TimerTask;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPIOServiceListener;

public abstract class ConnectionManager<IO extends XMPPIOService<?>>
extends AbstractMessageReceiver
implements XMPPIOServiceListener<IO> {
    public static final String HT_TRAFFIC_THROTTLING_PROP_KEY = "--cm-ht-traffic-throttling";
    public static final String HT_TRAFFIC_THROTTLING_PROP_VAL = "xmpp:25k:0:disc,bin:200m:0:disc";
    public static final String NET_BUFFER_HT_PROP_KEY = "--net-buff-high-throughput";
    public static final String NET_BUFFER_ST_PROP_KEY = "--net-buff-standard";
    public static final String PORT_LOCAL_HOST_PROP_KEY = "local-host";
    public static final String ST_TRAFFIC_THROTTLING_PROP_KEY = "--cm-traffic-throttling";
    public static final String ST_TRAFFIC_THROTTLING_PROP_VAL = "xmpp:2500:0:disc,bin:20m:0:disc";
    public static final String TRAFFIC_THROTTLING_PROP_KEY = "traffic-throttling";
    protected static final long LAST_MINUTE_BIN_LIMIT_PROP_VAL = 20000000L;
    protected static final long LAST_MINUTE_PACKETS_LIMIT_PROP_VAL = 2500L;
    protected static final String MAX_INACTIVITY_TIME = "max-inactivity-time";
    protected static final String MAX_RECONNECTS_PROP_KEY = "max-reconnects";
    protected static final int NET_BUFFER_HT_PROP_VAL = 65536;
    protected static final String NET_BUFFER_PROP_KEY = "net-buffer";
    protected static final int NET_BUFFER_ST_PROP_VAL = 2048;
    protected static final String PORT_CLASS_PROP_KEY = "class";
    protected static final String PORT_IFC_PROP_KEY = "ifc";
    protected static final String PORT_KEY = "port-no";
    protected static final String PORT_REMOTE_HOST_PROP_KEY = "remote-host";
    protected static final String PORT_REMOTE_HOST_PROP_VAL = "localhost";
    protected static final String PORT_SOCKET_PROP_KEY = "socket";
    protected static final String PORT_TYPE_PROP_KEY = "type";
    protected static final String PROP_KEY = "connections/";
    protected static final long TOTAL_BIN_LIMIT_PROP_VAL = 0L;
    protected static final long TOTAL_PACKETS_LIMIT_PROP_VAL = 0L;
    protected static final String WHITE_CHAR_ACK_PROP_KEY = "white-char-ack";
    protected static final String XMPP_ACK_PROP_KEY = "xmpp-ack";
    private static final Logger log = Logger.getLogger(ConnectionManager.class.getName());
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    protected static final boolean XMPP_ACK_PROP_VAL = false;
    protected static final boolean WHITE_CHAR_ACK_PROP_VAL = false;
    protected static final String PORTS_PROP_KEY = "connections/ports";
    protected static final boolean TLS_USE_PROP_VAL = true;
    protected static final String TLS_PROP_KEY = "connections/tls/";
    protected static final String TLS_USE_PROP_KEY = "connections/tls/use";
    protected static final boolean TLS_REQUIRED_PROP_VAL = false;
    protected static final String TLS_REQUIRED_PROP_KEY = "connections/tls/required";
    public String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private int services_size = 0;
    private long socketOverflow = 0L;
    private Thread watchdog = null;
    private long watchdogRuns = 0L;
    private long watchdogStopped = 0L;
    private long watchdogTests = 0L;
    private boolean white_char_ack = false;
    private boolean xmpp_ack = false;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();
    private long total_packets_limit = 0L;
    private long total_bin_limit = 0L;
    private ConcurrentHashMap<String, IO> services = new ConcurrentHashMap();
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    private long maxInactivityTime = this.getMaxInactiveTime();
    private long last_minute_packets_limit = 2500L;
    private long last_minute_bin_limit = 20000000L;
    private IOServiceStatisticsGetter ioStatsGetter = new IOServiceStatisticsGetter();
    private boolean initializationCompleted = false;
    protected int net_buffer = 2048;
    protected long connectionDelay = 2000L;
    private LIMIT_ACTION xmppLimitAction = LIMIT_ACTION.DISCONNECT;

    public boolean checkTrafficLimits(IO serv) {
        boolean xmppLimitHit = false;
        if (this.last_minute_packets_limit > 0L) {
            boolean bl = xmppLimitHit = ((XMPPIOService)serv).getPacketsReceived(false) >= this.last_minute_packets_limit || ((XMPPIOService)serv).getPacketsSent(false) >= this.last_minute_packets_limit;
        }
        if (!xmppLimitHit && this.total_packets_limit > 0L) {
            boolean bl = xmppLimitHit = ((XMPPIOService)serv).getTotalPacketsReceived() >= this.total_packets_limit || ((XMPPIOService)serv).getTotalPacketsSent() >= this.total_packets_limit;
        }
        if (xmppLimitHit) {
            Level level = Level.FINER;
            if (this.isHighThroughput()) {
                level = Level.WARNING;
            }
            switch (this.xmppLimitAction) {
                case DROP_PACKETS: {
                    if (log.isLoggable(level)) {
                        log.log(level, "[[{0}]] XMPP Limits exceeded on connection {1} dropping pakcets: {2}", new Object[]{this.getName(), serv, ((XMPPIOService)serv).getReceivedPackets()});
                    }
                    while (((XMPPIOService)serv).getReceivedPackets().poll() != null) {
                    }
                    break;
                }
                default: {
                    if (log.isLoggable(level)) {
                        log.log(level, "[[{0}]] XMPP Limits exceeded on connection {1} stopping, packets dropped: {2}", new Object[]{this.getName(), serv, ((XMPPIOService)serv).getReceivedPackets()});
                    }
                    ((IOService)serv).forceStop();
                }
            }
            return false;
        }
        boolean binLimitHit = false;
        long bytesSent = ((IOService)serv).getBytesSent(false);
        long bytesReceived = ((IOService)serv).getBytesReceived(false);
        if (this.last_minute_bin_limit > 0L) {
            binLimitHit = bytesSent >= this.last_minute_bin_limit || bytesReceived >= this.last_minute_bin_limit;
        }
        long totalSent = ((IOService)serv).getTotalBytesSent();
        long totalReceived = ((IOService)serv).getTotalBytesReceived();
        if (!binLimitHit && this.total_bin_limit > 0L) {
            boolean bl = binLimitHit = totalReceived >= this.total_bin_limit || totalSent >= this.total_bin_limit;
        }
        if (binLimitHit) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "[[{0}]] Binary Limits exceeded ({1}:{2}:{3}:{4}) on connection {5} stopping, packets dropped: {6}", new Object[]{this.getName(), bytesSent, bytesReceived, totalSent, totalReceived, serv, ((XMPPIOService)serv).getReceivedPackets()});
            }
            ((IOService)serv).forceStop();
            return false;
        }
        return true;
    }

    @Override
    public synchronized void everyMinute() {
        int tmp;
        super.everyMinute();
        this.services_size = tmp = this.services.size();
        this.doForAllServices(this.ioStatsGetter);
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        if (packet.getTo() != null) {
            return packet.getTo().hashCode();
        }
        return super.hashCodeForPacket(packet);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("servicesMap", (Object)this.services);
    }

    @Override
    public void initializationCompleted() {
        if (this.isInitializationComplete()) {
            return;
        }
        super.initializationCompleted();
        this.initializationCompleted = true;
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, this.connectionDelay);
        }
        this.waitingTasks.clear();
    }

    @Override
    public void packetsReady(IO serv) throws IOException {
        if (this.checkTrafficLimits(serv)) {
            this.writePacketsToSocket(serv, this.processSocketData(serv));
        }
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public void processPacket(Packet packet) {
        this.writePacketToSocket(packet);
    }

    public abstract Queue<Packet> processSocketData(IO var1);

    public abstract void reconnectionFailed(Map<String, Object> var1);

    @Override
    public void release() {
        this.releaseListeners();
        super.release();
    }

    public void serviceStarted(IO service) {
        XMPPIOService serv;
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "[[{0}]] Connection started: {1}", new Object[]{this.getName(), service});
        }
        if ((serv = (XMPPIOService)this.services.get(id)) != null) {
            if (serv == service) {
                log.log(Level.WARNING, "{0}: That would explain a lot, adding the same service twice, ID: {1}", new Object[]{this.getName(), serv});
            } else {
                log.log(Level.WARNING, "{0}: Attempt to add different service with the same ID: {1}", new Object[]{this.getName(), service});
                serv.stop();
            }
        }
        this.services.put(id, service);
        ++this.services_size;
    }

    @Override
    public boolean serviceStopped(IO service) {
        try {
            this.ioStatsGetter.check(service);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Nothing serious to worry about but please notify the developer.", e);
        }
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "[[{0}]] Connection stopped: {1}", new Object[]{this.getName(), service});
        }
        if (id != null) {
            boolean result = this.services.remove(id, service);
            if (result) {
                --this.services_size;
            } else if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "[[{0}]] Attempt to stop incorrect service: {1}", new Object[]{this.getName(), service});
            }
            return result;
        }
        return false;
    }

    @Override
    public void stop() {
        this.releaseListeners();
        for (XMPPIOService service : this.services.values()) {
            service.forceStop();
        }
        super.stop();
    }

    public void updateConnectionDetails(Map<String, Object> port_props) {
    }

    public void writePacketsToSocket(IO serv, Queue<Packet> packets) {
        if (serv != null) {
            if (packets != null && packets.size() > 0) {
                Packet p = null;
                while ((p = packets.poll()) != null) {
                    if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINER, "{0}, Processing packet: {1}, type: {2}", new Object[]{serv, p.getElemName(), p.getType()});
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Writing packet: {1}", new Object[]{serv, p});
                    }
                    ((XMPPIOService)serv).addPacketToSend(p);
                }
                try {
                    ((XMPPIOService)serv).processWaitingPackets();
                    SocketThread.addSocketService(serv);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, serv + "Exception during writing packets: ", e);
                    try {
                        ((XMPPIOService)serv).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, serv + "Exception stopping XMPPIOService: ", e1);
                    }
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can't find service for packets: [{0}] ", packets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePacketToSocket(IO ios, Packet p) {
        if (ios != null) {
            if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
                log.log(Level.FINER, "{0}, Processing packet: {1}, type: {2}", new Object[]{ios, p.getElemName(), p.getType()});
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Writing packet: {1}", new Object[]{ios, p});
            }
            ((XMPPIOService)ios).addPacketToSend(p);
            if (((XMPPIOService)ios).writeInProgress.tryLock()) {
                try {
                    ((XMPPIOService)ios).processWaitingPackets();
                    SocketThread.addSocketService(ios);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, ios + "Exception during writing packets: ", e);
                    try {
                        ((XMPPIOService)ios).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, ios + "Exception stopping XMPPIOService: ", e1);
                    }
                }
                finally {
                    ((XMPPIOService)ios).writeInProgress.unlock();
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can''t find service for packet: <{0}> {1}, service id: {2}", new Object[]{p.getElemName(), p.getTo(), this.getServiceId(p)});
        }
        return false;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        log.log(Level.CONFIG, "{0} defaults: {1}", new Object[]{this.getName(), params.toString()});
        Map<String, Object> props = super.getDefaults(params);
        props.put(TLS_USE_PROP_KEY, true);
        this.checkHighThroughputProperty(NET_BUFFER_HT_PROP_KEY, 65536, NET_BUFFER_ST_PROP_KEY, 2048, NET_BUFFER_PROP_KEY, Integer.class, params, props);
        this.checkHighThroughputProperty(HT_TRAFFIC_THROTTLING_PROP_KEY, this.getDefTrafficThrottling(), ST_TRAFFIC_THROTTLING_PROP_KEY, this.getDefTrafficThrottling(), TRAFFIC_THROTTLING_PROP_KEY, String.class, params, props);
        int[] ports = null;
        String ports_str = (String)params.get("--" + this.getName() + "-ports");
        if (ports_str != null) {
            String[] ports_stra = ports_str.split(",");
            ports = new int[ports_stra.length];
            int k = 0;
            for (String p : ports_stra) {
                try {
                    ports[k++] = Integer.parseInt(p);
                }
                catch (Exception e) {
                    log.warning("Incorrect ports default settings: " + p);
                }
            }
        }
        int ports_size = 0;
        if (ports != null) {
            log.config("Port settings preset: " + Arrays.toString(ports));
            for (int port : ports) {
                this.putDefPortParams(props, port, SocketType.plain);
            }
            props.put(PORTS_PROP_KEY, ports);
        } else {
            int[] ssls;
            int[] plains = this.getDefPlainPorts();
            if (plains != null) {
                ports_size += plains.length;
            }
            if ((ssls = this.getDefSSLPorts()) != null) {
                ports_size += ssls.length;
            }
            if (ports_size > 0) {
                ports = new int[ports_size];
            }
            if (ports != null) {
                int i;
                int idx = 0;
                if (plains != null) {
                    idx = plains.length;
                    for (i = 0; i < idx; ++i) {
                        ports[i] = plains[i];
                        this.putDefPortParams(props, ports[i], SocketType.plain);
                    }
                }
                if (ssls != null) {
                    for (i = idx; i < idx + ssls.length; ++i) {
                        ports[i] = ssls[i - idx];
                        this.putDefPortParams(props, ports[i], SocketType.ssl);
                    }
                }
                props.put(PORTS_PROP_KEY, ports);
            }
        }
        String acks = (String)params.get("--stanza-ack");
        if (acks != null) {
            String[] acks_arr;
            for (String ack_type : acks_arr = acks.split(",")) {
                if ("white-char".equals(ack_type)) {
                    this.white_char_ack = true;
                }
                if (!"xmpp".equals(ack_type)) continue;
                this.xmpp_ack = true;
            }
        }
        props.put(WHITE_CHAR_ACK_PROP_KEY, this.white_char_ack);
        props.put(XMPP_ACK_PROP_KEY, this.xmpp_ack);
        props.put(MAX_INACTIVITY_TIME, this.getMaxInactiveTime() / 1000L);
        return props;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Open connections", this.services_size, Level.INFO);
        if (list.checkLevel(Level.FINEST) || this.services.size() < 1000) {
            int waitingToSendSize = 0;
            for (XMPPIOService serv : this.services.values()) {
                waitingToSendSize += serv.waitingToSendSize();
            }
            list.add(this.getName(), "Waiting to send", waitingToSendSize, Level.FINE);
        }
        list.add(this.getName(), "Bytes sent", this.bytesSent, Level.FINE);
        list.add(this.getName(), "Bytes received", this.bytesReceived, Level.FINE);
        list.add(this.getName(), "Socket overflow", this.socketOverflow, Level.FINE);
        list.add(this.getName(), "Watchdog runs", this.watchdogRuns, Level.FINER);
        list.add(this.getName(), "Watchdog tests", this.watchdogTests, Level.FINE);
        list.add(this.getName(), "Watchdog stopped", this.watchdogStopped, Level.FINE);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.watchdog = new Thread((Runnable)new Watchdog(), "Watchdog - " + name);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.get(MAX_INACTIVITY_TIME) != null) {
            this.maxInactivityTime = (Long)props.get(MAX_INACTIVITY_TIME) * 1000L;
        }
        if (props.get(WHITE_CHAR_ACK_PROP_KEY) != null) {
            this.white_char_ack = (Boolean)props.get(WHITE_CHAR_ACK_PROP_KEY);
        }
        if (props.get(XMPP_ACK_PROP_KEY) != null) {
            this.xmpp_ack = (Boolean)props.get(XMPP_ACK_PROP_KEY);
        }
        if (props.get(NET_BUFFER_PROP_KEY) != null) {
            this.net_buffer = (Integer)props.get(NET_BUFFER_PROP_KEY);
        }
        if (props.get(TRAFFIC_THROTTLING_PROP_KEY) != null) {
            String[] tmp;
            for (String tmp_s : tmp = ((String)props.get(TRAFFIC_THROTTLING_PROP_KEY)).split(",")) {
                String[] tmp_thr = tmp_s.split(":");
                if (tmp_thr[0].equalsIgnoreCase("xmpp")) {
                    this.last_minute_packets_limit = DataTypes.parseNum(tmp_thr[1], Long.class, 2500L);
                    log.warning(this.getName() + " last_minute_packets_limit = " + this.last_minute_packets_limit);
                    this.total_packets_limit = DataTypes.parseNum(tmp_thr[2], Long.class, 0L);
                    log.warning(this.getName() + " total_packets_limit = " + this.total_packets_limit);
                    if (tmp_thr[3].equalsIgnoreCase("disc")) {
                        this.xmppLimitAction = LIMIT_ACTION.DISCONNECT;
                    }
                    if (tmp_thr[3].equalsIgnoreCase("drop")) {
                        this.xmppLimitAction = LIMIT_ACTION.DROP_PACKETS;
                    }
                }
                if (!tmp_thr[0].equalsIgnoreCase("bin")) continue;
                this.last_minute_bin_limit = DataTypes.parseNum(tmp_thr[1], Long.class, 20000000L);
                log.warning(this.getName() + " last_minute_bin_limit = " + this.last_minute_bin_limit);
                this.total_bin_limit = DataTypes.parseNum(tmp_thr[2], Long.class, 0L);
                log.warning(this.getName() + " total_bin_limit = " + this.total_bin_limit);
            }
        }
        if (props.size() == 1) {
            return;
        }
        if (this.isInitializationComplete()) {
            return;
        }
        this.releaseListeners();
        int[] ports = (int[])props.get(PORTS_PROP_KEY);
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>(20);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!entry.getKey().startsWith(PROP_KEY + ports[i])) continue;
                    int idx = entry.getKey().lastIndexOf(47);
                    String key = entry.getKey().substring(idx + 1);
                    log.log(Level.CONFIG, "Adding port property key: {0}={1}", new Object[]{key, entry.getValue()});
                    port_props.put(key, entry.getValue());
                }
                port_props.put(PORT_KEY, ports[i]);
                this.addWaitingTask(port_props);
            }
        }
    }

    protected void addWaitingTask(Map<String, Object> conn) {
        if (this.initializationCompleted) {
            this.reconnectService(conn, this.connectionDelay);
        } else {
            this.waitingTasks.add(conn);
        }
    }

    protected <T> void checkHighThroughputProperty(String ht_def_key, T ht_dev_val, String st_def_key, T st_def_val, String prop_key, Class<T> prop_val_class, Map<String, Object> params, Map<String, Object> props) {
        T tmp = st_def_val;
        String str_tmp = null;
        if (this.isHighThroughput()) {
            tmp = ht_dev_val;
            str_tmp = (String)params.get(ht_def_key);
        } else {
            tmp = st_def_val;
            str_tmp = (String)params.get(st_def_key);
        }
        if (prop_val_class.isAssignableFrom(Integer.class)) {
            tmp = prop_val_class.cast(DataTypes.parseNum(str_tmp, Integer.class, (Integer)tmp));
        }
        if (prop_val_class.isAssignableFrom(Long.class)) {
            tmp = prop_val_class.cast(DataTypes.parseNum(str_tmp, Long.class, (Long)tmp));
        }
        if (prop_val_class.isAssignableFrom(String.class)) {
            tmp = prop_val_class.cast(str_tmp);
        }
        props.put(prop_key, tmp);
    }

    protected int countIOServices() {
        return this.services.size();
    }

    protected void doForAllServices(ServiceChecker<IO> checker) {
        for (XMPPIOService service : this.services.values()) {
            checker.check(service);
        }
    }

    protected boolean writePacketToSocket(Packet p) {
        IO ios = this.getXMPPIOService(p);
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected boolean writePacketToSocket(Packet p, String serviceId) {
        IO ios = this.getXMPPIOService(serviceId);
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected void writeRawData(IO ios, String data) {
        try {
            ((XMPPIOService)ios).writeRawData(data);
            SocketThread.addSocketService(ios);
        }
        catch (Exception e) {
            log.log(Level.WARNING, ios + "Exception during writing data: " + data, e);
            try {
                ((XMPPIOService)ios).stop();
            }
            catch (Exception e1) {
                log.log(Level.WARNING, ios + "Exception stopping XMPPIOService: ", e1);
            }
        }
    }

    protected int[] getDefPlainPorts() {
        return null;
    }

    protected int[] getDefSSLPorts() {
        return null;
    }

    protected String getDefTrafficThrottling() {
        String result = ST_TRAFFIC_THROTTLING_PROP_VAL;
        if (this.isHighThroughput()) {
            result = HT_TRAFFIC_THROTTLING_PROP_VAL;
        }
        return result;
    }

    protected abstract long getMaxInactiveTime();

    protected Map<String, Object> getParamsForPort(int port) {
        return null;
    }

    protected String getServiceId(Packet packet) {
        return this.getServiceId(packet.getTo());
    }

    protected String getServiceId(JID jid) {
        return jid.getResource();
    }

    protected String getUniqueId(IO serv) {
        return ((IOService)serv).getUniqueId();
    }

    protected IO getXMPPIOService(String serviceId) {
        return (IO)((XMPPIOService)this.services.get(serviceId));
    }

    protected IO getXMPPIOService(Packet p) {
        return (IO)((XMPPIOService)this.services.get(this.getServiceId(p)));
    }

    protected abstract IO getXMPPIOServiceInstance();

    protected boolean isHighThroughput() {
        return false;
    }

    protected boolean isTlsWantClientAuthEnabled() {
        return false;
    }

    private void putDefPortParams(Map<String, Object> props, int port, SocketType sock) {
        log.log(Level.CONFIG, "Generating defaults for port: {0}", port);
        props.put(PROP_KEY + port + "/" + PORT_TYPE_PROP_KEY, (Object)ConnectionType.accept);
        props.put(PROP_KEY + port + "/" + PORT_SOCKET_PROP_KEY, (Object)sock);
        props.put(PROP_KEY + port + "/" + PORT_IFC_PROP_KEY, this.PORT_IFC_PROP_VAL);
        props.put(PROP_KEY + port + "/" + PORT_REMOTE_HOST_PROP_KEY, PORT_REMOTE_HOST_PROP_VAL);
        props.put(PROP_KEY + port + "/" + TLS_REQUIRED_PROP_KEY, false);
        Map<String, Object> extra = this.getParamsForPort(port);
        if (extra != null) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                props.put(PROP_KEY + port + "/" + entry.getKey(), entry.getValue());
            }
        }
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        if (log.isLoggable(Level.FINER)) {
            String cid = "" + port_props.get("local-hostname") + "@" + port_props.get("remote-hostname");
            log.log(Level.FINER, "Reconnecting service for: {0}, scheduling next try in {1}secs, cid: {2}", new Object[]{this.getName(), delay / 1000L, cid});
        }
        this.addTimerTask(new TimerTask(){

            @Override
            public void run() {
                String host = (String)port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
                if (host == null) {
                    host = (String)port_props.get("remote-hostname");
                }
                int port = (Integer)port_props.get(ConnectionManager.PORT_KEY);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reconnecting service for component: {0}, to remote host: {1} on port: {2}", new Object[]{ConnectionManager.this.getName(), host, port});
                }
                ConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener(cli);
        }
        this.pending_open.clear();
    }

    private void startService(Map<String, Object> port_props) {
        if (port_props == null) {
            throw new NullPointerException("port_props cannot be null.");
        }
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener(cli);
    }

    private class Watchdog
    implements Runnable {
        private Watchdog() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(600000L);
                        ++ConnectionManager.this.watchdogRuns;
                        ConnectionManager.this.doForAllServices(new ServiceChecker<IO>(){

                            @Override
                            public void check(XMPPIOService service) {
                                try {
                                    if (null != service) {
                                        long lastTransfer;
                                        long curr_time = System.currentTimeMillis();
                                        if (curr_time - (lastTransfer = service.getLastTransferTime()) >= ConnectionManager.this.maxInactivityTime) {
                                            if (log.isLoggable(Level.INFO)) {
                                                log.log(Level.INFO, "{0}: Max inactive time exceeded, stopping: {1}", new Object[]{ConnectionManager.this.getName(), service});
                                            }
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.stop();
                                        } else if (curr_time - lastTransfer >= 1740000L) {
                                            service.writeRawData(" ");
                                            ++ConnectionManager.this.watchdogTests;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    try {
                                        if (service != null) {
                                            log.info(ConnectionManager.this.getName() + "Found dead connection, stopping: " + service);
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.forceStop();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class IOServiceStatisticsGetter
    implements ServiceChecker<IO> {
        private StatisticsList list = new StatisticsList(Level.ALL);

        private IOServiceStatisticsGetter() {
        }

        @Override
        public synchronized void check(IO service) {
            ConnectionManager.this.bytesReceived += ((IOService)service).getBytesReceived(true);
            ConnectionManager.this.bytesSent += ((IOService)service).getBytesSent(true);
            ConnectionManager.this.socketOverflow += ((IOService)service).getBuffOverflow(true);
            ((XMPPIOService)service).getPacketsReceived(true);
            ((XMPPIOService)service).getPacketsSent(true);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        private ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        @Override
        public void accept(SocketChannel sc) {
            block7: {
                String cid = "" + this.port_props.get("local-hostname") + "@" + this.port_props.get("remote-hostname");
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Accept called for service: {0}", cid);
                }
                Object serv = ConnectionManager.this.getXMPPIOServiceInstance();
                ((XMPPIOService)serv).setIOServiceListener(ConnectionManager.this);
                ((IOService)serv).setSessionData(this.port_props);
                try {
                    ((IOService)serv).accept(sc);
                    if (this.getSocketType() == SocketType.ssl) {
                        ((IOService)serv).startSSL(false, ConnectionManager.this.isTlsWantClientAuthEnabled());
                    }
                    ConnectionManager.this.serviceStarted(serv);
                    SocketThread.addSocketService(serv);
                }
                catch (Exception e) {
                    int recon;
                    if (this.getConnectionType() != ConnectionType.connect) break block7;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Problem reconnecting the service: {0}, cid: {1}", new Object[]{serv, cid});
                    }
                    ConnectionManager.this.updateConnectionDetails(this.port_props);
                    boolean reconnect = false;
                    Integer reconnects = (Integer)this.port_props.get(ConnectionManager.MAX_RECONNECTS_PROP_KEY);
                    if (reconnects != null && (recon = reconnects.intValue()) != 0) {
                        this.port_props.put(ConnectionManager.MAX_RECONNECTS_PROP_KEY, --recon);
                        reconnect = true;
                    }
                    if (reconnect) {
                        ConnectionManager.this.reconnectService(this.port_props, ConnectionManager.this.connectionDelay);
                    }
                    ConnectionManager.this.reconnectionFailed(this.port_props);
                }
            }
        }

        public String toString() {
            return this.port_props.toString();
        }

        @Override
        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(ConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(ConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf(type);
        }

        @Override
        public String[] getIfcs() {
            return (String[])this.port_props.get(ConnectionManager.PORT_IFC_PROP_KEY);
        }

        @Override
        public int getPort() {
            return (Integer)this.port_props.get(ConnectionManager.PORT_KEY);
        }

        @Override
        public int getReceiveBufferSize() {
            return ConnectionManager.this.net_buffer;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.port_props.get("remote-address");
        }

        @Override
        public String getRemoteHostname() {
            if (this.port_props.containsKey(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY)) {
                return (String)this.port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
            }
            return (String)this.port_props.get("remote-hostname");
        }

        @Override
        public SocketType getSocketType() {
            return SocketType.valueOf(this.port_props.get(ConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        @Override
        public String getSRVType() {
            String type = (String)this.port_props.get("srv-type");
            if (type == null || type.isEmpty()) {
                return null;
            }
            return type;
        }

        @Override
        public int getTrafficClass() {
            if (ConnectionManager.this.isHighThroughput()) {
                return 8;
            }
            return 2;
        }
    }

    public static enum LIMIT_ACTION {
        DISCONNECT,
        DROP_PACKETS;

    }
}

