/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.io.SSLContextContainerIfc;

public class SSLContextContainer
implements SSLContextContainerIfc {
    private static final Logger log = Logger.getLogger(SSLContextContainer.class.getName());
    public static final String PER_DOMAIN_CERTIFICATE_KEY = "virt-hosts-cert-";
    private ArrayList<X509Certificate> acceptedIssuers = new ArrayList(200);
    private File[] certsDirs = null;
    private String def_cert_alias = null;
    private String email = "admin@tigase.org";
    private char[] emptyPass = new char[0];
    private Map<String, KeyManagerFactory> kmfs = new ConcurrentSkipListMap<String, KeyManagerFactory>();
    private String o = "Tigase.org";
    private String ou = "XMPP Service";
    private SecureRandom secureRandom = new SecureRandom();
    private Map<String, SSLContext> sslContexts = new ConcurrentSkipListMap<String, SSLContext>();
    private X509TrustManager[] tms = new X509TrustManager[]{new FakeTrustManager()};
    private KeyStore trustKeyStore = null;

    private KeyManagerFactory addCertificateEntry(CertificateEntry entry, String alias, boolean store) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keys = KeyStore.getInstance("JKS");
        keys.load(null, this.emptyPass);
        keys.setKeyEntry(alias, entry.getPrivateKey(), this.emptyPass, CertificateUtil.sort(entry.getCertChain()));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keys, this.emptyPass);
        this.kmfs.put(alias, kmf);
        if (store) {
            CertificateUtil.storeCertificate(new File(this.certsDirs[0], alias + ".pem").toString(), entry);
        }
        return kmf;
    }

    @Override
    public void addCertificates(Map<String, String> params) throws CertificateParsingException {
        String pemCert = params.get("pem-certificate");
        String saveToDiskVal = params.get("cert-save-to-disk");
        boolean saveToDisk = saveToDiskVal != null && saveToDiskVal.equalsIgnoreCase("true");
        String alias = params.get("cert-alias");
        if (alias == null) {
            throw new RuntimeException("Certificate alias must be specified");
        }
        if (pemCert != null) {
            try {
                CertificateEntry entry = CertificateUtil.parseCertificate(new CharArrayReader(pemCert.toCharArray()));
                this.addCertificateEntry(entry, alias, saveToDisk);
                this.sslContexts.remove(alias);
            }
            catch (Exception ex) {
                throw new CertificateParsingException("Problem adding a new certificate.", ex);
            }
        }
    }

    private Map<String, File> findPredefinedCertificates(Map<String, Object> params) {
        HashMap<String, File> result = new HashMap<String, File>();
        if (params == null) {
            return result;
        }
        for (String t : params.keySet()) {
            if (!t.startsWith(PER_DOMAIN_CERTIFICATE_KEY)) continue;
            String domainName = t.substring(PER_DOMAIN_CERTIFICATE_KEY.length());
            File f = new File(params.get(t).toString());
            result.put(domainName, f);
        }
        return result;
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname, boolean clientMode) {
        return this.getSSLContext(protocol, hostname, clientMode, this.tms);
    }

    public static <T> T find(Map<String, T> data, String key) {
        if (data.containsKey(key)) {
            return data.get(key);
        }
        for (Map.Entry<String, T> entry : data.entrySet()) {
            String k = entry.getKey();
            if (!k.startsWith("*") || !key.endsWith(k.substring(1))) continue;
            data.put(key, entry.getValue());
            return entry.getValue();
        }
        return null;
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname, boolean clientMode, TrustManager ... tms) {
        SSLContext sslContext = null;
        String alias = hostname;
        try {
            if (clientMode) {
                sslContext = SSLContext.getInstance(protocol);
                sslContext.init(null, tms, this.secureRandom);
                return sslContext;
            }
            if (alias == null) {
                alias = this.def_cert_alias;
            }
            if ((sslContext = SSLContextContainer.find(this.sslContexts, alias)) == null) {
                KeyManagerFactory kmf = SSLContextContainer.find(this.kmfs, alias);
                if (kmf == null) {
                    KeyPair keyPair = CertificateUtil.createKeyPair(1024, "secret");
                    X509Certificate cert = CertificateUtil.createSelfSignedCertificate(this.email, alias, this.ou, this.o, null, null, null, keyPair);
                    CertificateEntry entry = new CertificateEntry();
                    entry.setPrivateKey(keyPair.getPrivate());
                    entry.setCertChain(new Certificate[]{cert});
                    kmf = this.addCertificateEntry(entry, alias, true);
                    log.log(Level.WARNING, "Auto-generated certificate for domain: {0}", alias);
                }
                sslContext = SSLContext.getInstance(protocol);
                sslContext.init(kmf.getKeyManagers(), tms, this.secureRandom);
                this.sslContexts.put(alias, sslContext);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSLContext for domain: " + alias + ", protocol: " + protocol, e);
            sslContext = null;
        }
        return sslContext;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustKeyStore;
    }

    @Override
    public void init(Map<String, Object> params) {
        try {
            String pemD;
            this.def_cert_alias = (String)params.get("ssl-def-cert-domain");
            if (this.def_cert_alias == null) {
                this.def_cert_alias = "default";
            }
            if ((pemD = (String)params.get("ssl-certs-location")) == null) {
                pemD = "certs/";
            }
            String[] pemDirs = pemD.split(",");
            this.certsDirs = new File[pemDirs.length];
            int certsDirsIdx = -1;
            Map<String, File> predefined = this.findPredefinedCertificates(params);
            log.log(Level.CONFIG, "Loading predefined server certificates");
            for (Map.Entry<String, File> entry : predefined.entrySet()) {
                try {
                    CertificateEntry certEntry = CertificateUtil.loadCertificate(entry.getValue());
                    String alias = entry.getKey();
                    this.addCertificateEntry(certEntry, alias, false);
                    log.log(Level.CONFIG, "Loaded server certificate for domain: {0} from file: {1}", new Object[]{alias, entry.getValue()});
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Cannot load certficate from file: " + entry.getValue(), ex);
                }
            }
            for (String pemDir : pemDirs) {
                log.log(Level.CONFIG, "Loading server certificates from PEM directory: {0}", pemDir);
                this.certsDirs[++certsDirsIdx] = new File(pemDir);
                for (File file : this.certsDirs[certsDirsIdx].listFiles(new PEMFileFilter())) {
                    try {
                        CertificateEntry certEntry = CertificateUtil.loadCertificate(file);
                        String alias = file.getName();
                        if (alias.endsWith(".pem")) {
                            alias = alias.substring(0, alias.length() - 4);
                        }
                        this.addCertificateEntry(certEntry, alias, false);
                        log.log(Level.CONFIG, "Loaded server certificate for domain: {0} from file: {1}", new Object[]{alias, file});
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Cannot load certficate from file: " + file, ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "There was a problem initializing SSL certificates.", ex);
        }
        String trustLoc = (String)params.get("trusted-certs-dir");
        if (trustLoc == null) {
            trustLoc = "/etc/ssl/certs";
        }
        final String[] trustLocations = trustLoc.split(",");
        new Thread(){

            @Override
            public void run() {
                SSLContextContainer.this.loadTrustedCerts(trustLocations);
            }
        }.start();
    }

    private void loadTrustedCerts(String[] trustLocations) {
        int counter = 0;
        long start = System.currentTimeMillis();
        try {
            FileInputStream in;
            this.trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.trustKeyStore.load(null, this.emptyPass);
            File trustStoreFile = new File(System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar));
            File userStoreFile = new File("~/.keystore");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Looking for trusted certs in: {0}", trustStoreFile);
            }
            if (trustStoreFile.exists()) {
                log.log(Level.CONFIG, "Loading trustKeyStore from location: {0}", trustStoreFile);
                in = new FileInputStream(trustStoreFile);
                this.trustKeyStore.load(in, null);
                ((InputStream)in).close();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Looking for trusted certs in: {0}", userStoreFile);
            }
            if (userStoreFile.exists()) {
                log.log(Level.CONFIG, "Loading trustKeyStore from location: {0}", userStoreFile);
                in = new FileInputStream(userStoreFile);
                this.trustKeyStore.load(in, null);
                ((InputStream)in).close();
            }
            log.log(Level.CONFIG, "Loading trustKeyStore from locations: {0}", Arrays.toString(trustLocations));
            for (String location : trustLocations) {
                File root = new File(location);
                File[] files = root.listFiles(new PEMFileFilter());
                if (files == null) continue;
                for (File file : files) {
                    try {
                        CertificateEntry certEntry = CertificateUtil.loadCertificate(file);
                        Certificate[] chain = certEntry.getCertChain();
                        if (chain == null) continue;
                        for (Certificate cert : chain) {
                            if (!(cert instanceof X509Certificate)) continue;
                            X509Certificate crt = (X509Certificate)cert;
                            String alias = crt.getSubjectX500Principal().getName();
                            this.trustKeyStore.setCertificateEntry(alias, crt);
                            this.acceptedIssuers.add(crt);
                            log.log(Level.FINEST, "Imported certificate: {0}", alias);
                            ++counter;
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Problem loading certificate from file: {0}", file);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "An error loading trusted certificates", ex);
        }
        try {
            if (!this.trustKeyStore.aliases().hasMoreElements()) {
                log.log(Level.CONFIG, "No Trusted Anchors!!! Creating temporary trusted CA cert!");
                KeyPair keyPair = CertificateUtil.createKeyPair(1024, "secret");
                X509Certificate cert = CertificateUtil.createSelfSignedCertificate("fake_local@tigase", "fake one", "none", "none", "none", "none", "US", keyPair);
                this.trustKeyStore.setCertificateEntry("generated fake CA", cert);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't generate fake trusted CA certificate", e);
        }
        this.tms = new X509TrustManager[]{new FakeTrustManager(this.acceptedIssuers.toArray(new X509Certificate[this.acceptedIssuers.size()]))};
        long seconds = (System.currentTimeMillis() - start) / 1000L;
        log.log(Level.CONFIG, "Loaded {0} trust certificates, it took {1} seconds.", new Object[]{counter, seconds});
    }

    private class PEMFileFilter
    implements FileFilter {
        private PEMFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && (pathname.getName().endsWith(".pem") || pathname.getName().endsWith(".PEM") || pathname.getName().endsWith(".crt") || pathname.getName().endsWith(".CRT") || pathname.getName().endsWith(".cer") || pathname.getName().endsWith(".CER"));
        }
    }

    private static class FakeTrustManager
    implements X509TrustManager {
        private X509Certificate[] issuers = null;

        FakeTrustManager() {
        }

        FakeTrustManager(X509Certificate[] ai) {
            this.issuers = ai;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.issuers;
        }
    }
}

