/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryImpl;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.SimpleCache;
import tigase.xmpp.BareJID;

public class JDBCRepository
implements AuthRepository,
UserRepository {
    public static final String CURRENT_DB_SCHEMA_VER = "5.1";
    public static final String DEF_MAXIDS_TBL = "tig_max_ids";
    public static final String DEF_NODES_TBL = "tig_nodes";
    public static final String DEF_PAIRS_TBL = "tig_pairs";
    public static final String DEF_ROOT_NODE = "root";
    public static final String DEF_USERS_TBL = "tig_users";
    public static final String DERBY_GETSCHEMAVER_QUERY = "values TigGetDBProperty('schema-version')";
    public static final String JDBC_GETSCHEMAVER_QUERY = "select TigGetDBProperty('schema-version')";
    public static final String SCHEMA_UPGRADE_LINK = "http://www.tigase.org/content/tigase-51-database-schema-upgrade";
    private static final String ADD_NODE_QUERY = "{ call TigAddNode(?, ?, ?) }";
    private static final String ADD_USER_PLAIN_PW_QUERY = "{ call TigAddUserPlainPw(?, ?) }";
    private static final String COUNT_USERS_FOR_DOMAIN_QUERY = "select count(*) from tig_users where user_id like ?";
    private static final String DEF_GET_USERS_QUERY = "{ call TigAllUsers() }";
    private static final String GET_USER_DB_UID_QUERY = "{ call TigGetUserDBUid(?) }";
    private static final String GET_USERS_COUNT_QUERY = "{ call TigAllUsersCount() }";
    private static final Logger log = Logger.getLogger(JDBCRepository.class.getName());
    private static final String PGSQL_GET_USERS_QUERY = "select TigAllUsers()";
    private static final String REMOVE_USER_QUERY = "{ call TigRemoveUser(?) }";
    private static final String UPDATE_PAIRS_QUERY = "{ call TigUpdatePairs(?, ?, ?, ?) }";
    private static final String USER_STR = "User: ";
    private static final String REMOVE_KEY_DATA_QUERY = "delete from tig_pairs where (nid = ?) AND (pkey = ?)";
    private static final String NODES_FOR_NODE_QUERY = "select nid, node from tig_nodes where parent_nid = ?";
    private static final String KEYS_FOR_NODE_QUERY = "select pkey from tig_pairs where (nid = ?)";
    private static final String INSERT_KEY_VAL_QUERY = "insert into tig_pairs (nid, uid, pkey, pval)  values (?, ?, ?, ?)";
    private static final String DATA_FOR_NODE_QUERY = "select pval from tig_pairs where (nid = ?) AND (pkey = ?)";
    private AuthRepository auth = null;
    private Map<String, Object> cache = null;
    private DataRepository data_repo = null;
    private String get_users_query = null;
    private boolean derby_mode = false;
    private boolean autoCreateUser = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataList(DataRepository repo, BareJID user_id, String subnode, String key, String[] list) throws UserNotFoundException, SQLException, UserNotFoundException {
        long uid = -2L;
        long nid = -2L;
        try {
            uid = this.getUserUID(repo, user_id, this.autoCreateUser);
            nid = this.getNodeNID(repo, uid, subnode);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Saving data adding data list, user_id: {0}, subnode: {1}, key: {2}, uid: {3}, nid: {4}, list: {5}", new Object[]{user_id, subnode, key, uid, nid, Arrays.toString(list)});
            }
            if (nid < 0L) {
                try {
                    nid = this.createNodePath(repo, user_id, subnode);
                }
                catch (SQLException e) {
                    nid = this.getNodeNID(repo, uid, subnode);
                }
            }
            PreparedStatement insert_key_val_st = null;
            insert_key_val_st = repo == null ? this.data_repo.getPreparedStatement(user_id, INSERT_KEY_VAL_QUERY) : repo.getPreparedStatement(user_id, INSERT_KEY_VAL_QUERY);
            PreparedStatement preparedStatement = insert_key_val_st;
            synchronized (preparedStatement) {
                insert_key_val_st.setLong(1, nid);
                insert_key_val_st.setLong(2, uid);
                insert_key_val_st.setString(3, key);
                for (String val : list) {
                    insert_key_val_st.setString(4, val);
                    insert_key_val_st.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Error adding data list, user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", uid: " + uid + ", nid: " + nid + ", list: " + Arrays.toString(list), e);
            throw e;
        }
    }

    @Override
    public void addDataList(BareJID user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            this.addDataList(null, user_id, subnode, key, list);
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Problem adding data list to repository", ex);
        }
    }

    @Override
    public void addUser(BareJID user_id) throws UserExistsException, TigaseDBException {
        try {
            this.addUserRepo(null, user_id);
        }
        catch (SQLException e) {
            throw new UserExistsException("Error adding user to repository: ", e);
        }
    }

    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    @Override
    @Deprecated
    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.digestAuth(user, digest, id, alg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getData(BareJID user_id, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String string;
            PreparedStatement data_for_node_st;
            long nid = this.getNodeNID(null, user_id, subnode);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Loading data for key: {0}, user: {1}, node: {2}, def: {3}, found nid: {4}", new Object[]{key, user_id, subnode, def, nid});
            }
            PreparedStatement preparedStatement = data_for_node_st = this.data_repo.getPreparedStatement(user_id, DATA_FOR_NODE_QUERY);
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    String result = def;
                    data_for_node_st.setLong(1, nid);
                    data_for_node_st.setString(2, key);
                    rs = data_for_node_st.executeQuery();
                    if (rs.next()) {
                        result = rs.getString(1);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Found data: {0}", result);
                        }
                    }
                    String string2 = result;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl18 : MonitorExitStatement: MONITOREXIT : var9_9
                    this.data_repo.release(null, rs);
                    return string2;
                }
                string = def;
            }
            this.data_repo.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Error getting user data for: " + user_id + "/" + subnode + "/" + key, e);
            }
        }
    }

    @Override
    public String getData(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, subnode, key, null);
    }

    @Override
    public String getData(BareJID user_id, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, null, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getDataList(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String[] stringArray;
            PreparedStatement data_for_node_st;
            long nid = this.getNodeNID(null, user_id, subnode);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Loading data for key: {0}, user: {1}, node: {2}, found nid: {3}", new Object[]{key, user_id, subnode, nid});
            }
            PreparedStatement preparedStatement = data_for_node_st = this.data_repo.getPreparedStatement(user_id, DATA_FOR_NODE_QUERY);
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    String[] result;
                    ArrayList<String> results = new ArrayList<String>();
                    data_for_node_st.setLong(1, nid);
                    data_for_node_st.setString(2, key);
                    rs = data_for_node_st.executeQuery();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.log(Level.FINEST, "Found data: {0}", rs.getString(1));
                    }
                    String[] stringArray2 = result = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl20 : MonitorExitStatement: MONITOREXIT : var8_8
                    this.data_repo.release(null, rs);
                    return stringArray2;
                }
                stringArray = null;
            }
            this.data_repo.release(null, rs);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Error getting data list for: " + user_id + "/" + subnode + "/" + key, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getKeys(BareJID user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        rs = null;
        try {
            nid = this.getNodeNID(null, user_id, subnode);
            if (nid <= 0L) ** GOTO lbl-1000
            results = new ArrayList<String>();
            var8_9 = keys_for_node_st = this.data_repo.getPreparedStatement(user_id, "select pkey from tig_pairs where (nid = ?)");
            synchronized (var8_9) {
                keys_for_node_st.setLong(1, nid);
                rs = keys_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                var9_10 = results.size() == 0 ? null : results.toArray(new String[results.size()]);
            }
            this.data_repo.release(null, rs);
            return var9_10;
lbl-1000:
            // 1 sources

            {
                var6_7 = null;
            }
            this.data_repo.release(null, rs);
            return var6_7;
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Error getting subnodes list.", e);
            }
            catch (Throwable var11_11) {
                this.data_repo.release(null, rs);
                throw var11_11;
            }
        }
    }

    @Override
    public String[] getKeys(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user_id, null);
    }

    @Override
    public String getResourceUri() {
        return this.data_repo.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getSubnodes(BareJID user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String[] stringArray;
            PreparedStatement nodes_for_node_st;
            long nid = this.getNodeNID(null, user_id, subnode);
            PreparedStatement preparedStatement = nodes_for_node_st = this.data_repo.getPreparedStatement(user_id, NODES_FOR_NODE_QUERY);
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    ArrayList<String> results = new ArrayList<String>();
                    nodes_for_node_st.setLong(1, nid);
                    rs = nodes_for_node_st.executeQuery();
                    while (rs.next()) {
                        results.add(rs.getString(2));
                    }
                    String[] stringArray2 = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl15 : MonitorExitStatement: MONITOREXIT : var7_7
                    this.data_repo.release(null, rs);
                    return stringArray2;
                }
                stringArray = null;
            }
            this.data_repo.release(null, rs);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Error getting subnodes list.", e);
            }
        }
    }

    @Override
    public String[] getSubnodes(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user_id, null);
    }

    @Override
    public long getUserUID(BareJID user_id) throws TigaseDBException {
        Long cache_res = (Long)this.cache.get(user_id.toString());
        if (cache_res != null) {
            return cache_res;
        }
        long result = -1L;
        try {
            result = this.getUserUID(null, user_id);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error retrieving user UID from repository: ", e);
        }
        this.cache.put(user_id.toString(), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUserUID(DataRepository repo, BareJID user_id) throws SQLException {
        ResultSet rs = null;
        long result = -1L;
        try {
            PreparedStatement uid_sp = null;
            uid_sp = repo == null ? this.data_repo.getPreparedStatement(user_id, GET_USER_DB_UID_QUERY) : repo.getPreparedStatement(user_id, GET_USER_DB_UID_QUERY);
            PreparedStatement preparedStatement = uid_sp;
            synchronized (preparedStatement) {
                uid_sp.setString(1, user_id.toString());
                rs = uid_sp.executeQuery();
                result = rs.next() ? rs.getLong(1) : -1L;
            }
            this.data_repo.release(null, rs);
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BareJID> getUsers() throws TigaseDBException {
        ResultSet rs = null;
        ArrayList<BareJID> users = null;
        try {
            PreparedStatement all_users_sp;
            PreparedStatement preparedStatement = all_users_sp = this.data_repo.getPreparedStatement(null, this.get_users_query);
            synchronized (preparedStatement) {
                rs = all_users_sp.executeQuery();
                users = new ArrayList<BareJID>(1000);
                while (rs.next()) {
                    users.add(BareJID.bareJIDInstanceNS(rs.getString(1)));
                }
            }
            this.data_repo.release(null, rs);
            rs = null;
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Problem loading user list from repository", e);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                rs = null;
                throw throwable;
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        ResultSet rs = null;
        try {
            PreparedStatement users_count_sp;
            long users = -1L;
            PreparedStatement preparedStatement = users_count_sp = this.data_repo.getPreparedStatement(null, GET_USERS_COUNT_QUERY);
            synchronized (preparedStatement) {
                rs = users_count_sp.executeQuery();
                if (rs.next()) {
                    users = rs.getLong(1);
                }
            }
            long l = users;
            this.data_repo.release(null, rs);
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.data_repo.release(null, rs);
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        ResultSet rs = null;
        try {
            PreparedStatement users_domain_count_st;
            long users = -1L;
            PreparedStatement preparedStatement = users_domain_count_st = this.data_repo.getPreparedStatement(null, COUNT_USERS_FOR_DOMAIN_QUERY);
            synchronized (preparedStatement) {
                users_domain_count_st.setString(1, "%@" + domain);
                rs = users_domain_count_st.executeQuery();
                if (rs.next()) {
                    users = rs.getLong(1);
                }
            }
            long l = users;
            this.data_repo.release(null, rs);
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.data_repo.release(null, rs);
            rs = null;
        }
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        try {
            this.derby_mode = connection_str.startsWith("jdbc:derby");
            this.data_repo = RepositoryFactory.getDataRepository(null, connection_str, params);
            this.checkDBSchema();
            if (connection_str.contains("autoCreateUser=true")) {
                this.autoCreateUser = true;
            }
            if (connection_str.contains("cacheRepo=off")) {
                log.fine("Disabling cache.");
                this.cache = Collections.synchronizedMap(new RepoCache(0, -1000L));
            } else {
                this.cache = Collections.synchronizedMap(new RepoCache(10000, 60000L));
            }
            this.data_repo.initPreparedStatement(GET_USER_DB_UID_QUERY, GET_USER_DB_UID_QUERY);
            this.data_repo.initPreparedStatement(GET_USERS_COUNT_QUERY, GET_USERS_COUNT_QUERY);
            this.get_users_query = connection_str.startsWith("jdbc:postgresql") ? PGSQL_GET_USERS_QUERY : DEF_GET_USERS_QUERY;
            this.data_repo.initPreparedStatement(this.get_users_query, this.get_users_query);
            this.data_repo.initPreparedStatement(ADD_USER_PLAIN_PW_QUERY, ADD_USER_PLAIN_PW_QUERY);
            this.data_repo.initPreparedStatement(REMOVE_USER_QUERY, REMOVE_USER_QUERY);
            this.data_repo.initPreparedStatement(ADD_NODE_QUERY, ADD_NODE_QUERY);
            this.data_repo.initPreparedStatement(COUNT_USERS_FOR_DOMAIN_QUERY, COUNT_USERS_FOR_DOMAIN_QUERY);
            this.data_repo.initPreparedStatement(DATA_FOR_NODE_QUERY, DATA_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(KEYS_FOR_NODE_QUERY, KEYS_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(NODES_FOR_NODE_QUERY, NODES_FOR_NODE_QUERY);
            this.data_repo.initPreparedStatement(INSERT_KEY_VAL_QUERY, INSERT_KEY_VAL_QUERY);
            this.data_repo.initPreparedStatement(REMOVE_KEY_DATA_QUERY, REMOVE_KEY_DATA_QUERY);
            this.data_repo.initPreparedStatement(UPDATE_PAIRS_QUERY, UPDATE_PAIRS_QUERY);
            this.auth = new AuthRepositoryImpl(this);
            log.log(Level.INFO, "Initialized database connection: {0}", connection_str);
        }
        catch (Exception e) {
            this.data_repo = null;
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
    }

    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(props);
    }

    @Override
    @Deprecated
    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.plainAuth(user, password);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    @Override
    public void removeData(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(null, user_id, subnode, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeData(DataRepository repo, BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            long nid = this.getNodeNID(repo, user_id, subnode);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Removing data, user_id: {0}, subnode: {1}, key: {2}, nid: {3}", new Object[]{user_id, subnode, key, nid});
            }
            PreparedStatement remove_key_data_st = null;
            remove_key_data_st = repo == null ? this.data_repo.getPreparedStatement(user_id, REMOVE_KEY_DATA_QUERY) : repo.getPreparedStatement(user_id, REMOVE_KEY_DATA_QUERY);
            PreparedStatement preparedStatement = remove_key_data_st;
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    remove_key_data_st.setLong(1, nid);
                    remove_key_data_st.setString(2, key);
                    remove_key_data_st.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    @Override
    public void removeData(BareJID user_id, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user_id, null, key);
    }

    @Override
    public void removeSubnode(BareJID user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        if (subnode == null) {
            return;
        }
        try {
            long nid = this.getNodeNID(null, user_id, subnode);
            if (nid > 0L) {
                this.deleteSubnode(null, nid);
                this.cache.remove(user_id + "/" + subnode);
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing user: {0}", user_id);
        }
        try {
            PreparedStatement user_del_sp;
            stmt = this.data_repo.createStatement(user_id);
            long uid = this.getUserUID(null, user_id, this.autoCreateUser);
            query = "delete from tig_pairs where uid = " + uid;
            stmt.executeUpdate(query);
            query = "delete from tig_nodes where uid = " + uid;
            stmt.executeUpdate(query);
            PreparedStatement preparedStatement = user_del_sp = this.data_repo.getPreparedStatement(user_id, REMOVE_USER_QUERY);
            synchronized (preparedStatement) {
                user_del_sp.setString(1, user_id.toString());
                user_del_sp.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error removing user from repository: " + query, e);
        }
        finally {
            this.data_repo.release(stmt, rs);
            stmt = null;
            this.cache.remove(user_id.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(BareJID user_id, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        DataRepository repo;
        long uid = -2L;
        long nid = -2L;
        DataRepository dataRepository = repo = this.data_repo.takeRepoHandle(user_id);
        synchronized (dataRepository) {
            try {
                uid = this.getUserUID(repo, user_id, this.autoCreateUser);
                nid = this.getNodeNID(repo, uid, subnode);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Saving data setting data, user_id: {0}, subnode: {1}, key: {2}, uid: {3}, nid: {4}, value: {5}", new Object[]{user_id, subnode, key, uid, nid, value});
                }
                if (nid < 0L) {
                    try {
                        nid = this.createNodePath(repo, user_id, subnode);
                    }
                    catch (SQLException e) {
                        nid = this.getNodeNID(repo, uid, subnode);
                    }
                }
                PreparedStatement update_pairs_sp = repo.getPreparedStatement(user_id, UPDATE_PAIRS_QUERY);
                update_pairs_sp.setLong(1, nid);
                update_pairs_sp.setLong(2, uid);
                update_pairs_sp.setString(3, key);
                update_pairs_sp.setString(4, value);
                update_pairs_sp.executeUpdate();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Error setting data , user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", uid: " + uid + ", nid: " + nid + ", value: " + value, e);
            }
        }
    }

    @Override
    public void setData(BareJID user_id, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user_id, null, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataList(BareJID user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        DataRepository repo;
        DataRepository dataRepository = repo = this.data_repo.takeRepoHandle(user_id);
        synchronized (dataRepository) {
            try {
                this.removeData(repo, user_id, subnode, key);
                try {
                    this.addDataList(repo, user_id, subnode, key, list);
                }
                catch (SQLException ex) {
                    throw new TigaseDBException("Problem adding data to DB, user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", list: " + Arrays.toString(list), ex);
                }
            }
            finally {
                this.data_repo.releaseRepoHandle(repo);
            }
        }
    }

    @Override
    public void updatePassword(BareJID user, String password) throws TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    @Override
    public boolean userExists(BareJID user) {
        try {
            this.getUserUID(null, user, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long addNode(DataRepository repo, long uid, long parent_nid, String node_name) throws SQLException {
        ResultSet rs = null;
        PreparedStatement node_add_sp = null;
        node_add_sp = repo == null ? this.data_repo.getPreparedStatement(null, ADD_NODE_QUERY) : repo.getPreparedStatement(null, ADD_NODE_QUERY);
        PreparedStatement preparedStatement = node_add_sp;
        synchronized (preparedStatement) {
            block7: {
                long l;
                try {
                    if (parent_nid < 0L) {
                        node_add_sp.setNull(1, -5);
                    } else {
                        node_add_sp.setLong(1, parent_nid);
                    }
                    node_add_sp.setLong(2, uid);
                    node_add_sp.setString(3, node_name);
                    rs = node_add_sp.executeQuery();
                    if (!rs.next()) break block7;
                    l = rs.getLong(1);
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                return l;
            }
            log.warning("Missing NID after adding new node...");
            long l = -1L;
            this.data_repo.release(null, rs);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addUserRepo(DataRepository repo, BareJID user_id) throws SQLException {
        ResultSet rs = null;
        long uid = -1L;
        PreparedStatement user_add_sp = null;
        user_add_sp = repo == null ? this.data_repo.getPreparedStatement(user_id, ADD_USER_PLAIN_PW_QUERY) : repo.getPreparedStatement(user_id, ADD_USER_PLAIN_PW_QUERY);
        PreparedStatement preparedStatement = user_add_sp;
        synchronized (preparedStatement) {
            try {
                user_add_sp.setString(1, user_id.toString());
                user_add_sp.setNull(2, 12);
                rs = user_add_sp.executeQuery();
                if (rs.next()) {
                    uid = rs.getLong(1);
                } else {
                    log.warning("Missing UID after adding new user...");
                }
                this.data_repo.release(null, rs);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.cache.put(user_id.toString(), uid);
        return uid;
    }

    private String buildNodeQuery(long uid, String node_path) {
        String query = "select nid as nid1 from tig_nodes where (uid = " + uid + ")" + " AND (parent_nid is null)" + " AND (node = '" + DEF_ROOT_NODE + "')";
        if (node_path == null) {
            return query;
        }
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        int cnt = 1;
        String subquery = query;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            subquery = "select nid as nid" + ++cnt + ", node as node" + cnt + " from " + DEF_NODES_TBL + ", (" + subquery + ") nodes" + (cnt - 1) + " where (parent_nid = nid" + (cnt - 1) + ")" + " AND (node = '" + token + "')";
        }
        return subquery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDBSchema() throws SQLException {
        String schema_version = "1.0";
        String query = this.derby_mode ? DERBY_GETSCHEMAVER_QUERY : JDBC_GETSCHEMAVER_QUERY;
        Statement stmt = this.data_repo.createStatement(null);
        ResultSet rs = stmt.executeQuery(query);
        try {
            if (rs.next() && !CURRENT_DB_SCHEMA_VER.equals(schema_version = rs.getString(1))) {
                System.err.println("\n\nPlease upgrade database schema now.");
                System.err.println("Current scheme version is: " + schema_version + ", expected: " + CURRENT_DB_SCHEMA_VER);
                System.err.println("Check the schema upgrade guide at the address:");
                System.err.println(SCHEMA_UPGRADE_LINK);
                System.err.println("----");
                System.err.println("If you have upgraded your schema and you are still");
                System.err.println("experiencing this problem please contact support at");
                System.err.println("e-mail address: support@tigase.org");
                System.exit(100);
            }
        }
        finally {
            this.data_repo.release(stmt, rs);
        }
    }

    private long createNodePath(DataRepository repo, BareJID user_id, String node_path) throws SQLException, UserNotFoundException {
        if (node_path == null) {
            return this.getNodeNID(repo, user_id, null);
        }
        long uid = this.getUserUID(repo, user_id, this.autoCreateUser);
        long nid = this.getNodeNID(repo, uid, null);
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        StringBuilder built_path = new StringBuilder();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            built_path.append("/").append(token);
            long cur_nid = this.getNodeNID(repo, uid, built_path.toString());
            if (cur_nid > 0L) {
                nid = cur_nid;
                continue;
            }
            nid = this.addNode(repo, uid, nid, token);
        }
        return nid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubnode(DataRepository repo, long nid) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            stmt = repo == null ? this.data_repo.createStatement(null) : repo.createStatement(null);
            query = "delete from tig_pairs where nid = " + nid;
            stmt.executeUpdate(query);
            query = "delete from tig_nodes where nid = " + nid;
            stmt.executeUpdate(query);
        }
        finally {
            this.data_repo.release(stmt, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNodeNID(DataRepository repo, long uid, String node_path) throws SQLException, UserNotFoundException {
        String query = this.buildNodeQuery(uid, node_path);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        long nid = -1L;
        try {
            stmt = repo == null ? this.data_repo.createStatement(null) : repo.createStatement(null);
            rs = stmt.executeQuery(query);
            nid = rs.next() ? rs.getLong(1) : -1L;
            if (nid <= 0L) {
                if (node_path == null) {
                    log.info("Missing root node, database upgrade or bug in the code? Adding missing root node now.");
                    nid = this.addNode(repo, uid, -1L, DEF_ROOT_NODE);
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Missing nid for node path: {0} and uid: {1}", new Object[]{node_path, uid});
                }
            }
            long l = nid;
            this.data_repo.release(stmt, rs);
            stmt = null;
            rs = null;
            return l;
        }
        catch (Throwable throwable) {
            this.data_repo.release(stmt, rs);
            stmt = null;
            rs = null;
            throw throwable;
        }
    }

    private long getNodeNID(DataRepository repo, BareJID user_id, String node_path) throws SQLException, UserNotFoundException {
        Long cache_res = (Long)this.cache.get(user_id + "/" + node_path);
        if (cache_res != null) {
            return cache_res;
        }
        long uid = this.getUserUID(repo, user_id, this.autoCreateUser);
        long result = this.getNodeNID(repo, uid, node_path);
        if (result > 0L) {
            this.cache.put(user_id + "/" + node_path, result);
        }
        return result;
    }

    private long getUserUID(DataRepository repo, BareJID user_id, boolean autoCreate) throws SQLException, UserNotFoundException {
        long result = this.getUserUID(repo, user_id);
        if (result <= 0L) {
            if (autoCreate) {
                result = this.addUserRepo(repo, user_id);
            } else {
                throw new UserNotFoundException("User does not exist: " + user_id);
            }
        }
        return result;
    }

    private class RepoCache
    extends SimpleCache<String, Object> {
        public RepoCache(int maxsize, long cache_time) {
            super(maxsize, cache_time);
        }

        @Override
        public Object remove(Object key) {
            if (this.cache_off) {
                return null;
            }
            Object val = super.remove(key);
            String strk = key.toString();
            Iterator ks = this.keySet().iterator();
            while (ks.hasNext()) {
                String k = ((String)ks.next()).toString();
                if (!k.startsWith(strk)) continue;
                ks.remove();
            }
            return val;
        }
    }
}

