/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class SMNonCachingAllNodes
implements ClusteringStrategyIfc {
    private static final Logger log = Logger.getLogger(SMNonCachingAllNodes.class.getName());
    private CopyOnWriteArrayList<JID> cl_nodes_list = new CopyOnWriteArrayList();
    private SessionManagerHandler sm = null;
    private Random rand = new Random();

    @Override
    public void setSessionManagerHandler(SessionManagerHandler sm) {
        this.sm = sm;
    }

    @Override
    public boolean containsJid(BareJID jid) {
        return false;
    }

    @Override
    public List<JID> getAllNodes() {
        return this.cl_nodes_list;
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        return null;
    }

    @Override
    public List<JID> getNodesForJid(JID jid) {
        return this.getAllNodes();
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add("cl-caching-strat", "Connected nodes", this.cl_nodes_list.size(), Level.INFO);
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return false;
    }

    @Override
    public boolean needsSync() {
        return false;
    }

    @Override
    public void nodeConnected(JID jid) {
        boolean result = this.cl_nodes_list.addIfAbsent(jid);
        log.log(Level.FINE, "Cluster nodes: {0}, added: {1}", new Object[]{this.cl_nodes_list, result});
    }

    @Override
    public void nodeDisconnected(JID jid) {
        boolean result = this.cl_nodes_list.remove(jid);
        log.log(Level.FINE, "Cluster nodes: {0}, removed: {1}", new Object[]{this.cl_nodes_list, result});
    }

    @Override
    public void setProperties(Map<String, Object> props) {
    }

    @Override
    public void userDisconnected(Queue<Packet> results, ConnectionRecord rec) {
    }

    @Override
    public void usersConnected(Queue<Packet> results, ConnectionRecord ... rec) {
    }

    @Override
    public List<JID> getNodesForPacketForward(JID fromNode, Set<JID> visitedNodes, Packet packet) {
        if (visitedNodes != null) {
            List<JID> result = this.selectNodes(fromNode, visitedNodes);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Visited nodes not null: {0}, selecting new node: {1}, for packet: {2}", new Object[]{visitedNodes, result, packet});
            }
            return result;
        }
        if (packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null) {
            List<JID> result = this.getAllNodes();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Presence packet found: {0}, selecting all nodes: {1}", new Object[]{packet, result});
            }
            return result;
        }
        if (this.isSuitableForForward(packet)) {
            List<JID> result = this.selectNodes(fromNode, visitedNodes);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Visited nodes null, selecting new node: {0}, for packet: {1}", new Object[]{result, packet});
            }
            return result;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return null;
    }

    protected boolean isSuitableForForward(Packet packet) {
        if (packet.getType() == StanzaType.error) {
            return false;
        }
        if (packet.getPacketFrom() != null && !this.sm.getComponentId().equals(packet.getPacketFrom())) {
            return false;
        }
        if (packet.getStanzaTo() == null || this.sm.isLocalDomain(packet.getStanzaTo().toString(), false) || this.sm.getComponentId().equals(packet.getStanzaTo().getBareJID())) {
            return false;
        }
        if (packet.getStanzaFrom() == null || this.sm.isLocalDomain(packet.getStanzaFrom().toString(), false) || this.sm.getComponentId().equals(packet.getStanzaFrom().getBareJID())) {
            return false;
        }
        return this.sm.isLocalDomain(packet.getStanzaTo().getDomain(), false);
    }

    private List<JID> selectNodes(JID fromNode, Set<JID> visitedNodes) {
        List<JID> result;
        block13: {
            result = null;
            int size = this.cl_nodes_list.size();
            if (size == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No connected cluster nodes found, returning null");
                }
                return null;
            }
            int idx = this.rand.nextInt(size);
            if (visitedNodes == null || visitedNodes.size() == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No visited nodes yet, trying random idx: " + idx);
                }
                try {
                    result = Collections.singletonList(this.cl_nodes_list.get(idx));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    try {
                        result = Collections.singletonList(this.cl_nodes_list.get(0));
                        break block13;
                    }
                    catch (IndexOutOfBoundsException ioobe2) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "IndexOutOfBoundsException twice! Should not happen very often, returning null");
                        }
                        break block13;
                    }
                }
            }
            for (JID jid : this.cl_nodes_list) {
                if (visitedNodes.contains(jid)) continue;
                result = Collections.singletonList(jid);
                break;
            }
            if (result == null && !this.sm.getComponentId().equals(fromNode)) {
                result = Collections.singletonList(fromNode);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "All nodes visited, sending it back to the first node: " + result);
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "List of result nodes: " + result);
        }
        return result;
    }

    @Override
    public List<JID> getNodesForUserConnect(JID jid) {
        return this.getAllNodes();
    }

    @Override
    public List<JID> getNodesForUserDisconnect(JID jid) {
        return this.getAllNodes();
    }

    @Override
    @Deprecated
    public Object getInternalCacheData() {
        return null;
    }

    @Override
    public Set<ConnectionRecord> getConnectionRecords(BareJID bareJID) {
        return null;
    }

    @Override
    public ConnectionRecord getConnectionRecord(JID jid) {
        return null;
    }

    @Override
    public void presenceUpdate(Element presence, ConnectionRecord rec) {
    }
}

