/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.repo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.repo.ClConConfigRepository;
import tigase.cluster.repo.ClusterRepoConstants;
import tigase.cluster.repo.ClusterRepoItem;

public class ClConDirRepository
extends ClConConfigRepository
implements ClusterRepoConstants {
    public static final String REPO_FILE_EXTENSION = ".rep";
    public static final String REPO_URI_DB_DEF_VAL = "etc/";
    private static final Logger log = Logger.getLogger(ClConDirRepository.class.getName());
    private File repo_dir = new File("etc/");
    private DirFilter dirFilter = new DirFilter();

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        defs.put("repo-uri", REPO_URI_DB_DEF_VAL);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        this.repo_dir = new File((String)properties.get("repo-uri"));
    }

    @Override
    public void storeItem(ClusterRepoItem item) {
        try {
            File file = new File(this.repo_dir, item.getHostname() + REPO_FILE_EXTENSION);
            BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));
            bw.write(item.toPropertyString());
            bw.newLine();
            bw.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
    }

    @Override
    public void reload() {
        super.reload();
        try {
            File[] files;
            for (File file : files = this.repo_dir.listFiles(this.dirFilter)) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                String data = br.readLine();
                br.close();
                ClusterRepoItem item = this.getItemInstance();
                item.initFromPropertyString(data);
                this.itemLoaded(item);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
    }

    private class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(ClConDirRepository.REPO_FILE_EXTENSION);
        }
    }
}

