/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.server.ServiceChecker;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPIOService;

public class ClientConnectionClustered
extends ClientConnectionManager
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(ClientConnectionClustered.class.getName());
    private SeeOtherHostIfc see_other_host_strategy = null;
    private List<BareJID> connectedNodes = new CopyOnWriteArrayList<BareJID>(){
        {
            this.add(ClientConnectionClustered.this.getDefHostName());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(String node) {
        BareJID nodeJID = BareJID.bareJIDInstanceNS(null, node);
        List<BareJID> list = this.connectedNodes;
        synchronized (list) {
            if (!this.connectedNodes.contains(nodeJID)) {
                this.connectedNodes.add(nodeJID);
                Object[] arr_list = this.connectedNodes.toArray(new BareJID[this.connectedNodes.size()]);
                Arrays.sort(arr_list);
                this.connectedNodes = new CopyOnWriteArrayList<Object>(arr_list);
                if (this.see_other_host_strategy != null) {
                    this.see_other_host_strategy.setNodes(this.connectedNodes);
                }
            }
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Disconnected nodes: {0}", node);
        }
        BareJID nodeJID = BareJID.bareJIDInstanceNS(null, node);
        this.connectedNodes.remove(nodeJID);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(this.connectedNodes);
        }
        final String hostname = node;
        this.doForAllServices(new ServiceChecker<XMPPIOService<Object>>(){

            @Override
            public void check(XMPPIOService<Object> service) {
                JID dataReceiver = service.getDataReceiver();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Checking service for dataReceiver: {0}", dataReceiver);
                }
                if (dataReceiver != null && dataReceiver.getDomain().equals(hostname)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Stopping service because corresponding cluster node stopped.");
                    }
                    service.stop();
                }
            }
        });
    }

    @Override
    public SeeOtherHostIfc getSeeOtherHostInstance(String see_other_host_class) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Configuring see_other_host clustered strategy for: " + see_other_host_class);
        }
        if (see_other_host_class == null) {
            see_other_host_class = "tigase.server.xmppclient.SeeOtherHostHashed";
        }
        this.see_other_host_strategy = super.getSeeOtherHostInstance(see_other_host_class);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(this.connectedNodes);
        }
        return this.see_other_host_strategy;
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
    }
}

