/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.MechanismSelector;
import tigase.auth.mechanisms.TigaseSaslServerFactory;
import tigase.xmpp.XMPPResourceConnection;

public class DefaultMechanismSelector
implements MechanismSelector {
    protected Map<String, Object> settings;

    @Override
    public Collection<String> filterMechanisms(Enumeration<SaslServerFactory> serverFactories, XMPPResourceConnection session) {
        HashMap props = new HashMap();
        ArrayList<String> result = new ArrayList<String>();
        while (serverFactories.hasMoreElements()) {
            String[] x;
            SaslServerFactory ss = serverFactories.nextElement();
            for (String name : x = ss.getMechanismNames(props)) {
                if (!this.match(ss, name, session)) continue;
                result.add(name);
            }
        }
        return result;
    }

    @Override
    public void init(Map<String, Object> settings) {
        this.settings = settings;
    }

    protected boolean match(SaslServerFactory factory, String mechanismName, XMPPResourceConnection session) {
        if (factory instanceof TigaseSaslServerFactory) {
            if (!session.getDomain().isAnonymousEnabled() && "ANONYMOUS".equals(mechanismName)) {
                return false;
            }
            return !"EXTERNAL".equals(mechanismName) || session.getSessionData("SASL_EXTERNAL_ALLOWED") == Boolean.TRUE;
        }
        return false;
    }
}

