/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.ElementUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqStats
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH, Iq.IQ_COMMAND_PATH};
    private static final Logger log = Logger.getLogger(JabberIqStats.class.getName());
    private static final String XMLNS = "http://jabber.org/protocol/stats";
    private static final String ID = "http://jabber.org/protocol/stats";
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/stats", "http://jabber.org/protocol/commands"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/stats"})};

    @Override
    public String id() {
        return "http://jabber.org/protocol/stats";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            BareJID id;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received packet: {0}", packet);
            }
            if (packet.isCommand()) {
                if (packet.getCommand() == Command.GETSTATS && packet.getType() == StanzaType.result) {
                    Element iq = ElementUtils.createIqQuery(session.getDomainAsJID(), session.getJID(), StanzaType.result, packet.getStanzaId(), "http://jabber.org/protocol/stats");
                    Element query = iq.getChild("query");
                    Element stats = Command.getData(packet, "statistics", null);
                    query.addChildren(stats.getChildren());
                    Packet result = Packet.packetInstance(iq, session.getSMComponentId(), session.getJID());
                    result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                    results.offer(result);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Sending result: {0}", result);
                    }
                    return;
                }
                return;
            }
            BareJID bareJID = id = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
            if (id == null || session.isLocalDomain(id.toString(), false)) {
                String oldto = packet.getAttributeStaticStr("oldto");
                Packet result = Command.GETSTATS.getPacket(packet.getStanzaFrom(), session.getDomainAsJID(), StanzaType.get, packet.getStanzaId());
                if (oldto != null) {
                    result.getElement().setAttribute("oldto", oldto);
                }
                results.offer(result);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending result: " + result);
                }
                return;
            }
            if (session.isUserId(id)) {
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                result.setPacketFrom(packet.getTo());
                results.offer(result);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending result: " + result);
                }
            } else {
                Packet result = packet.copyElementOnly();
                results.offer(result);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending result: " + result);
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received stats request but user session is not authorized yet: " + packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

