/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.XMPPResourceConnection;

public class XMPPSession {
    private static final Logger log = Logger.getLogger(XMPPSession.class.getName());
    private CopyOnWriteArrayList<XMPPResourceConnection> activeResources = null;
    private long creationTime = 0L;
    private long packets_counter = 0L;
    private Map<String, Object> sessionData = new ConcurrentHashMap<String, Object>();
    private String username = null;

    public XMPPSession(String username) {
        this.activeResources = new CopyOnWriteArrayList();
        this.username = username;
        this.creationTime = System.currentTimeMillis();
    }

    public void addResourceConnection(XMPPResourceConnection conn) throws TigaseStringprepException {
        XMPPResourceConnection old_res;
        String resource;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding resource connection for username : " + this.username + ", id: " + conn);
        }
        if ((resource = conn.getResource()) != null) {
            ArrayDeque<XMPPResourceConnection> old_ress = new ArrayDeque<XMPPResourceConnection>();
            for (XMPPResourceConnection act_conn : this.activeResources) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Resource checking: " + act_conn.getResource() + ", connectionID: " + act_conn);
                }
                if (!resource.equalsIgnoreCase(act_conn.getResource())) continue;
                old_ress.add(act_conn);
            }
            XMPPResourceConnection old_res2 = null;
            while ((old_res2 = (XMPPResourceConnection)old_ress.poll()) != null) {
                if (old_res2 == conn) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found old resource connection, id: " + old_res2);
                }
                try {
                    old_res2.putSessionData("error-key", "conflict");
                    old_res2.logout();
                }
                catch (Exception e) {
                    log.log(Level.INFO, "Exception during closing old connection, ignoring.", e);
                }
                this.removeResourceConnection(old_res2);
            }
        }
        try {
            old_res = this.getResourceForConnectionId(conn.getConnectionId());
        }
        catch (NoConnectionIdException ex) {
            old_res = null;
        }
        if (old_res == null) {
            this.activeResources.add(conn);
            conn.setParentSession(this);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Number of active resources is: " + this.activeResources.size());
            if (this.activeResources.size() > 1) {
                int i = 0;
                for (XMPPResourceConnection res : this.activeResources) {
                    log.finest("RES " + ++i + ": " + res);
                }
            }
        }
    }

    public List<XMPPResourceConnection> getActiveResourcesClone() {
        return (List)this.activeResources.clone();
    }

    public List<XMPPResourceConnection> getActiveResources() {
        return this.activeResources;
    }

    public int getActiveResourcesSize() {
        return this.activeResources.size();
    }

    public Object getCommonSessionData(String key) {
        return this.sessionData.get(key);
    }

    public JID[] getConnectionIds() {
        JID[] result = new JID[this.activeResources.size()];
        int idx = 0;
        for (XMPPResourceConnection conn : this.activeResources) {
            try {
                result[idx] = conn.getConnectionId();
                ++idx;
            }
            catch (NoConnectionIdException ex) {}
        }
        return result;
    }

    public JID[] getJIDs() {
        JID[] result = new JID[this.activeResources.size()];
        int idx = 0;
        for (XMPPResourceConnection conn : this.activeResources) {
            result[idx++] = conn.getjid();
        }
        return result;
    }

    public long getLiveTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public synchronized XMPPResourceConnection getResourceConnection(JID jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Called for: " + jid);
        }
        if (this.activeResources.size() == 0) {
            return null;
        }
        if (this.activeResources.size() == 1) {
            XMPPResourceConnection result = this.activeResources.get(0);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Only 1 active resource: " + result.getResource());
            }
            return result;
        }
        XMPPResourceConnection conn = this.getResourceForJID(jid);
        if (conn != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Number of resources: " + this.activeResources.size() + ", got resource for jid: " + jid);
            }
            return conn;
        }
        ArrayList<XMPPResourceConnection> al = new ArrayList<XMPPResourceConnection>();
        int highest_priority = 0;
        for (XMPPResourceConnection conn_tmp : this.activeResources) {
            if (!conn_tmp.isAuthorized()) {
                log.info("Old XMPP connection which is not authorized anymore, removing..." + conn_tmp);
                this.activeResources.remove(conn_tmp);
            }
            if (conn_tmp.getPriority() == highest_priority) {
                al.add(conn_tmp);
                continue;
            }
            if (conn_tmp.getPriority() <= highest_priority) continue;
            al.clear();
            al.add(conn_tmp);
            highest_priority = conn_tmp.getPriority();
        }
        if (al.size() == 1) {
            return (XMPPResourceConnection)al.get(0);
        }
        XMPPResourceConnection conn_last = (XMPPResourceConnection)al.get(0);
        long time = conn_last.getLastAccessed();
        for (int i = 1; i < al.size(); ++i) {
            if (((XMPPResourceConnection)al.get(i)).getLastAccessed() <= time) continue;
            conn_last = (XMPPResourceConnection)al.get(i);
            time = conn_last.getLastAccessed();
        }
        return conn_last;
    }

    public XMPPResourceConnection getResourceForConnectionId(JID connectionId) {
        try {
            for (XMPPResourceConnection conn : this.activeResources) {
                if (!connectionId.equals(conn.getConnectionId())) continue;
                return conn;
            }
        }
        catch (NoConnectionIdException noConnectionIdException) {
            // empty catch block
        }
        return null;
    }

    public XMPPResourceConnection getResourceForJID(JID jid) {
        String resource = jid.getResource();
        return this.getResourceForResource(resource);
    }

    public XMPPResourceConnection getResourceForResource(String resource) {
        if (resource != null && resource.length() > 0) {
            for (XMPPResourceConnection conn : this.activeResources) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Resource checking: " + conn.getResource() + ", connectionID: " + conn);
                }
                if (!resource.equalsIgnoreCase(conn.getResource())) continue;
                return conn;
            }
        }
        return null;
    }

    public String getUserName() {
        return this.username;
    }

    public void removeResourceConnection(XMPPResourceConnection conn) {
        this.activeResources.remove(conn);
        conn.removeParentSession(null);
    }

    public void streamClosed(XMPPResourceConnection conn) {
        this.removeResourceConnection(conn);
    }

    protected void putCommonSessionData(String key, Object value) {
        this.sessionData.put(key, value);
    }

    protected Object removeCommonSessionData(String key) {
        return this.sessionData.remove(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XMPPSession=[");
        sb.append("username: ").append(this.username);
        sb.append(", resources: ").append(this.activeResources.toString());
        sb.append("]");
        return sb.toString();
    }

    public void incPacketsCounter() {
        ++this.packets_counter;
    }

    public long getPacketsCounter() {
        return this.packets_counter;
    }
}

