/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public abstract class XMPPProcessorAbstract
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger(XMPPProcessorAbstract.class.getName());

    public abstract void processFromUserToServerPacket(JID var1, Packet var2, XMPPResourceConnection var3, NonAuthUserRepository var4, Queue<Packet> var5, Map<String, Object> var6) throws PacketErrorTypeException;

    public abstract void processServerSessionPacket(Packet var1, XMPPResourceConnection var2, NonAuthUserRepository var3, Queue<Packet> var4, Map<String, Object> var5) throws PacketErrorTypeException;

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        try {
            if (session == null) {
                this.processNullSessionPacket(packet, repo, results, settings);
                return;
            }
            if (session.isServerSession()) {
                this.processServerSessionPacket(packet, session, repo, results, settings);
                return;
            }
            try {
                JID connectionId = session.getConnectionId();
                if (connectionId.equals(packet.getPacketFrom())) {
                    this.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                    return;
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "This should not happen, this is not a server session and still connection id is not set: " + session + ", packet: " + packet, ex);
            }
            try {
                if (session.isUserId(packet.getStanzaTo().getBareJID())) {
                    this.processToUserPacket(packet, session, repo, results, settings);
                }
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.WARNING, "Packet to a user session which is not yet authenticated: " + session + ", packet: " + packet);
            }
        }
        catch (PacketErrorTypeException ex) {
            log.info("Attempt to send an error response to the error packet: " + packet + ", session: " + session + ", plugin: " + this.id());
        }
    }

    public void processFromUserOutPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        results.offer(packet.copyElementOnly());
    }

    public void processFromUserPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        try {
            if (packet.getStanzaTo() == null || session.isLocalDomain(packet.getStanzaTo().toString(), false) || session.isUserId(packet.getStanzaTo().getBareJID())) {
                this.processFromUserToServerPacket(connectionId, packet, session, repo, results, settings);
            } else {
                this.processFromUserOutPacket(connectionId, packet, session, repo, results, settings);
            }
        }
        catch (NotAuthorizedException ex) {
            log.info("Session not yet authorized to send ping requests: " + session + ", packet: " + packet);
        }
    }

    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        try {
            Packet result = packet.copyElementOnly();
            result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
            result.setPacketFrom(packet.getTo());
            results.offer(result);
        }
        catch (NoConnectionIdException ex) {
            log.log(Level.WARNING, "This should not happen, this is not a server session and still connection id is not set: " + session + ", packet: " + packet, ex);
        }
    }
}

