/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Arrays;
import tigase.xml.SimpleHandler;

public class SimpleParser {
    public int ATTRIBUTES_NUMBER_LIMIT = Integer.getInteger("tigase.xml.attributes_number_limit", this.ATTRIBUTES_NUMBER_LIMIT);
    public static final String ATTRIBUTES_NUMBER_LIMIT_PROP_KEY = "tigase.xml.attributes_number_limit";
    public int MAX_ATTRIBS_NUMBER = Integer.getInteger("tigase.xml.max_attrib_number", this.MAX_ATTRIBS_NUMBER);
    public static final String MAX_ATTRIBS_NUMBER_PROP_KEY = "tigase.xml.max_attrib_number";
    public int MAX_ELEMENT_NAME_SIZE = Integer.getInteger("tigase.xml.max_element_size", this.MAX_ELEMENT_NAME_SIZE);
    public static final String MAX_ELEMENT_NAME_SIZE_PROP_KEY = "tigase.xml.max_element_size";
    public int MAX_ATTRIBUTE_NAME_SIZE = Integer.getInteger("tigase.xml.max_attribute_name_size", this.MAX_ATTRIBUTE_NAME_SIZE);
    public static final String MAX_ATTRIBUTE_NAME_SIZE_PROP_KEY = "tigase.xml.max_attribute_name_size";
    public int MAX_ATTRIBUTE_VALUE_SIZE = Integer.getInteger("tigase.xml.max_attribute_value_size", this.MAX_ATTRIBUTE_VALUE_SIZE);
    public static final String MAX_ATTRIBUTE_VALUE_SIZE_PROP_KEY = "tigase.xml.max_attribute_value_size";
    public int MAX_CDATA_SIZE = Integer.getInteger("tigase.xml.max_cdata_size", this.MAX_CDATA_SIZE);
    public static final String MAX_CDATA_SIZE_PROP_KEY = "tigase.xml.max_cdata_size";
    private static final char OPEN_BRACKET = '<';
    private static final char CLOSE_BRACKET = '>';
    private static final char QUESTION_MARK = '?';
    private static final char EXCLAMATION_MARK = '!';
    private static final char SLASH = '/';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char EQUALS = '=';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char[] QUOTES = new char[]{'\'', '\"'};
    private static final char[] WHITE_CHARS = new char[]{' ', '\n', '\r', '\t'};
    private static final char[] END_NAME_CHARS = new char[]{'>', '/', ' ', '\t', '\n', '\r'};
    private static final char[] ERR_NAME_CHARS = new char[]{'<', '?'};
    private static final char[] IGNORE_CHARS = new char[]{'\u0000'};

    public final void parse(SimpleHandler handler, char[] data, int off, int len) {
        char chr;
        ParserState parser_state = (ParserState)handler.restoreParserState();
        if (parser_state == null) {
            parser_state = new ParserState();
        }
        block18: for (int index = off; index < len && (chr = data[index]) != IGNORE_CHARS[0]; ++index) {
            switch (parser_state.state) {
                case START: {
                    if (chr != '<') continue block18;
                    parser_state.state = State.OPEN_BRACKET;
                    parser_state.slash_found = false;
                    continue block18;
                }
                case OPEN_BRACKET: {
                    switch (chr) {
                        case '!': 
                        case '?': {
                            parser_state.state = State.OTHER_XML;
                            parser_state.element_cdata = new StringBuilder(100);
                            parser_state.element_cdata.append(chr);
                            continue block18;
                        }
                        case '/': {
                            parser_state.state = State.CLOSE_ELEMENT;
                            parser_state.element_name = new StringBuilder(10);
                            parser_state.slash_found = true;
                            continue block18;
                        }
                    }
                    if (Arrays.binarySearch(WHITE_CHARS, chr) >= 0) continue block18;
                    parser_state.state = State.ELEMENT_NAME;
                    parser_state.element_name = new StringBuilder(10);
                    parser_state.element_name.append(chr);
                    continue block18;
                }
                case ELEMENT_NAME: {
                    if (this.isWhite(chr)) {
                        parser_state.state = State.END_ELEMENT_NAME;
                        continue block18;
                    }
                    if (chr == '/') {
                        parser_state.slash_found = true;
                        continue block18;
                    }
                    if (chr == '>') {
                        parser_state.state = State.ELEMENT_CDATA;
                        handler.startElement(parser_state.element_name, null, null);
                        if (parser_state.slash_found) {
                            handler.endElement(parser_state.element_name);
                        }
                        parser_state.element_name = null;
                        continue block18;
                    }
                    if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1]) {
                        parser_state.state = State.ERROR;
                        parser_state.errorMessage = "Not allowed character in start element name: " + chr + "\nExisting characters in start element name: " + parser_state.element_name.toString();
                        continue block18;
                    }
                    parser_state.element_name.append(chr);
                    if (parser_state.element_name.length() <= this.MAX_ELEMENT_NAME_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max element name size exceeded: " + this.MAX_ELEMENT_NAME_SIZE + "\nreceived: " + parser_state.element_name.toString();
                    continue block18;
                }
                case CLOSE_ELEMENT: {
                    if (this.isWhite(chr)) continue block18;
                    if (chr == '/') {
                        parser_state.state = State.ERROR;
                        parser_state.errorMessage = "Not allowed character in close element name: " + chr + "\nExisting characters in close element name: " + parser_state.element_name.toString();
                        continue block18;
                    }
                    if (chr == '>') {
                        parser_state.state = State.ELEMENT_CDATA;
                        handler.endElement(parser_state.element_name);
                        parser_state.element_name = null;
                        continue block18;
                    }
                    if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1]) {
                        parser_state.state = State.ERROR;
                        parser_state.errorMessage = "Not allowed character in close element name: " + chr + "\nExisting characters in close element name: " + parser_state.element_name.toString();
                        continue block18;
                    }
                    parser_state.element_name.append(chr);
                    if (parser_state.element_name.length() <= this.MAX_ELEMENT_NAME_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max element name size exceeded: " + this.MAX_ELEMENT_NAME_SIZE + "\nreceived: " + parser_state.element_name.toString();
                    continue block18;
                }
                case END_ELEMENT_NAME: {
                    if (chr == '/') {
                        parser_state.slash_found = true;
                        continue block18;
                    }
                    if (chr == '>') {
                        parser_state.state = State.ELEMENT_CDATA;
                        handler.startElement(parser_state.element_name, parser_state.attrib_names, parser_state.attrib_values);
                        parser_state.attrib_names = null;
                        parser_state.attrib_values = null;
                        parser_state.current_attr = -1;
                        if (parser_state.slash_found) {
                            handler.endElement(parser_state.element_name);
                        }
                        parser_state.element_name = null;
                        continue block18;
                    }
                    if (this.isWhite(chr)) continue block18;
                    parser_state.state = State.ATTRIB_NAME;
                    if (parser_state.attrib_names == null) {
                        parser_state.attrib_names = this.initArray(this.MAX_ATTRIBS_NUMBER);
                        parser_state.attrib_values = this.initArray(this.MAX_ATTRIBS_NUMBER);
                    } else if (parser_state.current_attr == parser_state.attrib_names.length - 1) {
                        if (parser_state.attrib_names.length >= this.ATTRIBUTES_NUMBER_LIMIT) {
                            parser_state.state = State.ERROR;
                            parser_state.errorMessage = "Attributes nuber limit exceeded: " + this.ATTRIBUTES_NUMBER_LIMIT + "\nreceived: " + parser_state.element_name.toString();
                            continue block18;
                        }
                        int new_size = parser_state.attrib_names.length + this.MAX_ATTRIBS_NUMBER;
                        parser_state.attrib_names = this.resizeArray(parser_state.attrib_names, new_size);
                        parser_state.attrib_values = this.resizeArray(parser_state.attrib_values, new_size);
                    }
                    parser_state.attrib_names[++parser_state.current_attr] = new StringBuilder(8);
                    parser_state.attrib_names[parser_state.current_attr].append(chr);
                    continue block18;
                }
                case ATTRIB_NAME: {
                    if (this.isWhite(chr) || chr == '=') {
                        parser_state.state = State.END_OF_ATTR_NAME;
                        continue block18;
                    }
                    parser_state.attrib_names[parser_state.current_attr].append(chr);
                    if (parser_state.attrib_names[parser_state.current_attr].length() <= this.MAX_ATTRIBUTE_NAME_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max attribute name size exceeded: " + this.MAX_ATTRIBUTE_NAME_SIZE + "\nreceived: " + parser_state.attrib_names[parser_state.current_attr].toString();
                    continue block18;
                }
                case END_OF_ATTR_NAME: {
                    if (chr == '\'') {
                        parser_state.state = State.ATTRIB_VALUE_S;
                        parser_state.attrib_values[parser_state.current_attr] = new StringBuilder(64);
                    }
                    if (chr != '\"') continue block18;
                    parser_state.state = State.ATTRIB_VALUE_D;
                    parser_state.attrib_values[parser_state.current_attr] = new StringBuilder(64);
                    continue block18;
                }
                case ATTRIB_VALUE_S: {
                    if (chr == '\'') {
                        parser_state.state = State.END_ELEMENT_NAME;
                        continue block18;
                    }
                    parser_state.attrib_values[parser_state.current_attr].append(chr);
                    if (parser_state.attrib_values[parser_state.current_attr].length() <= this.MAX_ATTRIBUTE_VALUE_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max attribute value size exceeded: " + this.MAX_ATTRIBUTE_VALUE_SIZE + "\nreceived: " + parser_state.attrib_values[parser_state.current_attr].toString();
                    continue block18;
                }
                case ATTRIB_VALUE_D: {
                    if (chr == '\"') {
                        parser_state.state = State.END_ELEMENT_NAME;
                        continue block18;
                    }
                    parser_state.attrib_values[parser_state.current_attr].append(chr);
                    if (parser_state.attrib_values[parser_state.current_attr].length() <= this.MAX_ATTRIBUTE_VALUE_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max attribute value size exceeded: " + this.MAX_ATTRIBUTE_VALUE_SIZE + "\nreceived: " + parser_state.attrib_values[parser_state.current_attr].toString();
                    continue block18;
                }
                case ELEMENT_CDATA: {
                    if (chr == '<') {
                        parser_state.state = State.OPEN_BRACKET;
                        parser_state.slash_found = false;
                        if (parser_state.element_cdata == null) continue block18;
                        handler.elementCData(parser_state.element_cdata);
                        parser_state.element_cdata = null;
                        continue block18;
                    }
                    if (parser_state.element_cdata == null) {
                        parser_state.element_cdata = new StringBuilder(100);
                    }
                    parser_state.element_cdata.append(chr);
                    if (parser_state.element_cdata.length() <= this.MAX_CDATA_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max cdata size exceeded: " + this.MAX_CDATA_SIZE + "\nreceived: " + parser_state.element_cdata.toString();
                    continue block18;
                }
                case OTHER_XML: {
                    if (chr == '>') {
                        parser_state.state = State.START;
                        handler.otherXML(parser_state.element_cdata);
                        parser_state.element_cdata = null;
                        continue block18;
                    }
                    if (parser_state.element_cdata == null) {
                        parser_state.element_cdata = new StringBuilder(100);
                    }
                    parser_state.element_cdata.append(chr);
                    if (parser_state.element_cdata.length() <= this.MAX_CDATA_SIZE) continue block18;
                    parser_state.state = State.ERROR;
                    parser_state.errorMessage = "Max cdata size exceeded: " + this.MAX_CDATA_SIZE + "\nreceived: " + parser_state.element_cdata.toString();
                    continue block18;
                }
                case ERROR: {
                    handler.error(parser_state.errorMessage);
                    parser_state = null;
                    return;
                }
                default: {
                    assert (false) : "Unknown SimpleParser state: " + (Object)((Object)parser_state.state);
                    continue block18;
                }
            }
        }
        handler.saveParserState(parser_state);
    }

    private StringBuilder[] initArray(int size) {
        Object[] array = new StringBuilder[size];
        Arrays.fill(array, null);
        return array;
    }

    private boolean isWhite(char chr) {
        for (char c : WHITE_CHARS) {
            if (chr != c) continue;
            return true;
        }
        return false;
    }

    private StringBuilder[] resizeArray(StringBuilder[] src, int size) {
        Object[] array = new StringBuilder[size];
        System.arraycopy(src, 0, array, 0, src.length);
        Arrays.fill(array, src.length, array.length, null);
        return array;
    }

    static {
        Arrays.sort(IGNORE_CHARS);
    }

    private static class ParserState {
        StringBuilder[] attrib_names = null;
        StringBuilder[] attrib_values = null;
        int current_attr = -1;
        StringBuilder element_cdata = null;
        StringBuilder element_name = null;
        String errorMessage = null;
        boolean slash_found = false;
        State state = State.START;

        private ParserState() {
        }
    }

    private static enum State {
        START,
        OPEN_BRACKET,
        ELEMENT_NAME,
        END_ELEMENT_NAME,
        ATTRIB_NAME,
        END_OF_ATTR_NAME,
        ATTRIB_VALUE_S,
        ATTRIB_VALUE_D,
        ELEMENT_CDATA,
        OTHER_XML,
        ERROR,
        CLOSE_ELEMENT;

    }
}

