/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.UserNotFoundException;
import tigase.server.xmppclient.SeeOtherHostHashed;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

public class SeeOtherHostDB
extends SeeOtherHostHashed {
    private static final Logger log = Logger.getLogger(SeeOtherHostDB.class.getName());
    public static final String SEE_OTHER_HOST_TABLE = "tig_see_other_hosts";
    public static final String SEE_OTHER_HOST_DB_URL_KEY = "cm-see-other-host/db-url";
    public static final String SEE_OTHER_HOST_DB_QUERY_KEY = "cm-see-other-host/get-host-query";
    public static final String DB_GET_ALL_DATA_DB_QUERY_KEY = "cm-see-other-host/get-all-data-query";
    public static final String GET_ALL_QUERY_TIMEOUT_QUERY_KEY = "cm-see-other-host/get-all-query-timeout";
    public static final String SERIAL_ID = "sid";
    public static final String USER_ID = "uid";
    public static final String NODE_ID = "node_id";
    public static final String DEF_DB_GET_HOST_QUERY = " select * from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid and user_id = ?";
    private static final String DEF_DB_GET_ALL_DATA_QUERY = "select user_id, node_id from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid";
    private static final String CREATE_STATS_TABLE = "create table tig_see_other_hosts ( sid serial,uid bigint unsigned NOT NULL, node_id varchar(2049) NOT NULL,  primary key (sid),  constraint tig_see_other_host_constr foreign key (uid) references tig_users (uid))";
    private static final int DEF_QUERY_TIME_OUT = 0;
    private String get_host_query = " select * from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid and user_id = ?";
    private String get_all_data_query = "select user_id, node_id from tig_users, tig_see_other_hosts where tig_users.uid = tig_see_other_hosts.uid";
    private String get_host_DB_url = "";
    private DataRepository data_repo = null;
    private Map<BareJID, BareJID> redirectsMap = new ConcurrentSkipListMap<BareJID, BareJID>();

    @Override
    public BareJID findHostForJID(BareJID jid, BareJID host) {
        BareJID see_other_host = this.redirectsMap.get(jid);
        if (see_other_host != null) {
            return see_other_host;
        }
        see_other_host = host;
        try {
            see_other_host = this.queryDB(jid);
        }
        catch (Exception ex) {
            see_other_host = super.findHostForJID(jid, host);
            log.log(Level.SEVERE, "DB lookup failed, fallback to SeeOtherHostHashed: ", ex);
        }
        return see_other_host;
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        if (params.containsKey("--user-db-uri")) {
            this.get_host_DB_url = (String)params.get("--user-db-uri");
        }
        defs.put(SEE_OTHER_HOST_DB_URL_KEY, this.get_host_DB_url);
        defs.put(SEE_OTHER_HOST_DB_QUERY_KEY, this.get_host_query);
        defs.put(DB_GET_ALL_DATA_DB_QUERY_KEY, this.get_all_data_query);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.containsKey(SEE_OTHER_HOST_DB_URL_KEY) && !props.get(SEE_OTHER_HOST_DB_URL_KEY).toString().trim().isEmpty()) {
            this.get_host_DB_url = props.get(SEE_OTHER_HOST_DB_URL_KEY).toString().trim();
        }
        props.put(SEE_OTHER_HOST_DB_URL_KEY, this.get_host_DB_url);
        if (props.containsKey(SEE_OTHER_HOST_DB_QUERY_KEY) && !props.get(SEE_OTHER_HOST_DB_QUERY_KEY).toString().trim().isEmpty()) {
            this.get_host_query = props.get(SEE_OTHER_HOST_DB_QUERY_KEY).toString().trim();
        }
        props.put(SEE_OTHER_HOST_DB_QUERY_KEY, this.get_host_query);
        if (props.containsKey(DB_GET_ALL_DATA_DB_QUERY_KEY) && !props.get(DB_GET_ALL_DATA_DB_QUERY_KEY).toString().trim().isEmpty()) {
            this.get_all_data_query = props.get(DB_GET_ALL_DATA_DB_QUERY_KEY).toString().trim();
        }
        props.put(DB_GET_ALL_DATA_DB_QUERY_KEY, this.get_all_data_query);
        try {
            this.initRepository(this.get_host_DB_url, null);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot initialize connection to database: ", ex);
        }
    }

    public void initRepository(String conn_str, Map<String, String> map) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, DBInitException {
        log.log(Level.INFO, "Initializing dbAccess for db connection url: {0}", conn_str);
        this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, map);
        this.data_repo.initPreparedStatement(this.get_host_query, this.get_host_query);
        this.data_repo.initPreparedStatement(this.get_all_data_query, this.get_all_data_query);
        this.queryAllDB();
    }

    private BareJID queryDB(BareJID user) throws UserNotFoundException, SQLException, TigaseStringprepException {
        PreparedStatement get_host = this.data_repo.getPreparedStatement(user, this.get_host_query);
        ResultSet rs = null;
        PreparedStatement preparedStatement = get_host;
        synchronized (preparedStatement) {
            get_host.setString(1, user.toString());
            rs = get_host.executeQuery();
            if (rs.next()) {
                return BareJID.bareJIDInstance(rs.getString(NODE_ID));
            }
            throw new UserNotFoundException("Item does not exist for user: " + user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryAllDB() throws SQLException {
        PreparedStatement get_all = this.data_repo.getPreparedStatement(null, this.get_all_data_query);
        get_all.setQueryTimeout(0);
        ResultSet rs = null;
        PreparedStatement preparedStatement = get_all;
        synchronized (preparedStatement) {
            rs = get_all.executeQuery();
            while (rs.next()) {
                String user_jid = rs.getString("user_id");
                String node_jid = rs.getString(NODE_ID);
                try {
                    BareJID user = BareJID.bareJIDInstance(user_jid);
                    BareJID node = BareJID.bareJIDInstance(node_jid);
                    this.redirectsMap.put(user, node);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Invalid user's or node's JID: " + user_jid + ", " + node_jid);
                }
            }
        }
        log.info("Loaded " + this.redirectsMap.size() + " redirect definitions from database.");
    }
}

