/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSendQueueTask;
import tigase.server.bosh.BoshSessionCache;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.bosh.BoshTask;
import tigase.server.bosh.Constants;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.util.TigaseStringprepException;
import tigase.util.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class BoshSession {
    private static final String IQ_ELEMENT_NAME = "iq";
    private static final Logger log = Logger.getLogger(BoshSession.class.getName());
    private static final String MESSAGE_ELEMENT_NAME = "message";
    private static final String PRESENCE_ELEMENT_NAME = "presence";
    private static final long SECOND = 1000L;
    private static final TimerTaskComparator timerTaskComparator = new TimerTaskComparator();
    private BoshSessionCache cache = null;
    private long cache_reload_counter = 0L;
    private long[] currentRids = null;
    private JID dataReceiver = null;
    private String domain = null;
    private BoshSessionTaskHandler handler = null;
    private int[] hashCodes = null;
    private BoshTask inactivityTimer = null;
    private long previous_received_rid = -1L;
    private BoshSendQueueTask queueTask = null;
    private String[] replace_with = new String[]{"$1&lt;a href=\"http://$2\" target=\"_blank\"&gt;$2&lt;/a&gt;", "$1&lt;a href=\"$2\" target=\"_blank\"&gt;$2&lt;/a&gt;"};
    private int rids_head = 0;
    private int rids_tail = 0;
    private String sessionId = null;
    private UUID sid = null;
    private Queue<BoshIOService> old_connections = new LinkedBlockingQueue<BoshIOService>(4);
    private ConcurrentSkipListMap<BoshTask, BoshIOService> connections = new ConcurrentSkipListMap(timerTaskComparator);
    private JID userJid = null;
    private Set<BoshTask> waitTimerSet = new ConcurrentSkipListSet<BoshTask>(timerTaskComparator);
    private Queue<Element> waiting_packets = new ConcurrentLinkedQueue<Element>();
    private boolean terminate = false;
    private long min_polling = 10L;
    private long max_wait = 30L;
    private long max_pause = 10L;
    private long max_inactivity = 10L;
    private int max_batch_size = 15;
    private Pattern[] links_regexs = new Pattern[]{Pattern.compile("([^>/\";]|^)(www\\.[^ ]+)", 2), Pattern.compile("([^\">;]|^)(http://[^ ]+)", 2)};
    private int hold_requests = 1;
    private String content_type = "text/xml; charset=utf-8";
    private int concurrent_requests = 2;
    private boolean cache_on = false;
    private long batch_queue_timeout = 100L;
    private long last_send_time;

    public BoshSession(String def_domain, JID dataReceiver, BoshSessionTaskHandler handler) {
        this.sid = UUID.randomUUID();
        this.domain = def_domain;
        this.dataReceiver = dataReceiver;
        this.handler = handler;
        this.last_send_time = System.currentTimeMillis();
    }

    public void close() {
        this.terminate = true;
        this.processPacket(null, null);
        this.closeAllConnections();
    }

    private void closeAllConnections() {
        for (BoshIOService conn : this.old_connections) {
            conn.stop();
        }
        for (BoshIOService conn : this.connections.values()) {
            conn.stop();
        }
    }

    public void disconnected(BoshIOService bios) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disconnected called for: " + bios.getUniqueId());
        }
        if (bios != null && bios.getWaitTimer() != null) {
            this.handler.cancelTask(bios.getWaitTimer());
            this.connections.remove(bios.getWaitTimer());
        }
        if (this.inactivityTimer != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling inactivityTimer: " + this.getSid());
            }
            this.handler.cancelTask(this.inactivityTimer);
        }
        if (this.connections.isEmpty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting inactivityTimer for " + this.max_inactivity + ": " + this.getSid());
            }
            this.inactivityTimer = this.handler.scheduleTask(this, this.max_inactivity * 1000L);
        }
    }

    public JID getDataReceiver() {
        return this.dataReceiver;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UUID getSid() {
        return this.sid;
    }

    public void init(Packet packet, BoshIOService service, long max_wait, long min_polling, long max_inactivity, int concurrent_requests, int hold_requests, long max_pause, int max_batch_size, long batch_queue_timeout, Queue<Packet> out_results) {
        String lang;
        String cache_action = packet.getAttributeStaticStr("cache");
        if (cache_action != null && cache_action.equals(Constants.CacheAction.on.toString())) {
            this.cache = new BoshSessionCache();
            this.cache_on = true;
            log.fine("BoshSessionCache set to ON");
        }
        this.hashCodes = new int[(this.concurrent_requests + 1) * 5];
        this.currentRids = new long[(this.concurrent_requests + 1) * 5];
        for (int i = 0; i < this.currentRids.length; ++i) {
            this.currentRids[i] = -1L;
            this.hashCodes[i] = -1;
        }
        long wait_l = max_wait;
        String wait_s = packet.getAttributeStaticStr("wait");
        if (wait_s != null) {
            try {
                wait_l = Long.parseLong(wait_s);
            }
            catch (NumberFormatException e) {
                wait_l = max_wait;
            }
        }
        this.max_wait = Math.min(wait_l, max_wait);
        int hold_i = hold_requests;
        String tmp_str = packet.getAttributeStaticStr("hold");
        if (tmp_str != null) {
            try {
                hold_i = Integer.parseInt(tmp_str);
            }
            catch (NumberFormatException e) {
                hold_i = hold_requests;
            }
        }
        if ((tmp_str = packet.getAttributeStaticStr("rid")) != null) {
            try {
                this.previous_received_rid = Long.parseLong(tmp_str);
                this.currentRids[this.rids_head++] = this.previous_received_rid;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.hold_requests = Math.max(hold_i, hold_requests);
        if (packet.getAttributeStaticStr("to") != null) {
            this.domain = packet.getAttributeStaticStr("to");
        }
        this.max_batch_size = max_batch_size;
        this.batch_queue_timeout = batch_queue_timeout;
        this.min_polling = min_polling;
        this.max_inactivity = max_inactivity;
        this.concurrent_requests = concurrent_requests;
        this.max_pause = max_pause;
        if (packet.getAttributeStaticStr("content") != null) {
            this.content_type = packet.getAttributeStaticStr("content");
        }
        if ((lang = packet.getAttributeStaticStr("xml:lang")) == null) {
            lang = "en";
        }
        service.setContentType(this.content_type);
        Element body = new Element("body", new String[]{"wait", "inactivity", "polling", "requests", "hold", "maxpause", "sid", "ver", "from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{Long.valueOf(this.max_wait).toString(), Long.valueOf(this.max_inactivity).toString(), Long.valueOf(this.min_polling).toString(), Integer.valueOf(this.concurrent_requests).toString(), Integer.valueOf(this.hold_requests).toString(), Long.valueOf(this.max_pause).toString(), this.sid.toString(), "1.6", this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
        this.sessionId = UUID.randomUUID().toString();
        body.setAttribute("authid", this.sessionId);
        if (this.getCurrentRidTail() > 0L) {
            body.setAttribute("ack", "" + this.takeCurrentRidTail());
        }
        try {
            BareJID hostJid;
            BareJID userId;
            BareJID bareJID = userId = packet.getAttributeStaticStr("from") != null ? BareJID.bareJIDInstance(packet.getAttributeStaticStr("from")) : null;
            if (userId != null && (hostJid = this.handler.getSeeOtherHostForJID(userId, SeeOtherHostIfc.Phase.OPEN)) != null) {
                Element error = new Element("stream:error");
                Element seeOtherHost = new Element("see-other-host", hostJid.toString());
                seeOtherHost.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                error.addChild(seeOtherHost);
                body.addChild(error);
            }
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(BoshSession.class.getName()).log(Level.SEVERE, null, ex);
        }
        body.setXMLNS("http://jabber.org/protocol/httpbind");
        this.sendBody(service, body);
        Packet streamOpen = Command.STREAM_OPENED.getPacket(null, null, StanzaType.set, UUID.randomUUID().toString(), Command.DataType.submit);
        Command.addFieldValue(streamOpen, "session-id", this.sessionId);
        Command.addFieldValue(streamOpen, "hostname", this.domain);
        Command.addFieldValue(streamOpen, "xml:lang", lang);
        this.handler.addOutStreamOpen(streamOpen, this);
    }

    public synchronized void processPacket(Packet packet, Queue<Packet> out_results) {
        if (packet != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("[" + this.connections.size() + "] Processing packet: " + packet.toString());
            }
            if (this.filterInPacket(packet)) {
                this.waiting_packets.offer(packet.getElement());
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("[" + this.connections.size() + "] In packet filtered: " + packet.toString());
            }
        }
        if (!(this.connections.isEmpty() || this.waiting_packets.isEmpty() && !this.terminate)) {
            long currentTime = System.currentTimeMillis();
            if (this.terminate || this.waiting_packets.size() >= this.max_batch_size || currentTime - this.last_send_time > this.batch_queue_timeout) {
                Map.Entry<BoshTask, BoshIOService> entry = this.connections.pollFirstEntry();
                BoshIOService serv = entry.getValue();
                this.sendBody(serv, null);
            } else if (this.queueTask == null) {
                this.queueTask = this.handler.scheduleSendQueueTask(this, this.batch_queue_timeout);
            }
        }
    }

    public synchronized void processSocketPacket(Packet packet, BoshIOService service, Queue<Packet> out_results) {
        BoshTask waitTimer;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.connections.size() + "] Processing socket packet: " + packet.toString());
        }
        if ((waitTimer = service.getWaitTimer()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling waitTimer: " + this.getSid());
            }
            this.handler.cancelTask(waitTimer);
        }
        if (this.inactivityTimer != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling inactivityTimer: " + this.getSid());
            }
            this.handler.cancelTask(this.inactivityTimer);
        }
        if (packet.getElemName() == "body" && packet.getXMLNS() == "http://jabber.org/protocol/httpbind") {
            List<Element> children = packet.getElemChildrenStaticStr(Constants.BODY_EL_PATH);
            boolean duplicate = false;
            if (packet.getAttributeStaticStr("rid") != null) {
                try {
                    long rid = Long.parseLong(packet.getAttributeStaticStr("rid"));
                    if (this.isDuplicateRid(rid, children)) {
                        log.info("Discovered duplicate client connection, trying to close the old one with RID: " + rid);
                        Element body = this.getBodyElem();
                        body.setAttribute("type", StanzaType.terminate.toString());
                        this.sendBody(service, body);
                        return;
                    }
                    service.setRid(rid);
                    duplicate = this.isDuplicateMessage(rid, children);
                    if (!duplicate) {
                        this.processRid(rid, children);
                    }
                }
                catch (NumberFormatException e) {
                    log.warning("Incorrect RID value: " + packet.getAttributeStaticStr("rid"));
                }
            }
            service.setContentType(this.content_type);
            service.setSid(this.sid);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting waitTimer for " + this.max_wait + ": " + this.getSid());
            }
            waitTimer = this.handler.scheduleTask(this, this.max_wait * 1000L);
            service.setWaitTimer(waitTimer);
            this.connections.put(waitTimer, service);
            if (!duplicate) {
                if (packet.getType() != null && packet.getType() == StanzaType.terminate) {
                    this.max_inactivity = 2L;
                    this.terminate = true;
                    Packet command2 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, UUID.randomUUID().toString());
                    this.handler.addOutStreamClosed(command2, this);
                }
                if (packet.getAttributeStaticStr("xmpp:restart") != null && packet.getAttributeStaticStr("xmpp:restart").equals("true")) {
                    log.fine("Found stream restart instruction: " + packet.toString());
                    out_results.offer(Command.GETFEATURES.getPacket(null, null, StanzaType.get, "restart1", null));
                }
                if (packet.getAttributeStaticStr("cache") != null) {
                    try {
                        Constants.CacheAction action = Constants.CacheAction.valueOf(packet.getAttributeStaticStr("cache"));
                        if (this.cache_on || action == Constants.CacheAction.on) {
                            this.processCache(action, packet);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warning("Incorrect cache action: " + packet.getAttributeStaticStr("cache"));
                    }
                } else if (children != null) {
                    for (Element el : children) {
                        try {
                            Packet result;
                            if (el.getXMLNS().equals("http://jabber.org/protocol/httpbind")) {
                                el.setXMLNS("jabber:client");
                            }
                            if (this.filterOutPacket(result = Packet.packetInstance(el))) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Sending out packet: " + result.toString());
                                }
                                out_results.offer(result);
                                continue;
                            }
                            if (!log.isLoggable(Level.FINEST)) continue;
                            log.finest("Out packet filtered: " + result.toString());
                        }
                        catch (TigaseStringprepException ex) {
                            log.warning("Packet addressing problem, stringprep processing failed, dropping: " + el);
                        }
                    }
                }
            } else {
                log.info("Duplicated packet: " + packet.toString());
            }
        } else {
            log.warning("[" + this.connections.size() + "] Unexpected packet from the network: " + packet.toString());
            String er_msg = "Invalid body element";
            if (packet.getElemName() != "body") {
                er_msg = er_msg + ", incorrect root element name, use body";
            }
            if (packet.getXMLNS() != "http://jabber.org/protocol/httpbind") {
                er_msg = er_msg + ", incorrect xmlns, use http://jabber.org/protocol/httpbind";
            }
            try {
                Packet error = Authorization.BAD_REQUEST.getResponseMessage(packet, er_msg, true);
                this.waiting_packets.add(error.getElement());
                this.terminate = true;
                Packet command3 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, UUID.randomUUID().toString());
                this.handler.addOutStreamClosed(command3, this);
            }
            catch (PacketErrorTypeException e) {
                log.info("Error type and incorrect from bosh client? Ignoring...");
            }
        }
        this.processPacket(null, out_results);
        if (this.connections.size() > this.hold_requests) {
            BoshIOService serv = this.connections.pollFirstEntry().getValue();
            this.sendBody(serv, null);
        }
    }

    public void setDataReceiver(JID dataReceiver) {
        this.dataReceiver = dataReceiver;
    }

    public boolean task(Queue<Packet> out_results, TimerTask tt) {
        if (tt == this.inactivityTimer) {
            if (this.connections.size() > 0) {
                return false;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("inactivityTimer fired: " + this.getSid());
            }
            for (BoshTask waitTimer : this.waitTimerSet) {
                if (waitTimer == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Canceling waitTimer: " + this.getSid());
                }
                this.handler.cancelTask(waitTimer);
            }
            for (Element packet : this.waiting_packets) {
                try {
                    if (packet.getName() == "stream:features") continue;
                    out_results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(Packet.packetInstance(packet), "Bosh = disconnected", true));
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Packet addressing problem, stringprep processing failed, dropping: " + packet);
                }
                catch (PacketErrorTypeException e) {
                    log.info("Packet processing exception: " + e);
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Closing session, inactivity timeout expired: " + this.getSid());
            }
            Packet command2 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, UUID.randomUUID().toString());
            this.handler.addOutStreamClosed(command2, this);
            this.closeAllConnections();
            return true;
        }
        BoshIOService serv = this.connections.remove(tt);
        if (serv != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("waitTimer fired: " + this.getSid());
            }
            this.sendBody(serv, null);
        }
        return false;
    }

    private Element applyFilters(Element packet) {
        String body;
        Element result = packet.clone();
        if (result.getName() == MESSAGE_ELEMENT_NAME && (body = result.getCDataStaticStr(Message.MESSAGE_BODY_PATH)) != null) {
            boolean count = false;
            result.getChild("body").setCData(body);
        }
        return result;
    }

    private boolean filterInPacket(Packet packet) {
        if (this.cache_on) {
            this.processAutomaticCache(packet);
        }
        return true;
    }

    private boolean filterOutPacket(Packet packet) {
        if (this.cache_on && packet.getElemName() == MESSAGE_ELEMENT_NAME) {
            this.cache.addToMessage(packet.getElement());
        }
        return true;
    }

    private Element getBodyElem() {
        Element body = new Element("body", new String[]{"from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
        body.setXMLNS("http://jabber.org/protocol/httpbind");
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentRidTail() {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentRids[this.rids_tail];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicateMessage(long rid, List<Element> packets) {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            int hashCode = -1;
            if (packets != null && !packets.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Element elem : packets) {
                    sb.append(elem.toString());
                }
                hashCode = sb.toString().hashCode();
            }
            if (hashCode == -1) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return false;
            }
            for (int i = 0; i < this.currentRids.length; ++i) {
                if (rid != this.currentRids[i]) continue;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return hashCode == this.hashCodes[i];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicateRid(long rid, List<Element> packets) {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            int hashCode = -1;
            if (packets != null && !packets.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Element elem : packets) {
                    sb.append(elem.toString());
                }
                hashCode = sb.toString().hashCode();
            }
            for (int i = 0; i < this.currentRids.length; ++i) {
                if (rid != this.currentRids[i]) continue;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return hashCode != this.hashCodes[i];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    private void processAutomaticCache(Packet packet) {
        if (packet.getElemName() == PRESENCE_ELEMENT_NAME) {
            this.cache.addPresence(packet.getElement());
        }
        if (packet.getElemName() == MESSAGE_ELEMENT_NAME) {
            this.cache.addFromMessage(packet.getElement());
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_QUERY_PATH, "jabber:iq:roster")) {
            this.cache.addRoster(packet.getElement());
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_BIND_PATH, "urn:ietf:params:xml:ns:xmpp-bind")) {
            this.cache.set("bosh-resource-bind", Collections.singletonList(packet.getElement()));
        }
    }

    private void processCache(Constants.CacheAction action, Packet packet) {
        ++this.cache_reload_counter;
        int packet_counter = 0;
        List<Element> children = packet.getElemChildrenStaticStr(Constants.BODY_EL_PATH);
        String cache_id = packet.getAttributeStaticStr("cache-id");
        List<Element> cache_res = null;
        switch (action) {
            case on: {
                if (this.cache == null) {
                    this.cache = new BoshSessionCache();
                }
                this.cache_on = true;
                log.fine("BoshSessionCache set to ON");
                break;
            }
            case off: {
                this.cache_on = false;
                log.fine("BoshSessionCache set to OFF");
                break;
            }
            case set: {
                this.cache.set(cache_id, children);
                break;
            }
            case add: {
                this.cache.add(cache_id, children);
                break;
            }
            case get: {
                cache_res = this.cache.get(cache_id);
                break;
            }
            case remove: {
                this.cache.remove(cache_id);
                break;
            }
            case get_all: {
                cache_res = this.cache.getAll();
                this.retireAllOldConnections();
                break;
            }
            default: {
                log.warning("Unknown cache action: " + action.toString());
            }
        }
        if (cache_res != null) {
            for (Element elem : cache_res) {
                elem.addAttribute("reload-counter", "" + this.cache_reload_counter);
                elem.addAttribute("packet-counter", "" + ++packet_counter);
                this.waiting_packets.add(elem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRid(long rid, List<Element> packets) {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            if (this.previous_received_rid + 1L != rid) {
                log.info("Incorrect packet order, last_rid=" + this.previous_received_rid + ", current_rid=" + rid);
            }
            if (packets != null && !packets.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Element elem : packets) {
                    sb.append(elem.toString());
                }
                this.hashCodes[this.rids_head] = sb.toString().hashCode();
            } else {
                this.hashCodes[this.rids_head] = -1;
            }
            this.previous_received_rid = rid;
            this.currentRids[this.rids_head++] = rid;
            if (this.rids_head >= this.currentRids.length) {
                this.rids_head = 0;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public void terminateBoshSession() {
        this.terminate = true;
    }

    public synchronized void sendWaitingPackets() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("trying to send waiting packets from queue of " + this.getSid() + " after timer = " + this.waiting_packets.size());
        }
        if (!this.waiting_packets.isEmpty()) {
            Map.Entry<BoshTask, BoshIOService> entry = this.connections.pollFirstEntry();
            if (entry == null) {
                return;
            }
            BoshIOService serv = entry.getValue();
            this.sendBody(serv, null);
        }
    }

    private synchronized void sendBody(BoshIOService serv, Element body_par) {
        if (this.queueTask != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling queue timer: " + this.getSid());
            }
            this.handler.cancelSendQueueTask(this.queueTask);
            this.queueTask = null;
        }
        this.last_send_time = System.currentTimeMillis();
        BoshTask timer = serv.getWaitTimer();
        if (timer != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling waitTimer: " + this.getSid());
            }
            this.handler.cancelTask(timer);
        } else {
            log.info("No waitTimer for the Bosh connection! " + serv);
        }
        Element body = body_par;
        if (body == null) {
            body = this.getBodyElem();
            long rid = this.takeCurrentRidTail();
            if (rid > 0L) {
                body.setAttribute("ack", "" + rid);
            }
            if (!this.waiting_packets.isEmpty()) {
                Element stanza = this.waiting_packets.poll();
                if (stanza.getXMLNS() == null) {
                    stanza.setXMLNS("jabber:client");
                }
                body.addChild(stanza);
                while (!this.waiting_packets.isEmpty() && body.getChildren().size() < this.max_batch_size) {
                    stanza = this.waiting_packets.poll();
                    if (stanza.getXMLNS() == null) {
                        stanza.setXMLNS("jabber:client");
                    }
                    body.addChild(stanza);
                }
            }
        }
        if (body.getChild("stream:error") != null) {
            body.addAttribute("condition", "remote-stream-error");
            body.addAttribute("type", "terminate");
            body.addAttribute("xmlns:stream", "http://etherx.jabber.org/streams");
            this.terminate = true;
            System.out.println("stream:error termination");
        }
        try {
            if (this.terminate) {
                body.setAttribute("type", StanzaType.terminate.toString());
            }
            this.handler.writeRawData(serv, body.toString());
            this.retireConnectionService(serv);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "[" + this.connections.size() + "] Exception during writing to socket", e);
        }
    }

    private void retireConnectionService(BoshIOService serv) {
        if (!this.old_connections.contains(serv)) {
            while (!this.old_connections.offer(serv)) {
                BoshIOService old_serv = this.old_connections.poll();
                if (old_serv != null) {
                    old_serv.stop();
                    continue;
                }
                if (!log.isLoggable(Level.WARNING)) break;
                log.warning("old_connections queue is empty but can not add new element!: " + this.getSid());
                break;
            }
        }
        serv.setSid(null);
        this.disconnected(serv);
    }

    private void retireAllOldConnections() {
        while (this.connections.size() > 1) {
            Map.Entry<BoshTask, BoshIOService> entry = this.connections.pollFirstEntry();
            this.handler.cancelTask(entry.getKey());
            BoshIOService serv = entry.getValue();
            if (serv != null) {
                this.retireConnectionService(serv);
                continue;
            }
            if (!log.isLoggable(Level.WARNING)) continue;
            log.warning("connections queue size is greater than 1 but poll returns null" + this.getSid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long takeCurrentRidTail() {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            int idx = this.rids_tail++;
            if (this.rids_tail >= this.currentRids.length) {
                this.rids_tail = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentRids[idx];
        }
    }

    public void setUserJid(String jid) {
        this.userJid = JID.jidInstanceNS(jid);
    }

    private static class TimerTaskComparator
    implements Comparator<BoshTask> {
        private TimerTaskComparator() {
        }

        @Override
        public int compare(BoshTask o1, BoshTask o2) {
            if (o1.timerOrder > o2.timerOrder) {
                return 1;
            }
            if (o1.timerOrder < o2.timerOrder) {
                return -1;
            }
            return 0;
        }
    }
}

