/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class Message
extends Packet {
    public static final String ELEM_NAME = "message";
    public static final String[] MESSAGE_BODY_PATH = new String[]{"message", "body"};
    public static final String[] MESSAGE_SUBJECT_PATH = new String[]{"message", "subject"};
    public static final String[] MESSAGE_ERROR_PATH = new String[]{"message", "error"};
    public static final String[] MESSAGE_DELAY_PATH = new String[]{"message", "delay"};

    public Message(Element elem) throws TigaseStringprepException {
        super(elem);
    }

    public Message(Element elem, JID stanzaFrom, JID stanzaTo) {
        super(elem, stanzaFrom, stanzaTo);
    }

    public static Packet getMessage(JID from, JID to, StanzaType type, String body, String subject, String thread, String id) {
        Element message = new Element(ELEM_NAME, new Element[]{new Element("body", body)}, null, null);
        message.setXMLNS("jabber:client");
        if (from != null) {
            message.addAttribute("from", from.toString());
        }
        if (to != null) {
            message.addAttribute("to", to.toString());
        }
        if (type != null) {
            message.addAttribute("type", type.name());
        }
        if (id != null) {
            message.addAttribute("id", id);
        }
        if (subject != null) {
            message.addChild(new Element("subject", subject));
        }
        if (thread != null) {
            message.addChild(new Element("thread", thread));
        }
        return Message.packetInstance(message, from, to);
    }

    @Override
    protected String[] getElNameErrorPath() {
        return MESSAGE_ERROR_PATH;
    }
}

