/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public enum Command {
    STREAM_OPENED(Priority.SYSTEM),
    CLIENT_AUTH(Priority.SYSTEM),
    USER_LOGIN(Priority.SYSTEM),
    STREAM_CLOSED(Priority.SYSTEM),
    STREAM_CLOSED_UPDATE(Priority.SYSTEM),
    CHECK_USER_CONNECTION(Priority.SYSTEM),
    STARTTLS(Priority.NORMAL),
    STARTZLIB(Priority.NORMAL),
    GETFEATURES(Priority.HIGH),
    GETDISCO(Priority.HIGH),
    CLOSE(Priority.SYSTEM),
    GETSTATS(Priority.HIGH),
    USER_STATUS(Priority.NORMAL),
    BROADCAST_TO_ONLINE(Priority.NORMAL),
    BROADCAST_TO_ALL(Priority.NORMAL),
    REDIRECT(Priority.SYSTEM),
    VHOSTS_RELOAD(Priority.NORMAL),
    VHOSTS_UPDATE(Priority.NORMAL),
    VHOSTS_REMOVE(Priority.NORMAL),
    OTHER(Priority.NORMAL);

    public static final String COMMAND_EL = "command";
    public static final String FIELD_EL = "field";
    public static final String VALUE_EL = "value";
    public static final String XMLNS = "http://jabber.org/protocol/commands";
    protected static final String[] FIELD_VALUE_PATH;
    private static final Logger log;
    private Priority priority = Priority.NORMAL;

    private Command(Priority priority) {
        this.priority = priority;
    }

    public static void addAction(Packet packet, Action action) {
        Command.addActionEl(packet.getElement(), action);
    }

    public static void addCheckBoxField(Packet packet, String f_name, boolean f_value) {
        Command.addFieldValue(packet, f_name, Boolean.toString(f_value), "boolean");
    }

    public static void addFieldMultiValue(Packet packet, String f_name, List<String> f_value) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        if (f_value != null) {
            Element field = new Element(FIELD_EL, new String[]{"var", "type"}, new String[]{XMLUtils.escape(f_name), "text-multi"});
            for (String val : f_value) {
                if (val == null) continue;
                Element value = new Element(VALUE_EL, XMLUtils.escape(val));
                field.addChild(value);
            }
            x.addChild(field);
        }
    }

    public static void addFieldMultiValue(Packet packet, String f_name, Throwable ex) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        ArrayList<String> f_value = null;
        if (ex != null) {
            f_value = new ArrayList<String>(100);
            f_value.add(ex.getLocalizedMessage());
            for (StackTraceElement ste : ex.getStackTrace()) {
                f_value.add("  " + ste.toString());
            }
        }
        if (f_value != null) {
            Element field = new Element(FIELD_EL, new String[]{"var", "type"}, new String[]{XMLUtils.escape(f_name), "text-multi"});
            for (String val : f_value) {
                if (val == null) continue;
                Element value = new Element(VALUE_EL, XMLUtils.escape(val));
                field.addChild(value);
            }
            x.addChild(field);
        }
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var"}, new String[]{XMLUtils.escape(f_name)});
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String label, String[] labels, String[] options) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), "list-single", XMLUtils.escape(label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape(options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape(labels[i])}));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String[] f_values, String label, String[] labels, String[] options) {
        int i;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element(FIELD_EL, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), "list-multi", XMLUtils.escape(label)});
        for (i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape(options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape(labels[i])}));
        }
        for (i = 0; i < f_values.length; ++i) {
            field.addChild(new Element(VALUE_EL, XMLUtils.escape(f_values[i])));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String label, String[] labels, String[] options, String type) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), type, XMLUtils.escape(label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape(options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape(labels[i])}));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String type) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type"}, new String[]{XMLUtils.escape(f_name), type});
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String type, String label) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), type, XMLUtils.escape(label)});
        x.addChild(field);
    }

    public static void addHiddenField(Packet packet, String f_name, String f_value) {
        Command.addFieldValue(packet, f_name, f_value, "hidden");
    }

    public static void addInstructions(Packet packet, String instructions) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        x.addChild(new Element("instructions", instructions));
    }

    public static void addNote(Packet packet, String note) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element notes = command2.getChild("note");
        if (notes == null) {
            notes = new Element("note", new String[]{"type"}, new String[]{"info"});
            command2.addChild(notes);
        }
        notes.setCData(XMLUtils.escape(note));
    }

    public static void addTextField(Packet packet, String f_name, String f_value) {
        Command.addFieldValue(packet, f_name, f_value, "fixed");
    }

    public static void addTitle(Packet packet, String title) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = Command.addDataForm(command2, DataType.submit);
        }
        x.addChild(new Element("title", title));
    }

    public static Element createIqCommand(JID from, JID to, StanzaType type, String id, String node, DataType data_type) {
        Element iq = Command.createCommandEl(from, to, type, id, node, data_type);
        return iq;
    }

    public static Action getAction(Packet packet) {
        String action = packet.getAttributeStaticStr(Iq.IQ_COMMAND_PATH, "action");
        try {
            return Action.valueOf(action);
        }
        catch (Exception e) {
            return Action.other;
        }
    }

    public static boolean getCheckBoxFieldValue(Packet packet, String f_name) {
        String result = Command.getFieldValue(packet, f_name);
        if (result == null) {
            return false;
        }
        return (result = result.trim()).equalsIgnoreCase("true") || result.equals("1");
    }

    public static List<Element> getData(Packet packet) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        return command2.getChildren();
    }

    public static Element getData(Packet packet, String el_name, String xmlns) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        return command2.getChild(el_name, xmlns);
    }

    public static String getFieldValue(Packet packet, String f_name) {
        List<Element> children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                String value;
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name) || (value = child.getChildCDataStaticStr(FIELD_VALUE_PATH)) == null) continue;
                return XMLUtils.unescape(value);
            }
        }
        return null;
    }

    public static String getFieldValue(Packet packet, String f_name, boolean debug) {
        Element iq = packet.getElement();
        log.info("Command iq: " + iq.toString());
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        log.info("Command command: " + command2.toString());
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            log.info("Command x: NULL");
            return null;
        }
        log.info("Command x: " + x.toString());
        List<Element> children = x.getChildren();
        for (Element child : children) {
            log.info("Command form child: " + child.toString());
            if (child.getName().equals(FIELD_EL) && child.getAttributeStaticStr("var").equals(f_name)) {
                String value = child.getChildCDataStaticStr(FIELD_VALUE_PATH);
                log.info("Command found: field=" + f_name + ", value=" + value);
                if (value == null) continue;
                return XMLUtils.unescape(value);
            }
            log.info("Command not found: field=" + f_name + ", value=" + child.getChildCDataStaticStr(FIELD_VALUE_PATH));
        }
        return null;
    }

    public static String[] getFieldValues(Packet packet, String f_name) {
        List<Element> children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name)) continue;
                LinkedList<String> values = new LinkedList<String>();
                List<Element> val_children = child.getChildren();
                if (val_children != null) {
                    for (Element val_child : val_children) {
                        String value;
                        if (!val_child.getName().equals(VALUE_EL) || (value = val_child.getCData()) == null) continue;
                        values.add(XMLUtils.unescape(value));
                    }
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static boolean removeFieldValue(Packet packet, String f_name) {
        List<Element> children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name)) continue;
                return x.removeChild(child);
            }
        }
        return false;
    }

    public static String getFieldKeyStartingWith(Packet packet, String f_name) {
        List<Element> children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL, XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").startsWith(f_name)) continue;
                return child.getAttributeStaticStr("var");
            }
        }
        return null;
    }

    public static void setData(Packet packet, Element data) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        command2.addChild(data);
    }

    public static void setData(Packet packet, List<Element> data) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        command2.addChildren(data);
    }

    public static void setStatus(Packet packet, Status status) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild(COMMAND_EL);
        command2.setAttribute("status", status.toString());
    }

    public static Command valueof(String cmd) {
        try {
            return Command.valueOf(cmd);
        }
        catch (Exception e) {
            return OTHER;
        }
    }

    private static void addActionEl(Element iq, Action action) {
        Element command2 = iq.getChild(COMMAND_EL);
        Element actions = command2.getChild("actions");
        if (actions == null) {
            actions = new Element("actions", new String[]{Action.execute.toString()}, new String[]{action.toString()});
            command2.addChild(actions);
        }
        actions.addChild(new Element(action.toString()));
    }

    private static Element addDataForm(Element command2, DataType data_type) {
        Element x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", data_type.name()});
        command2.addChild(x);
        return x;
    }

    private static Element createCommandEl(JID from, JID to, StanzaType type, String id, String node, DataType data_type) {
        Element iq = new Element("iq", new String[]{"type"}, new String[]{type.toString()});
        if (from != null) {
            iq.setAttribute("from", from.toString());
        }
        iq.setAttribute("id", id);
        if (to != null) {
            iq.setAttribute("to", to.toString());
        }
        Element command2 = new Element(COMMAND_EL, new String[]{"xmlns", "node"}, new String[]{XMLNS, node});
        iq.addChild(command2);
        if (data_type != null) {
            Command.addDataForm(command2, data_type);
            if (data_type == DataType.result) {
                Command.setStatusEl(iq, Status.completed);
            }
            if (data_type == DataType.form) {
                Command.setStatusEl(iq, Status.executing);
                Command.addActionEl(iq, Action.complete);
            }
        }
        return iq;
    }

    private static void setStatusEl(Element iq, Status status) {
        Element command2 = iq.getChild(COMMAND_EL);
        command2.setAttribute("status", status.name());
    }

    public Packet getPacket(JID from, JID to, StanzaType type, String id) {
        Element elem = Command.createIqCommand(from, to, type, id, this.toString(), null);
        Packet result = Packet.packetInstance(elem, from, to);
        result.setPriority(this.priority);
        return result;
    }

    public Packet getPacket(JID from, JID to, StanzaType type, String id, DataType data_type) {
        Element elem = Command.createIqCommand(from, to, type, id, this.toString(), data_type);
        Packet result = Packet.packetInstance(elem, from, to);
        result.setPriority(this.priority);
        return result;
    }

    static {
        FIELD_VALUE_PATH = new String[]{FIELD_EL, VALUE_EL};
        log = Logger.getLogger("tigase.server.Command");
    }

    public static enum Status {
        executing,
        completed,
        canceled,
        other;

    }

    public static enum DataType {
        result,
        form,
        submit;

    }

    public static enum Action {
        execute,
        cancel,
        prev,
        next,
        complete,
        other;

    }
}

