/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionType;

public class ConnectionOpenThread
implements Runnable {
    public static final long def_5222_throttling = 200L;
    public static final long def_5223_throttling = 50L;
    public static final long def_5269_throttling = 100L;
    public static final long def_5280_throttling = 1000L;
    private static ConnectionOpenThread acceptThread = null;
    private static final Logger log = Logger.getLogger(ConnectionOpenThread.class.getName());
    public static Map<Integer, PortThrottlingData> throttling = new ConcurrentHashMap<Integer, PortThrottlingData>(10);
    protected long accept_counter = 0L;
    private Selector selector = null;
    private boolean stopping = false;
    private Timer timer = null;
    private ConcurrentLinkedQueue<ConnectionOpenListener> waiting = new ConcurrentLinkedQueue();

    private ConnectionOpenThread() {
        this.timer = new Timer("Connections open timer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (PortThrottlingData portData : throttling.values()) {
                    portData.lastSecondConnections = 0L;
                }
            }
        }, 1000L, 1000L);
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Server I/O error, can't continue my work.", e);
            this.stopping = true;
        }
    }

    public static ConnectionOpenThread getInstance() {
        if (acceptThread == null) {
            acceptThread = new ConnectionOpenThread();
            Thread thrd = new Thread(acceptThread);
            thrd.setName("ConnectionOpenThread");
            thrd.start();
            if (log.isLoggable(Level.FINER)) {
                log.finer("ConnectionOpenThread started.");
            }
        }
        return acceptThread;
    }

    public void addConnectionOpenListener(ConnectionOpenListener al) {
        this.waiting.offer(al);
        this.selector.wakeup();
    }

    public void removeConnectionOpenListener(ConnectionOpenListener al) {
        for (SelectionKey key : this.selector.keys()) {
            if (al != key.attachment()) continue;
            try {
                key.cancel();
                SelectableChannel channel = key.channel();
                channel.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception during removing connection listener.", e);
            }
            break;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            try {
                this.selector.select();
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey sk = i.next();
                    i.remove();
                    SocketChannel sc = null;
                    if ((sk.readyOps() & 0x10) != 0) {
                        PortThrottlingData port_throttling;
                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                        sc = nextReady.accept();
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("OP_ACCEPT");
                        }
                        if ((port_throttling = throttling.get(nextReady.socket().getLocalPort())) != null) {
                            ++port_throttling.lastSecondConnections;
                            if (port_throttling.lastSecondConnections > port_throttling.throttling) {
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "New connections throttling level exceeded, closing: {0}", sc);
                                }
                                sc.close();
                                sc = null;
                            }
                        } else {
                            log.log(Level.WARNING, "Throttling not configured for port: {0}", nextReady.socket().getLocalPort());
                        }
                    }
                    if ((sk.readyOps() & 8) != 0) {
                        sk.cancel();
                        sc = (SocketChannel)sk.channel();
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("OP_CONNECT");
                        }
                    }
                    if (sc != null) {
                        try {
                            sc.configureBlocking(false);
                            sc.socket().setSoLinger(false, 0);
                            sc.socket().setReuseAddress(true);
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, "Registered new client socket: {0}", sc);
                            }
                            ConnectionOpenListener al = (ConnectionOpenListener)sk.attachment();
                            sc.socket().setTrafficClass(al.getTrafficClass());
                            sc.socket().setReceiveBufferSize(al.getReceiveBufferSize());
                            al.accept(sc);
                        }
                        catch (SocketException e) {
                            log.log(Level.INFO, "Socket closed instantly after it had been opened?", e);
                            ConnectionOpenListener al = (ConnectionOpenListener)sk.attachment();
                            al.accept(sc);
                        }
                    } else {
                        log.warning("Can't obtain socket channel from selection key.");
                    }
                    ++this.accept_counter;
                }
                this.addAllWaiting();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Server I/O error.", e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Other service exception.", e);
            }
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setName("ConnectionOpenThread");
        t.start();
    }

    public void stop() {
        this.stopping = true;
        this.selector.wakeup();
    }

    private void addAllWaiting() throws IOException {
        ConnectionOpenListener al = null;
        while ((al = this.waiting.poll()) != null) {
            try {
                this.addPort(al);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error: creating connection for: " + al, e);
                al.accept(null);
            }
        }
    }

    private void addISA(InetSocketAddress isa, ConnectionOpenListener al) throws IOException {
        switch (al.getConnectionType()) {
            case accept: {
                long port_throttling = this.getThrottlingForPort(isa.getPort());
                throttling.put(isa.getPort(), new PortThrottlingData(port_throttling));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Setting up throttling for the port {0} to {1} connections per second.", new Object[]{isa.getPort(), port_throttling});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Setting up 'accept' channel...");
                }
                ServerSocketChannel ssc = ServerSocketChannel.open();
                ssc.socket().setReceiveBufferSize(al.getReceiveBufferSize());
                ssc.configureBlocking(false);
                ssc.socket().bind(isa);
                ssc.register(this.selector, 16, al);
                break;
            }
            case connect: {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Setting up ''connect'' channel for: {0}/{1}", new Object[]{isa.getAddress(), isa.getPort()});
                }
                SocketChannel sc = SocketChannel.open();
                sc.socket().setReceiveBufferSize(al.getReceiveBufferSize());
                sc.socket().setTrafficClass(al.getTrafficClass());
                sc.configureBlocking(false);
                sc.connect(isa);
                sc.register(this.selector, 8, al);
                break;
            }
            default: {
                log.log(Level.WARNING, "Unknown connection type: {0}", (Object)al.getConnectionType());
            }
        }
    }

    private void addPort(ConnectionOpenListener al) throws IOException {
        if (al.getConnectionType() == ConnectionType.connect && al.getRemoteAddress() != null) {
            this.addISA(al.getRemoteAddress(), al);
        } else if (al.getIfcs() == null || al.getIfcs().length == 0 || al.getIfcs()[0].equals("ifc") || al.getIfcs()[0].equals("*")) {
            this.addISA(new InetSocketAddress(al.getPort()), al);
        } else {
            for (String ifc : al.getIfcs()) {
                this.addISA(new InetSocketAddress(ifc, al.getPort()), al);
            }
        }
    }

    private long getThrottlingForPort(int port) {
        long result = 200L;
        switch (port) {
            case 5223: {
                result = 50L;
                break;
            }
            case 5269: {
                result = 100L;
                break;
            }
            case 5280: {
                result = 1000L;
            }
        }
        String throttling_prop = System.getProperty("new-connections-throttling");
        if (throttling_prop != null) {
            String[] all_ports_thr;
            for (String port_thr : all_ports_thr = throttling_prop.split(",")) {
                String[] port_thr_ar = port_thr.split(":");
                if (port_thr_ar.length == 2) {
                    try {
                        int port_no = Integer.parseInt(port_thr_ar[0]);
                        if (port_no == port) {
                            return Long.parseLong(port_thr_ar[1]);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Connections throttling configuration error, bad format, check the documentation for a correct syntax, port throttling config: {0}", port_thr);
                    }
                    continue;
                }
                log.log(Level.WARNING, "Connections throttling configuration error, bad format, check the documentation for a correct syntax, port throttling config: {0}", port_thr);
            }
        }
        return result;
    }

    private class PortThrottlingData {
        protected long lastSecondConnections = 0L;
        protected long throttling;

        private PortThrottlingData(long throttling_prop) {
            this.throttling = throttling_prop;
        }
    }
}

